/*
 * Decompiled with CFR 0.152.
 */
package pd.internal.utils;

import java.io.Serializable;
import pd.DataFrame;
import pd.internal.series.SeriesData;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class StringUtils$
implements Serializable {
    public static final StringUtils$ MODULE$ = new StringUtils$();

    private StringUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringUtils$.class);
    }

    public String asElements(int n) {
        return n == 1 ? "1 element" : "" + n + " elements";
    }

    public String fixedString(String s, int len, boolean leftAlign, boolean centerAlign) {
        String string;
        String str = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)c -> this.$anonfun$1(BoxesRunTime.unboxToChar((Object)c)));
        if (len < 2) {
            throw new IllegalArgumentException("Column width must be greater than 1.");
        }
        int actualLength = str.length();
        if (actualLength == len) {
            string = str;
        } else if (actualLength > len) {
            string = str.substring(0, len - 2) + "..";
        } else if (centerAlign) {
            int leftSpace = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((len - actualLength) / 2 + actualLength), 0);
            string = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(str), leftSpace, ' ')))), len, ' ')));
        } else {
            string = leftAlign ? StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(str), len, ' ') : StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(str))), len, ' ')));
        }
        return string;
    }

    public boolean fixedString$default$3() {
        return false;
    }

    public boolean fixedString$default$4() {
        return false;
    }

    public String pretty(Object v, int maxWidth) {
        String string;
        block11: {
            Object object = v;
            while (true) {
                Object object2;
                if (ScalaRunTime$.MODULE$.isArray(object2 = object, 1)) {
                    Object a = object2;
                    if (ScalaRunTime$.MODULE$.array_length(a) > 5) {
                        Object object3 = Predef$.MODULE$.genericArrayOps(a);
                        Object object4 = Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.take$extension(object3, 5));
                        string = "[" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)_$1 -> _$1.toString(), ClassTag$.MODULE$.apply(String.class))).mkString(", ") + ", ...";
                    } else {
                        Object object5 = Predef$.MODULE$.genericArrayOps(a);
                        string = "[" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object5, (Function1 & Serializable)_$2 -> _$2.toString(), ClassTag$.MODULE$.apply(String.class))).mkString(", ") + "]";
                    }
                    break block11;
                }
                if (object2 instanceof Double) {
                    double d;
                    double d2 = BoxesRunTime.unboxToDouble((Object)object2);
                    if (maxWidth > 4 && (d2 > 1.0E-4 || d2 < -1.0E-4)) {
                        BigDecimal bigDecimal = package$.MODULE$.BigDecimal().apply(d2);
                        package$.MODULE$.BigDecimal();
                        d = bigDecimal.setScale(maxWidth - 4, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble();
                    } else {
                        d = d2;
                    }
                    double v2 = d;
                    String s = BoxesRunTime.boxToDouble((double)v2).toString();
                    if (s.length() > maxWidth && s.contains("E")) {
                        int ix = s.indexOf("E");
                        String exponent = s.substring(ix);
                        if (maxWidth > exponent.length() + 2) {
                            StringBuilder stringBuilder = new StringBuilder();
                            BigDecimal bigDecimal = package$.MODULE$.BigDecimal().apply(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s.substring(0, s.length() - exponent.length()))));
                            int n = maxWidth - exponent.length() - 2;
                            package$.MODULE$.BigDecimal();
                            string = stringBuilder.append(BoxesRunTime.boxToDouble((double)bigDecimal.setScale(n, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble()).toString()).append(exponent).toString();
                        } else {
                            string = s;
                        }
                    } else {
                        string = s;
                    }
                    break block11;
                }
                if (!(object2 instanceof Float)) break;
                float f = BoxesRunTime.unboxToFloat((Object)object2);
                object = BoxesRunTime.boxToDouble((double)f);
            }
            string = object.toString();
        }
        return string;
    }

    public String separatorLine(int width, int numColumns, char character, int firstWidth) {
        int initialWidth = firstWidth == 0 ? width : firstWidth;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numColumns).map((Function1 & Serializable)i -> this.separatorLine$$anonfun$1(width, character, initialWidth, BoxesRunTime.unboxToInt((Object)i))).mkString("+ ", " + ", " +");
    }

    public char separatorLine$default$3() {
        return '-';
    }

    public int separatorLine$default$4() {
        return 0;
    }

    public String table(DataFrame df, int n, int width, boolean annotateIndex, boolean annotateType, int colWidth, int indexWidth, String indexPrintName, Function2<Object, Object, String> indexPrintRepresentation) {
        int n2;
        scala.collection.mutable.StringBuilder s = new scala.collection.mutable.StringBuilder();
        if (width == 0) {
            n2 = df.numCols();
        } else {
            int n3;
            int x = n3 = (width - (annotateIndex ? colWidth + 8 : 5)) / (colWidth + 3);
            n2 = x <= df.numCols() ? x : df.numCols();
        }
        int m = n2;
        String string = m < df.numCols() ? " ...\n" : "\n";
        String line = this.separatorLine(colWidth, annotateIndex ? m + 1 : m, '-', annotateIndex ? indexWidth : colWidth) + (m < df.numCols() ? " ---\n" : "\n");
        String indexSep = m > 0 ? " | " : "";
        s.append(line);
        s.append(((IterableOnceOps)((IterableOps)df.colIndex().take(m)).map((Function1 & Serializable)c -> this.fixedString((String)c._1(), colWidth, this.fixedString$default$3(), true))).mkString(annotateIndex ? "| " + this.fixedString(indexPrintName, indexWidth, this.fixedString$default$3(), true) + indexSep : "| ", " | ", " |" + string));
        if (annotateType) {
            s.append(((IterableOnceOps)((IterableOps)df.colIndex().take(m)).map((Function1 & Serializable)c -> {
                String string = ((SeriesData)c._2()).typeDescription(((SeriesData)c._2()).typeDescription$default$1());
                boolean bl = this.fixedString$default$3();
                return this.fixedString(string, colWidth, bl, true);
            })).mkString(annotateIndex ? "| " + this.fixedString("", indexWidth, this.fixedString$default$3(), this.fixedString$default$4()) + indexSep : "| ", " | ", " |" + string));
        }
        s.append(line);
        s.append(df.index().iterator().take(n).map((Function1 & Serializable)rowIx -> this.table$$anonfun$5(df, annotateIndex, colWidth, indexWidth, indexPrintRepresentation, m, string, indexSep, BoxesRunTime.unboxToInt((Object)rowIx))).mkString(""));
        s.append(line);
        if (n < df.index().length()) {
            s.append("  showing " + n + " of " + df.index().length() + " rows\n");
        }
        if (m < df.numCols()) {
            s.append("  showing " + m + " of " + df.numCols() + " columns\n");
        }
        return s.toString();
    }

    private final /* synthetic */ boolean $anonfun$1(char c) {
        return c != '\n';
    }

    private final /* synthetic */ String separatorLine$$anonfun$1(int width$1, char character$1, int initialWidth$1, int i) {
        return StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(""), i == 0 ? initialWidth$1 : width$1, character$1);
    }

    private final String table$$anonfun$3$$anonfun$1$$anonfun$1(int colWidth$5) {
        return this.fixedString("null", colWidth$5, this.fixedString$default$3(), true);
    }

    private final /* synthetic */ String table$$anonfun$5(DataFrame df$1, boolean annotateIndex$1, int colWidth$3, int indexWidth$1, Function2 indexPrintRepresentation$1, int m$1, String break$1, String indexSep$1, int rowIx) {
        return ((IterableOnceOps)((IterableOps)df$1.colIndex().take(m$1)).map((Function1 & Serializable)c -> {
            SeriesData SeriesData_this = (SeriesData)c._2();
            return this.fixedString(this.pretty((SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[rowIx] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), rowIx)) : None$.MODULE$).getOrElse(() -> this.table$$anonfun$3$$anonfun$1$$anonfun$1(colWidth$3)), colWidth$3), colWidth$3, this.fixedString$default$3(), this.fixedString$default$4());
        })).mkString(annotateIndex$1 ? "| " + indexPrintRepresentation$1.apply((Object)BoxesRunTime.boxToInteger((int)rowIx), (Object)BoxesRunTime.boxToInteger((int)indexWidth$1)) + indexSep$1 : "| ", " | ", " |" + break$1);
    }
}

