/*
 * Decompiled with CFR 0.152.
 */
package pd.io.csv;

import com.univocity.parsers.common.processor.ColumnProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import pd.DataFrame;
import pd.DataFrame$;
import pd.Series;
import pd.Series$;
import pd.io.StringDecoding$;
import pd.io.csv.CsvReader$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

public class CsvReader {
    private final boolean header;
    private final char delimiter;
    private final String lineSeparator;
    private final char quote;
    private final Charset charset;
    private final Function1<Series<String>, Try<Series<?>>>[] defaultDecoders;
    private final Map<String, Function1<Series<String>, Try<Series<?>>>> columnDecoders;
    private final boolean nullEncodingEnabled;
    private final String nullEncoding;
    private final boolean skipEmptyLines;
    private final long rowLimit;
    private final long rowsSkipped;

    public static boolean $lessinit$greater$default$1() {
        return CsvReader$.MODULE$.$lessinit$greater$default$1();
    }

    public static char $lessinit$greater$default$2() {
        return CsvReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$3() {
        return CsvReader$.MODULE$.$lessinit$greater$default$3();
    }

    public static char $lessinit$greater$default$4() {
        return CsvReader$.MODULE$.$lessinit$greater$default$4();
    }

    public static Charset $lessinit$greater$default$5() {
        return CsvReader$.MODULE$.$lessinit$greater$default$5();
    }

    public static Function1<Series<String>, Try<Series<?>>>[] $lessinit$greater$default$6() {
        return CsvReader$.MODULE$.$lessinit$greater$default$6();
    }

    public static Map<String, Function1<Series<String>, Try<Series<?>>>> $lessinit$greater$default$7() {
        return CsvReader$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean $lessinit$greater$default$8() {
        return CsvReader$.MODULE$.$lessinit$greater$default$8();
    }

    public static String $lessinit$greater$default$9() {
        return CsvReader$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean $lessinit$greater$default$10() {
        return CsvReader$.MODULE$.$lessinit$greater$default$10();
    }

    public static long $lessinit$greater$default$11() {
        return CsvReader$.MODULE$.$lessinit$greater$default$11();
    }

    public static long $lessinit$greater$default$12() {
        return CsvReader$.MODULE$.$lessinit$greater$default$12();
    }

    public CsvReader(boolean header, char delimiter, String lineSeparator, char quote, Charset charset, Function1<Series<String>, Try<Series<?>>>[] defaultDecoders, Map<String, Function1<Series<String>, Try<Series<?>>>> columnDecoders, boolean nullEncodingEnabled, String nullEncoding, boolean skipEmptyLines, long rowLimit, long rowsSkipped) {
        this.header = header;
        this.delimiter = delimiter;
        this.lineSeparator = lineSeparator;
        this.quote = quote;
        this.charset = charset;
        this.defaultDecoders = defaultDecoders;
        this.columnDecoders = columnDecoders;
        this.nullEncodingEnabled = nullEncodingEnabled;
        this.nullEncoding = nullEncoding;
        this.skipEmptyLines = skipEmptyLines;
        this.rowLimit = rowLimit;
        this.rowsSkipped = rowsSkipped;
    }

    public DataFrame read(URL url) {
        Try try_ = Using$.MODULE$.apply(() -> this.read$$anonfun$1(url), (Function1 & Serializable)reader -> this.read((Reader)reader), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        DataFrame df = (DataFrame)((Success)try_).value();
        return df;
    }

    public DataFrame read(String path) {
        Try try_ = Using$.MODULE$.apply(() -> this.read$$anonfun$3(path), (Function1 & Serializable)reader -> this.read((Reader)reader), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        DataFrame df = (DataFrame)((Success)try_).value();
        return df;
    }

    public DataFrame read(Reader reader) {
        DataFrame dataFrame;
        String[] stringArray;
        CsvParserSettings settings = CsvReader$.MODULE$.pd$io$csv$CsvReader$$$defaultSettings();
        if (this.delimiter == '\u0000') {
            settings.setDelimiterDetectionEnabled(true);
        } else {
            settings.setDelimiterDetectionEnabled(false);
            ((CsvFormat)settings.getFormat()).setDelimiter(this.delimiter);
        }
        if (this.lineSeparator.isEmpty()) {
            settings.setLineSeparatorDetectionEnabled(true);
        } else {
            settings.setLineSeparatorDetectionEnabled(false);
            settings.getFormat().setLineSeparator(this.lineSeparator);
        }
        if (this.quote == '\u0000') {
            settings.setQuoteDetectionEnabled(true);
        } else {
            settings.setQuoteDetectionEnabled(false);
            ((CsvFormat)settings.getFormat()).setQuote(this.quote);
        }
        if (this.header) {
            settings.setHeaderExtractionEnabled(true);
        } else {
            settings.setHeaderExtractionEnabled(false);
        }
        settings.setSkipEmptyLines(this.skipEmptyLines);
        if (this.rowLimit > -1L) {
            settings.setNumberOfRecordsToRead(this.rowLimit);
        }
        if (this.rowsSkipped > -1L) {
            settings.setNumberOfRowsToSkip(this.rowsSkipped);
        }
        ColumnProcessor processor = new ColumnProcessor();
        settings.setProcessor((Processor)processor);
        CsvParser parser = new CsvParser(settings);
        parser.parse(reader);
        if (this.header) {
            String[] stringArray2 = processor.getHeaders();
            if (stringArray2 == null) {
                stringArray = new String[]{};
            } else {
                String[] x = stringArray2;
                stringArray = x;
            }
        } else {
            stringArray = new String[]{};
        }
        String[] headers = stringArray;
        Buffer values = CollectionConverters$.MODULE$.ListHasAsScala(processor.getColumnValuesAsList()).asScala();
        if (values == null) {
            dataFrame = DataFrame$.MODULE$.empty();
        } else {
            ArrayBuffer added = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            int columnCount = values.size();
            dataFrame = DataFrame$.MODULE$.applyDynamic("apply", (Seq<Object>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), columnCount).map((Function1 & Serializable)ix -> this.read$$anonfun$5(headers, values, added, BoxesRunTime.unboxToInt((Object)ix))));
        }
        return dataFrame;
    }

    public DataFrame readResource(String path) {
        DataFrame dataFrame;
        block4: {
            Try try_;
            block5: {
                try {
                    try_ = Using$.MODULE$.apply(() -> this.readResource$$anonfun$1(path), (Function1 & Serializable)reader -> this.read((Reader)reader), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    if (try_ instanceof Success) {
                        DataFrame df;
                        dataFrame = df = (DataFrame)((Success)try_).value();
                        break block4;
                    }
                    if (!(try_ instanceof Failure)) break block5;
                    Throwable e = ((Failure)try_).exception();
                    throw e;
                }
                catch (NullPointerException nullPointerException) {
                    throw new FileNotFoundException("" + path + " (No such resource)");
                }
            }
            throw new MatchError((Object)try_);
        }
        return dataFrame;
    }

    private final BufferedReader read$$anonfun$1(URL url$1) {
        return new BufferedReader(new InputStreamReader(url$1.openStream(), this.charset));
    }

    private final BufferedReader read$$anonfun$3(String path$1) {
        return new BufferedReader(new FileReader(path$1, this.charset));
    }

    private final Series decode$1(Buffer values$1, String name, int ix) {
        Series<String> series;
        Function1<Series<String>, Try<Series<?>>>[] function1Array;
        Function1 function1;
        Option option = this.columnDecoders.get((Object)name);
        if (option instanceof Some && (function1 = (Function1)((Some)option).value()) instanceof Function1) {
            Function1 d = function1;
            function1Array = new Function1[]{d};
        } else if (None$.MODULE$.equals(option)) {
            function1Array = this.defaultDecoders;
        } else {
            throw new MatchError((Object)option);
        }
        Function1<Series<String>, Try<Series<?>>>[] decoders = function1Array;
        Series<String> series2 = Series$.MODULE$.from(CollectionConverters$.MODULE$.ListHasAsScala((List)values$1.apply(ix)).asScala(), ClassTag$.MODULE$.apply(String.class)).as(name);
        if (this.nullEncodingEnabled) {
            String string = this.nullEncoding;
            String string2 = "";
            series = !(string != null ? !string.equals(string2) : string2 != null) ? series2 : ((Series)series2.apply((Series)series2.notEqualsByRow(this.nullEncoding))).dense();
        } else {
            series = series2.fill("");
        }
        return StringDecoding$.MODULE$.autoDecode(series, decoders);
    }

    private final /* synthetic */ Series read$$anonfun$5(String[] headers$1, Buffer values$2, ArrayBuffer added$1, int ix) {
        Series series;
        if (ix < headers$1.length && headers$1[ix] != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(headers$1[ix])) && !added$1.contains((Object)headers$1[ix])) {
            String colName = headers$1[ix];
            added$1.append((Object)colName);
            series = this.decode$1(values$2, colName, ix);
        } else {
            series = this.decode$1(values$2, BoxesRunTime.boxToInteger((int)ix).toString(), ix);
        }
        return series;
    }

    private final InputStreamReader readResource$$anonfun$1(String path$2) {
        return new InputStreamReader(this.getClass().getResourceAsStream("/" + path$2), this.charset);
    }

    public static class Adapter {
        public CsvReader csv() {
            return new CsvReader(CsvReader$.MODULE$.$lessinit$greater$default$1(), CsvReader$.MODULE$.$lessinit$greater$default$2(), CsvReader$.MODULE$.$lessinit$greater$default$3(), CsvReader$.MODULE$.$lessinit$greater$default$4(), CsvReader$.MODULE$.$lessinit$greater$default$5(), CsvReader$.MODULE$.$lessinit$greater$default$6(), CsvReader$.MODULE$.$lessinit$greater$default$7(), CsvReader$.MODULE$.$lessinit$greater$default$8(), CsvReader$.MODULE$.$lessinit$greater$default$9(), CsvReader$.MODULE$.$lessinit$greater$default$10(), CsvReader$.MODULE$.$lessinit$greater$default$11(), CsvReader$.MODULE$.$lessinit$greater$default$12());
        }

        public CsvReader csv(boolean header, char delimiter, String lineSeparator, char quote, Charset charset, Function1<Series<String>, Try<Series<?>>>[] defaultDecoders, Map<String, Function1<Series<String>, Try<Series<?>>>> columnDecoders, boolean nullEncodingEnabled, String nullEncoding, boolean skipEmptyLines, long rowLimit, long rowsSkipped) {
            return new CsvReader(header, delimiter, lineSeparator, quote, charset, defaultDecoders, columnDecoders, nullEncodingEnabled, nullEncoding, skipEmptyLines, rowLimit, rowsSkipped);
        }

        public boolean csv$default$1() {
            return true;
        }

        public char csv$default$2() {
            return '\u0000';
        }

        public String csv$default$3() {
            return "";
        }

        public char csv$default$4() {
            return '\u0000';
        }

        public Charset csv$default$5() {
            return Charset.defaultCharset();
        }

        public Function1<Series<String>, Try<Series<?>>>[] csv$default$6() {
            return StringDecoding$.MODULE$.defaultDecoders();
        }

        public Map<String, Function1<Series<String>, Try<Series<?>>>> csv$default$7() {
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }

        public boolean csv$default$8() {
            return true;
        }

        public String csv$default$9() {
            return "";
        }

        public boolean csv$default$10() {
            return true;
        }

        public long csv$default$11() {
            return -1L;
        }

        public long csv$default$12() {
            return -1L;
        }
    }
}

