/*
 * Decompiled with CFR 0.152.
 */
package pd.io.csv;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import pd.DataFrame;
import pd.Series;
import pd.io.csv.CsvWriter$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;

public class CsvWriter {
    private final DataFrame df;
    private final boolean header;
    private final char delimiter;
    private final String lineSeparator;
    private final char quote;
    private final Charset charset;
    private final boolean skipEmptyLines;

    public static boolean $lessinit$greater$default$2() {
        return CsvWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public static char $lessinit$greater$default$3() {
        return CsvWriter$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$4() {
        return CsvWriter$.MODULE$.$lessinit$greater$default$4();
    }

    public static char $lessinit$greater$default$5() {
        return CsvWriter$.MODULE$.$lessinit$greater$default$5();
    }

    public static Charset $lessinit$greater$default$6() {
        return CsvWriter$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$7() {
        return CsvWriter$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean $lessinit$greater$default$8() {
        return CsvWriter$.MODULE$.$lessinit$greater$default$8();
    }

    public CsvWriter(DataFrame df, boolean header, char delimiter, String lineSeparator, char quote, Charset charset, String nullEncoding, boolean skipEmptyLines) {
        this.df = df;
        this.header = header;
        this.delimiter = delimiter;
        this.lineSeparator = lineSeparator;
        this.quote = quote;
        this.charset = charset;
        this.skipEmptyLines = skipEmptyLines;
    }

    public DataFrame write(String path) {
        Try try_ = Using$.MODULE$.apply(() -> this.write$$anonfun$1(path), (Function1 & Serializable)writer -> this.write((Writer)writer), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        DataFrame df = (DataFrame)((Success)try_).value();
        return df;
    }

    public DataFrame write(Writer writer) {
        CsvWriterSettings settings = new CsvWriterSettings();
        if (this.delimiter != '\u0000') {
            ((CsvFormat)settings.getFormat()).setDelimiter(this.delimiter);
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.lineSeparator))) {
            settings.getFormat().setLineSeparator(this.lineSeparator);
        }
        if (this.quote != '\u0000') {
            ((CsvFormat)settings.getFormat()).setQuote(this.quote);
        }
        settings.setHeaderWritingEnabled(this.header);
        if (this.header) {
            settings.setHeaders((String[])Arrays$.MODULE$.seqToArray(this.df.columns(), String.class));
        }
        settings.setSkipEmptyLines(this.skipEmptyLines);
        com.univocity.parsers.csv.CsvWriter csvWriter = new com.univocity.parsers.csv.CsvWriter(writer, settings);
        Series<Object>[] cols = this.df.columnArray();
        int length = cols.length;
        Iterator<Object> it = this.df.indexIterator();
        while (it.hasNext()) {
            int row = BoxesRunTime.unboxToInt((Object)it.next());
            String[] array = new String[length];
            for (int c = 0; c < length; ++c) {
                array[c] = (String)cols[c].apply(row).map((Function1 & Serializable)_$1 -> _$1.toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            csvWriter.writeRow(array);
        }
        return this.df;
    }

    private final BufferedWriter write$$anonfun$1(String path$1) {
        return new BufferedWriter(new FileWriter(path$1, this.charset));
    }

    public static class Adapter {
        private final DataFrame df;

        public Adapter(DataFrame df) {
            this.df = df;
        }

        public CsvWriter csv() {
            return new CsvWriter(this.df, CsvWriter$.MODULE$.$lessinit$greater$default$2(), CsvWriter$.MODULE$.$lessinit$greater$default$3(), CsvWriter$.MODULE$.$lessinit$greater$default$4(), CsvWriter$.MODULE$.$lessinit$greater$default$5(), CsvWriter$.MODULE$.$lessinit$greater$default$6(), CsvWriter$.MODULE$.$lessinit$greater$default$7(), CsvWriter$.MODULE$.$lessinit$greater$default$8());
        }

        public CsvWriter csv(boolean header, char delimiter, String lineSeparator, char quote, Charset charset, String nullEncoding, boolean skipEmptyLines) {
            return new CsvWriter(this.df, header, delimiter, lineSeparator, quote, charset, nullEncoding, skipEmptyLines);
        }

        public boolean csv$default$1() {
            return true;
        }

        public char csv$default$2() {
            return '\u0000';
        }

        public String csv$default$3() {
            return "";
        }

        public char csv$default$4() {
            return '\u0000';
        }

        public Charset csv$default$5() {
            return Charset.defaultCharset();
        }

        public String csv$default$6() {
            return "";
        }

        public boolean csv$default$7() {
            return true;
        }
    }
}

