/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.xml;

import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.panteleyev.commons.xml.Formatters;

public class XMLStreamWriterWrapper
implements AutoCloseable {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter writer;
    private final boolean localDateAsEpochDay;

    public static XMLStreamWriterWrapper newInstance(OutputStream out) {
        return XMLStreamWriterWrapper.newInstance(out, Set.of());
    }

    public static XMLStreamWriterWrapper newInstance(OutputStream out, Set<Option> options) {
        try {
            return new XMLStreamWriterWrapper(XML_OUTPUT_FACTORY.createXMLStreamWriter(out), options.contains((Object)Option.LOCAL_DATE_AS_EPOCH_DAY));
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    private XMLStreamWriterWrapper(XMLStreamWriter writer, boolean localDateAsEpochDay) {
        this.writer = writer;
        this.localDateAsEpochDay = localDateAsEpochDay;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void document(Runnable body) {
        try {
            this.writer.writeStartDocument();
            body.run();
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper element(String localName, Runnable body) {
        try {
            this.writer.writeStartElement(localName);
            body.run();
            this.writer.writeEndElement();
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper element(String localName, String text) {
        try {
            this.writer.writeStartElement(localName);
            this.writer.writeCharacters(text);
            this.writer.writeEndElement();
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper element(String localName, Map<String, ?> attributes) {
        return this.element(localName, attributes, null);
    }

    public XMLStreamWriterWrapper element(String localName, Map<String, ?> attributes, String text) {
        try {
            this.writer.writeStartElement(localName);
            this.attributes(attributes);
            if (text != null) {
                this.writer.writeCharacters(text);
            }
            this.writer.writeEndElement();
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper attribute(String name, Object value) {
        try {
            if (value != null) {
                this.writer.writeAttribute(name, this.valueToString(value));
            }
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper attributes(Map<String, ?> attributes) {
        try {
            for (Map.Entry<String, ?> entry : attributes.entrySet()) {
                if (entry.getValue() == null) continue;
                this.writer.writeAttribute(entry.getKey(), this.valueToString(entry.getValue()));
            }
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper text(String text) {
        try {
            this.writer.writeCharacters(text);
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String valueToString(Object value) {
        String string;
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, LocalDateTime.class, Enum.class, LocalDate.class, LocalDate.class}, (Object)object2, n)) {
                case 0: {
                    String stringValue;
                    string = stringValue = (String)object2;
                    break block7;
                }
                case 1: {
                    LocalDateTime localDateTime = (LocalDateTime)object2;
                    string = localDateTime.format(Formatters.DATE_TIME_FORMATTER);
                    break block7;
                }
                case 2: {
                    Enum enumValue = (Enum)object2;
                    string = enumValue.name();
                    break block7;
                }
                case 3: {
                    LocalDate localDate = (LocalDate)object2;
                    if (!this.localDateAsEpochDay) {
                        n = 4;
                        continue block7;
                    }
                    string = Long.toString(localDate.toEpochDay());
                    break block7;
                }
                case 4: {
                    LocalDate localDate = (LocalDate)object2;
                    string = localDate.format(Formatters.DATE_FORMATTER);
                    break block7;
                }
                default: {
                    string = value.toString();
                    break block7;
                }
            }
            break;
        }
        return string;
    }

    public static enum Option {
        LOCAL_DATE_AS_EPOCH_DAY;

    }
}

