/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.password;

import java.util.Arrays;
import java.util.Random;

public enum PasswordCharacterSet {
    UPPER_CASE_LETTERS(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'}, new char[]{'I', 'O'}),
    LOWER_CASE_LETTERS(new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'}, new char[]{'l'}),
    DIGITS(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}),
    SYMBOLS(new char[]{'@', '#', '$', '%', '&', '*', '(', ')', '-', '+', '=', '^', '.', ','});

    private static final Random RANDOM;
    private final char[] characters;
    private final char[] ambiguousCharacters;

    private PasswordCharacterSet(char[] characters, char[] ambiguousCharacters) {
        this.characters = characters;
        this.ambiguousCharacters = ambiguousCharacters;
    }

    private PasswordCharacterSet(char[] characters) {
        this(characters, new char[0]);
    }

    char nextCharacter(boolean allowAmbiguousLetters) {
        char sym;
        do {
            sym = this.characters[RANDOM.nextInt(this.characters.length)];
        } while (!allowAmbiguousLetters && this.isAmbiguous(sym));
        return sym;
    }

    char[] getCharacters() {
        return this.characters;
    }

    private boolean isAmbiguous(char c) {
        return this.ambiguousCharacters.length > 0 && Arrays.binarySearch(this.ambiguousCharacters, c) >= 0;
    }

    boolean hasCharacter(char[] password) {
        for (char c : password) {
            if (Arrays.binarySearch(this.characters, c) < 0) continue;
            return true;
        }
        return false;
    }

    static {
        RANDOM = new Random(System.currentTimeMillis());
    }
}

