/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.xml;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

final class Converter {
    static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_DATE;
    private static final String TYPE_STRING = "java.lang.String";
    private static final String TYPE_BIG_DECIMAL = "java.math.BigDecimal";
    private static final String TYPE_BOOLEAN = "java.lang.Boolean";
    private static final String TYPE_BOOL = "boolean";
    private static final String TYPE_INTEGER = "java.lang.Integer";
    private static final String TYPE_INT = "int";
    private static final String TYPE_LONG = "java.lang.Long";
    private static final String TYPE_LONG_P = "long";
    private static final String TYPE_DOUBLE = "java.lang.Double";
    private static final String TYPE_DOUBLE_P = "double";
    private static final String TYPE_UUID = "java.util.UUID";
    private static final String TYPE_LOCAL_DATE = "java.time.LocalDate";
    private static final String TYPE_LOCAL_DATE_TIME = "java.time.LocalDateTime";
    private static final String TYPE_BYTE_ARRAY = "byte[]";

    static String valueToString(Object value, boolean localDateAsEpochDay) {
        String string;
        Objects.requireNonNull(value);
        if (value.getClass().getTypeName().equals(TYPE_BYTE_ARRAY)) {
            return Base64.getEncoder().encodeToString((byte[])value);
        }
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, LocalDateTime.class, Enum.class, LocalDate.class, LocalDate.class}, (Object)object2, n)) {
                case 0: {
                    String stringValue;
                    string = stringValue = (String)object2;
                    break block7;
                }
                case 1: {
                    LocalDateTime localDateTime = (LocalDateTime)object2;
                    string = localDateTime.format(DATE_TIME_FORMATTER);
                    break block7;
                }
                case 2: {
                    Enum enumValue = (Enum)object2;
                    string = enumValue.name();
                    break block7;
                }
                case 3: {
                    LocalDate localDate = (LocalDate)object2;
                    if (!localDateAsEpochDay) {
                        n = 4;
                        continue block7;
                    }
                    string = Long.toString(localDate.toEpochDay());
                    break block7;
                }
                case 4: {
                    LocalDate localDate = (LocalDate)object2;
                    string = localDate.format(DATE_FORMATTER);
                    break block7;
                }
                default: {
                    string = value.toString();
                    break block7;
                }
            }
            break;
        }
        return string;
    }

    static <T> Optional<T> stringToValue(Class<T> type, String stringValue, boolean localDateAsEpochDay) {
        if (stringValue == null) {
            return Optional.empty();
        }
        if (type.isEnum()) {
            return Optional.of(Enum.valueOf(type, stringValue));
        }
        String typeName = type.getTypeName();
        if (typeName.equals(TYPE_STRING)) {
            return Optional.of(stringValue);
        }
        if (stringValue.isBlank()) {
            return Optional.empty();
        }
        return Optional.ofNullable(switch (typeName) {
            case TYPE_INT -> Integer.parseInt(stringValue);
            case TYPE_INTEGER -> Integer.valueOf(stringValue);
            case TYPE_LONG_P -> Long.parseLong(stringValue);
            case TYPE_LONG -> Long.valueOf(stringValue);
            case TYPE_BOOL -> Boolean.parseBoolean(stringValue);
            case TYPE_BOOLEAN -> Boolean.valueOf(stringValue);
            case TYPE_DOUBLE -> Double.valueOf(stringValue);
            case TYPE_DOUBLE_P -> Double.parseDouble(stringValue);
            case TYPE_BIG_DECIMAL -> new BigDecimal(stringValue);
            case TYPE_UUID -> UUID.fromString(stringValue);
            case TYPE_LOCAL_DATE -> {
                if (localDateAsEpochDay) {
                    yield LocalDate.ofEpochDay(Long.parseLong(stringValue));
                }
                yield LocalDate.parse(stringValue, DATE_FORMATTER);
            }
            case TYPE_LOCAL_DATE_TIME -> LocalDateTime.parse(stringValue, DATE_TIME_FORMATTER);
            case TYPE_BYTE_ARRAY -> Base64.getDecoder().decode(stringValue);
            default -> throw new IllegalArgumentException("Unsupported type: " + typeName);
        });
    }

    private Converter() {
    }
}

