/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.xml;

import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.panteleyev.commons.xml.Converter;
import org.panteleyev.commons.xml.SerializationOption;
import org.panteleyev.commons.xml.XMLEventWrapper;

public class XMLEventReaderWrapper
implements AutoCloseable {
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private final XMLEventReader reader;
    private final boolean localDateAsEpochDay;

    public static XMLEventReaderWrapper newInstance(InputStream inputStream) {
        return XMLEventReaderWrapper.newInstance(inputStream, Set.of());
    }

    public static XMLEventReaderWrapper newInstance(InputStream inputStream, Set<SerializationOption> options) {
        try {
            return new XMLEventReaderWrapper(INPUT_FACTORY.createXMLEventReader(inputStream), options.contains((Object)SerializationOption.LOCAL_DATE_AS_EPOCH_DAY));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private XMLEventReaderWrapper(XMLEventReader reader, boolean localDateAsEpochDay) {
        this.reader = reader;
        this.localDateAsEpochDay = localDateAsEpochDay;
    }

    boolean isLocalDateAsEpochDay() {
        return this.localDateAsEpochDay;
    }

    public XMLEventReader getReader() {
        return this.reader;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean hasNext() {
        return this.reader.hasNext();
    }

    public XMLEventWrapper nextEvent() {
        try {
            return new XMLEventWrapper(this.reader.nextEvent(), this);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Optional<XMLEventWrapper> peek() {
        try {
            XMLEvent event = this.reader.peek();
            return event == null ? Optional.empty() : Optional.of(new XMLEventWrapper(event, this));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Optional<String> getElementText() {
        try {
            return Optional.of(this.reader.getElementText());
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    public boolean getElementValue(boolean defaultValue) {
        return this.getElementText().map(Boolean::parseBoolean).orElse(defaultValue);
    }

    public int getElementValue(int defaultValue) {
        return this.getElementText().map(Integer::parseInt).orElse(defaultValue);
    }

    public long getElementValue(long defaultValue) {
        return this.getElementText().map(Long::parseLong).orElse(defaultValue);
    }

    public <T> Optional<T> getElementValue(Class<T> type) {
        return this.getElementText().flatMap(text -> Converter.stringToValue(type, text, this.localDateAsEpochDay));
    }

    public <T> T getElementValue(T defaultValue) {
        return (T)this.getElementText().map(text -> Converter.stringToValue(defaultValue.getClass(), text, this.localDateAsEpochDay)).orElse(defaultValue);
    }
}

