/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.password;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import org.panteleyev.commons.password.PasswordCharacterSet;

public final class PasswordGenerator {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public String generate(Set<PasswordCharacterSet> characterSets, int length) {
        return this.generate(characterSets, length, false);
    }

    public String generate(Set<PasswordCharacterSet> characterSets, int length, boolean allowAmbiguousLetters) {
        if (characterSets.isEmpty()) {
            throw new IllegalArgumentException("At least one character set must be used");
        }
        if (length < 4) {
            throw new IllegalArgumentException("Password length must be at least 4");
        }
        ArrayList<PasswordCharacterSet> characterSetList = new ArrayList<PasswordCharacterSet>(characterSets);
        char[] password = new char[length];
        do {
            for (int i = 0; i < length; ++i) {
                PasswordCharacterSet characterSet2 = characterSetList.get(RANDOM.nextInt(characterSetList.size()));
                password[i] = characterSet2.nextCharacter(allowAmbiguousLetters);
            }
        } while (!characterSetList.stream().allMatch(characterSet -> characterSet.hasCharacter(password)));
        return new String(password);
    }
}

