/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.xml;

import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.panteleyev.commons.xml.Converter;
import org.panteleyev.commons.xml.XMLEventReaderWrapper;

public class StartElementWrapper {
    private final StartElement startElement;
    private final XMLEventReaderWrapper wrapper;

    StartElementWrapper(StartElement startElement, XMLEventReaderWrapper wrapper) {
        this.startElement = startElement;
        this.wrapper = wrapper;
    }

    public QName getName() {
        return this.startElement.getName();
    }

    public Optional<String> getAttributeValue(QName name) {
        Attribute attribute = this.startElement.getAttributeByName(name);
        return attribute == null ? Optional.empty() : Optional.of(attribute.getValue());
    }

    public <T> Optional<T> getAttributeValue(QName name, Class<T> type) {
        Attribute attribute = this.startElement.getAttributeByName(name);
        return attribute == null ? Optional.empty() : Converter.stringToValue(type, attribute.getValue(), this.wrapper.isLocalDateAsEpochDay());
    }

    public <T> T getAttributeValue(QName name, T defaultValue) {
        Attribute attribute = this.startElement.getAttributeByName(name);
        return (T)(attribute == null ? defaultValue : Converter.stringToValue(defaultValue.getClass(), attribute.getValue(), this.wrapper.isLocalDateAsEpochDay()).map(v -> v).orElse(defaultValue));
    }

    public int getAttributeValue(QName name, int defaultValue) {
        Attribute attribute = this.startElement.getAttributeByName(name);
        try {
            return attribute == null ? defaultValue : Integer.parseInt(attribute.getValue());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public long getAttributeValue(QName name, long defaultValue) {
        Attribute attribute = this.startElement.getAttributeByName(name);
        try {
            return attribute == null ? defaultValue : Long.parseLong(attribute.getValue());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public double getAttributeValue(QName name, double defaultValue) {
        Attribute attribute = this.startElement.getAttributeByName(name);
        try {
            return attribute == null ? defaultValue : Double.parseDouble(attribute.getValue());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public boolean getAttributeValue(QName name, boolean defaultValue) {
        Attribute attribute = this.startElement.getAttributeByName(name);
        return attribute == null ? defaultValue : Boolean.parseBoolean(attribute.getValue());
    }
}

