/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.xml;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.panteleyev.commons.xml.StartElementWrapper;
import org.panteleyev.commons.xml.XMLEventReaderWrapper;

public class XMLEventWrapper {
    private final XMLEvent event;
    private final XMLEventReaderWrapper wrapper;

    XMLEventWrapper(XMLEvent event, XMLEventReaderWrapper wrapper) {
        this.event = event;
        this.wrapper = wrapper;
    }

    public void ifStartElement(QName name, Consumer<StartElementWrapper> handler) {
        if (!this.event.isStartElement()) {
            return;
        }
        StartElement startElement = this.event.asStartElement();
        if (startElement.getName().equals(name)) {
            handler.accept(new StartElementWrapper(startElement, this.wrapper));
        }
    }

    public void ifStartElement(QName name, Predicate<StartElementWrapper> condition, Consumer<StartElementWrapper> handler) {
        StartElementWrapper elementWrapper;
        if (!this.event.isStartElement()) {
            return;
        }
        StartElement startElement = this.event.asStartElement();
        if (startElement.getName().equals(name) && condition.test(elementWrapper = new StartElementWrapper(startElement, this.wrapper))) {
            handler.accept(new StartElementWrapper(startElement, this.wrapper));
        }
    }

    public Optional<StartElementWrapper> asStartElement(QName name) {
        if (!this.event.isStartElement()) {
            return Optional.empty();
        }
        StartElement startElement = this.event.asStartElement();
        return startElement.getName().equals(name) ? Optional.of(new StartElementWrapper(startElement, this.wrapper)) : Optional.empty();
    }

    public Optional<StartElementWrapper> asStartElement() {
        return this.event.isStartElement() ? Optional.of(new StartElementWrapper(this.event.asStartElement(), this.wrapper)) : Optional.empty();
    }

    public boolean isEndElement(QName name) {
        return this.event.isEndElement() && this.event.asEndElement().getName().equals(name);
    }
}

