/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.panteleyev.commons.crypto.AESImpl;

public interface AES {
    default public byte[] encrypt(String str, String password) {
        return this.encrypt(str.getBytes(StandardCharsets.UTF_8), password);
    }

    public byte[] encrypt(byte[] var1, String var2);

    public void encrypt(byte[] var1, String var2, OutputStream var3) throws IOException;

    default public void encrypt(String str, String password, OutputStream out) throws IOException {
        this.encrypt(str.getBytes(StandardCharsets.UTF_8), password, out);
    }

    public byte[] decrypt(byte[] var1, String var2);

    public String decryptString(byte[] var1, String var2);

    public byte[] decrypt(InputStream var1, String var2) throws IOException;

    public InputStream getInputStream(InputStream var1, String var2) throws IOException;

    public OutputStream getOutputStream(OutputStream var1, String var2) throws IOException;

    public static byte[] generate256key(String password) {
        return AESImpl.generateKey(password, "SHA-256");
    }

    public static AES aes(Function<String, byte[]> keyGen) {
        return AESImpl.getInstance(keyGen);
    }

    public static AES aes256() {
        return AES.aes(AES::generate256key);
    }
}

