/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.panteleyev.commons.crypto.AES;

class AESImpl
implements AES {
    private static final Logger LOGGER = Logger.getLogger(AESImpl.class.getName());
    private static final String ALGO = "AES";
    private static final String ALGO_FULL = "AES/CBC/PKCS5Padding";
    private static final int IV_LENGTH = 16;
    private static final int FILE_BUF_SIZE = 4096;
    private static final Map<Function<String, byte[]>, AES> IMPLS = new ConcurrentHashMap<Function<String, byte[]>, AES>(2);
    private final Function<String, byte[]> keyGen;

    static byte[] generateKey(String password, String algo) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            return md.digest(password.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    static AES getInstance(Function<String, byte[]> keyGen) {
        Objects.requireNonNull(keyGen);
        return IMPLS.computeIfAbsent(keyGen, k -> new AESImpl(keyGen));
    }

    private static byte[] generateIV() {
        byte[] res = new byte[16];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(res);
        return res;
    }

    private AESImpl(Function<String, byte[]> keyGen) {
        this.keyGen = keyGen;
    }

    @Override
    public byte[] encrypt(byte[] src, String password) {
        try {
            byte[] iv = AESImpl.generateIV();
            Cipher cipher = this.getCipher(1, password, iv);
            byte[] encrypted = cipher.doFinal(src);
            byte[] res = Arrays.copyOf(iv, iv.length + encrypted.length);
            int i = 0;
            int j = iv.length;
            while (i < encrypted.length) {
                res[j] = encrypted[i];
                ++i;
                ++j;
            }
            return res;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void encrypt(byte[] src, String password, OutputStream out) throws IOException {
        try (OutputStream cOut = this.getOutputStream(out, password);){
            cOut.write(src);
        }
    }

    @Override
    public byte[] decrypt(byte[] bytes, String password) {
        if (bytes.length <= 16) {
            throw new IllegalArgumentException("Byte array to decrypt is too short");
        }
        try {
            Cipher c = this.getCipher(2, password, Arrays.copyOf(bytes, 16));
            return c.doFinal(bytes, 16, bytes.length - 16);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public String decryptString(byte[] bytes, String password) {
        byte[] res = this.decrypt(bytes, password);
        return new String(res, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] decrypt(InputStream in, String password) throws IOException {
        if (in instanceof CipherInputStream) {
            throw new IllegalArgumentException("CipherInputStream must be used directly");
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (InputStream cin = this.getInputStream(in, password);){
                int nRead;
                byte[] buf = new byte[4096];
                while ((nRead = cin.read(buf)) > 0) {
                    for (int i = 0; i < nRead; ++i) {
                        out.write(buf[i]);
                    }
                }
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    @Override
    public InputStream getInputStream(InputStream in, String password) throws IOException {
        try {
            byte[] iv = new byte[16];
            for (int i = 0; i < 16; ++i) {
                int b = in.read();
                if (b == -1) {
                    throw new IOException("premature end of stream");
                }
                iv[i] = (byte)b;
            }
            return new CipherInputStream(in, this.getCipher(2, password, iv));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    @Override
    public OutputStream getOutputStream(OutputStream out, String password) throws IOException {
        try {
            byte[] iv = AESImpl.generateIV();
            Cipher cipher = this.getCipher(1, password, iv);
            out.write(iv);
            return new CipherOutputStream(out, cipher);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
    }

    private Cipher getCipher(int opMode, String password, byte[] iv) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = Cipher.getInstance(ALGO_FULL);
        SecretKeySpec key = new SecretKeySpec(this.keyGen.apply(password), ALGO);
        cipher.init(opMode, (Key)key, new IvParameterSpec(iv));
        return cipher;
    }
}

