/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.functional;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.panteleyev.commons.functional.Failure;
import org.panteleyev.commons.functional.Success;

public sealed interface Result<T>
permits Success, Failure {
    default public boolean isSuccess() {
        return this instanceof Success;
    }

    default public boolean isFailure() {
        return this instanceof Failure;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public T getOrThrow() {
        Exception exception;
        Result result = this;
        Objects.requireNonNull(result);
        Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Success.class, Failure.class}, (Object)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Success success = (Success)result2;
                try {
                    Object t;
                    Object value = t = success.value();
                    return value;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        Failure failure = (Failure)result2;
        {
            Exception exception2;
            exception = exception2 = failure.exception();
        }
        throw Result.toRuntimeException(exception);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Optional<T> get() {
        Object value;
        Optional optional;
        Result result = this;
        if (!(result instanceof Success)) {
            optional = Optional.empty();
            return optional;
        }
        Success success = (Success)result;
        try {
            Object t;
            value = t = success.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        optional = Optional.ofNullable(value);
        return optional;
    }

    default public void throwIfFailure() {
        Result result = this;
        if (result instanceof Failure) {
            Exception exception;
            Failure failure = (Failure)result;
            try {
                Exception exception2;
                exception = exception2 = failure.exception();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            throw Result.toRuntimeException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Result<T> onSuccess(Consumer<T> consumer) {
        Result result = this;
        if (!(result instanceof Success)) return this;
        Success success = (Success)result;
        try {
            Object t;
            Object value = t = success.value();
            consumer.accept(value);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Result<T> onFailure(Consumer<Exception> consumer) {
        Result result = this;
        if (!(result instanceof Failure)) return this;
        Failure failure = (Failure)result;
        try {
            Exception exception;
            Exception exception2 = exception = failure.exception();
            consumer.accept(exception2);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return this;
    }

    public static <T> Result<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> Result<T> empty() {
        return Result.success(null);
    }

    public static <T> Result<T> failure(Exception exception) {
        return new Failure(Objects.requireNonNull(exception, "Failure exception must not be null"));
    }

    private static RuntimeException toRuntimeException(Exception exception) {
        RuntimeException runtimeException;
        return exception instanceof RuntimeException ? (runtimeException = (RuntimeException)exception) : new RuntimeException(exception);
    }
}

