/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.commons.xml;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.panteleyev.commons.xml.Converter;
import org.panteleyev.commons.xml.SerializationOption;

public class XMLStreamWriterWrapper
implements AutoCloseable {
    private static final XMLOutputFactory OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter writer;
    private final boolean localDateAsEpochDay;

    public static XMLStreamWriterWrapper newInstance(OutputStream out) {
        return XMLStreamWriterWrapper.newInstance(out, Set.of());
    }

    public static XMLStreamWriterWrapper newInstance(OutputStream out, Set<SerializationOption> options) {
        try {
            return new XMLStreamWriterWrapper(OUTPUT_FACTORY.createXMLStreamWriter(out), options.contains((Object)SerializationOption.LOCAL_DATE_AS_EPOCH_DAY));
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    private XMLStreamWriterWrapper(XMLStreamWriter writer, boolean localDateAsEpochDay) {
        this.writer = writer;
        this.localDateAsEpochDay = localDateAsEpochDay;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void document(Runnable body) {
        try {
            this.writer.writeStartDocument();
            body.run();
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void document(QName name, Runnable body) {
        try {
            this.writer.writeStartDocument();
            this.writer.writeStartElement(name.getLocalPart());
            body.run();
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper element(QName name, Runnable body) {
        try {
            this.writer.writeStartElement(name.getLocalPart());
            body.run();
            this.writer.writeEndElement();
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper textElement(QName name, Object value) {
        try {
            this.writer.writeStartElement(name.getLocalPart());
            this.writer.writeCharacters(Converter.valueToString(value, this.localDateAsEpochDay));
            this.writer.writeEndElement();
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper element(QName name, Map<QName, ?> attributes) {
        return this.textElement(name, attributes, null);
    }

    public XMLStreamWriterWrapper textElement(QName name, Map<QName, ?> attributes, Object value) {
        try {
            this.writer.writeStartElement(name.getLocalPart());
            this.attributes(attributes);
            if (value != null) {
                this.writer.writeCharacters(Converter.valueToString(value, this.localDateAsEpochDay));
            }
            this.writer.writeEndElement();
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper attribute(QName name, Object value) {
        try {
            if (value != null) {
                this.writer.writeAttribute(name.getLocalPart(), Converter.valueToString(value, this.localDateAsEpochDay));
            }
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper attributes(Map<QName, ?> attributes) {
        try {
            for (Map.Entry<QName, ?> entry : attributes.entrySet()) {
                if (entry.getValue() == null) continue;
                this.writer.writeAttribute(entry.getKey().getLocalPart(), Converter.valueToString(entry.getValue(), this.localDateAsEpochDay));
            }
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    public XMLStreamWriterWrapper text(String text) {
        try {
            this.writer.writeCharacters(text);
            return this;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }
}

