/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.persistence;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.panteleyev.persistence.DAOProxy;
import org.panteleyev.persistence.MySQLProxy;
import org.panteleyev.persistence.Record;
import org.panteleyev.persistence.SQLiteProxy;
import org.panteleyev.persistence.annotations.Column;
import org.panteleyev.persistence.annotations.ForeignKey;
import org.panteleyev.persistence.annotations.Index;
import org.panteleyev.persistence.annotations.RecordBuilder;
import org.panteleyev.persistence.annotations.Table;
import sun.misc.Unsafe;

public class DAO {
    private static final String NOT_ANNOTATED = "Class is not properly annotated";
    private final Map<Class<? extends Record>, Integer> primaryKeys = new ConcurrentHashMap<Class<? extends Record>, Integer>();
    private final Map<Class<? extends Record>, String> insertSQL = new ConcurrentHashMap<Class<? extends Record>, String>();
    private final Map<Class<? extends Record>, String> updateSQL = new ConcurrentHashMap<Class<? extends Record>, String>();
    private final Map<Class<? extends Record>, String> deleteSQL = new ConcurrentHashMap<Class<? extends Record>, String>();
    private static final Unsafe UNSAFE;
    private final Map<Class<? extends Record>, Constructor<?>> constructorMap = new ConcurrentHashMap();
    private final Map<Constructor<?>, List<String>> constructorFieldsMap = new ConcurrentHashMap();
    private final Map<Class<? extends Record>, Map<String, FieldRecord>> columnMap = new ConcurrentHashMap<Class<? extends Record>, Map<String, FieldRecord>>();
    private DataSource datasource;
    private DAOProxy proxy;

    public DAO() {
    }

    DAO(DAOProxy proxy) {
        this.proxy = proxy;
    }

    public DAO(DataSource ds) {
        this.datasource = ds;
        this.proxy = this.setupProxy();
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public void setDataSource(DataSource ds) {
        this.datasource = ds;
        this.primaryKeys.clear();
        this.insertSQL.clear();
        this.deleteSQL.clear();
        this.proxy = this.setupProxy();
    }

    private DAOProxy setupProxy() {
        if (this.datasource != null) {
            String dsClass = this.datasource.getClass().getName().toLowerCase();
            if (dsClass.contains("mysql")) {
                return new MySQLProxy();
            }
            if (dsClass.contains("sqlite")) {
                return new SQLiteProxy();
            }
            throw new IllegalStateException("Unsupported database type");
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    /*
     * Exception decompiling
     */
    public <T extends Record> T get(Integer id, Class<? extends T> clazz) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T extends Record> List<T> getAll(Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        try (Connection conn = this.getDataSource().getConnection();){
            if (!clazz.isAnnotationPresent(Table.class)) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            String tableName = clazz.getAnnotation(Table.class).value();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + tableName);
            try (ResultSet set = ps.executeQuery();){
                while (set.next()) {
                    result.add(this.fromSQL(set, clazz));
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public <T extends Record> void getAll(Class<T> clazz, Map<Integer, T> result) {
        try (Connection conn = this.getDataSource().getConnection();){
            if (!clazz.isAnnotationPresent(Table.class)) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            String tableName = clazz.getAnnotation(Table.class).value();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + tableName);
            try (ResultSet set = ps.executeQuery();){
                while (set.next()) {
                    T r = this.fromSQL(set, clazz);
                    result.put(r.getId(), r);
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    static Map<String, FieldRecord> computeColumns(Class<? extends Record> clazz) {
        HashMap<String, FieldRecord> result = new HashMap<String, FieldRecord>();
        for (Field field : clazz.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            result.put(column.value(), new FieldRecord(field.getType(), UNSAFE.objectFieldOffset(field)));
        }
        return result;
    }

    private void fromSQL(ResultSet set, Record record, Map<String, FieldRecord> columns) throws SQLException {
        block10: for (Map.Entry<String, FieldRecord> entry : columns.entrySet()) {
            FieldRecord fieldRecord = entry.getValue();
            Object value = this.proxy.getFieldValue(entry.getKey(), fieldRecord.type, set);
            switch (fieldRecord.type.getName()) {
                case "int": {
                    UNSAFE.putInt(record, fieldRecord.offset, value == null ? 0 : (Integer)value);
                    continue block10;
                }
                case "long": {
                    UNSAFE.putLong(record, fieldRecord.offset, value == null ? 0L : (Long)value);
                    continue block10;
                }
                case "boolean": {
                    UNSAFE.putBoolean(record, fieldRecord.offset, value != null && (Boolean)value != false);
                    continue block10;
                }
            }
            UNSAFE.putObject(record, fieldRecord.offset, value);
        }
        UNSAFE.fullFence();
    }

    private <T extends Record> T fromSQL(ResultSet set, Constructor<?> constructor) {
        List fieldNames = this.constructorFieldsMap.computeIfAbsent(constructor, DAO::computeParameters);
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[fieldNames.size()];
        try {
            for (int i = 0; i < fieldNames.size(); ++i) {
                params[i] = this.proxy.getFieldValue((String)fieldNames.get(i), paramTypes[i], set);
            }
            return (T)((Record)constructor.newInstance(params));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    <T extends Record> T fromSQL(ResultSet set, Class<T> clazz) {
        Constructor builder = this.constructorMap.computeIfAbsent(clazz, keyClass -> {
            for (Constructor<?> constructor : keyClass.getConstructors()) {
                if (!constructor.isAnnotationPresent(RecordBuilder.class)) continue;
                return constructor;
            }
            return null;
        });
        try {
            if (builder != null) {
                return this.fromSQL(set, builder);
            }
            Map columns = this.columnMap.computeIfAbsent(clazz, DAO::computeColumns);
            if (columns.isEmpty()) {
                throw new IllegalStateException("Class " + clazz.getName() + " has no column annotations");
            }
            Record result = (Record)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.fromSQL(set, result, columns);
            return (T)result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTables(List<Class<? extends Record>> tables) {
        if (this.getDataSource() == null) {
            throw new IllegalStateException("Database not opened");
        }
        try (Connection conn = this.getDataSource().getConnection();
             Statement st = conn.createStatement();){
            Table table;
            for (int index = tables.size() - 1; index >= 0; --index) {
                Class<? extends Record> cl = tables.get(index);
                if (!cl.isAnnotationPresent(Table.class)) {
                    throw new IllegalStateException(NOT_ANNOTATED);
                }
                table = cl.getAnnotation(Table.class);
                st.executeUpdate("DROP TABLE IF EXISTS " + table.value());
            }
            for (Class<? extends Record> cl : tables) {
                table = cl.getAnnotation(Table.class);
                try {
                    StringBuilder b = new StringBuilder("CREATE TABLE IF NOT EXISTS ").append(table.value()).append(" (");
                    ArrayList<String> constraints = new ArrayList<String>();
                    HashSet<Field> indexed = new HashSet<Field>();
                    boolean first = true;
                    for (Field field : cl.getDeclaredFields()) {
                        String typeName;
                        if (!field.isAnnotationPresent(Column.class)) continue;
                        Column column = field.getAnnotation(Column.class);
                        String fName = column.value();
                        Class<?> getterType = field.getType();
                        String string = typeName = getterType.isEnum() ? "*** enum ***" : getterType.getTypeName();
                        if (!first) {
                            b.append(",");
                        }
                        first = false;
                        b.append(fName).append(" ").append(this.proxy.getColumnString(column, field.getAnnotation(ForeignKey.class), typeName, constraints));
                        if (!field.isAnnotationPresent(Index.class)) continue;
                        indexed.add(field);
                    }
                    if (!constraints.isEmpty()) {
                        b.append(",");
                        b.append(constraints.stream().collect(Collectors.joining(",")));
                    }
                    b.append(")");
                    st.executeUpdate(b.toString());
                    for (Field field : indexed) {
                        st.executeUpdate(this.proxy.buildIndex(table, field));
                    }
                }
                catch (SecurityException | SQLException ex) {
                    throw new RuntimeException(ex);
                    return;
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getInsertSQL(Record record) {
        return this.insertSQL.computeIfAbsent(record.getClass(), clazz -> {
            StringBuilder b = new StringBuilder("INSERT INTO ");
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException("Class " + clazz.getName() + " is not properly annotated");
            }
            b.append(table.value()).append(" (");
            int fCount = 0;
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    if (fCount != 0) {
                        b.append(",");
                    }
                    b.append(column.value());
                    ++fCount;
                }
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            if (fCount == 0) {
                throw new IllegalStateException("No fields");
            }
            b.append(") VALUES (");
            while (fCount != 0) {
                b.append("?");
                if (fCount != 1) {
                    b.append(",");
                }
                --fCount;
            }
            b.append(")");
            return b.toString();
        });
    }

    private String getUpdateSQL(Record record) {
        return this.updateSQL.computeIfAbsent(record.getClass(), clazz -> {
            StringBuilder b = new StringBuilder("update ");
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            b.append(table.value()).append(" set ");
            int fCount = 0;
            try {
                for (Field field : record.getClass().getDeclaredFields()) {
                    Column column = field.getAnnotation(Column.class);
                    if (column == null || column.primaryKey()) continue;
                    if (fCount != 0) {
                        b.append(", ");
                    }
                    b.append(column.value()).append("=?");
                    ++fCount;
                }
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            if (fCount == 0) {
                throw new IllegalStateException("No fields");
            }
            b.append(" WHERE id=?");
            return b.toString();
        });
    }

    private String getDeleteSQL(Class<? extends Record> clazz) {
        return this.deleteSQL.computeIfAbsent(clazz, cl -> {
            StringBuilder b = new StringBuilder("DELETE FROM ");
            Table table = cl.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            b.append(table.value()).append(" WHERE ");
            String idName = null;
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    Column column = field.getAnnotation(Column.class);
                    if (column == null || !column.primaryKey()) continue;
                    idName = column.value();
                    break;
                }
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            if (idName == null) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            b.append(idName).append("=?");
            return b.toString();
        });
    }

    private String getDeleteSQL(Record record) {
        return this.getDeleteSQL(record.getClass());
    }

    private void setData(Record record, PreparedStatement st, boolean update) {
        try {
            int index = 1;
            Map columns = this.columnMap.computeIfAbsent(record.getClass(), DAO::computeColumns);
            for (Field field : record.getClass().getDeclaredFields()) {
                Object value;
                if (!field.isAnnotationPresent(Column.class)) continue;
                Column fld = field.getAnnotation(Column.class);
                if (update && fld.primaryKey()) continue;
                FieldRecord fieldRecord = (FieldRecord)columns.get(fld.value());
                Class<?> fieldType = field.getType();
                switch (fieldType.getName()) {
                    case "int": {
                        value = UNSAFE.getInt(record, fieldRecord.offset);
                        break;
                    }
                    case "long": {
                        value = UNSAFE.getLong(record, fieldRecord.offset);
                        break;
                    }
                    case "boolean": {
                        value = UNSAFE.getBoolean(record, fieldRecord.offset);
                        break;
                    }
                    default: {
                        value = UNSAFE.getObject(record, fieldRecord.offset);
                    }
                }
                String typeName = fieldType.isEnum() ? "*** enum ***" : fieldType.getName();
                this.proxy.setFieldData(st, index++, value, typeName);
            }
            if (update) {
                st.setInt(index, record.getId());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private PreparedStatement getPreparedStatement(Record record, Connection conn, boolean update) throws SQLException {
        String sql = update ? this.getUpdateSQL(record) : this.getInsertSQL(record);
        PreparedStatement st = conn.prepareStatement(sql);
        this.setData(record, st, update);
        return st;
    }

    private PreparedStatement getDeleteStatement(Record record, Connection conn) throws SQLException {
        PreparedStatement st = conn.prepareStatement(this.getDeleteSQL(record));
        st.setInt(1, record.getId());
        return st;
    }

    private PreparedStatement getDeleteStatement(Integer id, Class<? extends Record> clazz, Connection conn) throws SQLException {
        PreparedStatement st = conn.prepareStatement(this.getDeleteSQL(clazz));
        st.setInt(1, id);
        return st;
    }

    public void preload(Collection<Class<? extends Record>> tables) {
        tables.stream().filter(x -> x.isAnnotationPresent(Table.class)).forEach(x -> {
            Table a = x.getAnnotation(Table.class);
            Integer id = this.getIdMaxValue(a.value());
            this.primaryKeys.put((Class<? extends Record>)x, id);
        });
    }

    public Integer generatePrimaryKey(Class<? extends Record> clazz) {
        return this.primaryKeys.compute(clazz, (k, v) -> {
            int n;
            if (v == null) {
                n = 1;
            } else {
                v = v + 1;
                n = v;
            }
            return n;
        });
    }

    /*
     * Exception decompiling
     */
    private Integer getIdMaxValue(String tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Record> T insert(T record) {
        try (Connection conn = this.getDataSource().getConnection();){
            T t = this.insert(conn, record);
            return t;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Record> T insert(Connection conn, T record) {
        if (record.getId() == 0) {
            throw new IllegalArgumentException("id == 0");
        }
        try (PreparedStatement st = this.getPreparedStatement(record, conn, false);){
            st.executeUpdate();
            Object obj = this.get(record.getId(), record.getClass());
            return (T)obj;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Record> void insert(int size, List<T> records) {
        try (Connection conn = this.getConnection();){
            this.insert(conn, size, records);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Record> void insert(Connection conn, int size, List<T> records) {
        if (size < 1) {
            throw new IllegalArgumentException("Batch size must be >= 1");
        }
        if (!records.isEmpty()) {
            String sql = this.getInsertSQL((Record)records.get(0));
            try (PreparedStatement st = conn.prepareStatement(sql);){
                int count = 0;
                for (Record r : records) {
                    this.setData(r, st, false);
                    st.addBatch();
                    if (++count % size != 0) continue;
                    st.executeBatch();
                }
                st.executeBatch();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Record> T update(T record) {
        try (Connection conn = this.getDataSource().getConnection();){
            T t = this.update(conn, record);
            return t;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Record> T update(Connection conn, T record) {
        if (record.getId() == 0) {
            throw new IllegalArgumentException("id == 0");
        }
        try (PreparedStatement ps = this.getPreparedStatement(record, conn, true);){
            ps.executeUpdate();
            Object obj = this.get(record.getId(), record.getClass());
            return (T)obj;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void delete(Record record) {
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = this.getDeleteStatement(record, conn);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void delete(Integer id, Class<? extends Record> clazz) {
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = this.getDeleteStatement(id, clazz, conn);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void deleteAll(Class<? extends Record> table) {
        try (Connection connection = this.getDataSource().getConnection();){
            this.deleteAll(connection, table);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void deleteAll(Connection connection, Class<? extends Record> table) {
        this.proxy.deleteAll(connection, table);
    }

    public void truncate(List<Class<? extends Record>> tables) {
        try (Connection connection = this.getDataSource().getConnection();){
            this.proxy.truncate(connection, tables);
            for (Class<? extends Record> t : tables) {
                this.primaryKeys.put(t, 0);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void resetPrimaryKey(Class<? extends Record> table) {
        this.primaryKeys.put(table, 0);
    }

    public void dropTables(List<Class<? extends Record>> tables) {
        try (Connection conn = this.getDataSource().getConnection();
             Statement st = conn.createStatement();){
            for (Class<? extends Record> t : tables) {
                st.execute("DROP TABLE " + Record.getTableName(t));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    static List<String> computeParameters(Constructor<?> constructor) {
        Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
        if (paramAnnotations.length == 0) {
            throw new IllegalArgumentException("Constructor builder must have parameters");
        }
        ArrayList<String> result = new ArrayList<String>(paramAnnotations.length);
        for (Annotation[] paramAnnotation : paramAnnotations) {
            String fieldName = Arrays.stream(paramAnnotation).filter(a -> a instanceof Column).findAny().map(a -> ((Column)a).value()).orElseThrow(RuntimeException::new);
            result.add(fieldName);
        }
        return result;
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static class FieldRecord {
        public final Class<?> type;
        public final long offset;

        public FieldRecord(Class<?> type, long offset) {
            this.type = type;
            this.offset = offset;
        }
    }
}

