/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.persistence;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.panteleyev.persistence.DAOProxy;
import org.panteleyev.persistence.DAOTypes;
import org.panteleyev.persistence.Record;
import org.panteleyev.persistence.annotations.Column;
import org.panteleyev.persistence.annotations.ForeignKey;

class MySQLProxy
implements DAOProxy,
DAOTypes {
    private static final Map<String, BiFunction<ResultSet, String, ?>> RESULT_SET_READERS = Map.ofEntries(Map.entry("java.lang.String", OBJECT_READER), Map.entry("java.lang.Integer", OBJECT_READER), Map.entry("int", INT_READER), Map.entry("java.lang.Long", OBJECT_READER), Map.entry("long", LONG_READER), Map.entry("boolean", BOOL_READER), Map.entry("java.lang.Boolean", OBJECT_READER), Map.entry("java.math.BigDecimal", BIG_DECIMAL_READER), Map.entry("java.util.Date", DATE_READER), Map.entry("java.time.LocalDate", LOCAL_DATE_READER));

    MySQLProxy() {
    }

    @Override
    public Map<String, BiFunction<ResultSet, String, ?>> getReaderMap() {
        return RESULT_SET_READERS;
    }

    @Override
    public String getColumnString(Column column, ForeignKey foreignKey, String typeName, List<String> constraints) {
        StringBuilder b = new StringBuilder();
        switch (typeName) {
            case "java.lang.String": 
            case "*** enum ***": {
                b.append("VARCHAR(").append(column.length()).append(")");
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                b.append("BOOLEAN");
                break;
            }
            case "java.lang.Integer": 
            case "int": {
                b.append("INTEGER");
                break;
            }
            case "java.lang.Long": 
            case "long": {
                b.append("BIGINT");
                break;
            }
            case "java.util.Date": 
            case "java.time.LocalDate": {
                b.append("BIGINT");
                break;
            }
            case "java.math.BigDecimal": {
                b.append("DECIMAL(").append(column.precision()).append(",").append(column.scale()).append(")");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported field type");
            }
        }
        if (column.primaryKey()) {
            b.append(" PRIMARY KEY");
        }
        if (!column.nullable()) {
            b.append(" NOT NULL");
        }
        if (foreignKey != null) {
            constraints.add(this.buildForeignKey(column, foreignKey));
        }
        return b.toString();
    }

    @Override
    public void truncate(Connection connection, List<Class<? extends Record>> tables) {
        try (Statement statement = connection.createStatement();){
            for (Class<? extends Record> t : tables) {
                statement.execute("TRUNCATE TABLE " + Record.getTableName(t));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

