/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.persistence;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.panteleyev.persistence.DAOProxy;
import org.panteleyev.persistence.DAOTypes;
import org.panteleyev.persistence.MySQLProxy;
import org.panteleyev.persistence.Record;
import org.panteleyev.persistence.SQLiteProxy;
import org.panteleyev.persistence.annotations.Column;
import org.panteleyev.persistence.annotations.ForeignKey;
import org.panteleyev.persistence.annotations.Index;
import org.panteleyev.persistence.annotations.PrimaryKey;
import org.panteleyev.persistence.annotations.RecordBuilder;
import org.panteleyev.persistence.annotations.Table;

public class DAO {
    private static final String NOT_ANNOTATED = "Class is not properly annotated";
    private final Map<Class<? extends Record>, Number> primaryKeys = new ConcurrentHashMap<Class<? extends Record>, Number>();
    private final Map<Class<? extends Record>, String> selectAllSql = new ConcurrentHashMap<Class<? extends Record>, String>();
    private final Map<Class<? extends Record>, String> selectByIdSql = new ConcurrentHashMap<Class<? extends Record>, String>();
    private final Map<Class<? extends Record>, String> insertSql = new ConcurrentHashMap<Class<? extends Record>, String>();
    private final Map<Class<? extends Record>, String> updateSql = new ConcurrentHashMap<Class<? extends Record>, String>();
    private final Map<Class<? extends Record>, String> deleteSql = new ConcurrentHashMap<Class<? extends Record>, String>();
    private static final Map<Class<? extends Record>, PrimaryKeyHandle> PRIMARY_KEY_HANDLE_MAP = new ConcurrentHashMap<Class<? extends Record>, PrimaryKeyHandle>();
    private static final Map<Class<? extends Record>, ConstructorHandle> CONSTRUCTOR_MAP = new ConcurrentHashMap<Class<? extends Record>, ConstructorHandle>();
    private static final Map<Class<? extends Record>, Map<String, VarHandle>> COLUMN_MAP = new ConcurrentHashMap<Class<? extends Record>, Map<String, VarHandle>>();
    private DataSource datasource;
    private DAOProxy proxy;
    private DatabaseType databaseType;

    public DAO() {
    }

    DAO(DAOProxy proxy) {
        this.proxy = proxy;
        this.databaseType = DatabaseType.getProxyType(proxy);
    }

    public DAO(DataSource ds, DatabaseType databaseType) {
        this.datasource = ds;
        this.proxy = databaseType.newProxy();
        this.databaseType = databaseType;
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDataSource(DataSource ds, DatabaseType databaseType) {
        this.datasource = ds;
        this.primaryKeys.clear();
        this.insertSql.clear();
        this.deleteSql.clear();
        this.proxy = databaseType.newProxy();
        this.databaseType = databaseType;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public <K, T extends Record<K>> Optional<T> get(K id, Class<? extends T> clazz) {
        try (Connection conn = this.getDataSource().getConnection();){
            Optional optional;
            block15: {
                if (!clazz.isAnnotationPresent(Table.class)) {
                    throw new IllegalStateException(NOT_ANNOTATED);
                }
                PreparedStatement ps = conn.prepareStatement(this.getSelectByIdSql(clazz));
                PrimaryKeyHandle primaryKey = DAO.findPrimaryKey(clazz);
                this.setColumnToPreparedStatement(ps, 1, primaryKey.field, id);
                ResultSet set = ps.executeQuery();
                try {
                    Optional optional2 = optional = set.next() ? Optional.of(this.fromSQL(set, clazz)) : Optional.empty();
                    if (set == null) break block15;
                }
                catch (Throwable throwable) {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                set.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Record> List<T> getAll(Connection conn, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            if (!clazz.isAnnotationPresent(Table.class)) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            PreparedStatement ps = conn.prepareStatement(this.getSelectAllSql(clazz));
            try (ResultSet set = ps.executeQuery();){
                while (set.next()) {
                    result.add(this.fromSQL(set, clazz));
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public <T extends Record> List<T> getAll(Class<T> clazz) {
        List<T> list;
        block8: {
            Connection conn = this.getDataSource().getConnection();
            try {
                list = this.getAll(conn, clazz);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            conn.close();
        }
        return list;
    }

    public <K, T extends Record<K>> void getAll(Connection conn, Class<T> clazz, Map<K, T> result) {
        try {
            if (!clazz.isAnnotationPresent(Table.class)) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            PreparedStatement ps = conn.prepareStatement(this.getSelectAllSql(clazz));
            try (ResultSet set = ps.executeQuery();){
                while (set.next()) {
                    T r = this.fromSQL(set, clazz);
                    result.put(r.getPrimaryKey(), r);
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <K, T extends Record<K>> void getAll(Class<T> clazz, Map<K, T> result) {
        try (Connection conn = this.getDataSource().getConnection();){
            this.getAll(conn, clazz, result);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    static Map<String, VarHandle> computeColumns(Class<? extends Record> clazz) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(clazz, MethodHandles.lookup());
            HashMap<String, VarHandle> result = new HashMap<String, VarHandle>();
            for (Field field : clazz.getDeclaredFields()) {
                Column column = field.getAnnotation(Column.class);
                if (column == null) continue;
                VarHandle handle = lookup.unreflectVarHandle(field);
                result.put(column.value(), handle);
            }
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void fromSQL(ResultSet set, Record record, Map<String, VarHandle> columns) throws SQLException {
        block10: for (Map.Entry<String, VarHandle> entry : columns.entrySet()) {
            VarHandle handle = entry.getValue();
            Object value = this.proxy.getFieldValue(entry.getKey(), handle.varType(), set);
            switch (handle.varType().getName()) {
                case "int": {
                    handle.set(record, value == null ? 0 : (Integer)value);
                    continue block10;
                }
                case "long": {
                    handle.set(record, value == null ? 0L : (Long)value);
                    continue block10;
                }
                case "boolean": {
                    handle.set(record, value != null && (Boolean)value != false);
                    continue block10;
                }
            }
            handle.set(record, value);
        }
    }

    private <T extends Record> T fromSQL(ResultSet set, ConstructorHandle builder) {
        try {
            ArrayList<Object> params = new ArrayList<Object>(builder.parameters.size());
            for (ParameterHandle ph : builder.parameters) {
                params.add(this.proxy.getFieldValue(ph.name, ph.type, set));
            }
            return (T)((Record)builder.handle.invokeWithArguments(params));
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    <T extends Record> T fromSQL(ResultSet set, Class<T> clazz) {
        ConstructorHandle builder = CONSTRUCTOR_MAP.computeIfAbsent(clazz, DAO::cacheConstructorHandle);
        try {
            if (builder != null) {
                return this.fromSQL(set, builder);
            }
            Map columns = COLUMN_MAP.computeIfAbsent(clazz, DAO::computeColumns);
            if (columns.isEmpty()) {
                throw new IllegalStateException("Class " + clazz.getName() + " has no column annotations");
            }
            Record result = (Record)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.fromSQL(set, result, columns);
            return (T)result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void createTables(List<Class<? extends Record>> tables) {
        if (this.getDataSource() == null) {
            throw new IllegalStateException("Database not opened");
        }
        try (Connection conn = this.getDataSource().getConnection();){
            this.createTables(conn, tables);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTables(Connection conn, List<Class<? extends Record>> tables) {
        try (Statement st = conn.createStatement();){
            Table table;
            for (int index = tables.size() - 1; index >= 0; --index) {
                Class<? extends Record> cl = tables.get(index);
                if (!cl.isAnnotationPresent(Table.class)) {
                    throw new IllegalStateException(NOT_ANNOTATED);
                }
                table = cl.getAnnotation(Table.class);
                st.executeUpdate("DROP TABLE IF EXISTS " + table.value());
            }
            for (Class<? extends Record> cl : tables) {
                table = cl.getAnnotation(Table.class);
                try {
                    StringBuilder b = new StringBuilder("CREATE TABLE IF NOT EXISTS ").append(table.value()).append(" (");
                    ArrayList<String> constraints = new ArrayList<String>();
                    HashSet<Field> indexed = new HashSet<Field>();
                    boolean first = true;
                    for (Field field : cl.getDeclaredFields()) {
                        String typeName;
                        if (!field.isAnnotationPresent(Column.class)) continue;
                        Column column = field.getAnnotation(Column.class);
                        String fName = column.value();
                        Class<?> getterType = field.getType();
                        String string = typeName = getterType.isEnum() ? "*** enum ***" : getterType.getTypeName();
                        if (!first) {
                            b.append(",");
                        }
                        first = false;
                        b.append(fName).append(" ").append(this.proxy.getColumnString(column, field.getAnnotation(PrimaryKey.class), field.getAnnotation(ForeignKey.class), typeName, constraints));
                        if (!field.isAnnotationPresent(Index.class)) continue;
                        indexed.add(field);
                    }
                    if (!constraints.isEmpty()) {
                        b.append(",");
                        b.append(String.join((CharSequence)",", constraints));
                    }
                    b.append(")");
                    st.executeUpdate(b.toString());
                    for (Field field : indexed) {
                        st.executeUpdate(this.proxy.buildIndex(table, field));
                    }
                }
                catch (SecurityException | SQLException ex) {
                    throw new RuntimeException(ex);
                    return;
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    String getSelectAllSql(Class<? extends Record> recordClass) {
        return this.selectAllSql.computeIfAbsent(recordClass, clazz -> {
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException("Class is not properly annotated: " + clazz.getName());
            }
            String columnString = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Column.class)).map(field -> this.proxy.getSelectColumnString((Field)field)).collect(Collectors.joining(","));
            if (columnString.isEmpty()) {
                throw new IllegalStateException("No fields");
            }
            return "SELECT " + columnString + " FROM " + table.value();
        });
    }

    String getSelectByIdSql(Class<? extends Record> recordClass) {
        return this.selectByIdSql.computeIfAbsent(recordClass, clazz -> this.getSelectAllSql((Class<? extends Record>)clazz) + " WHERE " + this.proxy.getWhereColumnString(DAO.findPrimaryKey((Class<? extends Record>)clazz).field) + "=?");
    }

    private String getInsertSQL(Record record) {
        return this.insertSql.computeIfAbsent(record.getClass(), clazz -> {
            StringBuilder b = new StringBuilder("INSERT INTO ");
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException("Class " + clazz.getName() + " is not properly annotated");
            }
            b.append(table.value()).append(" (");
            int fCount = 0;
            StringBuilder valueString = new StringBuilder();
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    Column column = field.getAnnotation(Column.class);
                    if (column == null) continue;
                    if (fCount != 0) {
                        b.append(",");
                        valueString.append(",");
                    }
                    b.append(column.value());
                    valueString.append(this.proxy.getInsertColumnPattern(field));
                    ++fCount;
                }
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            if (fCount == 0) {
                throw new IllegalStateException("No fields");
            }
            b.append(") VALUES (").append((CharSequence)valueString).append(")");
            return b.toString();
        });
    }

    private String getUpdateSQL(Record record) {
        return this.updateSql.computeIfAbsent(record.getClass(), clazz -> {
            StringBuilder b = new StringBuilder("update ");
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            b.append(table.value()).append(" set ");
            int fCount = 0;
            try {
                for (Field field : record.getClass().getDeclaredFields()) {
                    Column column = field.getAnnotation(Column.class);
                    if (column == null || field.getAnnotation(PrimaryKey.class) != null) continue;
                    if (fCount != 0) {
                        b.append(", ");
                    }
                    b.append(column.value()).append("=").append(this.proxy.getUpdateColumnPattern(field));
                    ++fCount;
                }
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            if (fCount == 0) {
                throw new IllegalStateException("No fields");
            }
            PrimaryKeyHandle primaryKeyField = DAO.findPrimaryKey(clazz);
            b.append(" WHERE ").append(this.proxy.getWhereColumnString(primaryKeyField.field)).append("=?");
            return b.toString();
        });
    }

    String getDeleteSQL(Class<? extends Record> clazz) {
        return this.deleteSql.computeIfAbsent(clazz, cl -> {
            StringBuilder b = new StringBuilder("DELETE FROM ");
            Table table = cl.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            b.append(table.value());
            PrimaryKeyHandle primaryKeyField = DAO.findPrimaryKey(clazz);
            b.append(" WHERE ").append(this.proxy.getWhereColumnString(primaryKeyField.field)).append("=?");
            return b.toString();
        });
    }

    private String getDeleteSQL(Record record) {
        return this.getDeleteSQL(record.getClass());
    }

    private void setColumnToPreparedStatement(Record record, PreparedStatement st, int index, Field field, VarHandle handle) throws SQLException {
        Class<?> fieldType = field.getType();
        Object value = handle.get(record);
        String typeName = fieldType.isEnum() ? "*** enum ***" : fieldType.getTypeName();
        this.proxy.setFieldData(st, index, value, typeName);
    }

    private void setColumnToPreparedStatement(PreparedStatement st, int index, Field field, Object value) throws SQLException {
        Class<?> fieldType = field.getType();
        String typeName = fieldType.isEnum() ? "*** enum ***" : fieldType.getTypeName();
        this.proxy.setFieldData(st, index, value, typeName);
    }

    private void setData(Record record, PreparedStatement st, boolean update) {
        try {
            int index = 1;
            Map columns = COLUMN_MAP.computeIfAbsent(record.getClass(), DAO::computeColumns);
            for (Field field : record.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                Column fld = field.getAnnotation(Column.class);
                if (update && field.getAnnotation(PrimaryKey.class) != null) continue;
                VarHandle handle = (VarHandle)columns.get(fld.value());
                this.setColumnToPreparedStatement(record, st, index++, field, handle);
            }
            if (update) {
                PrimaryKeyHandle primaryKey = DAO.findPrimaryKey(record.getClass());
                this.setColumnToPreparedStatement(record, st, index, primaryKey.field, primaryKey.handle);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private PreparedStatement getPreparedStatement(Record record, Connection conn, boolean update) throws SQLException {
        String sql = update ? this.getUpdateSQL(record) : this.getInsertSQL(record);
        PreparedStatement st = conn.prepareStatement(sql);
        this.setData(record, st, update);
        return st;
    }

    private PreparedStatement getDeleteStatement(Record record, Connection conn) throws SQLException {
        PreparedStatement st = conn.prepareStatement(this.getDeleteSQL(record));
        PrimaryKeyHandle primaryKey = DAO.findPrimaryKey(record.getClass());
        this.setColumnToPreparedStatement(record, st, 1, primaryKey.field, primaryKey.handle);
        return st;
    }

    private <K> PreparedStatement getDeleteStatement(K id, Class<? extends Record<K>> clazz, Connection conn) throws SQLException {
        PreparedStatement st = conn.prepareStatement(this.getDeleteSQL(clazz));
        PrimaryKeyHandle primaryKey = DAO.findPrimaryKey(clazz);
        this.setColumnToPreparedStatement(st, 1, primaryKey.field, id);
        return st;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void preload(Collection<Class<? extends Record>> tables) {
        for (Class<? extends Record> clazz : tables) {
            block26: {
                table = clazz.getAnnotation(Table.class);
                if (table == null) {
                    throw new IllegalStateException("Class is not properly annotated: " + clazz.getTypeName());
                }
                primaryKey = DAO.findPrimaryKey(clazz);
                if (!primaryKey.isAutoIncrement() || !DAOTypes.AUTO_INCREMENT_TYPES.contains(fieldTypeName = primaryKey.field.getType().getTypeName())) continue;
                pattern = this.proxy.getSelectColumnString(primaryKey.field);
                maxValue /* !! */  = 0;
                try {
                    conn = this.getDataSource().getConnection();
                    try {
                        st = conn.prepareStatement("SELECT MAX(" + pattern + ") FROM " + table.value());
                        rs = st.executeQuery();
                        try {
                            if (!rs.next()) break block26;
                            var12_15 = fieldTypeName;
                            var13_17 = -1;
                            switch (var12_15.hashCode()) {
                                case 104431: {
                                    if (!var12_15.equals("int")) break;
                                    var13_17 = 0;
                                    break;
                                }
                                case -2056817302: {
                                    if (!var12_15.equals("java.lang.Integer")) break;
                                    var13_17 = 1;
                                    break;
                                }
                                case 398795216: {
                                    if (!var12_15.equals("java.lang.Long")) break;
                                    var13_17 = 2;
                                    break;
                                }
                                case 3327612: {
                                    if (!var12_15.equals("long")) break;
                                    var13_17 = 3;
                                }
                            }
                            switch (var13_17) {
                                case 0: 
                                case 1: {
                                    maxValue /* !! */  = rs.getInt(1);
                                    ** break;
lbl38:
                                    // 1 sources

                                    break;
                                }
                                case 2: 
                                case 3: {
                                    maxValue /* !! */  = rs.getLong(1);
                                    break;
                                }
                                ** default:
lbl43:
                                // 1 sources

                                break;
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.primaryKeys.put(clazz, maxValue /* !! */ );
        }
    }

    public <K extends Number> K generatePrimaryKey(Class<? extends Record<K>> clazz) {
        PrimaryKeyHandle primaryKey = DAO.findPrimaryKey(clazz);
        if (!primaryKey.isAutoIncrement()) {
            throw new IllegalStateException("Primary key for class " + clazz + " is not set to auto increment");
        }
        return (K)this.primaryKeys.compute(clazz, (k, v) -> {
            if (v instanceof Integer) {
                return (Integer)v + 1;
            }
            if (v instanceof Long) {
                return (Long)v + 1L;
            }
            return 1;
        });
    }

    public void insert(Record record) {
        try (Connection conn = this.getDataSource().getConnection();){
            this.insert(conn, record);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void insert(Connection conn, Record record) {
        try (PreparedStatement st = this.getPreparedStatement(record, conn, false);){
            st.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Record> void insert(int size, List<T> records) {
        try (Connection conn = this.getConnection();){
            this.insert(conn, size, records);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Record> void insert(Connection conn, int size, List<T> records) {
        if (size < 1) {
            throw new IllegalArgumentException("Batch size must be >= 1");
        }
        if (!records.isEmpty()) {
            String sql = this.getInsertSQL((Record)records.get(0));
            try (PreparedStatement st = conn.prepareStatement(sql);){
                int count = 0;
                for (Record r : records) {
                    this.setData(r, st, false);
                    st.addBatch();
                    if (++count % size != 0) continue;
                    st.executeBatch();
                }
                st.executeBatch();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void update(Record record) {
        try (Connection conn = this.getDataSource().getConnection();){
            this.update(conn, record);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void update(Connection conn, Record record) {
        try (PreparedStatement ps = this.getPreparedStatement(record, conn, true);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void delete(Record record) {
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = this.getDeleteStatement(record, conn);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <K> void delete(K id, Class<? extends Record<K>> clazz) {
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = this.getDeleteStatement(id, clazz, conn);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void deleteAll(Class<? extends Record> table) {
        try (Connection connection = this.getDataSource().getConnection();){
            this.deleteAll(connection, table);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void deleteAll(Connection connection, Class<? extends Record> table) {
        this.proxy.deleteAll(connection, table);
    }

    public void truncate(List<Class<? extends Record>> tables) {
        try (Connection connection = this.getDataSource().getConnection();){
            this.truncate(connection, tables);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void truncate(Connection conn, List<Class<? extends Record>> tables) {
        this.proxy.truncate(conn, tables);
        for (Class<? extends Record> t : tables) {
            this.primaryKeys.put(t, 0);
        }
    }

    protected void resetPrimaryKey(Class<? extends Record> table) {
        this.primaryKeys.put(table, 0);
    }

    public void dropTables(List<Class<? extends Record>> tables) {
        try (Connection conn = this.getDataSource().getConnection();){
            this.dropTables(conn, tables);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void dropTables(Connection conn, List<Class<? extends Record>> tables) {
        try (Statement st = conn.createStatement();){
            for (Class<? extends Record> t : tables) {
                st.execute("DROP TABLE " + Record.getTableName(t));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    static ConstructorHandle cacheConstructorHandle(Class<?> clazz) {
        Constructor<?> constructor = null;
        for (Constructor<?> c : clazz.getConstructors()) {
            if (!c.isAnnotationPresent(RecordBuilder.class)) continue;
            constructor = c;
            break;
        }
        if (constructor == null) {
            return null;
        }
        Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
        Class<?>[] paramTypes = constructor.getParameterTypes();
        ArrayList<ParameterHandle> parameterHandles = new ArrayList<ParameterHandle>();
        for (int i = 0; i < constructor.getParameterCount(); ++i) {
            String fieldName = Arrays.stream(paramAnnotations[i]).filter(a -> a instanceof Column).findAny().map(a -> ((Column)a).value()).orElseThrow(RuntimeException::new);
            parameterHandles.add(new ParameterHandle(fieldName, paramTypes[i]));
        }
        if (parameterHandles.isEmpty()) {
            throw new IllegalArgumentException("Constructor builder must have parameters");
        }
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            MethodHandle handle = lookup.unreflectConstructor(constructor);
            return new ConstructorHandle(handle, parameterHandles);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static PrimaryKeyHandle findPrimaryKey(Class<? extends Record> recordClass) {
        return PRIMARY_KEY_HANDLE_MAP.computeIfAbsent(recordClass, clazz -> {
            for (Field field : clazz.getDeclaredFields()) {
                PrimaryKey primaryKey;
                Column column = field.getAnnotation(Column.class);
                if (column == null || (primaryKey = field.getAnnotation(PrimaryKey.class)) == null) continue;
                Map columns = COLUMN_MAP.computeIfAbsent((Class<? extends Record>)clazz, DAO::computeColumns);
                return new PrimaryKeyHandle(field, (VarHandle)columns.get(column.value()), primaryKey.isAutoIncrement());
            }
            throw new IllegalStateException("No primary key defined for " + clazz.getTypeName());
        });
    }

    static <K> K getPrimaryKey(Record<K> record) {
        PrimaryKeyHandle primaryKey = DAO.findPrimaryKey(record.getClass());
        return (K)primaryKey.handle.get(record);
    }

    static class PrimaryKeyHandle {
        private final Field field;
        private final VarHandle handle;
        private final boolean autoIncrement;

        PrimaryKeyHandle(Field field, VarHandle handle, boolean autoIncrement) {
            this.field = field;
            this.handle = handle;
            this.autoIncrement = autoIncrement;
        }

        public Field getField() {
            return this.field;
        }

        public VarHandle getHandle() {
            return this.handle;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }
    }

    static class ConstructorHandle {
        final MethodHandle handle;
        final List<ParameterHandle> parameters;

        ConstructorHandle(MethodHandle handle, List<ParameterHandle> parameters) {
            this.handle = handle;
            this.parameters = parameters;
        }
    }

    static class ParameterHandle {
        final String name;
        final Class<?> type;

        ParameterHandle(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }
    }

    public static enum DatabaseType {
        SQLITE(SQLiteProxy.class),
        MYSQL(MySQLProxy.class);

        private final Class<? extends DAOProxy> proxyClass;

        private DatabaseType(Class<? extends DAOProxy> proxyClass) {
            this.proxyClass = proxyClass;
        }

        DAOProxy newProxy() {
            try {
                return this.proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException(ex);
            }
        }

        static DatabaseType getProxyType(DAOProxy proxy) {
            if (proxy instanceof MySQLProxy) {
                return MYSQL;
            }
            if (proxy instanceof SQLiteProxy) {
                return SQLITE;
            }
            throw new IllegalStateException("Unknown proxy implementation");
        }
    }
}

