/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.persistence;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import org.panteleyev.persistence.Record;
import org.panteleyev.persistence.annotations.Column;
import org.panteleyev.persistence.annotations.ForeignKey;
import org.panteleyev.persistence.annotations.Index;
import org.panteleyev.persistence.annotations.PrimaryKey;
import org.panteleyev.persistence.annotations.ReferenceOption;
import org.panteleyev.persistence.annotations.Table;

interface DAOProxy {
    public static final BiFunction<ResultSet, String, Object> OBJECT_READER = (rs, name) -> {
        try {
            return rs.getObject((String)name);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, Boolean> BOOL_READER = (rs, name) -> {
        try {
            return rs.getBoolean((String)name);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, Boolean> INT_BOOL_READER = (rs, name) -> {
        try {
            Object value = rs.getObject((String)name);
            return value != null && (Integer)value == 1;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, Boolean> INT_BOOLEAN_READER = (rs, name) -> {
        try {
            Object value = rs.getObject((String)name);
            return value == null ? null : Boolean.valueOf((Integer)value == 1);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, BigDecimal> BIG_DECIMAL_READER = (rs, name) -> {
        try {
            return rs.getBigDecimal((String)name);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, Integer> INT_READER = (rs, name) -> {
        try {
            return rs.getInt((String)name);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, Long> LONG_READER = (rs, name) -> {
        try {
            return rs.getLong((String)name);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, Date> DATE_READER = (rs, name) -> {
        try {
            return rs.getObject((String)name) == null ? null : new Date(rs.getLong((String)name));
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, LocalDate> LOCAL_DATE_READER = (rs, name) -> {
        try {
            return rs.getObject((String)name) == null ? null : LocalDate.ofEpochDay(rs.getLong((String)name));
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, byte[]> BYTE_ARRAY_READER = (rs, name) -> {
        try {
            return rs.getBytes((String)name);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };
    public static final BiFunction<ResultSet, String, UUID> UUID_STRING_READER = (rs, name) -> {
        try {
            String uuid = rs.getString((String)name);
            return uuid == null ? null : UUID.fromString(uuid);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    };

    default public Object getFieldValue(String fieldName, Class typeClass, ResultSet set) throws SQLException {
        if (typeClass.isEnum()) {
            Object value = set.getObject(fieldName);
            return value == null ? null : Enum.valueOf(typeClass, (String)value);
        }
        BiFunction<ResultSet, String, ?> reader = this.getReaderMap().get(typeClass.getTypeName());
        if (reader == null) {
            throw new IllegalStateException("Unsupported field type: " + typeClass.getTypeName());
        }
        return reader.apply(set, fieldName);
    }

    public Map<String, BiFunction<ResultSet, String, ?>> getReaderMap();

    public String getColumnString(Column var1, PrimaryKey var2, ForeignKey var3, String var4, List<String> var5);

    public void truncate(Connection var1, List<Class<? extends Record>> var2);

    default public String getInsertColumnPattern(Field field) {
        return "?";
    }

    default public String getUpdateColumnPattern(Field field) {
        return "?";
    }

    default public String getWhereColumnString(Field field) {
        Column column = field.getAnnotation(Column.class);
        Objects.requireNonNull(column, "Field is not properly annotated: " + field.getName());
        return column.value();
    }

    default public String getSelectColumnString(Field field) {
        Column column = field.getAnnotation(Column.class);
        Objects.requireNonNull(column, "Field is not properly annotated: " + field.getName());
        return column.value();
    }

    default public void setFieldData(PreparedStatement st, int index, Object value, String typeName) throws SQLException {
        switch (typeName) {
            case "java.lang.String": {
                if (value == null) {
                    st.setNull(index, 12);
                    break;
                }
                st.setString(index, (String)value);
                break;
            }
            case "java.util.UUID": {
                if (value == null) {
                    st.setNull(index, 12);
                    break;
                }
                st.setString(index, value.toString());
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                if (value == null) {
                    st.setNull(index, 16);
                    break;
                }
                st.setBoolean(index, (Boolean)value);
                break;
            }
            case "java.lang.Integer": 
            case "int": {
                if (value == null) {
                    st.setNull(index, 4);
                    break;
                }
                st.setInt(index, (Integer)value);
                break;
            }
            case "java.lang.Long": 
            case "long": {
                if (value == null) {
                    st.setNull(index, 4);
                    break;
                }
                st.setLong(index, (Long)value);
                break;
            }
            case "java.util.Date": {
                if (value == null) {
                    st.setNull(index, 4);
                    break;
                }
                st.setLong(index, ((Date)value).getTime());
                break;
            }
            case "java.time.LocalDate": {
                if (value == null) {
                    st.setNull(index, 4);
                    break;
                }
                st.setLong(index, ((LocalDate)value).toEpochDay());
                break;
            }
            case "java.math.BigDecimal": {
                if (value == null) {
                    st.setNull(index, 3);
                    break;
                }
                st.setBigDecimal(index, (BigDecimal)value);
                break;
            }
            case "*** enum ***": {
                if (value == null) {
                    st.setNull(index, 12);
                    break;
                }
                st.setString(index, ((Enum)value).name());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported field type: " + typeName);
            }
        }
    }

    default public String buildForeignKey(Column column, ForeignKey key) {
        Objects.requireNonNull(key);
        Class parentTableClass = key.table();
        if (!parentTableClass.isAnnotationPresent(Table.class)) {
            throw new IllegalStateException("Foreign key references not annotated table");
        }
        String parentTableName = parentTableClass.getAnnotation(Table.class).value();
        String parentFieldName = key.column();
        StringBuilder fk = new StringBuilder();
        fk.append("FOREIGN KEY (").append(column.value()).append(") ").append("REFERENCES ").append(parentTableName).append("(").append(parentFieldName).append(")");
        if (key.onUpdate() != ReferenceOption.NONE) {
            fk.append(" ON UPDATE ").append(key.onUpdate().toString());
        }
        if (key.onDelete() != ReferenceOption.NONE) {
            fk.append(" ON DELETE ").append(key.onDelete().toString());
        }
        return fk.toString();
    }

    default public String buildIndex(Table table, Field field) {
        Column column = field.getAnnotation(Column.class);
        Index index = field.getAnnotation(Index.class);
        StringBuilder b = new StringBuilder("CREATE ");
        if (index.unique()) {
            b.append("UNIQUE ");
        }
        b.append("INDEX ").append(index.value()).append(" ON ").append(table.value()).append(" (").append(column.value()).append(")");
        return b.toString();
    }

    default public void deleteAll(Connection connection, Class<? extends Record> table) {
        try (Statement statement = connection.createStatement();){
            statement.execute("DELETE FROM " + Record.getTableName(table));
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

