/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.panteleyev.persistence.DAOProxy;
import org.panteleyev.persistence.DAOTypes;
import org.panteleyev.persistence.Record;
import org.panteleyev.persistence.annotations.Column;
import org.panteleyev.persistence.annotations.ForeignKey;
import org.panteleyev.persistence.annotations.PrimaryKey;

class SQLiteProxy
implements DAOProxy,
DAOTypes {
    private static final Map<String, BiFunction<ResultSet, String, ?>> RESULT_SET_READERS = Map.ofEntries(Map.entry("java.lang.String", OBJECT_READER), Map.entry("java.lang.Integer", OBJECT_READER), Map.entry("int", INT_READER), Map.entry("java.lang.Long", OBJECT_READER), Map.entry("long", LONG_READER), Map.entry("boolean", INT_BOOL_READER), Map.entry("java.lang.Boolean", INT_BOOLEAN_READER), Map.entry("java.math.BigDecimal", BIG_DECIMAL_READER), Map.entry("java.util.Date", DATE_READER), Map.entry("java.time.LocalDate", LOCAL_DATE_READER), Map.entry("byte[]", BYTE_ARRAY_READER), Map.entry("java.util.UUID", UUID_STRING_READER));

    SQLiteProxy() {
    }

    @Override
    public Map<String, BiFunction<ResultSet, String, ?>> getReaderMap() {
        return RESULT_SET_READERS;
    }

    @Override
    public String getColumnString(Column column, PrimaryKey primaryKey, ForeignKey foreignKey, String typeName, List<String> constraints) {
        StringBuilder b = new StringBuilder();
        switch (typeName) {
            case "java.lang.String": {
                if (column.isJson()) {
                    b.append("BLOB");
                    break;
                }
                b.append("VARCHAR(").append(column.length()).append(")");
                break;
            }
            case "java.util.UUID": {
                b.append("VARCHAR(36)");
                break;
            }
            case "*** enum ***": {
                b.append("VARCHAR(").append(column.length()).append(")");
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                b.append("BOOLEAN");
                break;
            }
            case "java.lang.Integer": 
            case "int": 
            case "java.lang.Long": 
            case "long": 
            case "java.util.Date": 
            case "java.time.LocalDate": {
                b.append("INTEGER");
                break;
            }
            case "java.math.BigDecimal": {
                b.append("VARCHAR(").append(column.precision() + 1).append(")");
                break;
            }
            case "byte[]": {
                b.append("BLOB");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported field type: ");
            }
        }
        if (primaryKey != null) {
            b.append(" PRIMARY KEY");
        } else if (column.unique()) {
            b.append(" UNIQUE");
        }
        if (!column.nullable()) {
            b.append(" NOT NULL");
        }
        if (foreignKey != null) {
            constraints.add(this.buildForeignKey(column, foreignKey));
        }
        return b.toString();
    }

    @Override
    public void truncate(Connection connection, List<Class<? extends Record>> tables) {
        tables.forEach(table -> this.deleteAll(connection, (Class<? extends Record>)table));
        try (Statement statement = connection.createStatement();){
            statement.execute("VACUUM");
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setFieldData(PreparedStatement st, int index, Object value, String typeName) throws SQLException {
        switch (typeName) {
            case "byte[]": {
                if (value == null) {
                    st.setNull(index, 2004);
                    break;
                }
                st.setBytes(index, (byte[])value);
                break;
            }
            default: {
                DAOProxy.super.setFieldData(st, index, value, typeName);
            }
        }
    }
}

