/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.persistence;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.panteleyev.persistence.annotations.Field;
import org.panteleyev.persistence.annotations.ForeignKey;
import org.panteleyev.persistence.annotations.Index;
import org.panteleyev.persistence.annotations.ReferenceOption;
import org.panteleyev.persistence.annotations.Table;

interface DAOProxy {
    public Object getFieldValue(String var1, Class var2, ResultSet var3) throws SQLException;

    public String getColumnString(Field var1, ForeignKey var2, String var3, List<String> var4);

    default public void setFieldData(PreparedStatement st, int index, Object value, String typeName) throws SQLException {
        switch (typeName) {
            case "java.lang.String": {
                if (value == null) {
                    st.setNull(index, 12);
                    break;
                }
                st.setString(index, (String)value);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                if (value == null) {
                    st.setNull(index, 16);
                    break;
                }
                st.setBoolean(index, (Boolean)value);
                break;
            }
            case "java.lang.Integer": 
            case "int": {
                if (value == null) {
                    st.setNull(index, 4);
                    break;
                }
                st.setInt(index, (Integer)value);
                break;
            }
            case "java.lang.Long": 
            case "long": {
                if (value == null) {
                    st.setNull(index, 4);
                    break;
                }
                st.setLong(index, (Long)value);
                break;
            }
            case "java.util.Date": {
                if (value == null) {
                    st.setNull(index, 4);
                    break;
                }
                st.setLong(index, ((Date)value).getTime());
                break;
            }
            case "java.math.BigDecimal": {
                if (value == null) {
                    st.setNull(index, 3);
                    break;
                }
                st.setBigDecimal(index, (BigDecimal)value);
                break;
            }
            case "*** enum ***": {
                if (value == null) {
                    st.setNull(index, 12);
                    break;
                }
                st.setString(index, ((Enum)value).name());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported field type");
            }
        }
    }

    default public String buildForeignKey(Field field, ForeignKey key) {
        Objects.requireNonNull(key);
        Class parentTableClass = key.table();
        if (!parentTableClass.isAnnotationPresent(Table.class)) {
            throw new IllegalStateException("Foreign key references not annotated table");
        }
        String parentTableName = parentTableClass.getAnnotation(Table.class).value();
        String parentFieldName = key.field();
        StringBuilder fk = new StringBuilder();
        fk.append("FOREIGN KEY (").append(field.value()).append(") ").append("REFERENCES ").append(parentTableName).append("(").append(parentFieldName).append(")");
        if (key.onUpdate() != ReferenceOption.NONE) {
            fk.append(" ON UPDATE ").append(key.onUpdate().toString());
        }
        if (key.onDelete() != ReferenceOption.NONE) {
            fk.append(" ON DELETE ").append(key.onDelete().toString());
        }
        return fk.toString();
    }

    default public String buildIndex(Table table, Method getter) {
        Field field = getter.getAnnotation(Field.class);
        Index index = getter.getAnnotation(Index.class);
        StringBuilder b = new StringBuilder("CREATE ");
        if (index.unique()) {
            b.append("UNIQUE ");
        }
        b.append("INDEX ").append(index.value()).append(" ON ").append(table.value()).append(" (").append(field.value()).append(")");
        return b.toString();
    }
}

