/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.panteleyev.persistence.DAOProxy;
import org.panteleyev.persistence.DAOTypes;
import org.panteleyev.persistence.annotations.Field;
import org.panteleyev.persistence.annotations.ForeignKey;

class MySQLProxy
implements DAOProxy,
DAOTypes {
    MySQLProxy() {
    }

    @Override
    public Object getFieldValue(String fieldName, Class typeClass, ResultSet set) throws SQLException {
        String typeName;
        Object value = set.getObject(fieldName);
        String string = typeName = typeClass.isEnum() ? "*** enum ***" : typeClass.getName();
        if (value != null) {
            switch (typeName) {
                case "java.lang.String": 
                case "java.lang.Integer": 
                case "int": 
                case "java.lang.Long": 
                case "long": 
                case "boolean": 
                case "java.lang.Boolean": {
                    break;
                }
                case "java.math.BigDecimal": {
                    value = set.getBigDecimal(fieldName);
                    break;
                }
                case "java.util.Date": {
                    value = new Date(set.getLong(fieldName));
                    break;
                }
                case "*** enum ***": {
                    value = Enum.valueOf(typeClass, (String)value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported field type");
                }
            }
        } else {
            switch (typeName) {
                case "int": {
                    value = 0;
                    break;
                }
                case "long": {
                    value = 0L;
                    break;
                }
                case "boolean": {
                    value = false;
                }
            }
        }
        return value;
    }

    @Override
    public String getColumnString(Field fld, ForeignKey foreignKey, String typeName, List<String> constraints) {
        StringBuilder b = new StringBuilder();
        switch (typeName) {
            case "java.lang.String": 
            case "*** enum ***": {
                b.append("VARCHAR(").append(fld.length()).append(")");
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                b.append("BOOLEAN");
                break;
            }
            case "java.lang.Integer": 
            case "int": {
                b.append("INTEGER");
                break;
            }
            case "java.lang.Long": 
            case "long": {
                b.append("BIGINT");
                break;
            }
            case "java.util.Date": {
                b.append("BIGINT");
                break;
            }
            case "java.math.BigDecimal": {
                b.append("DECIMAL(").append(fld.precision()).append(",").append(fld.scale()).append(")");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported field type");
            }
        }
        if (fld.primaryKey()) {
            b.append(" PRIMARY KEY");
        }
        if (!fld.nullable()) {
            b.append(" NOT NULL");
        }
        if (foreignKey != null) {
            constraints.add(this.buildForeignKey(fld, foreignKey));
        }
        return b.toString();
    }
}

