/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.persistence;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.panteleyev.persistence.DAOProxy;
import org.panteleyev.persistence.MySQLProxy;
import org.panteleyev.persistence.Record;
import org.panteleyev.persistence.SQLiteProxy;
import org.panteleyev.persistence.annotations.Field;
import org.panteleyev.persistence.annotations.ForeignKey;
import org.panteleyev.persistence.annotations.Index;
import org.panteleyev.persistence.annotations.RecordBuilder;
import org.panteleyev.persistence.annotations.Table;

public class DAO {
    private static final String NOT_ANNOTATED = "Class is not properly annotated";
    private final Map<Class<? extends Record>, Integer> primaryKeys = new ConcurrentHashMap<Class<? extends Record>, Integer>();
    private final Map<Class<? extends Record>, String> insertSQL = new ConcurrentHashMap<Class<? extends Record>, String>();
    private final Map<Class<? extends Record>, String> updateSQL = new ConcurrentHashMap<Class<? extends Record>, String>();
    private final Map<Class<? extends Record>, String> deleteSQL = new ConcurrentHashMap<Class<? extends Record>, String>();
    private DataSource datasource;
    private DAOProxy proxy;

    public DAO() {
    }

    public DAO(DataSource ds) {
        this.datasource = ds;
        this.proxy = this.setupProxy();
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public void setDataSource(DataSource ds) {
        this.datasource = ds;
        this.primaryKeys.clear();
        this.insertSQL.clear();
        this.deleteSQL.clear();
        this.proxy = this.setupProxy();
    }

    private DAOProxy setupProxy() {
        if (this.datasource != null) {
            String dsClass = this.datasource.getClass().getName().toLowerCase();
            if (dsClass.contains("mysql")) {
                return new MySQLProxy();
            }
            if (dsClass.contains("sqlite")) {
                return new SQLiteProxy();
            }
            throw new IllegalStateException("Unsupported database type");
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Record> T get(Integer id, Class<? extends T> clazz) {
        try (Connection conn = this.getDataSource().getConnection();){
            if (!clazz.isAnnotationPresent(Table.class)) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            Table ann = clazz.getAnnotation(Table.class);
            String tableName = ann.value();
            String idName = "id";
            for (Method method : clazz.getMethods()) {
                Field fieldAnn = method.getAnnotation(Field.class);
                if (fieldAnn == null || !fieldAnn.primaryKey()) continue;
                idName = fieldAnn.value();
                break;
            }
            String sql = "SELECT * FROM " + tableName + " WHERE " + idName + "=?";
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setInt(1, id);
            ResultSet set = ps.executeQuery();
            T t = set.next() ? (T)this.fromSQL(set, clazz) : null;
            return t;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Record> List<T> getAll(Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        try (Connection conn = this.getDataSource().getConnection();){
            if (!clazz.isAnnotationPresent(Table.class)) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            String tableName = clazz.getAnnotation(Table.class).value();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + tableName);
            ResultSet set = ps.executeQuery();
            while (set.next()) {
                result.add(this.fromSQL(set, clazz));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public <T extends Record> void getAll(Class<T> clazz, Map<Integer, T> result) {
        try (Connection conn = this.getDataSource().getConnection();){
            if (!clazz.isAnnotationPresent(Table.class)) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            String tableName = clazz.getAnnotation(Table.class).value();
            PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + tableName);
            ResultSet set = ps.executeQuery();
            while (set.next()) {
                T r = this.fromSQL(set, clazz);
                result.put(r.getId(), r);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T extends Record> T fromSQL(ResultSet set, Class<T> clazz) {
        try {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (!constructor.isAnnotationPresent(RecordBuilder.class)) continue;
                return this.fromSQL(set, constructor);
            }
            Record result = (Record)clazz.newInstance();
            this.fromSQL(set, result);
            return (T)result;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private <T extends Record> T fromSQL(ResultSet set, Constructor<?> constructor) throws SQLException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int paramCount = constructor.getParameterCount();
        Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            String fieldName = Arrays.stream(paramAnnotations[i]).filter(a -> a instanceof Field).findAny().map(a -> ((Field)a).value()).orElseThrow(RuntimeException::new);
            params[i] = this.proxy.getFieldValue(fieldName, paramTypes[i], set);
        }
        return (T)((Record)constructor.newInstance(params));
    }

    private void fromSQL(ResultSet set, Record record) throws SQLException {
        try {
            PropertyDescriptor[] pds;
            BeanInfo bi = Introspector.getBeanInfo(record.getClass());
            for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                Field fld;
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                Class getterClass = getter.getReturnType();
                if (getterClass.equals(Optional.class)) {
                    getterClass = this.getEffectiveType(getter);
                    String setterName = getter.getName().replace("get", "set");
                    for (Method m : record.getClass().getDeclaredMethods()) {
                        if (m.getParameterCount() != 1 || !m.getName().equals(setterName)) continue;
                        setter = m;
                        break;
                    }
                }
                if (setter == null || (fld = getter.getAnnotation(Field.class)) == null) continue;
                setter.invoke((Object)record, this.proxy.getFieldValue(fld.value(), getterClass, set));
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Class getEffectiveType(Method getter) {
        Type rType = getter.getGenericReturnType();
        if (rType instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)rType).getActualTypeArguments();
            if (actualTypeArguments.length != 1) {
                throw new IllegalStateException("Unsupported field type");
            }
            return (Class)actualTypeArguments[0];
        }
        return (Class)rType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createTables(List<Class<? extends Record>> tables) {
        if (this.getDataSource() == null) {
            throw new IllegalStateException("Database not opened");
        }
        try (Connection conn = this.getDataSource().getConnection();
             Statement st = conn.createStatement();){
            Table table;
            for (int index = tables.size() - 1; index >= 0; --index) {
                Class<? extends Record> cl = tables.get(index);
                if (!cl.isAnnotationPresent(Table.class)) {
                    throw new IllegalStateException(NOT_ANNOTATED);
                }
                table = cl.getAnnotation(Table.class);
                st.executeUpdate("DROP TABLE IF EXISTS " + table.value());
            }
            for (Class<? extends Record> cl : tables) {
                table = cl.getAnnotation(Table.class);
                try {
                    StringBuilder b = new StringBuilder("CREATE TABLE IF NOT EXISTS ").append(table.value()).append(" (");
                    BeanInfo bi = Introspector.getBeanInfo(cl);
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                    ArrayList<String> constraints = new ArrayList<String>();
                    HashSet<Method> indexed = new HashSet<Method>();
                    boolean first = true;
                    for (PropertyDescriptor pd : pds) {
                        String typeName;
                        Method getter = pd.getReadMethod();
                        if (getter == null || !getter.isAnnotationPresent(Field.class)) continue;
                        Field fld = getter.getAnnotation(Field.class);
                        String fName = fld.value();
                        Class getterType = this.getEffectiveType(getter);
                        String string = typeName = getterType.isEnum() ? "*** enum ***" : getterType.getTypeName();
                        if (!first) {
                            b.append(",");
                        }
                        first = false;
                        b.append(fName).append(" ").append(this.proxy.getColumnString(fld, getter.getAnnotation(ForeignKey.class), typeName, constraints));
                        if (!getter.isAnnotationPresent(Index.class)) continue;
                        indexed.add(getter);
                    }
                    if (!constraints.isEmpty()) {
                        b.append(",");
                        b.append(constraints.stream().collect(Collectors.joining(",")));
                    }
                    b.append(")");
                    st.executeUpdate(b.toString());
                    for (Method getter : indexed) {
                        st.executeUpdate(this.proxy.buildIndex(table, getter));
                    }
                }
                catch (IntrospectionException ex) {
                    throw new RuntimeException(ex);
                    return;
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getInsertSQL(Record record) {
        return this.insertSQL.computeIfAbsent(record.getClass(), clazz -> {
            StringBuilder b = new StringBuilder("INSERT INTO ");
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException("Class " + clazz.getName() + " is not properly annotated");
            }
            b.append(table.value()).append(" (");
            int fCount = 0;
            try {
                PropertyDescriptor[] pds;
                BeanInfo bi = Introspector.getBeanInfo(record.getClass());
                for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                    Field fld;
                    Method getter = pd.getReadMethod();
                    if (getter == null || (fld = getter.getAnnotation(Field.class)) == null) continue;
                    if (fCount != 0) {
                        b.append(",");
                    }
                    b.append(fld.value());
                    ++fCount;
                }
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
            if (fCount == 0) {
                throw new IllegalStateException("No fields");
            }
            b.append(") VALUES (");
            while (fCount != 0) {
                b.append("?");
                if (fCount != 1) {
                    b.append(",");
                }
                --fCount;
            }
            b.append(")");
            return b.toString();
        });
    }

    private String getUpdateSQL(Record record) {
        return this.updateSQL.computeIfAbsent(record.getClass(), clazz -> {
            StringBuilder b = new StringBuilder("update ");
            Table table = clazz.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            b.append(table.value()).append(" set ");
            int fCount = 0;
            try {
                PropertyDescriptor[] pds;
                BeanInfo bi = Introspector.getBeanInfo(record.getClass());
                for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                    Field fld;
                    Method getter = pd.getReadMethod();
                    if (getter == null || (fld = getter.getAnnotation(Field.class)) == null || fld.primaryKey()) continue;
                    if (fCount != 0) {
                        b.append(", ");
                    }
                    b.append(fld.value()).append("=?");
                    ++fCount;
                }
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
            if (fCount == 0) {
                throw new IllegalStateException("No fields");
            }
            b.append(" WHERE id=?");
            return b.toString();
        });
    }

    private String getDeleteSQL(Class<? extends Record> clazz) {
        return this.deleteSQL.computeIfAbsent(clazz, cl -> {
            StringBuilder b = new StringBuilder("delete from ");
            Table table = cl.getAnnotation(Table.class);
            if (table == null) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            b.append(table.value()).append(" where ");
            String idName = null;
            try {
                PropertyDescriptor[] pds;
                BeanInfo bi = Introspector.getBeanInfo(cl);
                for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                    Field fld;
                    Method getter = pd.getReadMethod();
                    if (getter == null || (fld = getter.getAnnotation(Field.class)) == null || !fld.primaryKey()) continue;
                    idName = fld.value();
                    break;
                }
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
            if (idName == null) {
                throw new IllegalStateException(NOT_ANNOTATED);
            }
            b.append(idName).append("=?");
            return b.toString();
        });
    }

    private String getDeleteSQL(Record record) {
        return this.getDeleteSQL(record.getClass());
    }

    private void setData(Record record, PreparedStatement st, boolean update) throws SQLException {
        try {
            BeanInfo bi = Introspector.getBeanInfo(record.getClass());
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int index = 1;
            for (PropertyDescriptor pd : pds) {
                Method getter = pd.getReadMethod();
                if (getter == null || !getter.isAnnotationPresent(Field.class)) continue;
                Field fld = getter.getAnnotation(Field.class);
                if (update && fld.primaryKey()) continue;
                Object value = getter.invoke((Object)record, new Object[0]);
                Class getterClass = getter.getReturnType();
                if (getterClass.equals(Optional.class)) {
                    getterClass = this.getEffectiveType(getter);
                    Method isPresentMethod = Optional.class.getDeclaredMethod("isPresent", new Class[0]);
                    value = (Boolean)isPresentMethod.invoke(value, new Object[0]) != false ? Optional.class.getDeclaredMethod("get", new Class[0]).invoke(value, new Object[0]) : null;
                }
                String typeName = getterClass.isEnum() ? "*** enum ***" : getterClass.getName();
                this.proxy.setFieldData(st, index++, value, typeName);
            }
            if (update) {
                st.setInt(index, record.getId());
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    private PreparedStatement getPreparedStatement(Record record, Connection conn, boolean update) throws SQLException {
        String sql = update ? this.getUpdateSQL(record) : this.getInsertSQL(record);
        PreparedStatement st = conn.prepareStatement(sql);
        this.setData(record, st, update);
        return st;
    }

    private PreparedStatement getDeleteStatement(Record record, Connection conn) throws SQLException {
        PreparedStatement st = conn.prepareStatement(this.getDeleteSQL(record));
        st.setInt(1, record.getId());
        return st;
    }

    private PreparedStatement getDeleteStatement(Integer id, Class<? extends Record> clazz, Connection conn) throws SQLException {
        PreparedStatement st = conn.prepareStatement(this.getDeleteSQL(clazz));
        st.setInt(1, id);
        return st;
    }

    public void preload(Collection<Class<? extends Record>> tables) {
        tables.stream().filter(x -> x.isAnnotationPresent(Table.class)).forEach(x -> {
            Table a = x.getAnnotation(Table.class);
            Integer id = this.getIdMaxValue(a.value());
            this.primaryKeys.put((Class<? extends Record>)x, id);
        });
    }

    public Integer generatePrimaryKey(Class<? extends Record> clazz) {
        return this.primaryKeys.compute(clazz, (k, v) -> {
            int n;
            if (v == null) {
                n = 1;
            } else {
                v = v + 1;
                n = v;
            }
            return n;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer getIdMaxValue(String tableName) {
        try (Connection conn = this.getDataSource().getConnection();){
            PreparedStatement st = conn.prepareStatement("SELECT id FROM " + tableName + " ORDER BY id DESC");
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                Integer n = rs.getInt(1);
                return n;
            }
            Integer n = 0;
            return n;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    public <T extends Record> T insert(T record) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T extends Record> void insert(int size, List<T> records) {
        if (size < 1) {
            throw new IllegalArgumentException("Batch size must be >= 1");
        }
        if (!records.isEmpty()) {
            String sql = this.getInsertSQL((Record)records.get(0));
            try (Connection conn = this.getConnection();
                 PreparedStatement st = conn.prepareStatement(sql);){
                int count = 0;
                for (Record r : records) {
                    this.setData(r, st, false);
                    st.addBatch();
                    if (++count % size != 0) continue;
                    st.executeBatch();
                }
                st.executeBatch();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public <T extends Record> T update(T record) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void delete(Record record) {
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = this.getDeleteStatement(record, conn);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void delete(Integer id, Class<? extends Record> clazz) {
        try (Connection conn = this.getDataSource().getConnection();
             PreparedStatement ps = this.getDeleteStatement(id, clazz, conn);){
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

