/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.buck.util.zip;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.pantsbuild.buck.util.zip.ZipConstants;

public class ZipScrubber {
    private static final long ZIP64_ENDSIG = 101075792L;
    private static final int EXTENDED_TIMESTAMP_ID = 21589;

    private ZipScrubber() {
    }

    private static void check(boolean bl, String string) throws IOException {
        if (!bl) {
            throw new IOException(string);
        }
    }

    public static void scrubZip(Path path) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileChannel.size());
            ZipScrubber.scrubZipBuffer(fileChannel.size(), mappedByteBuffer);
        }
    }

    @VisibleForTesting
    static void scrubZipBuffer(long l, ByteBuffer byteBuffer) throws IOException {
        int n;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n2 = (int)l - 22;
        while ((long)byteBuffer.getInt(n2) != 101010256L) {
            --n2;
        }
        long l2 = Short.toUnsignedLong(byteBuffer.getShort(n2 + 10));
        if ((l2 & 0xFFFFL) == 65535L) {
            n = n2;
            while ((long)byteBuffer.getInt(n) != 101075792L) {
                --n;
            }
            l2 = byteBuffer.getLong(n + 32);
        }
        n = byteBuffer.getInt(n2 + 16);
        for (long i = 0L; i < l2; ++i) {
            ByteBuffer byteBuffer2 = ZipScrubber.slice(byteBuffer, n);
            ZipScrubber.check((long)byteBuffer2.getInt(0) == 33639248L, "expected central directory header signature");
            byteBuffer2.putInt(12, 172032000);
            ByteBuffer byteBuffer3 = ZipScrubber.slice(byteBuffer, byteBuffer2.getInt(42));
            ZipScrubber.scrubLocalEntry(byteBuffer3);
            ZipScrubber.scrubExtraFields(ZipScrubber.slice(byteBuffer2, 46 + byteBuffer2.getShort(28)), byteBuffer2.getShort(30));
            n += 46 + byteBuffer2.getShort(28) + byteBuffer2.getShort(30) + byteBuffer2.getShort(32);
        }
    }

    private static ByteBuffer slice(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.position(n);
        byteBuffer2 = byteBuffer2.slice();
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer2;
    }

    private static void scrubLocalEntry(ByteBuffer byteBuffer) throws IOException {
        ZipScrubber.check((long)byteBuffer.getInt(0) == 67324752L, "expected local header signature");
        byteBuffer.putInt(10, 172032000);
        ZipScrubber.scrubExtraFields(ZipScrubber.slice(byteBuffer, 30 + byteBuffer.getShort(26)), byteBuffer.getShort(28));
    }

    private static void scrubExtraFields(ByteBuffer byteBuffer, short s) {
        int n = byteBuffer.position() + s;
        while (byteBuffer.position() < n) {
            short s2 = byteBuffer.getShort();
            int n2 = byteBuffer.getShort();
            if (s2 == 21589) {
                byteBuffer.get();
                --n2;
                while (n2 > 0) {
                    byteBuffer.putInt((int)(ZipConstants.getFakeTime() / 1000L));
                    n2 -= 4;
                }
                continue;
            }
            if (byteBuffer.position() + n2 >= n) break;
            byteBuffer.position(byteBuffer.position() + n2);
        }
    }

    private static String localEntryName(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.getShort(26)];
        ((ByteBuffer)((Buffer)byteBuffer.slice()).position(30)).get(byArray);
        return new String(byArray);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.err.println("usage: ZipScrubberCli file-to-scrub-in-place.zip");
            System.exit(2);
        }
        ZipScrubber.scrubZip(Paths.get(stringArray[0], new String[0]));
    }
}

