/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.ivy;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.url.URLHandler;
import org.apache.ivy.util.url.URLHandlerDispatcher;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;
import org.pantsbuild.args4j.InvalidCmdLineArgumentException;

public class DependencyUpdateChecker {
    @Option(name="-revision-to-check", metaVar="<revision>", usage="Target revision to check.")
    private String revisionToCheck = "latest.integration";
    @Option(name="-check-if-changed", usage="The resolve will compare the result with the last resolution done on this module to define the property ivy.deps.changed. Disabling this check may provide slightly better performance.")
    private boolean checkIfChanged = false;
    @Option(name="-show-transitive", usage="Show updates on transitive dependencies")
    private boolean showTransitive = false;
    private File settingsFile;
    private File ivyFile;
    private String[] confs = new String[]{"default"};
    private static volatile boolean callSystemExitOnFinish = true;
    private Ivy ivyInstance;
    private static PrintStream logStream = System.out;
    private final String INDENTATION = "  ";

    @Option(name="-settings", metaVar="<settingsfile>", required=true, usage="Ivy settings file")
    public void setSettingsFile(File file) throws InvalidCmdLineArgumentException {
        if (!file.exists()) {
            throw new InvalidCmdLineArgumentException("-settings", (Object)file, "Ivy settings file not found");
        }
        if (file.isDirectory()) {
            throw new InvalidCmdLineArgumentException("-settings", (Object)file, "Ivy settings file is not a file");
        }
        this.settingsFile = file;
    }

    @Option(name="-ivy", metaVar="<ivyfile>", required=true, usage="Ivy file")
    public void setIvyFile(File file) throws InvalidCmdLineArgumentException {
        if (!file.exists()) {
            throw new InvalidCmdLineArgumentException("-ivy", (Object)file, "Ivy file not found");
        }
        if (file.isDirectory()) {
            throw new InvalidCmdLineArgumentException("-ivy", (Object)file, "Ivy file is not a file");
        }
        this.ivyFile = file;
    }

    @Option(name="-confs", metaVar="<configurations>", usage="Resolve given configurations")
    public void setConfs(String string) {
        this.confs = string.split(",");
        for (int i = 0; i < this.confs.length; ++i) {
            this.confs[i] = this.confs[i].trim();
        }
    }

    public void log(String string) {
        logStream.println(string);
    }

    public static void setLogStream(PrintStream printStream) {
        logStream = printStream;
    }

    public void execute() throws IOException, ParseException {
        ResolveReport resolveReport = this.getResolvedReport();
        ModuleDescriptor moduleDescriptor = resolveReport.getModuleDescriptor();
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleDescriptor.getModuleRevisionId(), moduleDescriptor.getStatus(), moduleDescriptor.getPublicationDate());
        for (Configuration configuration : moduleDescriptor.getConfigurations()) {
            defaultModuleDescriptor.addConfiguration(configuration);
        }
        for (Configuration configuration : moduleDescriptor.getDependencies()) {
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance((ModuleRevisionId)configuration.getDependencyRevisionId(), (String)this.revisionToCheck);
            defaultModuleDescriptor.addDependency(configuration.clone(moduleRevisionId));
        }
        ResolveOptions resolveOptions = new ResolveOptions();
        resolveOptions.setDownload(false);
        resolveOptions.setConfs(this.confs);
        resolveOptions.setCheckIfChanged(this.checkIfChanged);
        resolveOptions.setTransitive(this.showTransitive);
        ResolveReport resolveReport2 = this.getIvyInstance().resolve((ModuleDescriptor)defaultModuleDescriptor, resolveOptions);
        this.displayDependencyUpdates(resolveReport, resolveReport2);
        if (this.showTransitive) {
            this.displayNewDependencyOnLatest(resolveReport, resolveReport2);
            this.displayMissingDependencyOnLatest(resolveReport, resolveReport2);
        }
    }

    private void displayDependencyUpdates(ResolveReport resolveReport, ResolveReport resolveReport2) {
        this.log("Dependency updates available:");
        boolean bl = false;
        for (Object e : resolveReport2.getDependencies()) {
            IvyNode ivyNode = (IvyNode)e;
            for (Object e2 : resolveReport.getDependencies()) {
                boolean bl2;
                IvyNode ivyNode2 = (IvyNode)e2;
                if (!ivyNode2.getModuleId().equals((Object)ivyNode.getModuleId()) || ivyNode2.getResolvedId().getRevision().equals(ivyNode.getResolvedId().getRevision())) continue;
                boolean bl3 = bl2 = ivyNode.getDependencyDescriptor(ivyNode.getRoot()) == null;
                if (bl2 && (!bl2 || !this.showTransitive)) continue;
                String string = "  " + ivyNode2.getResolvedId().getOrganisation() + '#' + ivyNode2.getResolvedId().getName() + (bl2 ? " (transitive)" : "") + "  " + ivyNode2.getResolvedId().getRevision() + " -> " + ivyNode.getResolvedId().getRevision();
                this.log(string);
                bl = true;
            }
        }
        if (!bl) {
            this.log("  All dependencies are up to date");
        }
    }

    private void displayMissingDependencyOnLatest(ResolveReport resolveReport, ResolveReport resolveReport2) {
        ArrayList<ModuleRevisionId> arrayList = new ArrayList<ModuleRevisionId>();
        for (Object object : resolveReport.getDependencies()) {
            IvyNode ivyNode = (IvyNode)object;
            boolean bl = false;
            for (Object e : resolveReport2.getDependencies()) {
                IvyNode ivyNode2 = (IvyNode)e;
                if (!ivyNode.getModuleId().equals((Object)ivyNode2.getModuleId())) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(ivyNode.getId());
        }
        if (arrayList.size() > 0) {
            this.log("List of missing dependencies on latest resolve:");
            for (ModuleRevisionId moduleRevisionId : arrayList) {
                this.log("  " + moduleRevisionId.toString());
            }
        }
    }

    private void displayNewDependencyOnLatest(ResolveReport resolveReport, ResolveReport resolveReport2) {
        ArrayList<ModuleRevisionId> arrayList = new ArrayList<ModuleRevisionId>();
        for (Object object : resolveReport2.getDependencies()) {
            IvyNode ivyNode = (IvyNode)object;
            boolean bl = false;
            for (Object e : resolveReport.getDependencies()) {
                IvyNode ivyNode2 = (IvyNode)e;
                if (!ivyNode2.getModuleId().equals((Object)ivyNode.getModuleId())) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(ivyNode.getId());
        }
        if (arrayList.size() > 0) {
            this.log("List of new dependencies on latest resolve:");
            for (ModuleRevisionId moduleRevisionId : arrayList) {
                this.log("  " + moduleRevisionId.toString());
            }
        }
    }

    public Ivy getIvyInstance() throws ParseException, IOException {
        if (this.ivyInstance != null) {
            return this.ivyInstance;
        }
        this.ivyInstance = Ivy.newInstance();
        URLHandlerDispatcher uRLHandlerDispatcher = new URLHandlerDispatcher();
        URLHandler uRLHandler = URLHandlerRegistry.getHttp();
        uRLHandlerDispatcher.setDownloader("http", uRLHandler);
        uRLHandlerDispatcher.setDownloader("https", uRLHandler);
        URLHandlerRegistry.setDefault((URLHandler)uRLHandlerDispatcher);
        IvySettings ivySettings = this.ivyInstance.getSettings();
        ivySettings.addAllVariables((Map)System.getProperties());
        this.ivyInstance.configure(this.settingsFile);
        return this.ivyInstance;
    }

    public ResolveReport getResolvedReport() throws ParseException, IOException {
        ResolveOptions resolveOptions = new ResolveOptions().setDownload(false).setTransitive(this.showTransitive).setConfs(this.confs);
        ResolveReport resolveReport = this.getIvyInstance().resolve(this.ivyFile.toURI().toURL(), resolveOptions);
        if (resolveReport.hasError()) {
            System.err.println("Resolved report has an error");
            DependencyUpdateChecker.exit(1);
        }
        return resolveReport;
    }

    private static void exit(int n) {
        if (callSystemExitOnFinish) {
            System.exit(n);
        } else if (n != 0) {
            throw new RuntimeException("DependencyUpdateChecker exited with status " + n);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DependencyUpdateChecker dependencyUpdateChecker = new DependencyUpdateChecker();
        ParserProperties parserProperties = ParserProperties.defaults().withUsageWidth(120);
        CmdLineParser cmdLineParser = new CmdLineParser((Object)dependencyUpdateChecker, parserProperties);
        try {
            cmdLineParser.parseArgument(stringArray);
        }
        catch (InvalidCmdLineArgumentException invalidCmdLineArgumentException) {
            System.err.println(invalidCmdLineArgumentException.getMessage());
            cmdLineParser.printUsage((OutputStream)System.err);
            System.err.println();
            return;
        }
        dependencyUpdateChecker.execute();
    }

    public static void setCallSystemExitOnFinish(boolean bl) {
        callSystemExitOnFinish = bl;
    }
}

