/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.jar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import javax.annotation.Nullable;
import org.pantsbuild.tools.jar.JarEntryCopier;
import org.pantsbuild.tools.jar.JarFileUtil;

public class JarBuilder
implements Closeable {
    private static final ByteSource DEFAULT_MANIFEST = JarBuilder.manifestSupplier(JarBuilder.createDefaultManifest());
    private static final Splitter JAR_PATH_SPLITTER = Splitter.on((char)'/');
    private static final Joiner JAR_PATH_JOINER = Joiner.on((char)'/');
    private final File target;
    private final Listener listener;
    private final Closer closer = Closer.create();
    private final List<EntryIndexer> additions = Lists.newLinkedList();
    @Nullable
    private ByteSource manifest;
    private static final Function<Pattern, Predicate<CharSequence>> AS_PATH_SELECTOR = new Function<Pattern, Predicate<CharSequence>>(){

        public Predicate<CharSequence> apply(Pattern pattern) {
            return Predicates.contains((Pattern)pattern);
        }
    };

    @VisibleForTesting
    static String joinJarPath(Iterable<String> iterable) {
        return JAR_PATH_JOINER.join(iterable).replaceAll("/{2,}", "/");
    }

    private static Source jarSource(File file) {
        return new JarSource(file){

            @Override
            public String identify(String string) {
                return String.format("%s!%s", this.source.getPath(), string);
            }

            public String toString() {
                return String.format("JarSource{jar=%s}", this.source.getPath());
            }
        };
    }

    private static Source fileSource(final File file) {
        return new FileSource(new File("/")){

            @Override
            public String identify(String string) {
                if (!file.getPath().equals(string)) {
                    throw new IllegalArgumentException("Cannot identify any entry name save for " + file.getPath());
                }
                return file.getPath();
            }

            public String toString() {
                return String.format("FileSource{file=%s}", file.getPath());
            }
        };
    }

    private static Source directorySource(File file) {
        return new FileSource(file){

            @Override
            public String identify(String string) {
                return new File(this.source, string).getPath();
            }

            public String toString() {
                return String.format("FileSource{directory=%s}", this.source.getPath());
            }
        };
    }

    private static Source memorySource() {
        return new Source(){

            @Override
            public String name() {
                return "<memory>";
            }

            @Override
            public String identify(String string) {
                return "<memory>!" + string;
            }

            public String toString() {
                return String.format("MemorySource{@%s}", Integer.toHexString(this.hashCode()));
            }
        };
    }

    private static ByteSource manifestSupplier(final Manifest manifest) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                manifest.write(byteArrayOutputStream);
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
        };
    }

    static Manifest ensureDefaultManifestEntries(Manifest manifest) {
        if (!manifest.getMainAttributes().containsKey(Attributes.Name.MANIFEST_VERSION)) {
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        Attributes.Name name = new Attributes.Name("Created-By");
        if (!manifest.getMainAttributes().containsKey(name)) {
            manifest.getMainAttributes().put(name, JarBuilder.class.getName());
        }
        return manifest;
    }

    private static Manifest createDefaultManifest() {
        return JarBuilder.ensureDefaultManifestEntries(new Manifest());
    }

    public JarBuilder(File file) {
        this(file, Listener.NOOP);
    }

    public JarBuilder(File file, Listener listener) {
        this.target = (File)Preconditions.checkNotNull((Object)file);
        this.listener = (Listener)Preconditions.checkNotNull((Object)listener);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public JarBuilder add(final ByteSource byteSource, final String string) {
        Preconditions.checkNotNull((Object)byteSource);
        Preconditions.checkNotNull((Object)string);
        this.additions.add(new EntryIndexer(){

            @Override
            public void execute(Multimap<String, ReadableEntry> multimap) {
                JarBuilder.add((Multimap<String, ReadableEntry>)multimap, NamedByteSource.create(JarBuilder.memorySource(), string, byteSource), string);
            }
        });
        return this;
    }

    private static boolean isEmpty(@Nullable String string) {
        return string == null || string.trim().isEmpty();
    }

    public JarBuilder addDirectory(final File file, final Optional<String> optional) {
        Preconditions.checkArgument((boolean)file.isDirectory(), (String)"Expected a directory, given a file: %s", (Object[])new Object[]{file});
        Preconditions.checkArgument((!optional.isPresent() || !JarBuilder.isEmpty((String)optional.get()) ? 1 : 0) != 0);
        this.additions.add(new EntryIndexer(){

            @Override
            public void execute(Multimap<String, ReadableEntry> multimap) throws JarBuilderException {
                Source source = JarBuilder.directorySource(file);
                ImmutableList immutableList = optional.isPresent() ? JAR_PATH_SPLITTER.split((CharSequence)optional.get()) : ImmutableList.of();
                FluentIterable fluentIterable = Files.fileTreeTraverser().preOrderTraversal((Object)file).filter(Files.isFile());
                for (File file2 : fluentIterable) {
                    Iterable<String> iterable = JarBuilder.relpathComponents(file2, file);
                    Iterable iterable2 = Iterables.concat((Iterable)immutableList, iterable);
                    String string = JarBuilder.joinJarPath(iterable);
                    String string2 = JarBuilder.joinJarPath(iterable2);
                    if ("META-INF/MANIFEST.MF".equals(string2)) continue;
                    NamedByteSource namedByteSource = NamedByteSource.create(source, string, Files.asByteSource((File)file2));
                    JarBuilder.add((Multimap<String, ReadableEntry>)multimap, namedByteSource, string2);
                }
            }
        });
        return this;
    }

    public JarBuilder addFile(final File file, final String string) {
        Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0, (String)"Expected a file, given a directory: %s", (Object[])new Object[]{file});
        Preconditions.checkArgument((!JarBuilder.isEmpty(string) ? 1 : 0) != 0);
        this.additions.add(new EntryIndexer(){

            @Override
            public void execute(Multimap<String, ReadableEntry> multimap) throws JarBuilderException {
                if ("META-INF/MANIFEST.MF".equals(string)) {
                    throw new JarBuilderException("A custom manifest entry should be added via the useCustomManifest methods");
                }
                NamedByteSource namedByteSource = NamedByteSource.create(JarBuilder.fileSource(file), file.getName(), Files.asByteSource((File)file));
                JarBuilder.add((Multimap<String, ReadableEntry>)multimap, namedByteSource, string);
            }
        });
        return this;
    }

    public JarBuilder addJar(final File file) {
        Preconditions.checkNotNull((Object)file);
        this.additions.add(new EntryIndexer(){

            @Override
            public void execute(final Multimap<String, ReadableEntry> multimap) throws IndexingException {
                final InputSupplier inputSupplier = (InputSupplier)((Object)JarBuilder.this.closer.register((Closeable)new JarSupplier(file)));
                final Source source = JarBuilder.jarSource(file);
                try {
                    JarBuilder.this.enumerateJarEntries(file, new JarEntryVisitor(){

                        @Override
                        public void visit(JarEntry jarEntry) throws IOException {
                            if (!jarEntry.isDirectory() && !"META-INF/MANIFEST.MF".equals(jarEntry.getName())) {
                                NamedByteSource namedByteSource = NamedByteSource.create(source, jarEntry.getName(), JarBuilder.entrySupplier(inputSupplier, jarEntry));
                                JarBuilder.add((Multimap<String, ReadableEntry>)multimap, namedByteSource, jarEntry);
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    throw new IndexingException(file, (Throwable)iOException);
                }
            }
        });
        return this;
    }

    private static void add(Multimap<String, ReadableEntry> multimap, NamedByteSource namedByteSource, String string) {
        multimap.put((Object)string, (Object)new ReadableEntry(namedByteSource, string));
    }

    private static void add(Multimap<String, ReadableEntry> multimap, NamedByteSource namedByteSource, JarEntry jarEntry) {
        multimap.put((Object)jarEntry.getName(), (Object)new ReadableJarEntry(namedByteSource, jarEntry));
    }

    public JarBuilder useCustomManifest(Manifest manifest) {
        Preconditions.checkNotNull((Object)manifest);
        this.manifest = JarBuilder.manifestSupplier(manifest);
        return this;
    }

    public JarBuilder useCustomManifest(File file) {
        Preconditions.checkNotNull((Object)file);
        NamedByteSource namedByteSource = NamedByteSource.create(JarBuilder.fileSource(file), file.getPath(), Files.asByteSource((File)file));
        return this.useCustomManifest(namedByteSource);
    }

    public JarBuilder useCustomManifest(CharSequence charSequence) {
        Preconditions.checkNotNull((Object)charSequence);
        return this.useCustomManifest(NamedByteSource.create(JarBuilder.memorySource(), "META-INF/MANIFEST.MF", ByteSource.wrap((byte[])charSequence.toString().getBytes(Charsets.UTF_8))));
    }

    public JarBuilder useCustomManifest(final NamedByteSource namedByteSource) {
        Preconditions.checkNotNull((Object)((Object)namedByteSource));
        return this.useCustomManifest(new InputSupplier<Manifest>(){

            @Override
            public Manifest getInput() throws IOException {
                Manifest manifest = new Manifest();
                try {
                    manifest.read(namedByteSource.openStream());
                    return manifest;
                }
                catch (IOException iOException) {
                    throw new JarCreationException("Invalid manifest from " + namedByteSource.source.identify(namedByteSource.name));
                }
            }
        });
    }

    private JarBuilder useCustomManifest(final InputSupplier<Manifest> inputSupplier) {
        this.manifest = new ByteSource(){

            public InputStream openStream() throws IOException {
                return JarBuilder.manifestSupplier((Manifest)inputSupplier.getInput()).openStream();
            }
        };
        return this;
    }

    public File write() throws IOException {
        return this.write(false, DuplicateHandler.always(DuplicateAction.SKIP), new Pattern[0]);
    }

    public File write(boolean bl) throws IOException {
        return this.write(bl, DuplicateHandler.always(DuplicateAction.SKIP), new Pattern[0]);
    }

    public File write(boolean bl, DuplicateHandler duplicateHandler, Pattern ... patternArray) throws IOException {
        return this.write(bl, duplicateHandler, (Iterable<Pattern>)ImmutableList.copyOf((Object[])patternArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File write(boolean bl, DuplicateHandler duplicateHandler, Iterable<Pattern> iterable) throws DuplicateEntryException, IOException {
        Preconditions.checkNotNull((Object)duplicateHandler);
        Predicate predicate = Predicates.or((Iterable)Iterables.transform((Iterable)ImmutableList.copyOf(iterable), AS_PATH_SELECTOR));
        Iterable<ReadableEntry> iterable2 = this.getEntries((Predicate<CharSequence>)predicate, duplicateHandler);
        File file = File.createTempFile(this.target.getName(), ".tmp", this.target.getParentFile());
        try {
            try {
                JarWriter jarWriter = this.jarWriter(file, bl);
                jarWriter.write("META-INF/MANIFEST.MF", this.manifest == null ? DEFAULT_MANIFEST : this.manifest);
                ArrayList arrayList = Lists.newArrayList();
                for (ReadableEntry readableEntry : iterable2) {
                    if (readableEntry instanceof ReadableJarEntry) {
                        arrayList.add((ReadableJarEntry)readableEntry);
                        continue;
                    }
                    jarWriter.write(readableEntry.getJarPath(), readableEntry.contents);
                }
                this.copyJarFiles(jarWriter, arrayList);
                this.closer.close();
                this.target.delete();
                Files.move((File)file, (File)this.target);
            }
            catch (IOException iOException) {
                throw this.closer.rethrow((Throwable)iOException);
            }
            finally {
                this.closer.close();
            }
        }
        finally {
            file.delete();
        }
        return this.target;
    }

    private void copyJarFiles(JarWriter jarWriter, Iterable<ReadableJarEntry> iterable) throws IOException {
        HashMultimap hashMultimap = HashMultimap.create();
        for (ReadableJarEntry object : iterable) {
            Preconditions.checkState((boolean)(object.getSource() instanceof JarSource));
            hashMultimap.put((Object)((JarSource)object.getSource()), (Object)object);
        }
        for (JarSource jarSource : hashMultimap.keySet()) {
            try (Closer closer = Closer.create();){
                InputSupplier inputSupplier = (InputSupplier)((Object)closer.register((Closeable)new JarSupplier(new File(jarSource.name()))));
                JarFile jarFile = (JarFile)inputSupplier.getInput();
                for (ReadableJarEntry readableJarEntry : hashMultimap.get((Object)jarSource)) {
                    JarEntry jarEntry = readableJarEntry.getJarEntry();
                    String string = jarEntry.getName();
                    jarWriter.copy(string, jarFile, jarEntry);
                }
            }
        }
    }

    private Iterable<ReadableEntry> getEntries(final Predicate<CharSequence> predicate, final DuplicateHandler duplicateHandler) throws JarBuilderException {
        Function<Map.Entry<String, Collection<ReadableEntry>>, Iterable<ReadableEntry>> function = new Function<Map.Entry<String, Collection<ReadableEntry>>, Iterable<ReadableEntry>>(){

            public Iterable<ReadableEntry> apply(Map.Entry<String, Collection<ReadableEntry>> entry) {
                String string = entry.getKey();
                Collection<ReadableEntry> collection = entry.getValue();
                return JarBuilder.this.processEntries((Predicate<CharSequence>)predicate, duplicateHandler, string, collection).asSet();
            }
        };
        return FluentIterable.from(this.getAdditions().asMap().entrySet()).transformAndConcat((Function)function);
    }

    private Optional<ReadableEntry> processEntries(Predicate<CharSequence> predicate, DuplicateHandler duplicateHandler, String string, Collection<ReadableEntry> collection) {
        if (predicate.apply((Object)string)) {
            this.listener.onSkip((Optional<? extends Entry>)Optional.absent(), collection);
            return Optional.absent();
        }
        if (collection.size() < 2) {
            ReadableEntry readableEntry = (ReadableEntry)Iterables.getOnlyElement(collection);
            this.listener.onWrite(readableEntry);
            return Optional.of((Object)readableEntry);
        }
        DuplicateAction duplicateAction = duplicateHandler.actionFor(string);
        switch (duplicateAction) {
            case SKIP: {
                ReadableEntry readableEntry = (ReadableEntry)Iterables.get(collection, (int)0);
                this.listener.onSkip((Optional<? extends Entry>)Optional.of((Object)readableEntry), Iterables.skip(collection, (int)1));
                return Optional.of((Object)readableEntry);
            }
            case REPLACE: {
                ReadableEntry readableEntry = (ReadableEntry)Iterables.getLast(collection);
                this.listener.onReplace(Iterables.limit(collection, (int)(collection.size() - 1)), readableEntry);
                return Optional.of((Object)readableEntry);
            }
            case CONCAT: {
                ByteSource byteSource = ByteSource.concat((Iterable)Iterables.transform(collection, ReadableEntry.GET_CONTENTS));
                ReadableEntry readableEntry = new ReadableEntry(NamedByteSource.create(JarBuilder.memorySource(), string, byteSource), string);
                this.listener.onConcat(string, collection);
                return Optional.of((Object)readableEntry);
            }
            case CONCAT_TEXT: {
                ByteSource byteSource = ByteSource.concat((Iterable)Iterables.transform(collection, ReadableTextEntry.GET_CONTENTS));
                ReadableEntry readableEntry = new ReadableEntry(NamedByteSource.create(JarBuilder.memorySource(), string, byteSource), string);
                this.listener.onConcat(string, collection);
                return Optional.of((Object)readableEntry);
            }
            case THROW: {
                throw new DuplicateEntryException((ReadableEntry)Iterables.get(collection, (int)1));
            }
        }
        throw new IllegalArgumentException("Unrecognized DuplicateAction " + (Object)((Object)duplicateAction));
    }

    private Multimap<String, ReadableEntry> getAdditions() throws JarBuilderException {
        LinkedListMultimap linkedListMultimap = LinkedListMultimap.create();
        if (this.target.exists() && this.target.length() > 0L) {
            final InputSupplier inputSupplier = (InputSupplier)((Object)this.closer.register((Closeable)new JarSupplier(this.target)));
            try {
                this.enumerateJarEntries(this.target, new JarEntryVisitor((Multimap)linkedListMultimap){
                    final /* synthetic */ Multimap val$entries;
                    {
                        this.val$entries = multimap;
                    }

                    @Override
                    public void visit(JarEntry jarEntry) throws IOException {
                        String string = jarEntry.getName();
                        ByteSource byteSource = JarBuilder.entrySupplier(inputSupplier, jarEntry);
                        if ("META-INF/MANIFEST.MF".equals(string)) {
                            if (JarBuilder.this.manifest == null) {
                                JarBuilder.this.manifest = byteSource;
                            }
                        } else if (!jarEntry.isDirectory()) {
                            this.val$entries.put((Object)string, (Object)new ReadableJarEntry(NamedByteSource.create(JarBuilder.jarSource(JarBuilder.this.target), string, byteSource), jarEntry));
                        }
                    }
                });
            }
            catch (IOException iOException) {
                throw new IndexingException(this.target, (Throwable)iOException);
            }
        }
        for (EntryIndexer entryIndexer : this.additions) {
            entryIndexer.execute((Multimap<String, ReadableEntry>)linkedListMultimap);
        }
        return linkedListMultimap;
    }

    private void enumerateJarEntries(File file, JarEntryVisitor jarEntryVisitor) throws IOException {
        Closer closer = Closer.create();
        JarFile jarFile = JarFileUtil.openJarFile(closer, file);
        try {
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                jarEntryVisitor.visit(enumeration.nextElement());
            }
        }
        catch (IOException iOException) {
            throw closer.rethrow((Throwable)iOException);
        }
        finally {
            closer.close();
        }
    }

    private JarWriter jarWriter(File file, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = (FileOutputStream)this.closer.register((Closeable)new FileOutputStream(file));
        BufferedOutputStream bufferedOutputStream = (BufferedOutputStream)this.closer.register((Closeable)new BufferedOutputStream(fileOutputStream, 0x100000));
        final JarOutputStream jarOutputStream = (JarOutputStream)this.closer.register((Closeable)new JarOutputStream(bufferedOutputStream));
        this.closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                jarOutputStream.closeEntry();
            }
        });
        return new JarWriter(jarOutputStream, bl);
    }

    private static ByteSource entrySupplier(final InputSupplier<JarFile> inputSupplier, final JarEntry jarEntry) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return ((JarFile)inputSupplier.getInput()).getInputStream(jarEntry);
            }
        };
    }

    @VisibleForTesting
    static Iterable<String> relpathComponents(File file, File file2) {
        List<String> list = JarBuilder.components(file2);
        List<String> list2 = JarBuilder.components(file);
        Iterator<String> iterator = list.iterator();
        Iterator<String> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext() && iterator.next().equals(iterator2.next())) {
            iterator.remove();
            iterator2.remove();
        }
        if (!list.isEmpty()) {
            list2.addAll(0, Collections.nCopies(list.size(), ".."));
        }
        return list2;
    }

    private static List<String> components(File file) {
        LinkedList linkedList = Lists.newLinkedList();
        File file2 = file;
        do {
            linkedList.addFirst(file2.getName());
        } while ((file2 = file2.getParentFile()) != null);
        return linkedList;
    }

    private static final class JarWriter {
        private static final Joiner JAR_PATH_JOINER = Joiner.on((char)'/');
        private final Set<List<String>> directories = Sets.newHashSet();
        private final JarOutputStream out;
        private final EntryFactory entryFactory;

        private JarWriter(JarOutputStream jarOutputStream, boolean bl) {
            this.out = jarOutputStream;
            this.entryFactory = new EntryFactory(bl);
        }

        public void write(String string, ByteSource byteSource) throws IOException {
            this.ensureParentDir(string);
            this.out.putNextEntry(this.entryFactory.createEntry(string, byteSource));
            byteSource.copyTo((OutputStream)this.out);
        }

        public void copy(String string, JarFile jarFile, JarEntry jarEntry) throws IOException {
            this.ensureParentDir(string);
            JarEntryCopier.copyEntry(this.out, string, jarFile, jarEntry);
        }

        private void ensureParentDir(String string) throws IOException {
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 != null) {
                List list = JarBuilder.components(file2);
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
                for (String string2 : list) {
                    arrayList.add(string2);
                    if (this.directories.contains(arrayList)) continue;
                    this.directories.add((List<String>)ImmutableList.copyOf((Collection)arrayList));
                    this.out.putNextEntry(new JarEntry(JarBuilder.joinJarPath(arrayList) + "/"));
                }
            }
        }

        static class EntryFactory {
            private final boolean compress;

            EntryFactory(boolean bl) {
                this.compress = bl;
            }

            JarEntry createEntry(String string, ByteSource byteSource) throws IOException {
                JarEntry jarEntry = new JarEntry(string);
                jarEntry.setMethod(this.compress ? 8 : 0);
                if (!this.compress) {
                    this.prepareEntry(jarEntry, byteSource);
                }
                return jarEntry;
            }

            private void prepareEntry(JarEntry jarEntry, ByteSource byteSource) throws IOException {
                final CRC32 cRC32 = new CRC32();
                long l = (Long)byteSource.read((ByteProcessor)new ByteProcessor<Long>(){
                    private long size = 0L;

                    public boolean processBytes(byte[] byArray, int n, int n2) throws IOException {
                        this.size += (long)n2;
                        cRC32.update(byArray, n, n2);
                        return true;
                    }

                    public Long getResult() {
                        return this.size;
                    }
                });
                jarEntry.setSize(l);
                jarEntry.setCompressedSize(l);
                jarEntry.setCrc(cRC32.getValue());
            }
        }
    }

    private static interface JarEntryVisitor {
        public void visit(JarEntry var1) throws IOException;
    }

    private static interface EntryIndexer {
        public void execute(Multimap<String, ReadableEntry> var1) throws JarBuilderException;
    }

    private static class JarSupplier
    implements InputSupplier<JarFile>,
    Closeable {
        private final Closer closer = Closer.create();
        private final InputSupplier<JarFile> supplier;

        JarSupplier(final File file) {
            this.supplier = new InputSupplier<JarFile>(){

                @Override
                public JarFile getInput() throws IOException {
                    try {
                        return JarFileUtil.openJarFile(JarSupplier.this.closer, file, false);
                    }
                    catch (ZipException zipException) {
                        ZipException zipException2 = new ZipException("error in opening zip file " + file);
                        zipException2.initCause(zipException);
                        throw zipException2;
                    }
                }
            };
        }

        @Override
        public JarFile getInput() throws IOException {
            return this.supplier.getInput();
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
        }
    }

    private static interface InputSupplier<T> {
        public T getInput() throws IOException;
    }

    public static interface Listener {
        public static final Listener NOOP = new Listener(){

            @Override
            public void onSkip(Optional<? extends Entry> optional, Iterable<? extends Entry> iterable) {
            }

            @Override
            public void onReplace(Iterable<? extends Entry> iterable, Entry entry) {
            }

            @Override
            public void onConcat(String string, Iterable<? extends Entry> iterable) {
            }

            @Override
            public void onWrite(Entry entry) {
            }
        };

        public void onSkip(Optional<? extends Entry> var1, Iterable<? extends Entry> var2);

        public void onReplace(Iterable<? extends Entry> var1, Entry var2);

        public void onConcat(String var1, Iterable<? extends Entry> var2);

        public void onWrite(Entry var1);
    }

    private static class ReadableJarEntry
    extends ReadableEntry {
        private final JarEntry jarEntry;

        public ReadableJarEntry(NamedByteSource namedByteSource, JarEntry jarEntry) {
            super(namedByteSource, jarEntry.getName());
            this.jarEntry = jarEntry;
        }

        public JarEntry getJarEntry() {
            return this.jarEntry;
        }
    }

    private static class ReadableEntry
    implements Entry {
        static final Function<ReadableEntry, NamedByteSource> GET_CONTENTS = new Function<ReadableEntry, NamedByteSource>(){

            public NamedByteSource apply(ReadableEntry readableEntry) {
                return readableEntry.contents;
            }
        };
        private final NamedByteSource contents;
        private final String path;

        ReadableEntry(NamedByteSource namedByteSource, String string) {
            this.contents = namedByteSource;
            this.path = string;
        }

        @Override
        public Source getSource() {
            return this.contents.source;
        }

        @Override
        public String getName() {
            return this.contents.name;
        }

        @Override
        public String getJarPath() {
            return this.path;
        }
    }

    private static class ReadableTextEntry
    extends ReadableEntry {
        static final Function<ReadableEntry, NamedByteSource> GET_CONTENTS = new Function<ReadableEntry, NamedByteSource>(){

            public NamedByteSource apply(ReadableEntry readableEntry) {
                return new NamedTextByteSource(readableEntry.contents);
            }
        };

        ReadableTextEntry(NamedByteSource namedByteSource, String string) {
            super(namedByteSource, string);
        }
    }

    public static interface Entry {
        public Source getSource();

        public String getName();

        public String getJarPath();
    }

    private static class NamedByteSource
    extends ByteSource {
        protected final Source source;
        protected final String name;
        protected final ByteSource inputSupplier;

        static NamedByteSource create(Source source, String string, ByteSource byteSource) {
            return new NamedByteSource(source, string, byteSource);
        }

        private NamedByteSource(Source source, String string, ByteSource byteSource) {
            this.source = source;
            this.name = string;
            this.inputSupplier = byteSource;
        }

        public InputStream openStream() throws IOException {
            return this.inputSupplier.openStream();
        }
    }

    private static final class NamedTextByteSource
    extends NamedByteSource {
        private NamedTextByteSource(NamedByteSource namedByteSource) {
            super(namedByteSource.source, namedByteSource.name, namedByteSource.inputSupplier);
        }

        @Override
        public InputStream openStream() throws IOException {
            return new NewlineAppendingInputStream(this.inputSupplier.openStream());
        }
    }

    private static class NewlineAppendingInputStream
    extends InputStream {
        private InputStream underlyingStream;
        private int lastByteRead = -1;
        private boolean atEOS = false;

        public NewlineAppendingInputStream(InputStream inputStream) {
            this.underlyingStream = inputStream;
        }

        @Override
        public int read() throws IOException {
            if (this.atEOS) {
                return -1;
            }
            int n = this.underlyingStream.read();
            if (n == -1) {
                this.atEOS = true;
                if (this.lastByteRead == -1 || this.lastByteRead == 10) {
                    return -1;
                }
                return 10;
            }
            this.lastByteRead = n;
            return n;
        }
    }

    private static abstract class JarSource
    extends FileSource {
        protected JarSource(File file) {
            super(file);
        }
    }

    private static abstract class FileSource
    implements Source {
        protected final File source;

        protected FileSource(File file) {
            this.source = file;
        }

        @Override
        public String name() {
            return this.source.getPath();
        }
    }

    public static interface Source {
        public String name();

        public String identify(String var1);
    }

    public static class DuplicateHandler {
        private final DuplicateAction defaultAction;
        private final Iterable<DuplicatePolicy> policies;

        public static DuplicateHandler always(DuplicateAction duplicateAction) {
            Preconditions.checkNotNull((Object)((Object)duplicateAction));
            return new DuplicateHandler(duplicateAction, (Iterable<DuplicatePolicy>)ImmutableList.of((Object)new DuplicatePolicy((Predicate<CharSequence>)Predicates.alwaysTrue(), duplicateAction)));
        }

        public static DuplicateHandler skipDuplicatesConcatWellKnownMetadata() {
            DuplicatePolicy duplicatePolicy = DuplicatePolicy.pathMatches("^META-INF/services/", DuplicateAction.CONCAT_TEXT);
            ImmutableList immutableList = ImmutableList.of((Object)duplicatePolicy);
            return new DuplicateHandler(DuplicateAction.SKIP, (Iterable<DuplicatePolicy>)immutableList);
        }

        public DuplicateHandler(DuplicateAction duplicateAction, DuplicatePolicy ... duplicatePolicyArray) {
            this(duplicateAction, (Iterable<DuplicatePolicy>)ImmutableList.copyOf((Object[])duplicatePolicyArray));
        }

        public DuplicateHandler(DuplicateAction duplicateAction, Iterable<DuplicatePolicy> iterable) {
            this.defaultAction = (DuplicateAction)((Object)Preconditions.checkNotNull((Object)((Object)duplicateAction)));
            this.policies = ImmutableList.copyOf(iterable);
        }

        @VisibleForTesting
        DuplicateAction actionFor(String string) {
            for (DuplicatePolicy duplicatePolicy : this.policies) {
                if (!duplicatePolicy.apply(string)) continue;
                return duplicatePolicy.getAction();
            }
            return this.defaultAction;
        }
    }

    public static class DuplicatePolicy
    implements Predicate<CharSequence> {
        private final Predicate<CharSequence> selector;
        private final DuplicateAction action;

        public static DuplicatePolicy pathMatches(String string, DuplicateAction duplicateAction) {
            return new DuplicatePolicy((Predicate<CharSequence>)Predicates.containsPattern((String)string), duplicateAction);
        }

        public DuplicatePolicy(Predicate<CharSequence> predicate, DuplicateAction duplicateAction) {
            this.selector = (Predicate)Preconditions.checkNotNull(predicate);
            this.action = (DuplicateAction)((Object)Preconditions.checkNotNull((Object)((Object)duplicateAction)));
        }

        public DuplicateAction getAction() {
            return this.action;
        }

        public boolean apply(CharSequence charSequence) {
            return this.selector.apply((Object)charSequence);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("selector", this.selector).toString();
        }
    }

    public static enum DuplicateAction {
        SKIP,
        REPLACE,
        CONCAT,
        CONCAT_TEXT,
        THROW;

    }

    public static class DuplicateEntryException
    extends RuntimeException {
        private final ReadableEntry entry;

        DuplicateEntryException(ReadableEntry readableEntry) {
            super("Detected a duplicate entry for " + readableEntry.getJarPath());
            this.entry = readableEntry;
        }

        public String getPath() {
            return this.entry.getJarPath();
        }

        public ByteSource getSource() {
            return this.entry.contents;
        }
    }

    public static class IndexingException
    extends JarBuilderException {
        public IndexingException(File file, Throwable throwable) {
            super("Problem indexing jar at " + file + ": " + throwable.getMessage(), throwable);
        }
    }

    public static class JarCreationException
    extends JarBuilderException {
        public JarCreationException(String string) {
            super(string);
        }
    }

    public static class JarBuilderException
    extends IOException {
        public JarBuilderException(String string) {
            super(string);
        }

        public JarBuilderException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

