/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.jar;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;
import org.pantsbuild.args4j.ArgfileOptionHandler;
import org.pantsbuild.args4j.CollectionOptionHandler;
import org.pantsbuild.args4j.InvalidCmdLineArgumentException;
import org.pantsbuild.args4j.Parser;
import org.pantsbuild.tools.jar.JarBuilder;

public final class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());
    private final Options options;
    private static final Splitter CLASS_PATH_SPLITTER = Splitter.on((char)File.pathSeparatorChar).omitEmptyStrings();
    private static final Function<String, Iterable<String>> ENTRY_TO_PATHS = new Function<String, Iterable<String>>(){

        public Iterable<String> apply(String string) {
            return CLASS_PATH_SPLITTER.split((CharSequence)string);
        }
    };
    private static final Joiner CLASS_PATH_JOINER = Joiner.on((char)' ');

    private Main(Options options) {
        this.options = options;
    }

    private void run() throws ExitException {
        if (this.options.mainClass != null && this.options.manifest != null) {
            throw new ExitException(1, "Can specify main or manifest but not both.", new Object[0]);
        }
        if (!this.options.update && this.options.targetJar.exists() && !this.options.targetJar.delete()) {
            throw new ExitException(1, "Failed to delete file at requested target path %s", this.options.targetJar);
        }
        Closer closer = Closer.create();
        try {
            this.doRun(closer, this.options.targetJar);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException iOException) {
                LOG.warning("Failed to close one or more resources: " + iOException);
            }
        }
    }

    private void doRun(Closer closer, File file) throws ExitException {
        Object object;
        JarBuilder jarBuilder = (JarBuilder)closer.register((Closeable)new JarBuilder(file, new LoggingListener(file)));
        try {
            object = this.getManifest();
            if (object != null) {
                jarBuilder.useCustomManifest((Manifest)object);
            }
        }
        catch (IOException iOException) {
            throw new ExitException(1, "Failed to configure custom manifest: %s", iOException);
        }
        for (Object object2 : this.options.files) {
            ((Options.FileSource)object2).addTo(jarBuilder);
        }
        for (Object object2 : this.options.jars) {
            jarBuilder.addJar((File)object2);
        }
        object = new JarBuilder.DuplicateHandler(this.options.defaultAction, this.options.policies);
        try {
            jarBuilder.write(this.options.compress, (JarBuilder.DuplicateHandler)object, this.options.skip);
        }
        catch (JarBuilder.DuplicateEntryException duplicateEntryException) {
            throw new ExitException(1, "Refusing to write duplicate entry: %s", duplicateEntryException);
        }
        catch (IOException iOException) {
            throw new ExitException(1, "Unexpected problem writing target jar %s: %s", file, iOException);
        }
    }

    @Nullable
    private Manifest getManifest() throws IOException {
        if (this.options.manifest == null && this.options.mainClass == null && this.options.classPath == null) {
            return null;
        }
        Manifest manifest = this.loadManifest();
        if (this.options.mainClass != null) {
            manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.options.mainClass);
        }
        if (this.options.classPath != null) {
            String string = CLASS_PATH_JOINER.join((Iterable)FluentIterable.from((Iterable)this.options.classPath).transformAndConcat(ENTRY_TO_PATHS));
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, string);
        }
        return manifest;
    }

    private Manifest loadManifest() throws IOException {
        Manifest manifest = new Manifest();
        if (this.options.manifest != null) {
            try (Closer closer = Closer.create();){
                FileInputStream fileInputStream = (FileInputStream)closer.register((Closeable)new FileInputStream(this.options.manifest));
                manifest.read(fileInputStream);
            }
        }
        return JarBuilder.ensureDefaultManifestEntries(manifest);
    }

    public static void main(String[] stringArray) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new SimpleFormatter());
        consoleHandler.setLevel(Level.WARNING);
        Logger.getLogger("").addHandler(consoleHandler);
        Options options = new Options();
        Parser.Result result = Parser.parse((Object)options, (String[])stringArray);
        if (result.isFailure()) {
            result.printUsage((OutputStream)System.err);
            Main.exit(1);
        } else if (options.help) {
            result.printUsage((OutputStream)System.out);
            Main.exit(0);
        }
        Main main = new Main(options);
        try {
            main.run();
        }
        catch (ExitException exitException) {
            System.err.println(exitException.getMessage());
            Main.exit(exitException.code);
        }
        Main.exit(0);
    }

    private static void exit(int n) {
        System.exit(n);
    }

    static class ExitException
    extends Exception {
        private final int code;

        ExitException(int n, String string, Object ... objectArray) {
            super(String.format(string, objectArray));
            this.code = n;
        }
    }

    private static class LoggingListener
    implements JarBuilder.Listener {
        private JarBuilder.Source source = null;
        private final File target;

        LoggingListener(File file) {
            this.target = file;
        }

        @Override
        public void onSkip(Optional<? extends JarBuilder.Entry> optional, Iterable<? extends JarBuilder.Entry> iterable) {
            if (LOG.isLoggable(Level.FINE)) {
                if (optional.isPresent()) {
                    LOG.fine(String.format("Retaining %s and skipping %s", LoggingListener.identify((JarBuilder.Entry)optional.get()), LoggingListener.identify(iterable)));
                } else {
                    LOG.fine(String.format("Skipping %s", LoggingListener.identify(iterable)));
                }
            }
        }

        @Override
        public void onReplace(Iterable<? extends JarBuilder.Entry> iterable, JarBuilder.Entry entry) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Using %s to replace %s", LoggingListener.identify(entry), LoggingListener.identify(iterable)));
            }
        }

        @Override
        public void onConcat(String string, Iterable<? extends JarBuilder.Entry> iterable) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Concatenating %s!%s from %s", this.target.getPath(), string, LoggingListener.identify(iterable)));
            }
        }

        @Override
        public void onWrite(JarBuilder.Entry entry) {
            if (!entry.getSource().equals(this.source)) {
                this.source = entry.getSource();
                LOG.fine(entry.getSource().name());
            }
            LOG.log(Level.FINER, "\t{0}", entry.getName());
        }

        private static String identify(JarBuilder.Entry entry) {
            return entry.getSource().identify(entry.getName());
        }

        private static String identify(Iterable<? extends JarBuilder.Entry> iterable) {
            return Joiner.on((String)",").join((Iterable)FluentIterable.from(iterable).transform((Function)new Function<JarBuilder.Entry, String>(){

                public String apply(JarBuilder.Entry entry) {
                    return LoggingListener.identify(entry);
                }
            }));
        }
    }

    public static class Options {
        @Option(name="-h", aliases={"-help"}, help=true, usage="Display this help screen.")
        private boolean help;
        @Option(name="-main", usage="The name of the fully qualified main class. If a -manifest is specified its contents will be used but this -main will override any entry already present.")
        private String mainClass;
        @Option(name="-classpath", usage="A list of comma-separated classpath entries. If a -manifest is specified its contents will be used but this -classpath will override any entry already present.", handler=ClassPathOptionHandler.class)
        private List<String> classPath = null;
        private File manifest;
        @Option(name="-update", usage="Update the jar if it already exists, otherwise create it.")
        private boolean update;
        @Option(name="-compress", usage="Compress jar entries.")
        private boolean compress;
        @Option(name="-files", usage="A mapping from filesystem paths to jar paths. The mapping is specified in the form [fs path1](=[jar path1]),[fs path2](=[jar path2]). For example: /etc/hosts=hosts,/var/log=logs would create a jar with a hosts file entry and the contents of the /var/log tree added as individual entries under the logs/ directory in the jar. For directories, the mapping can be skipped in which case the directory tree is added as-is to the resulting jar.", handler=FilesOptionHandler.class)
        private List<FileSource> files = Lists.newArrayList();
        @Option(name="-jars", usage="A list of comma-separated jar files whose entries to add to the output jar.", handler=JarsOptionHandler.class)
        private List<File> jars = Lists.newArrayList();
        @Option(name="-skip", usage="A list of regular expressions identifying entries to skip.", handler=PatternOptionHandler.class)
        private List<Pattern> skip = Lists.newArrayList();
        private static final String ACTIONS = "SKIP|REPLACE|CONCAT|CONCAT_TEXT|THROW";
        @Option(name="-default_action", usage="The default duplicate action to apply if no policies match. Can be any of SKIP|REPLACE|CONCAT|CONCAT_TEXT|THROW")
        private JarBuilder.DuplicateAction defaultAction = JarBuilder.DuplicateAction.SKIP;
        @Option(name="-policies", usage="A list of duplicate policies to apply. Policies are specified as [regex]=[action], and the action can be any one of SKIP|REPLACE|CONCAT|CONCAT_TEXT|THROW. For example: ^META-INF/services/=CONCAT_TEXT would concatenate duplicate service files into one large service file.", handler=DuplicatePolicyParser.class)
        private List<JarBuilder.DuplicatePolicy> policies = Lists.newArrayList();
        @Argument(metaVar="TARGET_JAR", usage="The target jar file path to write.", required=true)
        private File targetJar;

        @Option(name="-manifest", usage="A path to a manifest file to use. If -main or -classpath is specified those values will overwrite the corresponding entry in this manifest.")
        void setManifest(File file) {
            if (file == null) {
                throw new InvalidCmdLineArgumentException("-manifest", (Object)file, "Cannot be null.");
            }
            if (!file.exists()) {
                throw new InvalidCmdLineArgumentException("-manifest", (Object)file, "Must exist.");
            }
            if (!file.isFile()) {
                throw new InvalidCmdLineArgumentException("-manifest", (Object)file, "Must be a file.");
            }
            if (!file.canRead()) {
                throw new InvalidCmdLineArgumentException("-manifest", (Object)file, "Must be readable.");
            }
            this.manifest = file;
        }

        public static class PatternOptionHandler
        extends CollectionOptionHandler<Pattern> {
            public PatternOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super Pattern> setter) {
                super(cmdLineParser, optionDef, setter, "PATTERN", (CollectionOptionHandler.ItemParser)new CollectionOptionHandler.ItemParser<Pattern>(){

                    public Pattern parse(String string) {
                        try {
                            return Pattern.compile(string);
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw new IllegalArgumentException(patternSyntaxException);
                        }
                    }
                });
            }
        }

        public static class JarsOptionHandler
        extends ArgfileOptionHandler<File> {
            public JarsOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super File> setter) {
                super((OptionHandler)new CollectionOptionHandler(cmdLineParser, optionDef, setter, "JAR", (CollectionOptionHandler.ItemParser)new CollectionOptionHandler.ItemParser<File>(){

                    public File parse(String string) {
                        return new File(string);
                    }
                }));
            }
        }

        public static class FilesOptionHandler
        extends ArgfileOptionHandler<FileSource> {
            public FilesOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super FileSource> setter) {
                super((OptionHandler)new FileSourceOptionHandler(cmdLineParser, optionDef, setter));
            }
        }

        public static class ClassPathOptionHandler
        extends ArgfileOptionHandler<String> {
            public ClassPathOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super String> setter) {
                super((OptionHandler)new CollectionOptionHandler(cmdLineParser, optionDef, setter, "CLASS_PATH_ENTRY", CollectionOptionHandler.ItemParser.IDENTITY));
            }
        }

        public static class FileSourceOptionHandler
        extends CollectionOptionHandler<FileSource> {
            private static final Splitter DESTINATION_SPLITTER = Splitter.on((char)'=').trimResults().omitEmptyStrings();

            public FileSourceOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super FileSource> setter) {
                super(cmdLineParser, optionDef, setter, "FILE_SOURCE", (CollectionOptionHandler.ItemParser)new CollectionOptionHandler.ItemParser<FileSource>(){

                    public FileSource parse(String string) {
                        ImmutableList immutableList = ImmutableList.copyOf((Iterable)DESTINATION_SPLITTER.split((CharSequence)string));
                        Preconditions.checkArgument((1 <= immutableList.size() && immutableList.size() <= 2 ? 1 : 0) != 0, (String)"Failed to parse entry %s", (Object[])new Object[]{string});
                        File file = new File((String)immutableList.get(0));
                        String string2 = immutableList.size() == 2 ? (String)immutableList.get(1) : null;
                        return new FileSource(file, string2);
                    }
                });
            }
        }

        static class FileSource {
            private static final Splitter JAR_PATH_SPLITTER = Splitter.on((char)'/');
            private final File source;
            @Nullable
            private final String destination;

            FileSource(File file, @Nullable String string) {
                if (!file.exists() || !file.canRead()) {
                    throw new IllegalArgumentException(String.format("The source %s is not a readable path", file));
                }
                if (!file.isDirectory() && string == null) {
                    throw new IllegalArgumentException(String.format("The source file %s must have a jar destination specified.", file));
                }
                if (string != null) {
                    Preconditions.checkArgument((!Strings.isNullOrEmpty((String)string.trim()) ? 1 : 0) != 0, (Object)"The destination path cannot be blank");
                    Preconditions.checkArgument((!string.startsWith("/") ? 1 : 0) != 0, (String)"The destination path cannot be absolute, given: %s", (Object[])new Object[]{string});
                    Preconditions.checkArgument((!ImmutableSet.copyOf((Iterable)JAR_PATH_SPLITTER.split((CharSequence)string)).contains((Object)"..") ? 1 : 0) != 0, (String)"The destination path cannot be relative, given: %s", (Object[])new Object[]{string});
                }
                this.source = file;
                this.destination = string;
            }

            void addTo(JarBuilder jarBuilder) {
                if (this.source.isDirectory()) {
                    jarBuilder.addDirectory(this.source, (Optional<String>)Optional.fromNullable((Object)this.destination));
                } else {
                    jarBuilder.addFile(this.source, this.destination);
                }
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("destination", (Object)this.destination).toString();
            }
        }

        public static class DuplicatePolicyParser
        extends CollectionOptionHandler<JarBuilder.DuplicatePolicy> {
            private static final Splitter REGEX_ACTION_SPLITTER = Splitter.on((char)'=').trimResults().omitEmptyStrings();

            public DuplicatePolicyParser(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super JarBuilder.DuplicatePolicy> setter) {
                super(cmdLineParser, optionDef, setter, "DUPLICATE_POLICY", (CollectionOptionHandler.ItemParser)new CollectionOptionHandler.ItemParser<JarBuilder.DuplicatePolicy>(){

                    public JarBuilder.DuplicatePolicy parse(String string) {
                        ImmutableList immutableList = ImmutableList.copyOf((Iterable)REGEX_ACTION_SPLITTER.split((CharSequence)string));
                        Preconditions.checkArgument((immutableList.size() == 2 ? 1 : 0) != 0, (String)"Failed to parse jar path regex/action pair %s", (Object[])new Object[]{string});
                        String string2 = (String)immutableList.get(0);
                        JarBuilder.DuplicateAction duplicateAction = JarBuilder.DuplicateAction.valueOf((String)immutableList.get(1));
                        return JarBuilder.DuplicatePolicy.pathMatches(string2, duplicateAction);
                    }
                });
            }
        }
    }
}

