/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.jar;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class JarEntryCopier {
    private static final FieldReader<FilterInputStream, InputStream> FIS_IN = FieldReader.create(FilterInputStream.class, InputStream.class, "in");
    private static final FieldReader<ZipOutputStream, CRC32> ZOS_CRC = FieldReader.create(ZipOutputStream.class, CRC32.class, "crc");
    private static final FieldAccessor<CRC32, Integer> CRC_VALUE = FieldAccessor.create(CRC32.class, Integer.TYPE, "crc");
    private static final FieldAccessor<ZipEntry, String> ZE_NAME = FieldAccessor.create(ZipEntry.class, String.class, "name");

    static void copyEntry(JarOutputStream jarOutputStream, String string, JarFile jarFile, JarEntry jarEntry) throws IOException {
        JarEntry jarEntry2 = new JarEntry(jarEntry);
        ZE_NAME.set(jarEntry2, string);
        if (jarEntry2.isDirectory()) {
            jarEntry2.setMethod(0);
            jarEntry2.setSize(0L);
            jarEntry2.setCompressedSize(0L);
            jarEntry2.setCrc(0L);
            jarOutputStream.putNextEntry(jarEntry2);
            jarOutputStream.closeEntry();
        } else if (jarEntry.getMethod() == 0) {
            try (Closer closer = Closer.create();){
                InputStream inputStream = (InputStream)closer.register((Closeable)jarFile.getInputStream(jarEntry));
                jarOutputStream.putNextEntry(jarEntry2);
                ByteStreams.copy((InputStream)inputStream, (OutputStream)jarOutputStream);
            }
            jarOutputStream.closeEntry();
        } else {
            try (Closer closer = Closer.create();){
                FilterInputStream filterInputStream = (FilterInputStream)closer.register((Closeable)jarFile.getInputStream(jarEntry));
                InputStream inputStream = FIS_IN.get(filterInputStream);
                jarOutputStream.putNextEntry(jarEntry2);
                jarEntry2.setMethod(0);
                jarEntry2.setSize(jarEntry.getCompressedSize());
                ByteStreams.copy((InputStream)inputStream, (OutputStream)jarOutputStream);
            }
            CRC_VALUE.set(ZOS_CRC.get(jarOutputStream), (int)jarEntry.getCrc());
            jarOutputStream.closeEntry();
            jarEntry2.setMethod(8);
            jarEntry2.setSize(jarEntry.getSize());
        }
    }

    private JarEntryCopier() {
    }

    private static class FieldAccessor<T, V>
    extends FieldReader<T, V> {
        public static <T, V> FieldAccessor<T, V> create(Class<T> clazz, Class<V> clazz2, String string) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                return new FieldAccessor<T, V>(field, clazz2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
        }

        FieldAccessor(Field field, Class<V> clazz) {
            super(field, clazz);
            Preconditions.checkArgument((boolean)field.getType().isAssignableFrom(clazz));
        }

        public void set(T t, V v) {
            try {
                this.field.set(t, v);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
    }

    private static class FieldReader<T, V> {
        protected final Field field;
        private final Class<V> fieldType;

        public static <T, V> FieldReader<T, V> create(Class<T> clazz, Class<V> clazz2, String string) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                return new FieldReader<T, V>(field, clazz2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
        }

        FieldReader(Field field, Class<V> clazz) {
            Preconditions.checkArgument((boolean)clazz.isAssignableFrom(field.getType()));
            this.field = field;
            this.fieldType = clazz;
        }

        public V get(T t) {
            try {
                return (V)this.field.get(t);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }

        public Class<V> getType() {
            return this.fieldType;
        }
    }
}

