/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.jar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import javax.annotation.Nullable;
import org.pantsbuild.tools.jar.JarEntryCopier;
import org.pantsbuild.tools.jar.JarFileUtil;

public class JarBuilder
implements Closeable {
    private static final ByteSource DEFAULT_MANIFEST = JarBuilder.manifestSupplier(JarBuilder.createDefaultManifest());
    private static final Splitter JAR_PATH_SPLITTER = Splitter.on((char)'/');
    private static final Joiner JAR_PATH_JOINER = Joiner.on((char)'/');
    private final File target;
    private final Listener listener;
    private final Closer closer = Closer.create();
    private final List<EntryIndexer> additions = Lists.newLinkedList();
    @Nullable
    private ByteSource manifest;
    private static final Function<Pattern, Predicate<CharSequence>> AS_PATH_SELECTOR = new Function<Pattern, Predicate<CharSequence>>(){

        public Predicate<CharSequence> apply(Pattern item) {
            return Predicates.contains((Pattern)item);
        }
    };

    private static Source jarSource(File jar) {
        return new JarSource(jar){

            @Override
            public String identify(String name) {
                return String.format("%s!%s", this.source.getPath(), name);
            }

            public String toString() {
                return String.format("JarSource{jar=%s}", this.source.getPath());
            }
        };
    }

    private static Source fileSource(final File file) {
        return new FileSource(new File("/")){

            @Override
            public String identify(String name) {
                if (!file.getPath().equals(name)) {
                    throw new IllegalArgumentException("Cannot identify any entry name save for " + file.getPath());
                }
                return file.getPath();
            }

            public String toString() {
                return String.format("FileSource{file=%s}", file.getPath());
            }
        };
    }

    private static Source directorySource(File directory) {
        return new FileSource(directory){

            @Override
            public String identify(String name) {
                return new File(this.source, name).getPath();
            }

            public String toString() {
                return String.format("FileSource{directory=%s}", this.source.getPath());
            }
        };
    }

    private static Source memorySource() {
        return new Source(){

            @Override
            public String name() {
                return "<memory>";
            }

            @Override
            public String identify(String name) {
                return "<memory>!" + name;
            }

            public String toString() {
                return String.format("MemorySource{@%s}", Integer.toHexString(this.hashCode()));
            }
        };
    }

    private static ByteSource manifestSupplier(final Manifest mf) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                mf.write(out);
                return new ByteArrayInputStream(out.toByteArray());
            }
        };
    }

    static Manifest ensureDefaultManifestEntries(Manifest manifest) {
        if (!manifest.getMainAttributes().containsKey(Attributes.Name.MANIFEST_VERSION)) {
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        Attributes.Name createdBy = new Attributes.Name("Created-By");
        if (!manifest.getMainAttributes().containsKey(createdBy)) {
            manifest.getMainAttributes().put(createdBy, JarBuilder.class.getName());
        }
        return manifest;
    }

    private static Manifest createDefaultManifest() {
        return JarBuilder.ensureDefaultManifestEntries(new Manifest());
    }

    public JarBuilder(File target) {
        this(target, Listener.NOOP);
    }

    public JarBuilder(File target, Listener listener) {
        this.target = (File)Preconditions.checkNotNull((Object)target);
        this.listener = (Listener)Preconditions.checkNotNull((Object)listener);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public JarBuilder add(final ByteSource contents, final String jarPath) {
        Preconditions.checkNotNull((Object)contents);
        Preconditions.checkNotNull((Object)jarPath);
        this.additions.add(new EntryIndexer(){

            @Override
            public void execute(Multimap<String, ReadableEntry> entries) {
                JarBuilder.add((Multimap<String, ReadableEntry>)entries, NamedByteSource.create(JarBuilder.memorySource(), jarPath, contents), jarPath);
            }
        });
        return this;
    }

    private static boolean isEmpty(@Nullable String value) {
        return value == null || value.trim().isEmpty();
    }

    public JarBuilder addDirectory(final File directory, final Optional<String> jarPath) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"Expected a directory, given a file: %s", (Object[])new Object[]{directory});
        Preconditions.checkArgument((!jarPath.isPresent() || !JarBuilder.isEmpty((String)jarPath.get()) ? 1 : 0) != 0);
        this.additions.add(new EntryIndexer(){

            @Override
            public void execute(Multimap<String, ReadableEntry> entries) throws JarBuilderException {
                Source directorySource = JarBuilder.directorySource(directory);
                ImmutableList jarBasePath = jarPath.isPresent() ? JAR_PATH_SPLITTER.split((CharSequence)jarPath.get()) : ImmutableList.of();
                FluentIterable files = Files.fileTreeTraverser().preOrderTraversal((Object)directory).filter(Files.isFile());
                for (File child : files) {
                    Iterable<String> relpathComponents = JarBuilder.relpathComponents(child, directory);
                    Iterable path = Iterables.concat((Iterable)jarBasePath, relpathComponents);
                    String entryPath = JAR_PATH_JOINER.join(relpathComponents);
                    if ("META-INF/MANIFEST.MF".equals(entryPath)) continue;
                    NamedByteSource contents = NamedByteSource.create(directorySource, entryPath, Files.asByteSource((File)child));
                    JarBuilder.add((Multimap<String, ReadableEntry>)entries, contents, JAR_PATH_JOINER.join(path));
                }
            }
        });
        return this;
    }

    public JarBuilder addFile(final File file, final String jarPath) {
        Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0, (String)"Expected a file, given a directory: %s", (Object[])new Object[]{file});
        Preconditions.checkArgument((!JarBuilder.isEmpty(jarPath) ? 1 : 0) != 0);
        this.additions.add(new EntryIndexer(){

            @Override
            public void execute(Multimap<String, ReadableEntry> entries) throws JarBuilderException {
                if ("META-INF/MANIFEST.MF".equals(jarPath)) {
                    throw new JarBuilderException("A custom manifest entry should be added via the useCustomManifest methods");
                }
                NamedByteSource contents = NamedByteSource.create(JarBuilder.fileSource(file), file.getName(), Files.asByteSource((File)file));
                JarBuilder.add((Multimap<String, ReadableEntry>)entries, contents, jarPath);
            }
        });
        return this;
    }

    public JarBuilder addJar(final File file) {
        Preconditions.checkNotNull((Object)file);
        this.additions.add(new EntryIndexer(){

            @Override
            public void execute(final Multimap<String, ReadableEntry> entries) throws IndexingException {
                final InputSupplier jarSupplier = (InputSupplier)((Object)JarBuilder.this.closer.register((Closeable)new JarSupplier(file)));
                final Source jarSource = JarBuilder.jarSource(file);
                try {
                    JarBuilder.this.enumerateJarEntries(file, new JarEntryVisitor(){

                        @Override
                        public void visit(JarEntry entry) throws IOException {
                            if (!entry.isDirectory() && !"META-INF/MANIFEST.MF".equals(entry.getName())) {
                                NamedByteSource contents = NamedByteSource.create(jarSource, entry.getName(), JarBuilder.entrySupplier(jarSupplier, entry));
                                JarBuilder.add((Multimap<String, ReadableEntry>)entries, contents, entry);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    throw new IndexingException(file, (Throwable)e);
                }
            }
        });
        return this;
    }

    private static void add(Multimap<String, ReadableEntry> entries, NamedByteSource contents, String jarPath) {
        entries.put((Object)jarPath, (Object)new ReadableEntry(contents, jarPath));
    }

    private static void add(Multimap<String, ReadableEntry> entries, NamedByteSource contents, JarEntry jarEntry) {
        entries.put((Object)jarEntry.getName(), (Object)new ReadableJarEntry(contents, jarEntry));
    }

    public JarBuilder useCustomManifest(Manifest customManifest) {
        Preconditions.checkNotNull((Object)customManifest);
        this.manifest = JarBuilder.manifestSupplier(customManifest);
        return this;
    }

    public JarBuilder useCustomManifest(File customManifest) {
        Preconditions.checkNotNull((Object)customManifest);
        NamedByteSource contents = NamedByteSource.create(JarBuilder.fileSource(customManifest), customManifest.getPath(), Files.asByteSource((File)customManifest));
        return this.useCustomManifest(contents);
    }

    public JarBuilder useCustomManifest(CharSequence customManifest) {
        Preconditions.checkNotNull((Object)customManifest);
        return this.useCustomManifest(NamedByteSource.create(JarBuilder.memorySource(), "META-INF/MANIFEST.MF", ByteSource.wrap((byte[])customManifest.toString().getBytes(Charsets.UTF_8))));
    }

    public JarBuilder useCustomManifest(final NamedByteSource customManifest) {
        Preconditions.checkNotNull((Object)((Object)customManifest));
        return this.useCustomManifest(new InputSupplier<Manifest>(){

            @Override
            public Manifest getInput() throws IOException {
                Manifest mf = new Manifest();
                try {
                    mf.read(customManifest.openStream());
                    return mf;
                }
                catch (IOException e) {
                    throw new JarCreationException("Invalid manifest from " + customManifest.source.identify(customManifest.name));
                }
            }
        });
    }

    private JarBuilder useCustomManifest(final InputSupplier<Manifest> manifestSource) {
        this.manifest = new ByteSource(){

            public InputStream openStream() throws IOException {
                return JarBuilder.manifestSupplier((Manifest)manifestSource.getInput()).openStream();
            }
        };
        return this;
    }

    public File write() throws IOException {
        return this.write(false, DuplicateHandler.always(DuplicateAction.SKIP), new Pattern[0]);
    }

    public File write(boolean compress) throws IOException {
        return this.write(compress, DuplicateHandler.always(DuplicateAction.SKIP), new Pattern[0]);
    }

    public File write(boolean compress, DuplicateHandler duplicateHandler, Pattern ... skipPatterns) throws IOException {
        return this.write(compress, duplicateHandler, (Iterable<Pattern>)ImmutableList.copyOf((Object[])skipPatterns));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File write(boolean compress, DuplicateHandler duplicateHandler, Iterable<Pattern> skipPatterns) throws DuplicateEntryException, IOException {
        Preconditions.checkNotNull((Object)duplicateHandler);
        Predicate skipPath = Predicates.or((Iterable)Iterables.transform((Iterable)ImmutableList.copyOf(skipPatterns), AS_PATH_SELECTOR));
        Iterable<ReadableEntry> entries = this.getEntries((Predicate<CharSequence>)skipPath, duplicateHandler);
        File tmp = File.createTempFile(this.target.getName(), ".tmp", this.target.getParentFile());
        try {
            try {
                JarWriter writer = this.jarWriter(tmp, compress);
                writer.write("META-INF/MANIFEST.MF", this.manifest == null ? DEFAULT_MANIFEST : this.manifest);
                ArrayList jarEntries = Lists.newArrayList();
                for (ReadableEntry entry : entries) {
                    if (entry instanceof ReadableJarEntry) {
                        jarEntries.add((ReadableJarEntry)entry);
                        continue;
                    }
                    writer.write(entry.getJarPath(), entry.contents);
                }
                this.copyJarFiles(writer, jarEntries);
                this.closer.close();
                this.target.delete();
                Files.move((File)tmp, (File)this.target);
            }
            catch (IOException e) {
                throw this.closer.rethrow((Throwable)e);
            }
            finally {
                this.closer.close();
            }
        }
        finally {
            tmp.delete();
        }
        return this.target;
    }

    private void copyJarFiles(JarWriter writer, Iterable<ReadableJarEntry> entries) throws IOException {
        HashMultimap jarEntries = HashMultimap.create();
        for (ReadableJarEntry entry : entries) {
            Preconditions.checkState((boolean)(entry.getSource() instanceof JarSource));
            jarEntries.put((Object)((JarSource)entry.getSource()), (Object)entry);
        }
        for (JarSource source : jarEntries.keySet()) {
            Closer jarFileCloser = Closer.create();
            try {
                InputSupplier jarSupplier = (InputSupplier)((Object)jarFileCloser.register((Closeable)new JarSupplier(new File(source.name()))));
                JarFile jarFile = (JarFile)jarSupplier.getInput();
                for (ReadableJarEntry readableJarEntry : jarEntries.get((Object)source)) {
                    JarEntry jarEntry = readableJarEntry.getJarEntry();
                    String resource = jarEntry.getName();
                    writer.copy(resource, jarFile, jarEntry);
                }
            }
            catch (IOException ex) {
                throw jarFileCloser.rethrow((Throwable)ex);
            }
            finally {
                jarFileCloser.close();
            }
        }
    }

    private Iterable<ReadableEntry> getEntries(final Predicate<CharSequence> skipPath, final DuplicateHandler duplicateHandler) throws JarBuilderException {
        Function<Map.Entry<String, Collection<ReadableEntry>>, Iterable<ReadableEntry>> mergeEntries = new Function<Map.Entry<String, Collection<ReadableEntry>>, Iterable<ReadableEntry>>(){

            public Iterable<ReadableEntry> apply(Map.Entry<String, Collection<ReadableEntry>> item) {
                String jarPath = item.getKey();
                Collection<ReadableEntry> entries = item.getValue();
                return JarBuilder.this.processEntries((Predicate<CharSequence>)skipPath, duplicateHandler, jarPath, entries).asSet();
            }
        };
        return FluentIterable.from(this.getAdditions().asMap().entrySet()).transformAndConcat((Function)mergeEntries);
    }

    private Optional<ReadableEntry> processEntries(Predicate<CharSequence> skipPath, DuplicateHandler duplicateHandler, String jarPath, Collection<ReadableEntry> itemEntries) {
        if (skipPath.apply((Object)jarPath)) {
            this.listener.onSkip((Optional<? extends Entry>)Optional.absent(), itemEntries);
            return Optional.absent();
        }
        if (itemEntries.size() < 2) {
            ReadableEntry entry = (ReadableEntry)Iterables.getOnlyElement(itemEntries);
            this.listener.onWrite(entry);
            return Optional.of((Object)entry);
        }
        DuplicateAction action = duplicateHandler.actionFor(jarPath);
        switch (action) {
            case SKIP: {
                ReadableEntry original = (ReadableEntry)Iterables.get(itemEntries, (int)0);
                this.listener.onSkip((Optional<? extends Entry>)Optional.of((Object)original), Iterables.skip(itemEntries, (int)1));
                return Optional.of((Object)original);
            }
            case REPLACE: {
                ReadableEntry replacement = (ReadableEntry)Iterables.getLast(itemEntries);
                this.listener.onReplace(Iterables.limit(itemEntries, (int)(itemEntries.size() - 1)), replacement);
                return Optional.of((Object)replacement);
            }
            case CONCAT: {
                ByteSource concat = ByteSource.concat((Iterable)Iterables.transform(itemEntries, ReadableEntry.GET_CONTENTS));
                ReadableEntry concatenatedEntry = new ReadableEntry(NamedByteSource.create(JarBuilder.memorySource(), jarPath, concat), jarPath);
                this.listener.onConcat(jarPath, itemEntries);
                return Optional.of((Object)concatenatedEntry);
            }
            case THROW: {
                throw new DuplicateEntryException((ReadableEntry)Iterables.get(itemEntries, (int)1));
            }
        }
        throw new IllegalArgumentException("Unrecognized DuplicateAction " + (Object)((Object)action));
    }

    private Multimap<String, ReadableEntry> getAdditions() throws JarBuilderException {
        LinkedListMultimap entries = LinkedListMultimap.create();
        if (this.target.exists() && this.target.length() > 0L) {
            final InputSupplier jarSupplier = (InputSupplier)((Object)this.closer.register((Closeable)new JarSupplier(this.target)));
            try {
                this.enumerateJarEntries(this.target, new JarEntryVisitor((Multimap)entries){
                    final /* synthetic */ Multimap val$entries;
                    {
                        this.val$entries = multimap;
                    }

                    @Override
                    public void visit(JarEntry jarEntry) throws IOException {
                        String entryPath = jarEntry.getName();
                        ByteSource contents = JarBuilder.entrySupplier(jarSupplier, jarEntry);
                        if ("META-INF/MANIFEST.MF".equals(entryPath)) {
                            if (JarBuilder.this.manifest == null) {
                                JarBuilder.this.manifest = contents;
                            }
                        } else if (!jarEntry.isDirectory()) {
                            this.val$entries.put((Object)entryPath, (Object)new ReadableJarEntry(NamedByteSource.create(JarBuilder.jarSource(JarBuilder.this.target), entryPath, contents), jarEntry));
                        }
                    }
                });
            }
            catch (IOException e) {
                throw new IndexingException(this.target, (Throwable)e);
            }
        }
        for (EntryIndexer addition : this.additions) {
            addition.execute((Multimap<String, ReadableEntry>)entries);
        }
        return entries;
    }

    private void enumerateJarEntries(File jarFile, JarEntryVisitor visitor) throws IOException {
        Closer jarFileCloser = Closer.create();
        JarFile jar = JarFileUtil.openJarFile(jarFileCloser, jarFile);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                visitor.visit(entries.nextElement());
            }
        }
        catch (IOException e) {
            throw jarFileCloser.rethrow((Throwable)e);
        }
        finally {
            jarFileCloser.close();
        }
    }

    private JarWriter jarWriter(File path, boolean compress) throws IOException {
        FileOutputStream out = (FileOutputStream)this.closer.register((Closeable)new FileOutputStream(path));
        final JarOutputStream jar = (JarOutputStream)this.closer.register((Closeable)new JarOutputStream(out));
        this.closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                jar.closeEntry();
            }
        });
        return new JarWriter(jar, compress);
    }

    private static ByteSource entrySupplier(final InputSupplier<JarFile> jar, final JarEntry entry) {
        return new ByteSource(){

            public InputStream openStream() throws IOException {
                return ((JarFile)jar.getInput()).getInputStream(entry);
            }
        };
    }

    @VisibleForTesting
    static Iterable<String> relpathComponents(File fullPath, File relativeTo) {
        List<String> base = JarBuilder.components(relativeTo);
        List<String> path = JarBuilder.components(fullPath);
        Iterator<String> baseIter = base.iterator();
        Iterator<String> pathIter = path.iterator();
        while (baseIter.hasNext() && pathIter.hasNext() && baseIter.next().equals(pathIter.next())) {
            baseIter.remove();
            pathIter.remove();
        }
        if (!base.isEmpty()) {
            path.addAll(0, Collections.nCopies(base.size(), ".."));
        }
        return path;
    }

    private static List<String> components(File file) {
        LinkedList components = Lists.newLinkedList();
        File path = file;
        do {
            components.addFirst(path.getName());
        } while ((path = path.getParentFile()) != null);
        return components;
    }

    private static final class JarWriter {
        private static final Joiner JAR_PATH_JOINER = Joiner.on((char)'/');
        private final Set<List<String>> directories = Sets.newHashSet();
        private final JarOutputStream out;
        private final EntryFactory entryFactory;

        private JarWriter(JarOutputStream out, boolean compress) {
            this.out = out;
            this.entryFactory = new EntryFactory(compress);
        }

        public void write(String path, ByteSource contents) throws IOException {
            this.ensureParentDir(path);
            this.out.putNextEntry(this.entryFactory.createEntry(path, contents));
            contents.copyTo((OutputStream)this.out);
        }

        public void copy(String path, JarFile jarIn, JarEntry srcJarEntry) throws IOException {
            this.ensureParentDir(path);
            JarEntryCopier.copyEntry(this.out, path, jarIn, srcJarEntry);
        }

        private void ensureParentDir(String path) throws IOException {
            File file = new File(path);
            File parent = file.getParentFile();
            if (parent != null) {
                List components = JarBuilder.components(parent);
                ArrayList ancestry = Lists.newArrayListWithCapacity((int)components.size());
                for (String component : components) {
                    ancestry.add(component);
                    if (this.directories.contains(ancestry)) continue;
                    this.directories.add((List<String>)ImmutableList.copyOf((Collection)ancestry));
                    this.out.putNextEntry(new JarEntry(JAR_PATH_JOINER.join((Iterable)ancestry) + "/"));
                }
            }
        }

        static class EntryFactory {
            private final boolean compress;

            EntryFactory(boolean compress) {
                this.compress = compress;
            }

            JarEntry createEntry(String path, ByteSource contents) throws IOException {
                JarEntry entry = new JarEntry(path);
                entry.setMethod(this.compress ? 8 : 0);
                if (!this.compress) {
                    this.prepareEntry(entry, contents);
                }
                return entry;
            }

            private void prepareEntry(JarEntry entry, ByteSource contents) throws IOException {
                final CRC32 crc32 = new CRC32();
                long size = (Long)contents.read((ByteProcessor)new ByteProcessor<Long>(){
                    private long size = 0L;

                    public boolean processBytes(byte[] buf, int off, int len) throws IOException {
                        this.size += (long)len;
                        crc32.update(buf, off, len);
                        return true;
                    }

                    public Long getResult() {
                        return this.size;
                    }
                });
                entry.setSize(size);
                entry.setCompressedSize(size);
                entry.setCrc(crc32.getValue());
            }
        }
    }

    private static interface JarEntryVisitor {
        public void visit(JarEntry var1) throws IOException;
    }

    private static interface EntryIndexer {
        public void execute(Multimap<String, ReadableEntry> var1) throws JarBuilderException;
    }

    private static class JarSupplier
    implements InputSupplier<JarFile>,
    Closeable {
        private final Closer closer = Closer.create();
        private final InputSupplier<JarFile> supplier;

        JarSupplier(final File file) {
            this.supplier = new InputSupplier<JarFile>(){

                @Override
                public JarFile getInput() throws IOException {
                    try {
                        return JarFileUtil.openJarFile(JarSupplier.this.closer, file, false);
                    }
                    catch (ZipException zex) {
                        ZipException e = new ZipException("error in opening zip file " + file);
                        e.initCause(zex);
                        throw e;
                    }
                }
            };
        }

        @Override
        public JarFile getInput() throws IOException {
            return this.supplier.getInput();
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
        }
    }

    private static interface InputSupplier<T> {
        public T getInput() throws IOException;
    }

    public static interface Listener {
        public static final Listener NOOP = new Listener(){

            @Override
            public void onSkip(Optional<? extends Entry> original, Iterable<? extends Entry> skipped) {
            }

            @Override
            public void onReplace(Iterable<? extends Entry> originals, Entry replacement) {
            }

            @Override
            public void onConcat(String name, Iterable<? extends Entry> entries) {
            }

            @Override
            public void onWrite(Entry entry) {
            }
        };

        public void onSkip(Optional<? extends Entry> var1, Iterable<? extends Entry> var2);

        public void onReplace(Iterable<? extends Entry> var1, Entry var2);

        public void onConcat(String var1, Iterable<? extends Entry> var2);

        public void onWrite(Entry var1);
    }

    private static class ReadableJarEntry
    extends ReadableEntry {
        private final JarEntry jarEntry;

        public ReadableJarEntry(NamedByteSource contents, JarEntry jarEntry) {
            super(contents, jarEntry.getName());
            this.jarEntry = jarEntry;
        }

        public JarEntry getJarEntry() {
            return this.jarEntry;
        }
    }

    private static class ReadableEntry
    implements Entry {
        static final Function<ReadableEntry, NamedByteSource> GET_CONTENTS = new Function<ReadableEntry, NamedByteSource>(){

            public NamedByteSource apply(ReadableEntry item) {
                return item.contents;
            }
        };
        private final NamedByteSource contents;
        private final String path;

        ReadableEntry(NamedByteSource contents, String path) {
            this.contents = contents;
            this.path = path;
        }

        @Override
        public Source getSource() {
            return this.contents.source;
        }

        @Override
        public String getName() {
            return this.contents.name;
        }

        @Override
        public String getJarPath() {
            return this.path;
        }
    }

    public static interface Entry {
        public Source getSource();

        public String getName();

        public String getJarPath();
    }

    private static final class NamedByteSource
    extends ByteSource {
        private final Source source;
        private final String name;
        private final ByteSource inputSupplier;

        static NamedByteSource create(Source source, String name, ByteSource inputSupplier) {
            return new NamedByteSource(source, name, inputSupplier);
        }

        private NamedByteSource(Source source, String name, ByteSource inputSupplier) {
            this.source = source;
            this.name = name;
            this.inputSupplier = inputSupplier;
        }

        public InputStream openStream() throws IOException {
            return this.inputSupplier.openStream();
        }
    }

    private static abstract class JarSource
    extends FileSource {
        protected JarSource(File source) {
            super(source);
        }
    }

    private static abstract class FileSource
    implements Source {
        protected final File source;

        protected FileSource(File source) {
            this.source = source;
        }

        @Override
        public String name() {
            return this.source.getPath();
        }
    }

    public static interface Source {
        public String name();

        public String identify(String var1);
    }

    public static class DuplicateHandler {
        private final DuplicateAction defaultAction;
        private final Iterable<DuplicatePolicy> policies;

        public static DuplicateHandler always(DuplicateAction action) {
            Preconditions.checkNotNull((Object)((Object)action));
            return new DuplicateHandler(action, (Iterable<DuplicatePolicy>)ImmutableList.of((Object)new DuplicatePolicy((Predicate<CharSequence>)Predicates.alwaysTrue(), action)));
        }

        public static DuplicateHandler skipDuplicatesConcatWellKnownMetadata() {
            DuplicatePolicy concatServices = DuplicatePolicy.pathMatches("^META-INF/services/", DuplicateAction.CONCAT);
            ImmutableList policies = ImmutableList.of((Object)concatServices);
            return new DuplicateHandler(DuplicateAction.SKIP, (Iterable<DuplicatePolicy>)policies);
        }

        public DuplicateHandler(DuplicateAction defaultAction, DuplicatePolicy ... policies) {
            this(defaultAction, (Iterable<DuplicatePolicy>)ImmutableList.copyOf((Object[])policies));
        }

        public DuplicateHandler(DuplicateAction defaultAction, Iterable<DuplicatePolicy> policies) {
            this.defaultAction = (DuplicateAction)((Object)Preconditions.checkNotNull((Object)((Object)defaultAction)));
            this.policies = ImmutableList.copyOf(policies);
        }

        @VisibleForTesting
        DuplicateAction actionFor(String jarPath) {
            for (DuplicatePolicy policy : this.policies) {
                if (!policy.apply(jarPath)) continue;
                return policy.getAction();
            }
            return this.defaultAction;
        }
    }

    public static class DuplicatePolicy
    implements Predicate<CharSequence> {
        private final Predicate<CharSequence> selector;
        private final DuplicateAction action;

        public static DuplicatePolicy pathMatches(String regex, DuplicateAction action) {
            return new DuplicatePolicy((Predicate<CharSequence>)Predicates.containsPattern((String)regex), action);
        }

        public DuplicatePolicy(Predicate<CharSequence> selector, DuplicateAction action) {
            this.selector = (Predicate)Preconditions.checkNotNull(selector);
            this.action = (DuplicateAction)((Object)Preconditions.checkNotNull((Object)((Object)action)));
        }

        public DuplicateAction getAction() {
            return this.action;
        }

        public boolean apply(CharSequence jarPath) {
            return this.selector.apply((Object)jarPath);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("selector", this.selector).toString();
        }
    }

    public static enum DuplicateAction {
        SKIP,
        REPLACE,
        CONCAT,
        THROW;

    }

    public static class DuplicateEntryException
    extends RuntimeException {
        private final ReadableEntry entry;

        DuplicateEntryException(ReadableEntry entry) {
            super("Detected a duplicate entry for " + entry.getJarPath());
            this.entry = entry;
        }

        public String getPath() {
            return this.entry.getJarPath();
        }

        public ByteSource getSource() {
            return this.entry.contents;
        }
    }

    public static class IndexingException
    extends JarBuilderException {
        public IndexingException(File jarPath, Throwable t) {
            super("Problem indexing jar at " + jarPath + ": " + t.getMessage(), t);
        }
    }

    public static class JarCreationException
    extends JarBuilderException {
        public JarCreationException(String message) {
            super(message);
        }
    }

    public static class JarBuilderException
    extends IOException {
        public JarBuilderException(String message) {
            super(message);
        }

        public JarBuilderException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

