/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.jar;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

final class JarEntryCopier {
    private static final FieldReader<FilterInputStream, InputStream> FIS_IN = FieldReader.create(FilterInputStream.class, InputStream.class, "in");
    private static final FieldReader<ZipOutputStream, CRC32> ZOS_CRC = FieldReader.create(ZipOutputStream.class, CRC32.class, "crc");
    private static final FieldAccessor<CRC32, Integer> CRC_VALUE = FieldAccessor.create(CRC32.class, Integer.TYPE, "crc");
    private static final FieldAccessor<ZipEntry, String> ZE_NAME = FieldAccessor.create(ZipEntry.class, String.class, "name");

    static void copyEntry(JarOutputStream jarOut, String name, JarFile jarIn, JarEntry jarEntry) throws IOException {
        JarEntry outEntry = new JarEntry(jarEntry);
        ZE_NAME.set(outEntry, name);
        if (outEntry.isDirectory()) {
            outEntry.setMethod(0);
            outEntry.setSize(0L);
            outEntry.setCompressedSize(0L);
            outEntry.setCrc(0L);
            jarOut.putNextEntry(outEntry);
            jarOut.closeEntry();
        } else if (jarEntry.getMethod() == 0) {
            Closer closer = Closer.create();
            try {
                InputStream is = (InputStream)closer.register((Closeable)jarIn.getInputStream(jarEntry));
                jarOut.putNextEntry(outEntry);
                ByteStreams.copy((InputStream)is, (OutputStream)jarOut);
            }
            catch (IOException e) {
                throw closer.rethrow((Throwable)e);
            }
            finally {
                closer.close();
            }
            jarOut.closeEntry();
        } else {
            Closer closer = Closer.create();
            try {
                FilterInputStream zis = (FilterInputStream)closer.register((Closeable)jarIn.getInputStream(jarEntry));
                InputStream is = FIS_IN.get(zis);
                jarOut.putNextEntry(outEntry);
                outEntry.setMethod(0);
                outEntry.setSize(jarEntry.getCompressedSize());
                ByteStreams.copy((InputStream)is, (OutputStream)jarOut);
            }
            catch (IOException e) {
                throw closer.rethrow((Throwable)e);
            }
            finally {
                closer.close();
            }
            CRC_VALUE.set(ZOS_CRC.get(jarOut), (int)jarEntry.getCrc());
            jarOut.closeEntry();
            outEntry.setMethod(8);
            outEntry.setSize(jarEntry.getSize());
        }
    }

    private JarEntryCopier() {
    }

    private static class FieldAccessor<T, V>
    extends FieldReader<T, V> {
        public static <T, V> FieldAccessor<T, V> create(Class<T> clazz, Class<V> fieldType, String name) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return new FieldAccessor<T, V>(field, fieldType);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        FieldAccessor(Field field, Class<V> fieldType) {
            super(field, fieldType);
            Preconditions.checkArgument((boolean)field.getType().isAssignableFrom(fieldType));
        }

        public void set(T instance, V value) {
            try {
                this.field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FieldReader<T, V> {
        protected final Field field;
        private final Class<V> fieldType;

        public static <T, V> FieldReader<T, V> create(Class<T> clazz, Class<V> fieldType, String name) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return new FieldReader<T, V>(field, fieldType);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        FieldReader(Field field, Class<V> fieldType) {
            Preconditions.checkArgument((boolean)fieldType.isAssignableFrom(field.getType()));
            this.field = field;
            this.fieldType = fieldType;
        }

        public V get(T instance) {
            try {
                return (V)this.field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Class<V> getType() {
            return this.fieldType;
        }
    }
}

