/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.jar;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;
import org.pantsbuild.args4j.ArgfileOptionHandler;
import org.pantsbuild.args4j.CollectionOptionHandler;
import org.pantsbuild.args4j.InvalidCmdLineArgumentException;
import org.pantsbuild.args4j.Parser;
import org.pantsbuild.tools.jar.JarBuilder;

public final class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());
    private final Options options;
    private static final Splitter CLASS_PATH_SPLITTER = Splitter.on((char)File.pathSeparatorChar).omitEmptyStrings();
    private static final Function<String, Iterable<String>> ENTRY_TO_PATHS = new Function<String, Iterable<String>>(){

        public Iterable<String> apply(String entry) {
            return CLASS_PATH_SPLITTER.split((CharSequence)entry);
        }
    };
    private static final Joiner CLASS_PATH_JOINER = Joiner.on((char)' ');

    private Main(Options options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws ExitException {
        if (this.options.mainClass != null && this.options.manifest != null) {
            throw new ExitException(1, "Can specify main or manifest but not both.", new Object[0]);
        }
        if (!this.options.update && this.options.targetJar.exists() && !this.options.targetJar.delete()) {
            throw new ExitException(1, "Failed to delete file at requested target path %s", this.options.targetJar);
        }
        Closer closer = Closer.create();
        try {
            this.doRun(closer, this.options.targetJar);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                LOG.warning("Failed to close one or more resources: " + e);
            }
        }
    }

    private void doRun(Closer closer, File targetJar) throws ExitException {
        JarBuilder jarBuilder = (JarBuilder)closer.register((Closeable)new JarBuilder(targetJar, new LoggingListener(targetJar)));
        try {
            Manifest mf = this.getManifest();
            if (mf != null) {
                jarBuilder.useCustomManifest(mf);
            }
        }
        catch (IOException e) {
            throw new ExitException(1, "Failed to configure custom manifest: %s", e);
        }
        for (Options.FileSource fileSource : this.options.files) {
            fileSource.addTo(jarBuilder);
        }
        for (File jar : this.options.jars) {
            jarBuilder.addJar(jar);
        }
        JarBuilder.DuplicateHandler duplicateHandler = new JarBuilder.DuplicateHandler(this.options.defaultAction, this.options.policies);
        try {
            jarBuilder.write(this.options.compress, duplicateHandler, this.options.skip);
        }
        catch (JarBuilder.DuplicateEntryException e) {
            throw new ExitException(1, "Refusing to write duplicate entry: %s", e);
        }
        catch (IOException e) {
            throw new ExitException(1, "Unexpected problem writing target jar %s: %s", targetJar, e);
        }
    }

    @Nullable
    private Manifest getManifest() throws IOException {
        if (this.options.manifest == null && this.options.mainClass == null && this.options.classPath == null) {
            return null;
        }
        Manifest mf = this.loadManifest();
        if (this.options.mainClass != null) {
            mf.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.options.mainClass);
        }
        if (this.options.classPath != null) {
            String classpath = CLASS_PATH_JOINER.join((Iterable)FluentIterable.from((Iterable)this.options.classPath).transformAndConcat(ENTRY_TO_PATHS));
            mf.getMainAttributes().put(Attributes.Name.CLASS_PATH, classpath);
        }
        return mf;
    }

    private Manifest loadManifest() throws IOException {
        Manifest mf = new Manifest();
        if (this.options.manifest != null) {
            Closer closer = Closer.create();
            try {
                FileInputStream input = (FileInputStream)closer.register((Closeable)new FileInputStream(this.options.manifest));
                mf.read(input);
            }
            catch (IOException e) {
                throw closer.rethrow((Throwable)new IOException("Failed to load manifest from " + this.options.manifest, e));
            }
            finally {
                closer.close();
            }
        }
        return JarBuilder.ensureDefaultManifestEntries(mf);
    }

    public static void main(String[] args) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        handler.setLevel(Level.WARNING);
        Logger.getLogger("").addHandler(handler);
        Options options = new Options();
        Parser.Result result = Parser.parse((Object)options, (String[])args);
        if (result.isFailure()) {
            result.printUsage((OutputStream)System.err);
            Main.exit(1);
        } else if (options.help) {
            result.printUsage((OutputStream)System.out);
            Main.exit(0);
        }
        Main main = new Main(options);
        try {
            main.run();
        }
        catch (ExitException e) {
            System.err.println(e.getMessage());
            Main.exit(e.code);
        }
        Main.exit(0);
    }

    private static void exit(int code) {
        System.exit(code);
    }

    static class ExitException
    extends Exception {
        private final int code;

        ExitException(int code, String message, Object ... args) {
            super(String.format(message, args));
            this.code = code;
        }
    }

    private static class LoggingListener
    implements JarBuilder.Listener {
        private JarBuilder.Source source = null;
        private final File target;

        LoggingListener(File target) {
            this.target = target;
        }

        @Override
        public void onSkip(Optional<? extends JarBuilder.Entry> original, Iterable<? extends JarBuilder.Entry> skipped) {
            if (LOG.isLoggable(Level.FINE)) {
                if (original.isPresent()) {
                    LOG.fine(String.format("Retaining %s and skipping %s", LoggingListener.identify((JarBuilder.Entry)original.get()), LoggingListener.identify(skipped)));
                } else {
                    LOG.fine(String.format("Skipping %s", LoggingListener.identify(skipped)));
                }
            }
        }

        @Override
        public void onReplace(Iterable<? extends JarBuilder.Entry> originals, JarBuilder.Entry replacement) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Using %s to replace %s", LoggingListener.identify(replacement), LoggingListener.identify(originals)));
            }
        }

        @Override
        public void onConcat(String entryName, Iterable<? extends JarBuilder.Entry> entries) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Concatenating %s!%s from %s", this.target.getPath(), entryName, LoggingListener.identify(entries)));
            }
        }

        @Override
        public void onWrite(JarBuilder.Entry entry) {
            if (!entry.getSource().equals(this.source)) {
                this.source = entry.getSource();
                LOG.fine(entry.getSource().name());
            }
            LOG.log(Level.FINER, "\t{0}", entry.getName());
        }

        private static String identify(JarBuilder.Entry entry) {
            return entry.getSource().identify(entry.getName());
        }

        private static String identify(Iterable<? extends JarBuilder.Entry> entries) {
            return Joiner.on((String)",").join((Iterable)FluentIterable.from(entries).transform((Function)new Function<JarBuilder.Entry, String>(){

                public String apply(JarBuilder.Entry input) {
                    return LoggingListener.identify(input);
                }
            }));
        }
    }

    public static class Options {
        @Option(name="-h", aliases={"-help"}, help=true, usage="Display this help screen.")
        private boolean help;
        @Option(name="-main", usage="The name of the fully qualified main class. If a -manifest is specified its contents will be used but this -main will override any entry already present.")
        private String mainClass;
        @Option(name="-classpath", usage="A list of comma-separated classpath entries. If a -manifest is specified its contents will be used but this -classpath will override any entry already present.", handler=ClassPathOptionHandler.class)
        private List<String> classPath = null;
        private File manifest;
        @Option(name="-update", usage="Update the jar if it already exists, otherwise create it.")
        private boolean update;
        @Option(name="-compress", usage="Compress jar entries.")
        private boolean compress;
        @Option(name="-files", usage="A mapping from filesystem paths to jar paths. The mapping is specified in the form [fs path1](=[jar path1]),[fs path2](=[jar path2]). For example: /etc/hosts=hosts,/var/log=logs would create a jar with a hosts file entry and the contents of the /var/log tree added as individual entries under the logs/ directory in the jar. For directories, the mapping can be skipped in which case the directory tree is added as-is to the resulting jar.", handler=FilesOptionHandler.class)
        private List<FileSource> files = Lists.newArrayList();
        @Option(name="-jars", usage="A list of comma-separated jar files whose entries to add to the output jar.", handler=JarsOptionHandler.class)
        private List<File> jars = Lists.newArrayList();
        @Option(name="-skip", usage="A list of regular expressions identifying entries to skip.", handler=PatternOptionHandler.class)
        private List<Pattern> skip = Lists.newArrayList();
        private static final String ACTIONS = "SKIP|REPLACE|CONCAT|THROW";
        @Option(name="-default_action", usage="The default duplicate action to apply if no policies match. Can be any of SKIP|REPLACE|CONCAT|THROW")
        private JarBuilder.DuplicateAction defaultAction = JarBuilder.DuplicateAction.SKIP;
        @Option(name="-policies", usage="A list of duplicate policies to apply. Policies are specified as [regex]=[action], and the action can be any one of SKIP|REPLACE|CONCAT|THROW. For example: ^META-INF/services/=CONCAT would concatenate duplicate service files into one large service file.", handler=DuplicatePolicyParser.class)
        private List<JarBuilder.DuplicatePolicy> policies = Lists.newArrayList();
        @Argument(metaVar="TARGET_JAR", usage="The target jar file path to write.", required=true)
        private File targetJar;

        @Option(name="-manifest", usage="A path to a manifest file to use. If -main or -classpath is specified those values will overwrite the corresponding entry in this manifest.")
        void setManifest(File manifest) {
            if (manifest == null) {
                throw new InvalidCmdLineArgumentException("-manifest", (Object)manifest, "Cannot be null.");
            }
            if (!manifest.exists()) {
                throw new InvalidCmdLineArgumentException("-manifest", (Object)manifest, "Must exist.");
            }
            if (!manifest.isFile()) {
                throw new InvalidCmdLineArgumentException("-manifest", (Object)manifest, "Must be a file.");
            }
            if (!manifest.canRead()) {
                throw new InvalidCmdLineArgumentException("-manifest", (Object)manifest, "Must be readable.");
            }
            this.manifest = manifest;
        }

        public static class PatternOptionHandler
        extends CollectionOptionHandler<Pattern> {
            public PatternOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Pattern> setter) {
                super(parser, option, setter, "PATTERN", (CollectionOptionHandler.ItemParser)new CollectionOptionHandler.ItemParser<Pattern>(){

                    public Pattern parse(String item) {
                        try {
                            return Pattern.compile(item);
                        }
                        catch (PatternSyntaxException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                });
            }
        }

        public static class JarsOptionHandler
        extends ArgfileOptionHandler<File> {
            public JarsOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super File> setter) {
                super((OptionHandler)new CollectionOptionHandler(parser, option, setter, "JAR", (CollectionOptionHandler.ItemParser)new CollectionOptionHandler.ItemParser<File>(){

                    public File parse(String item) {
                        return new File(item);
                    }
                }));
            }
        }

        public static class FilesOptionHandler
        extends ArgfileOptionHandler<FileSource> {
            public FilesOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super FileSource> setter) {
                super((OptionHandler)new FileSourceOptionHandler(parser, option, setter));
            }
        }

        public static class ClassPathOptionHandler
        extends ArgfileOptionHandler<String> {
            public ClassPathOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
                super((OptionHandler)new CollectionOptionHandler(parser, option, setter, "CLASS_PATH_ENTRY", CollectionOptionHandler.ItemParser.IDENTITY));
            }
        }

        public static class FileSourceOptionHandler
        extends CollectionOptionHandler<FileSource> {
            private static final Splitter DESTINATION_SPLITTER = Splitter.on((char)'=').trimResults().omitEmptyStrings();

            public FileSourceOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super FileSource> setter) {
                super(parser, option, setter, "FILE_SOURCE", (CollectionOptionHandler.ItemParser)new CollectionOptionHandler.ItemParser<FileSource>(){

                    public FileSource parse(String item) {
                        ImmutableList components = ImmutableList.copyOf((Iterable)DESTINATION_SPLITTER.split((CharSequence)item));
                        Preconditions.checkArgument((1 <= components.size() && components.size() <= 2 ? 1 : 0) != 0, (String)"Failed to parse entry %s", (Object[])new Object[]{item});
                        File source = new File((String)components.get(0));
                        String destination = components.size() == 2 ? (String)components.get(1) : null;
                        return new FileSource(source, destination);
                    }
                });
            }
        }

        static class FileSource {
            private static final Splitter JAR_PATH_SPLITTER = Splitter.on((char)'/');
            private final File source;
            @Nullable
            private final String destination;

            FileSource(File source, @Nullable String destination) {
                if (!source.exists() || !source.canRead()) {
                    throw new IllegalArgumentException(String.format("The source %s is not a readable path", source));
                }
                if (!source.isDirectory() && destination == null) {
                    throw new IllegalArgumentException(String.format("The source file %s must have a jar destination specified.", source));
                }
                if (destination != null) {
                    Preconditions.checkArgument((!Strings.isNullOrEmpty((String)destination.trim()) ? 1 : 0) != 0, (Object)"The destination path cannot be blank");
                    Preconditions.checkArgument((!destination.startsWith("/") ? 1 : 0) != 0, (String)"The destination path cannot be absolute, given: %s", (Object[])new Object[]{destination});
                    Preconditions.checkArgument((!ImmutableSet.copyOf((Iterable)JAR_PATH_SPLITTER.split((CharSequence)destination)).contains((Object)"..") ? 1 : 0) != 0, (String)"The destination path cannot be relative, given: %s", (Object[])new Object[]{destination});
                }
                this.source = source;
                this.destination = destination;
            }

            void addTo(JarBuilder jarBuilder) {
                if (this.source.isDirectory()) {
                    jarBuilder.addDirectory(this.source, (Optional<String>)Optional.fromNullable((Object)this.destination));
                } else {
                    jarBuilder.addFile(this.source, this.destination);
                }
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("destination", (Object)this.destination).toString();
            }
        }

        public static class DuplicatePolicyParser
        extends CollectionOptionHandler<JarBuilder.DuplicatePolicy> {
            private static final Splitter REGEX_ACTION_SPLITTER = Splitter.on((char)'=').trimResults().omitEmptyStrings();

            public DuplicatePolicyParser(CmdLineParser parser, OptionDef option, Setter<? super JarBuilder.DuplicatePolicy> setter) {
                super(parser, option, setter, "DUPLICATE_POLICY", (CollectionOptionHandler.ItemParser)new CollectionOptionHandler.ItemParser<JarBuilder.DuplicatePolicy>(){

                    public JarBuilder.DuplicatePolicy parse(String item) {
                        ImmutableList components = ImmutableList.copyOf((Iterable)REGEX_ACTION_SPLITTER.split((CharSequence)item));
                        Preconditions.checkArgument((components.size() == 2 ? 1 : 0) != 0, (String)"Failed to parse jar path regex/action pair %s", (Object[])new Object[]{item});
                        String regex = (String)components.get(0);
                        JarBuilder.DuplicateAction action = JarBuilder.DuplicateAction.valueOf((String)components.get(1));
                        return JarBuilder.DuplicatePolicy.pathMatches(regex, action);
                    }
                });
            }
        }
    }
}

