/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import java.util.Arrays;

public class Base64 {
    private static final char[] indexToDigit = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] digitToIndex = new int[128];

    static {
        assert (indexToDigit.length == 64);
        Arrays.fill(digitToIndex, -1);
        int i = 0;
        while (i < indexToDigit.length) {
            Base64.digitToIndex[Base64.indexToDigit[i]] = i;
            ++i;
        }
    }

    private Base64() {
    }

    public static char[] encode(byte[] in) {
        char[] ret = new char[(in.length + 2) / 3 * 4];
        int p = 0;
        int i = 0;
        while (i < in.length) {
            int bits = (in[i++] & 0xFF) << 16 | (i < in.length ? in[i++] & 0xFF : 0) << 8 | (i < in.length ? in[i++] & 0xFF : 0);
            ret[p++] = indexToDigit[(bits & 0xFC0000) >> 18];
            ret[p++] = indexToDigit[(bits & 0x3F000) >> 12];
            ret[p++] = indexToDigit[(bits & 0xFC0) >> 6];
            ret[p++] = indexToDigit[bits & 0x3F];
        }
        assert (p == ret.length);
        int padding = (3 - in.length % 3) % 3;
        int j = ret.length - padding;
        while (j < ret.length) {
            ret[j] = 61;
            ++j;
        }
        return ret;
    }

    public static byte[] decode(char[] in) {
        if (in.length % 4 != 0) {
            throw new IllegalArgumentException("Base64-encoded string must be of length that is a multiple of 4.");
        }
        int len = in.length;
        while (len > 0 && in[len - 1] == '=') {
            --len;
        }
        int padding = in.length - len;
        byte[] ret = new byte[in.length / 4 * 3 - padding];
        int i = 0;
        int p = 0;
        while (i < len) {
            char c3;
            char c0 = in[i++];
            char c1 = in[i++];
            char c2 = i < len ? in[i++] : (char)'A';
            char c = c3 = i < len ? in[i++] : (char)'A';
            if (c0 > '\u007f' || c1 > '\u007f' || c2 > '\u007f' || c3 > '\u007f') {
                throw new IllegalArgumentException("Invalid Base64 digit in: " + c0 + c1 + c2 + c3);
            }
            int n0 = digitToIndex[c0];
            int n1 = digitToIndex[c1];
            int n2 = digitToIndex[c2];
            int n3 = digitToIndex[c3];
            if (n0 < 0 || n1 < 0 || n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException("Invalid Base64 digit in: " + c0 + c1 + c2 + c3);
            }
            int bits = n0 << 18 | n1 << 12 | n2 << 6 | n3;
            ret[p++] = (byte)((bits & 0xFF0000) >> 16);
            if (p < ret.length) {
                ret[p++] = (byte)((bits & 0xFF00) >> 8);
            }
            if (p >= ret.length) continue;
            ret[p++] = (byte)(bits & 0xFF);
        }
        return ret;
    }
}

