/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.Base64;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class Base64Test {
    @Test
    public void testEmpty() {
        Assert.assertEquals((long)Base64.encode(new byte[0]).length, (long)0L);
        Assert.assertEquals((long)Base64.decode(new char[0]).length, (long)0L);
    }

    @Test
    public void testRoundTrip() {
        this.doTestRoundTrip(100, 4, 123);
        this.doTestRoundTrip(20000, 1000, 456);
        this.doTestRoundTrip(1000, 10000, 789);
    }

    private void doTestRoundTrip(int numTests, int maxInputSize, int seed) {
        Random rng = new Random(seed);
        int i = 0;
        while (i < numTests) {
            byte[] bytes = new byte[rng.nextInt(maxInputSize)];
            rng.nextBytes(bytes);
            char[] chars = Base64.encode(bytes);
            byte[] roundtrippedBytes = Base64.decode(chars);
            Assert.assertArrayEquals((byte[])roundtrippedBytes, (byte[])bytes);
            ++i;
        }
    }
}

