/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.PrivateException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class BinaryFileReader {
    protected byte[] buf;
    protected int curBufPos;
    protected String fileFullPath;

    protected void initBuf(byte[] buf, String fileFullPath) {
        this.buf = buf;
        this.curBufPos = 0;
        this.fileFullPath = fileFullPath;
    }

    protected char nextChar() {
        return (char)(((this.buf[this.curBufPos++] & 0xFF) << 8) + (this.buf[this.curBufPos++] & 0xFF));
    }

    protected char getChar(int bufPos) {
        return (char)(((this.buf[bufPos] & 0xFF) << 8) + (this.buf[bufPos + 1] & 0xFF));
    }

    protected int nextInt() {
        return ((this.buf[this.curBufPos++] & 0xFF) << 24) + ((this.buf[this.curBufPos++] & 0xFF) << 16) + ((this.buf[this.curBufPos++] & 0xFF) << 8) + (this.buf[this.curBufPos++] & 0xFF);
    }

    protected int getInt(int bufPos) {
        return ((this.buf[bufPos] & 0xFF) << 24) + ((this.buf[bufPos + 1] & 0xFF) << 16) + ((this.buf[bufPos + 2] & 0xFF) << 8) + (this.buf[bufPos + 3] & 0xFF);
    }

    protected long nextLong() {
        long res = this.getLong(this.curBufPos);
        this.curBufPos += 8;
        return res;
    }

    protected long getLong(int bufPos) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bufPos, 8));
        try {
            return bufin.readLong();
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    protected float nextFloat() {
        float res = this.getFloat(this.curBufPos);
        this.curBufPos += 4;
        return res;
    }

    protected float getFloat(int bufPos) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bufPos, 4));
        try {
            return bufin.readFloat();
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    protected double nextDouble() {
        double res = this.getDouble(this.curBufPos);
        this.curBufPos += 8;
        return res;
    }

    protected double getDouble(int bufPos) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bufPos, 8));
        try {
            return bufin.readDouble();
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }
}

