/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

public class BinaryFileWriter {
    protected byte[] buf;
    protected int curBufSize;
    protected int bufInc;
    protected int curBufPos;
    protected int threshold;
    private boolean bufferIncreaseAllowed = true;

    protected void initBuf(int initSize) {
        this.buf = new byte[initSize];
        this.curBufSize = initSize;
        this.bufInc = initSize / 5;
        this.curBufPos = 0;
        this.threshold = this.curBufSize - this.bufInc;
    }

    protected void increaseBuf() {
        if (!this.bufferIncreaseAllowed) {
            return;
        }
        byte[] newBuf = new byte[this.curBufSize + this.bufInc];
        System.arraycopy(this.buf, 0, newBuf, 0, this.curBufPos);
        this.buf = newBuf;
        this.curBufSize = this.buf.length;
        this.threshold = this.curBufSize - this.bufInc;
    }

    protected void setBufferIncreaseMode(boolean increaseMode) {
        this.bufferIncreaseAllowed = increaseMode;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    protected void writeByte(byte b) {
        if (this.curBufPos > this.threshold) {
            this.increaseBuf();
        }
        this.buf[this.curBufPos++] = b;
    }

    protected void writeChar(int ch) {
        this.buf[this.curBufPos++] = (byte)(ch >> 8 & 0xFF);
        this.buf[this.curBufPos++] = (byte)(ch & 0xFF);
        if (this.curBufPos > this.threshold) {
            this.increaseBuf();
        }
    }

    protected void writeInt(int i) {
        this.buf[this.curBufPos++] = (byte)(i >> 24 & 0xFF);
        this.buf[this.curBufPos++] = (byte)(i >> 16 & 0xFF);
        this.buf[this.curBufPos++] = (byte)(i >> 8 & 0xFF);
        this.buf[this.curBufPos++] = (byte)(i & 0xFF);
        if (this.curBufPos > this.threshold) {
            this.increaseBuf();
        }
    }

    protected void writeLong(long l) {
        this.buf[this.curBufPos++] = (byte)(l >> 56 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 48 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 40 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 32 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 24 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 16 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l >> 8 & 0xFFL);
        this.buf[this.curBufPos++] = (byte)(l & 0xFFL);
        if (this.curBufPos > this.threshold) {
            this.increaseBuf();
        }
    }

    protected void writeFloat(float f) {
        int i = Float.floatToIntBits(f);
        this.writeInt(i);
    }

    protected void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.writeLong(l);
    }
}

