/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.BinaryFileReader;
import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.PrivateException;
import com.sun.tools.jmake.PublicExceptions;
import com.sun.tools.jmake.Utils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class BinaryProjectDatabaseReader
extends BinaryFileReader {
    private String[] stringTable;
    private Map<String, PCDEntry> pcd;
    private int nOfEntries;
    private int pdbFormat;

    public Map<String, PCDEntry> readProjectDatabaseFromFile(File infile) {
        byte[] buf = Utils.readFileIntoBuffer(infile);
        return this.readProjectDatabase(buf, infile.toString());
    }

    public Map<String, PCDEntry> readProjectDatabase(byte[] pdbFile, String pdbFileFullPath) {
        this.initBuf(pdbFile, pdbFileFullPath);
        this.readPreamble();
        this.readStringTable();
        this.pcd = new LinkedHashMap<String, PCDEntry>(this.nOfEntries * 4 / 3);
        int i = 0;
        while (i < this.nOfEntries) {
            PCDEntry entry = this.readPCDEntry();
            this.pcd.put(entry.className, entry);
            ++i;
        }
        this.stringTable = null;
        return this.pcd;
    }

    private void readPreamble() {
        int pdbSize;
        if (this.buf.length < Utils.magicLength + 8) {
            this.pdbCorruptedException("file too short");
        }
        int i = 0;
        while (i < Utils.magicLength) {
            if (this.buf[i] != Utils.MAGIC[i]) {
                this.pdbCorruptedException("wrong project database header");
            }
            ++i;
        }
        this.curBufPos += Utils.magicLength;
        this.pdbFormat = this.nextInt();
        if (this.pdbFormat != 1 && this.pdbFormat != 0x1030300) {
            this.pdbCorruptedException("wrong version number");
        }
        if (this.buf.length != Utils.MAGIC.length + 8 + (pdbSize = this.nextInt())) {
            this.pdbCorruptedException("file size does not match stored value");
        }
        this.nOfEntries = this.nextInt();
    }

    private void readStringTable() {
        int size = this.nextInt();
        this.stringTable = new String[size];
        int i = 0;
        while (i < size) {
            this.stringTable[i] = this.nextString();
            ++i;
        }
    }

    private PCDEntry readPCDEntry() {
        String className = this.nextStringRef();
        String javaFileFullPath = this.nextStringRef();
        long classFileLastModified = this.nextLong();
        long classFileFingerprint = this.nextLong();
        ClassInfo classInfo = this.readClassInfo();
        return new PCDEntry(className, javaFileFullPath, classFileLastModified, classFileFingerprint, classInfo);
    }

    private ClassInfo readClassInfo() {
        int i;
        ClassInfo res = new ClassInfo();
        res.name = this.nextStringRef();
        res.javacTargetRelease = this.pdbFormat >= 0x1030300 ? this.nextInt() : 0x1040000;
        int len = this.nextChar();
        if (len > 0) {
            String[] cpoolRefsToClasses = new String[len];
            i = 0;
            while (i < len) {
                cpoolRefsToClasses[i] = this.nextStringRef();
                ++i;
            }
            res.cpoolRefsToClasses = cpoolRefsToClasses;
            boolean[] isRefClassArray = new boolean[len];
            i = 0;
            while (i < len) {
                isRefClassArray[i] = this.buf[this.curBufPos++] != 0;
                ++i;
            }
            res.isRefClassArray = isRefClassArray;
        }
        if ((len = this.nextChar()) > 0) {
            String[] cpoolRefsToFieldClasses = new String[len];
            i = 0;
            while (i < len) {
                cpoolRefsToFieldClasses[i] = this.nextStringRef();
                ++i;
            }
            res.cpoolRefsToFieldClasses = cpoolRefsToFieldClasses;
            String[] cpoolRefsToFieldNames = new String[len];
            i = 0;
            while (i < len) {
                cpoolRefsToFieldNames[i] = this.nextStringRef();
                ++i;
            }
            res.cpoolRefsToFieldNames = cpoolRefsToFieldNames;
            String[] cpoolRefsToFieldSignatures = new String[len];
            i = 0;
            while (i < len) {
                cpoolRefsToFieldSignatures[i] = this.nextStringRef();
                ++i;
            }
            res.cpoolRefsToFieldSignatures = cpoolRefsToFieldSignatures;
        }
        if ((len = this.nextChar()) > 0) {
            String[] cpoolRefsToMethodClasses = new String[len];
            i = 0;
            while (i < len) {
                cpoolRefsToMethodClasses[i] = this.nextStringRef();
                ++i;
            }
            res.cpoolRefsToMethodClasses = cpoolRefsToMethodClasses;
            String[] cpoolRefsToMethodNames = new String[len];
            i = 0;
            while (i < len) {
                cpoolRefsToMethodNames[i] = this.nextStringRef();
                ++i;
            }
            res.cpoolRefsToMethodNames = cpoolRefsToMethodNames;
            String[] cpoolRefsToMethodSignatures = new String[len];
            i = 0;
            while (i < len) {
                cpoolRefsToMethodSignatures[i] = this.nextStringRef();
                ++i;
            }
            res.cpoolRefsToMethodSignatures = cpoolRefsToMethodSignatures;
        }
        res.accessFlags = this.nextChar();
        boolean bl = res.isNonMemberNestedClass = this.buf[this.curBufPos++] != 0;
        if (!"java/lang/Object".equals(res.name)) {
            res.superName = this.nextStringRef();
        }
        if ((len = (int)this.nextChar()) > 0) {
            String[] interfaces = new String[len];
            i = 0;
            while (i < len) {
                interfaces[i] = this.nextStringRef();
                ++i;
            }
            res.interfaces = interfaces;
        }
        if ((len = (int)this.nextChar()) > 0) {
            String[] fieldNames = new String[len];
            i = 0;
            while (i < len) {
                fieldNames[i] = this.nextStringRef();
                ++i;
            }
            res.fieldNames = fieldNames;
            String[] fieldSignatures = new String[len];
            i = 0;
            while (i < len) {
                fieldSignatures[i] = this.nextStringRef();
                ++i;
            }
            res.fieldSignatures = fieldSignatures;
            char[] fieldAccessFlags = new char[len];
            i = 0;
            while (i < len) {
                fieldAccessFlags[i] = this.nextChar();
                ++i;
            }
            res.fieldAccessFlags = fieldAccessFlags;
        }
        if ((len = (int)this.nextChar()) > 0) {
            Object[] primitiveConstantInitValues = new Object[len];
            i = 0;
            while (i < len) {
                byte code = this.buf[this.curBufPos++];
                switch (code) {
                    case 1: {
                        primitiveConstantInitValues[i] = this.nextStringRef();
                        break;
                    }
                    case 2: {
                        primitiveConstantInitValues[i] = this.nextInt();
                        break;
                    }
                    case 3: {
                        primitiveConstantInitValues[i] = this.nextLong();
                        break;
                    }
                    case 4: {
                        primitiveConstantInitValues[i] = Float.valueOf(this.nextFloat());
                        break;
                    }
                    case 5: {
                        primitiveConstantInitValues[i] = this.nextDouble();
                    }
                }
                ++i;
            }
            res.primitiveConstantInitValues = primitiveConstantInitValues;
        }
        if ((len = (int)this.nextChar()) > 0) {
            String[] methodNames = new String[len];
            i = 0;
            while (i < len) {
                methodNames[i] = this.nextStringRef();
                ++i;
            }
            res.methodNames = methodNames;
            String[] methodSignatures = new String[len];
            i = 0;
            while (i < len) {
                methodSignatures[i] = this.nextStringRef();
                ++i;
            }
            res.methodSignatures = methodSignatures;
            char[] methodAccessFlags = new char[len];
            i = 0;
            while (i < len) {
                methodAccessFlags[i] = this.nextChar();
                ++i;
            }
            res.methodAccessFlags = methodAccessFlags;
        }
        if ((len = (int)this.nextChar()) > 0) {
            String[][] checkedExceptions = new String[len][];
            i = 0;
            while (i < len) {
                int len1 = this.nextChar();
                if (len1 > 0) {
                    checkedExceptions[i] = new String[len1];
                    int j = 0;
                    while (j < len1) {
                        checkedExceptions[i][j] = this.nextStringRef();
                        ++j;
                    }
                }
                ++i;
            }
            res.checkedExceptions = checkedExceptions;
        }
        if ((len = (int)this.nextChar()) > 0) {
            String[] nestedClasses = new String[len];
            i = 0;
            while (i < len) {
                nestedClasses[i] = this.nextStringRef();
                ++i;
            }
            res.nestedClasses = nestedClasses;
        }
        res.initializeImmediateTransientFields();
        return res;
    }

    private String nextString() {
        char length = this.nextChar();
        if (this.buf.length < this.curBufPos + length) {
            this.pdbCorruptedException("data error");
        }
        String res = new String(this.buf, this.curBufPos, (int)length).intern();
        this.curBufPos += length;
        return res;
    }

    private String nextStringRef() {
        return this.stringTable[this.nextInt()];
    }

    private void pdbCorruptedException(String message) {
        throw new PrivateException(new PublicExceptions.PDBCorruptedException(message));
    }
}

