/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.BinaryFileWriter;
import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.PrivateException;
import com.sun.tools.jmake.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

public class BinaryProjectDatabaseWriter
extends BinaryFileWriter {
    private Map<String, PCDEntry> pcd = null;
    private int nOfEntries;
    private byte[] stringBuf;
    private int curStringBufPos;
    private int stringBufInc;
    private int curStringBufWatermark;
    private int stringCount;
    private StringHashTable stringHashTable = null;

    public void writeProjectDatabaseToFile(File outfile, Map<String, PCDEntry> pcd) {
        try {
            byte[] buf = new BinaryProjectDatabaseWriter().writeProjectDatabase(pcd);
            FileOutputStream out = new FileOutputStream(outfile);
            out.write(buf);
            out.close();
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    public byte[] writeProjectDatabase(Map<String, PCDEntry> pcd) {
        this.pcd = pcd;
        this.nOfEntries = pcd.size();
        this.initBuf(this.nOfEntries * 1000);
        this.stringBuf = new byte[this.nOfEntries * 300];
        this.stringBufInc = this.stringBuf.length / 5;
        this.curStringBufWatermark = this.stringBuf.length - 20;
        this.stringHashTable = new StringHashTable(this.stringBuf.length / 8);
        for (PCDEntry entry : pcd.values()) {
            this.writePCDEntry(entry);
        }
        byte[] mainBuf = this.buf;
        int mainBufSize = this.curBufPos;
        int preambleSize = Utils.MAGIC.length + 8;
        int stringBufSize = this.curStringBufPos;
        int pdbSize = stringBufSize + mainBufSize + 8;
        this.initBuf(preambleSize + pdbSize);
        this.setBufferIncreaseMode(false);
        this.writePreamble(pdbSize);
        this.writeStringTable(stringBufSize);
        System.arraycopy(mainBuf, 0, this.buf, this.curBufPos, mainBufSize);
        return this.buf;
    }

    private void writePreamble(int pdbSize) {
        System.arraycopy(Utils.MAGIC, 0, this.buf, 0, Utils.MAGIC.length);
        this.curBufPos += Utils.MAGIC.length;
        this.writeInt(0x1030300);
        this.writeInt(pdbSize);
        this.writeInt(this.pcd.size());
    }

    private void writeStringTable(int stringBufSize) {
        this.writeInt(this.stringCount);
        System.arraycopy(this.stringBuf, 0, this.buf, this.curBufPos, stringBufSize);
        this.curBufPos += stringBufSize;
    }

    private void writePCDEntry(PCDEntry entry) {
        this.writeStringRef(entry.className);
        this.writeStringRef(entry.javaFileFullPath);
        this.writeLong(entry.oldClassFileLastModified);
        this.writeLong(entry.oldClassFileFingerprint);
        this.writeClassInfo(entry.oldClassInfo);
    }

    private void writeClassInfo(ClassInfo ci) {
        int i;
        this.writeStringRef(ci.name);
        this.writeInt(ci.javacTargetRelease);
        int len = ci.cpoolRefsToClasses != null ? ci.cpoolRefsToClasses.length : 0;
        this.writeChar(len);
        if (len > 0) {
            String[] cpoolRefsToClasses = ci.cpoolRefsToClasses;
            i = 0;
            while (i < len) {
                this.writeStringRef(cpoolRefsToClasses[i]);
                ++i;
            }
            boolean[] isRefClassArray = ci.isRefClassArray;
            i = 0;
            while (i < len) {
                byte b = isRefClassArray[i] ? (byte)1 : 0;
                this.writeByte(b);
                ++i;
            }
        }
        len = ci.cpoolRefsToFieldClasses != null ? ci.cpoolRefsToFieldClasses.length : 0;
        this.writeChar(len);
        if (len > 0) {
            String[] cpoolRefsToFieldClasses = ci.cpoolRefsToFieldClasses;
            i = 0;
            while (i < len) {
                this.writeStringRef(cpoolRefsToFieldClasses[i]);
                ++i;
            }
            String[] cpoolRefsToFieldNames = ci.cpoolRefsToFieldNames;
            i = 0;
            while (i < len) {
                this.writeStringRef(cpoolRefsToFieldNames[i]);
                ++i;
            }
            String[] cpoolRefsToFieldSignatures = ci.cpoolRefsToFieldSignatures;
            i = 0;
            while (i < len) {
                this.writeStringRef(cpoolRefsToFieldSignatures[i]);
                ++i;
            }
        }
        len = ci.cpoolRefsToMethodClasses != null ? ci.cpoolRefsToMethodClasses.length : 0;
        this.writeChar(len);
        if (len > 0) {
            String[] cpoolRefsToMethodClasses = ci.cpoolRefsToMethodClasses;
            i = 0;
            while (i < len) {
                this.writeStringRef(cpoolRefsToMethodClasses[i]);
                ++i;
            }
            String[] cpoolRefsToMethodNames = ci.cpoolRefsToMethodNames;
            i = 0;
            while (i < len) {
                this.writeStringRef(cpoolRefsToMethodNames[i]);
                ++i;
            }
            String[] cpoolRefsToMethodSignatures = ci.cpoolRefsToMethodSignatures;
            i = 0;
            while (i < len) {
                this.writeStringRef(cpoolRefsToMethodSignatures[i]);
                ++i;
            }
        }
        this.writeChar(ci.accessFlags);
        byte b = ci.isNonMemberNestedClass ? (byte)1 : 0;
        this.writeByte(b);
        if (!"java/lang/Object".equals(ci.name)) {
            this.writeStringRef(ci.superName);
        }
        len = ci.interfaces != null ? ci.interfaces.length : 0;
        this.writeChar(len);
        if (len > 0) {
            String[] interfaces = ci.interfaces;
            i = 0;
            while (i < len) {
                this.writeStringRef(interfaces[i]);
                ++i;
            }
        }
        len = ci.fieldNames != null ? ci.fieldNames.length : 0;
        this.writeChar(len);
        if (len > 0) {
            String[] fieldNames = ci.fieldNames;
            i = 0;
            while (i < len) {
                this.writeStringRef(fieldNames[i]);
                ++i;
            }
            String[] fieldSignatures = ci.fieldSignatures;
            i = 0;
            while (i < len) {
                this.writeStringRef(fieldSignatures[i]);
                ++i;
            }
            char[] fieldAccessFlags = ci.fieldAccessFlags;
            i = 0;
            while (i < len) {
                this.writeChar(fieldAccessFlags[i]);
                ++i;
            }
        }
        len = ci.primitiveConstantInitValues != null ? ci.primitiveConstantInitValues.length : 0;
        this.writeChar(len);
        if (len > 0) {
            Object[] primitiveConstantInitValues = ci.primitiveConstantInitValues;
            i = 0;
            while (i < len) {
                Object pc = primitiveConstantInitValues[i];
                if (pc != null) {
                    if (pc instanceof String) {
                        this.writeByte((byte)1);
                        this.writeStringRef((String)pc);
                    } else if (pc instanceof Integer) {
                        this.writeByte((byte)2);
                        this.writeInt((Integer)pc);
                    } else if (pc instanceof Long) {
                        this.writeByte((byte)3);
                        this.writeLong((Long)pc);
                    } else if (pc instanceof Float) {
                        this.writeByte((byte)4);
                        this.writeFloat(((Float)pc).floatValue());
                    } else if (pc instanceof Double) {
                        this.writeByte((byte)5);
                        this.writeDouble((Double)pc);
                    }
                } else {
                    this.writeByte((byte)0);
                }
                ++i;
            }
        }
        len = ci.methodNames != null ? ci.methodNames.length : 0;
        this.writeChar(len);
        if (len > 0) {
            String[] methodNames = ci.methodNames;
            i = 0;
            while (i < len) {
                this.writeStringRef(methodNames[i]);
                ++i;
            }
            String[] methodSignatures = ci.methodSignatures;
            i = 0;
            while (i < len) {
                this.writeStringRef(methodSignatures[i]);
                ++i;
            }
            char[] methodAccessFlags = ci.methodAccessFlags;
            i = 0;
            while (i < len) {
                this.writeChar(methodAccessFlags[i]);
                ++i;
            }
        }
        len = ci.checkedExceptions != null ? ci.checkedExceptions.length : 0;
        this.writeChar(len);
        if (len > 0) {
            String[][] checkedExceptions = ci.checkedExceptions;
            i = 0;
            while (i < len) {
                int lenl = checkedExceptions[i] != null ? checkedExceptions[i].length : 0;
                this.writeChar(lenl);
                if (lenl > 0) {
                    int j = 0;
                    while (j < lenl) {
                        this.writeStringRef(checkedExceptions[i][j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        len = ci.nestedClasses != null ? ci.nestedClasses.length : 0;
        this.writeChar(len);
        if (len > 0) {
            String[] nestedClasses = ci.nestedClasses;
            i = 0;
            while (i < len) {
                this.writeStringRef(nestedClasses[i]);
                ++i;
            }
        }
    }

    private void writeString(String s) {
        byte[] sb = s.getBytes();
        int len = sb.length;
        if (this.curStringBufPos + len > this.curStringBufWatermark) {
            this.stringBufInc = len >= this.stringBufInc ? (this.stringBufInc + len) * 2 : this.stringBufInc * 5 / 4;
            byte[] newStringBuf = new byte[this.stringBuf.length + this.stringBufInc];
            System.arraycopy(this.stringBuf, 0, newStringBuf, 0, this.curStringBufPos);
            this.stringBuf = newStringBuf;
            this.curStringBufWatermark = this.stringBuf.length - 20;
        }
        this.stringBuf[this.curStringBufPos++] = (byte)(len >> 8 & 0xFF);
        this.stringBuf[this.curStringBufPos++] = (byte)(len & 0xFF);
        System.arraycopy(sb, 0, this.stringBuf, this.curStringBufPos, len);
        this.curStringBufPos += len;
    }

    private void writeStringRef(String s) {
        int stringRef = this.stringHashTable.get(s);
        if (stringRef == -1) {
            this.stringHashTable.add(s, this.stringCount);
            stringRef = this.stringCount++;
            this.writeString(s);
        }
        this.writeInt(stringRef);
    }

    static class StringHashTable {
        String[] keys;
        int[] values;
        int size;
        int nOfElements;
        int watermark;

        StringHashTable(int size) {
            this.size = size = this.makeLikePrimeNumber(size);
            this.keys = new String[size];
            this.values = new int[size];
            this.nOfElements = 0;
            this.watermark = size * 3 / 4;
        }

        final int get(String key) {
            int pos = (key.hashCode() & Integer.MAX_VALUE) % this.size;
            while (this.keys[pos] != null && !this.keys[pos].equals(key)) {
                pos = (pos + 3) % this.size;
            }
            if (key.equals(this.keys[pos])) {
                return this.values[pos];
            }
            return -1;
        }

        final void add(String key, int value) {
            if (this.nOfElements > this.watermark) {
                this.rehash();
            }
            int pos = (key.hashCode() & Integer.MAX_VALUE) % this.size;
            while (this.keys[pos] != null) {
                pos = (pos + 3) % this.size;
            }
            this.keys[pos] = key;
            this.values[pos] = value;
            ++this.nOfElements;
        }

        private final void rehash() {
            String[] oldKeys = this.keys;
            int[] oldValues = this.values;
            int oldSize = this.size;
            this.size = this.makeLikePrimeNumber(this.size * 3 / 2);
            this.keys = new String[this.size];
            this.values = new int[this.size];
            this.nOfElements = 0;
            this.watermark = this.size * 3 / 4;
            int i = 0;
            while (i < oldSize) {
                if (oldKeys[i] != null) {
                    this.add(oldKeys[i], oldValues[i]);
                }
                ++i;
            }
        }

        private final int makeLikePrimeNumber(int no) {
            no = no / 2 * 2 + 1;
            boolean prime = false;
            while (!(prime = (no += 2) % 3 != 0 && no % 5 != 0 && no % 7 != 0 && no % 11 != 0 && no % 13 != 0 && no % 17 != 0 && no % 19 != 0 && no % 23 != 0 && no % 29 != 0 && no % 31 != 0 && no % 37 != 0 && no % 41 != 0)) {
            }
            return no;
        }
    }
}

