/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.BinaryFileReader;
import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.PrivateException;
import com.sun.tools.jmake.PublicExceptions;
import java.lang.reflect.Modifier;

public class ClassFileReader
extends BinaryFileReader {
    public static final int JAVA_MAGIC = -889275714;
    public static final int JAVA_MINOR_VERSION = 0;
    public static final int JAVA_MIN_MAJOR_VERSION = 45;
    public static final int JAVA_MIN_MINOR_VERSION = 3;
    public static final int DEFAULT_MAJOR_VERSION = 46;
    public static final int DEFAULT_MINOR_VERSION = 0;
    public static final int JDK14_MAJOR_VERSION = 48;
    public static final int JDK15_MAJOR_VERSION = 49;
    public static final int JDK16_MAJOR_VERSION = 50;
    public static final int JDK17_MAJOR_VERSION = 51;
    public static final int JDK18_MAJOR_VERSION = 52;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Unicode = 2;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameandType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_InvokeDynamic = 18;
    private ClassInfo classInfo = null;
    private int[] cpOffsets;
    private Object[] cpObjectCache;
    private byte[] cpTags;

    public void readClassFile(byte[] classFile, ClassInfo classInfo, String classFileFullPath, boolean readFullInfo) {
        this.initBuf(classFile, classFileFullPath);
        this.classInfo = classInfo;
        this.readPreamble();
        this.readConstantPool(readFullInfo);
        this.readIntermediate();
        if (readFullInfo) {
            this.readFields();
            this.readMethods();
            this.readAttributes();
        }
    }

    private int versionWord(int major, int minor) {
        return major * 1000 + minor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readPreamble() {
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw this.classFileParseException("Illegal start of class file");
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion > '0' || this.versionWord(majorVersion, minorVersion) < this.versionWord(45, 3)) {
            if (majorVersion == '4') {
                this.classInfo.javacTargetRelease = 0x1080000;
                return;
            } else if (majorVersion == '3') {
                this.classInfo.javacTargetRelease = 0x1070000;
                return;
            } else if (majorVersion == '2') {
                this.classInfo.javacTargetRelease = 0x1060000;
                return;
            } else {
                if (majorVersion != '1') throw this.classFileParseException("Wrong version: " + majorVersion + "." + minorVersion);
                this.classInfo.javacTargetRelease = 0x1050000;
            }
            return;
        } else {
            this.classInfo.javacTargetRelease = 0x1040000;
        }
    }

    private void readConstantPool(boolean readFullInfo) {
        int classRefsNo = 0;
        int fieldRefsNo = 0;
        int methodRefsNo = 0;
        this.cpOffsets = new int[this.nextChar()];
        this.cpTags = new byte[this.cpOffsets.length];
        int i = 1;
        while (i < this.cpOffsets.length) {
            byte tag = this.buf[this.curBufPos++];
            this.cpOffsets[i] = this.curBufPos;
            this.cpTags[i] = tag;
            ++i;
            switch (tag) {
                case 1: {
                    char len = this.nextChar();
                    this.curBufPos += len;
                    break;
                }
                case 7: {
                    ++classRefsNo;
                    this.curBufPos += 2;
                    break;
                }
                case 8: 
                case 16: {
                    this.curBufPos += 2;
                    break;
                }
                case 9: {
                    ++fieldRefsNo;
                    this.curBufPos += 4;
                    break;
                }
                case 10: 
                case 11: {
                    ++methodRefsNo;
                    this.curBufPos += 4;
                    break;
                }
                case 15: {
                    this.curBufPos += 3;
                    break;
                }
                case 3: 
                case 4: 
                case 12: 
                case 18: {
                    this.curBufPos += 4;
                    break;
                }
                case 5: 
                case 6: {
                    this.curBufPos += 8;
                    ++i;
                    break;
                }
                default: {
                    throw this.classFileParseException("Bad constant pool tag: " + tag + " at " + Integer.toString(this.curBufPos - 1));
                }
            }
        }
        this.cpObjectCache = new Object[this.cpOffsets.length];
        if (!readFullInfo) {
            return;
        }
        this.classInfo.cpoolRefsToClasses = new String[classRefsNo];
        this.classInfo.isRefClassArray = new boolean[classRefsNo];
        this.classInfo.cpoolRefsToFieldClasses = new String[fieldRefsNo];
        this.classInfo.cpoolRefsToFieldNames = new String[fieldRefsNo];
        this.classInfo.cpoolRefsToFieldSignatures = new String[fieldRefsNo];
        this.classInfo.cpoolRefsToMethodClasses = new String[methodRefsNo];
        this.classInfo.cpoolRefsToMethodNames = new String[methodRefsNo];
        this.classInfo.cpoolRefsToMethodSignatures = new String[methodRefsNo];
        int curClassRef = 0;
        int curFieldRef = 0;
        int curMethodRef = 0;
        i = 0;
        while (i < this.cpOffsets.length) {
            int ofs = this.cpOffsets[i];
            switch (this.cpTags[i]) {
                case 7: {
                    char utf8Idx = this.getChar(ofs);
                    this.classInfo.cpoolRefsToClasses[curClassRef++] = this.classNameAtCPIndex(utf8Idx, this.classInfo.isRefClassArray, curClassRef - 1);
                    break;
                }
                case 9: {
                    char classIdx = this.getChar(ofs);
                    char nameAndTypeIdx = this.getChar(ofs + 2);
                    if (this.cpTags[classIdx] != 7 || this.cpTags[nameAndTypeIdx] != 12) {
                        this.badCPReference(ofs, i);
                    }
                    this.classInfo.cpoolRefsToFieldClasses[curFieldRef] = this.classNameAtCPIndex(this.getChar(this.cpOffsets[classIdx]));
                    ofs = this.cpOffsets[nameAndTypeIdx];
                    char nameIdx = this.getChar(ofs);
                    char sigIdx = this.getChar(ofs + 2);
                    if (this.cpTags[nameIdx] != 1 || this.cpTags[sigIdx] != 1) {
                        this.badCPReference(ofs, i);
                    }
                    this.classInfo.cpoolRefsToFieldNames[curFieldRef] = this.utf8AtCPIndex(nameIdx);
                    this.classInfo.cpoolRefsToFieldSignatures[curFieldRef] = this.signatureAtCPIndex(sigIdx);
                    ++curFieldRef;
                    break;
                }
                case 10: 
                case 11: {
                    char classIdx = this.getChar(ofs);
                    char nameAndTypeIdx = this.getChar(ofs + 2);
                    if (this.cpTags[classIdx] != 7 || this.cpTags[nameAndTypeIdx] != 12) {
                        this.badCPReference(ofs, i);
                    }
                    this.classInfo.cpoolRefsToMethodClasses[curMethodRef] = this.classNameAtCPIndex(this.getChar(this.cpOffsets[classIdx]));
                    ofs = this.cpOffsets[nameAndTypeIdx];
                    char nameIdx = this.getChar(ofs);
                    char sigIdx = this.getChar(ofs + 2);
                    if (this.cpTags[nameIdx] != 1 || this.cpTags[sigIdx] != 1) {
                        this.badCPReference(ofs, i);
                    }
                    this.classInfo.cpoolRefsToMethodNames[curMethodRef] = this.utf8AtCPIndex(nameIdx);
                    this.classInfo.cpoolRefsToMethodSignatures[curMethodRef] = this.signatureAtCPIndex(sigIdx);
                    ++curMethodRef;
                }
            }
            ++i;
        }
    }

    private void readIntermediate() {
        int intfCount;
        this.classInfo.accessFlags = this.nextChar();
        char classIdx = this.nextChar();
        if (this.cpTags[classIdx] != 7) {
            throw this.classFileParseException("Bad reference to this class name");
        }
        this.classInfo.name = this.classNameAtCPIndex(this.getChar(this.cpOffsets[classIdx]));
        char superClassIdx = this.nextChar();
        if (!"java/lang/Object".equals(this.classInfo.name)) {
            if (this.cpTags[superClassIdx] != 7) {
                throw this.classFileParseException("Bad reference to super class name");
            }
            this.classInfo.superName = this.classNameAtCPIndex(this.getChar(this.cpOffsets[superClassIdx]));
        }
        if ((intfCount = this.nextChar()) != 0) {
            this.classInfo.interfaces = new String[intfCount];
            int i = 0;
            while (i < intfCount) {
                classIdx = this.nextChar();
                if (this.cpTags[classIdx] != 7) {
                    throw this.classFileParseException("Bad reference to an implemented interface");
                }
                this.classInfo.interfaces[i] = this.classNameAtCPIndex(this.getChar(this.cpOffsets[classIdx]));
                ++i;
            }
        }
    }

    private void readFields() {
        int definedFieldCount = this.nextChar();
        if (definedFieldCount == 0) {
            return;
        }
        String[] names = new String[definedFieldCount];
        String[] signatures = new String[definedFieldCount];
        char[] accessFlags = new char[definedFieldCount];
        int ri = 0;
        int i = 0;
        while (i < definedFieldCount) {
            char flags = this.nextChar();
            String name = this.utf8AtCPIndex(this.nextChar());
            String sig = this.signatureAtCPIndex(this.nextChar());
            boolean recordField = !Modifier.isPrivate(flags) || !ClassInfo.isPrimitiveFieldSig(sig) && !this.classInfo.isNonProjectClassTypeFieldSig(sig);
            int attrCount = this.nextChar();
            int j = 0;
            while (j < attrCount) {
                char attrNameIdx = this.nextChar();
                int attrLen = this.nextInt();
                if (recordField && this.utf8AtCPIndex(attrNameIdx).equals("ConstantValue") && Modifier.isFinal(flags)) {
                    if (this.classInfo.primitiveConstantInitValues == null) {
                        this.classInfo.primitiveConstantInitValues = new Object[definedFieldCount];
                    }
                    char constValueIdx = this.nextChar();
                    switch (this.cpTags[constValueIdx]) {
                        case 8: {
                            this.classInfo.primitiveConstantInitValues[ri] = this.utf8AtCPIndex(this.getChar(this.cpOffsets[constValueIdx]));
                            break;
                        }
                        case 3: {
                            this.classInfo.primitiveConstantInitValues[ri] = this.getInt(this.cpOffsets[constValueIdx]);
                            break;
                        }
                        case 5: {
                            this.classInfo.primitiveConstantInitValues[ri] = this.getLong(this.cpOffsets[constValueIdx]);
                            break;
                        }
                        case 4: {
                            this.classInfo.primitiveConstantInitValues[ri] = Float.valueOf(this.getFloat(this.cpOffsets[constValueIdx]));
                            break;
                        }
                        case 6: {
                            this.classInfo.primitiveConstantInitValues[ri] = this.getDouble(this.cpOffsets[constValueIdx]);
                            break;
                        }
                        default: {
                            this.badCPEntry(constValueIdx);
                            break;
                        }
                    }
                } else {
                    this.curBufPos += attrLen;
                }
                ++j;
            }
            if (recordField) {
                names[ri] = name;
                signatures[ri] = sig;
                accessFlags[ri] = flags;
                ++ri;
            }
            ++i;
        }
        if (ri == definedFieldCount) {
            this.classInfo.fieldNames = names;
            this.classInfo.fieldSignatures = signatures;
            this.classInfo.fieldAccessFlags = accessFlags;
        } else if (ri > 0) {
            this.classInfo.fieldNames = new String[ri];
            this.classInfo.fieldSignatures = new String[ri];
            this.classInfo.fieldAccessFlags = new char[ri];
            System.arraycopy(names, 0, this.classInfo.fieldNames, 0, ri);
            System.arraycopy(signatures, 0, this.classInfo.fieldSignatures, 0, ri);
            System.arraycopy(accessFlags, 0, this.classInfo.fieldAccessFlags, 0, ri);
        }
    }

    private void readMethods() {
        int methodCount = this.nextChar();
        if (methodCount == 0) {
            return;
        }
        String[] names = new String[methodCount];
        String[] signatures = new String[methodCount];
        char[] accessFlags = new char[methodCount];
        int i = 0;
        while (i < methodCount) {
            accessFlags[i] = this.nextChar();
            names[i] = this.utf8AtCPIndex(this.nextChar());
            signatures[i] = this.signatureAtCPIndex(this.nextChar());
            int attrCount = this.nextChar();
            int j = 0;
            while (j < attrCount) {
                char attrNameIdx = this.nextChar();
                int attrLen = this.nextInt();
                if (this.utf8AtCPIndex(attrNameIdx).equals("Exceptions")) {
                    if (this.classInfo.checkedExceptions == null) {
                        this.classInfo.checkedExceptions = new String[methodCount][];
                    }
                    int nExceptions = this.nextChar();
                    String[] exceptions = new String[nExceptions];
                    int k = 0;
                    while (k < nExceptions) {
                        char excClassIdx = this.nextChar();
                        if (this.cpTags[excClassIdx] != 7) {
                            this.badCPEntry(excClassIdx);
                        }
                        exceptions[k] = this.classNameAtCPIndex(this.getChar(this.cpOffsets[excClassIdx]));
                        ++k;
                    }
                    this.classInfo.checkedExceptions[i] = exceptions;
                } else {
                    this.curBufPos += attrLen;
                }
                ++j;
            }
            ++i;
        }
        this.classInfo.methodNames = names;
        this.classInfo.methodSignatures = signatures;
        this.classInfo.methodAccessFlags = accessFlags;
    }

    private void readAttributes() {
        String nestedClassPrefix = String.valueOf(this.classInfo.name) + "$";
        int attrCount = this.nextChar();
        int i = 0;
        while (i < attrCount) {
            char attrNameIdx = this.nextChar();
            int attrLen = this.nextInt();
            if (this.utf8AtCPIndex(attrNameIdx).equals("InnerClasses")) {
                int nOfClasses = this.nextChar();
                String[] nestedClasses = new String[nOfClasses];
                char[] nestedClassAccessFlags = new char[nOfClasses];
                boolean[] nestedClassNonMember = new boolean[nOfClasses];
                int curIdx = 0;
                int j = 0;
                while (j < nOfClasses) {
                    char innerClassInfoIdx = this.nextChar();
                    char outerClassInfoIdx = this.nextChar();
                    char innerClassNameIdx = this.nextChar();
                    char innerClassAccessFlags = this.nextChar();
                    String nestedClassFullName = this.classNameAtCPIndex(this.getChar(this.cpOffsets[innerClassInfoIdx]));
                    if (nestedClassFullName.startsWith(nestedClassPrefix)) {
                        int p;
                        String nestedClassSimpleName;
                        String nestedClassNameSuffix = nestedClassFullName.substring(nestedClassPrefix.length());
                        if (!(innerClassNameIdx == '\u0000' ? this.findFirstNonDigit(nestedClassNameSuffix) != -1 : !nestedClassNameSuffix.equals(nestedClassSimpleName = this.utf8AtCPIndex(innerClassNameIdx)) && ((p = this.findFirstNonDigit(nestedClassNameSuffix)) == -1 || this.classInfo.javacTargetRelease == 0x1040000 && nestedClassNameSuffix.charAt(p++) != '$' || !nestedClassNameSuffix.substring(p).equals(nestedClassSimpleName)))) {
                            nestedClasses[curIdx] = nestedClassFullName;
                            nestedClassAccessFlags[curIdx] = innerClassAccessFlags;
                            nestedClassNonMember[curIdx] = outerClassInfoIdx == '\u0000';
                            ++curIdx;
                        }
                    }
                    ++j;
                }
                if (curIdx == nOfClasses) {
                    this.classInfo.nestedClasses = nestedClasses;
                    this.classInfo.nestedClassAccessFlags = nestedClassAccessFlags;
                    this.classInfo.nestedClassNonMember = nestedClassNonMember;
                } else if (curIdx > 0) {
                    this.classInfo.nestedClasses = new String[curIdx];
                    this.classInfo.nestedClassAccessFlags = new char[curIdx];
                    this.classInfo.nestedClassNonMember = new boolean[curIdx];
                    System.arraycopy(nestedClasses, 0, this.classInfo.nestedClasses, 0, curIdx);
                    System.arraycopy(nestedClassAccessFlags, 0, this.classInfo.nestedClassAccessFlags, 0, curIdx);
                    System.arraycopy(nestedClassNonMember, 0, this.classInfo.nestedClassNonMember, 0, curIdx);
                }
            } else {
                this.curBufPos += attrLen;
            }
            ++i;
        }
    }

    private int findFirstNonDigit(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isDigit(s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String utf8AtCPIndex(int idx) {
        if (this.cpTags[idx] != 1) {
            throw this.classFileParseException("Constant pool entry " + idx + " should be UTF8 constant");
        }
        if (this.cpObjectCache[idx] == null) {
            char utf8Len = this.getChar(this.cpOffsets[idx]);
            this.cpObjectCache[idx] = new String(this.buf, this.cpOffsets[idx] + 2, (int)utf8Len).intern();
        }
        return (String)this.cpObjectCache[idx];
    }

    private String classNameAtCPIndex(int idx) {
        return this.classNameAtCPIndex(idx, null, 0);
    }

    private String classNameAtCPIndex(int idx, boolean[] isRefClassArray, int isArrayIdx) {
        if (this.cpTags[idx] != 1) {
            throw this.classFileParseException("Constant pool entry " + idx + " should be UTF8 constant");
        }
        boolean isArray = false;
        if (this.cpObjectCache[idx] == null) {
            int stPos;
            int utf8Len = this.getChar(this.cpOffsets[idx]);
            int initStPos = stPos = this.cpOffsets[idx] + 2;
            while (this.buf[stPos] == 91) {
                ++stPos;
            }
            if (stPos != initStPos) {
                isArray = true;
                if (this.buf[stPos] == 76) {
                    ++stPos;
                    --utf8Len;
                }
            }
            this.cpObjectCache[idx] = new String(this.buf, stPos, utf8Len -= stPos - initStPos).intern();
            if (isRefClassArray != null) {
                isRefClassArray[isArrayIdx] = isArray;
            }
        }
        return (String)this.cpObjectCache[idx];
    }

    private String signatureAtCPIndex(int idx) {
        if (this.cpTags[idx] != 1) {
            throw this.classFileParseException("Constant pool entry " + idx + " should be UTF8 constant");
        }
        if (this.cpObjectCache[idx] == null) {
            int utf8Len = this.getChar(this.cpOffsets[idx]);
            byte[] tmp = new byte[utf8Len];
            System.arraycopy(this.buf, this.cpOffsets[idx] + 2, tmp, 0, utf8Len);
            boolean inClassName = false;
            int i = 0;
            while (i < utf8Len) {
                if (!inClassName) {
                    if (tmp[i] == 76) {
                        tmp[i] = 64;
                        inClassName = true;
                    }
                } else if (tmp[i] == 59) {
                    tmp[i] = 35;
                    inClassName = false;
                }
                ++i;
            }
            this.cpObjectCache[idx] = new String(tmp).intern();
        }
        return (String)this.cpObjectCache[idx];
    }

    private void badCPReference(int ofs, int i) {
        throw this.classFileParseException("Bad constant pool reference: " + ofs + " from entry " + i);
    }

    private void badCPEntry(int entryNo) {
        throw this.classFileParseException("Constant pool entry " + entryNo + " : invalid type");
    }

    private PrivateException classFileParseException(String msg) {
        return new PrivateException(new PublicExceptions.ClassFileParseException("Error reading class file " + this.fileFullPath + ":\n" + msg));
    }
}

