/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.PCDContainer;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.TestPCDUtils;
import java.io.File;
import java.util.Arrays;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;

public class ClassFileReaderTest {
    private boolean textFormat = true;

    @Test
    public void testNestedClassDetection() {
        String testRoot = "build/test/nested_class_detection";
        File[] sources = new File[]{new File("test/classfilereader/Parent.java")};
        String pdbPath = TestPCDUtils.compile(testRoot, sources, this.textFormat).getPdbPath();
        PCDContainer pcd = TestPCDUtils.loadPDB(pdbPath, this.textFormat);
        PCDEntry entry = pcd.pcd.get("classfilereader/Parent");
        TreeSet<String> nestedClasses = new TreeSet<String>(Arrays.asList(entry.oldClassInfo.nestedClasses));
        String[] expectedClassesArray = new String[]{"StaticChild", "ChildA", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "ChildB", "1LocalChildC", "1LocalChildD", "1LocalChildE"};
        TreeSet<String> expectedClasses = new TreeSet<String>();
        String[] stringArray = expectedClassesArray;
        int n = expectedClassesArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cls = stringArray[n2];
            expectedClasses.add("classfilereader/Parent$" + cls);
            ++n2;
        }
        Assert.assertEquals(expectedClasses, nestedClasses);
    }

    public static void main(String[] args) {
        new ClassFileReaderTest().testNestedClassDetection();
    }
}

