/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.ClassPath;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.PCDManager;
import com.sun.tools.jmake.Utils;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ClassInfo
implements Serializable {
    public static final int VER_OLD = 0;
    public static final int VER_NEW = 1;
    public static final int NO_VERSIONS = 2;
    private transient PCDManager pcdm;
    transient int verCode;
    String name = null;
    transient String packageName;
    int javacTargetRelease = 0x1040000;
    String[] cpoolRefsToClasses;
    boolean[] isRefClassArray;
    String[] cpoolRefsToFieldClasses;
    String[] cpoolRefsToFieldNames;
    String[] cpoolRefsToFieldSignatures;
    String[] cpoolRefsToMethodClasses;
    String[] cpoolRefsToMethodNames;
    String[] cpoolRefsToMethodSignatures;
    char accessFlags;
    boolean isNonMemberNestedClass = false;
    String superName;
    String[] interfaces;
    String[] fieldNames;
    String[] fieldSignatures;
    char[] fieldAccessFlags;
    Object[] primitiveConstantInitValues;
    String[] methodNames;
    String[] methodSignatures;
    char[] methodAccessFlags;
    String[][] checkedExceptions;
    transient ClassInfo[] directSubclasses;
    transient String directlyEnclosingClass;
    transient String topLevelEnclosingClass;
    String[] nestedClasses;
    transient char[] nestedClassAccessFlags;
    transient boolean[] nestedClassNonMember;

    public ClassInfo(byte[] classFileBytes, int verCode, PCDManager pcdm, String classFileFullPath) {
        this.pcdm = pcdm;
        this.verCode = verCode;
        pcdm.getClassFileReader().readClassFile(classFileBytes, this, classFileFullPath, true);
        this.packageName = Utils.getPackageName(this.name);
        this.directlyEnclosingClass = Utils.getDirectlyEnclosingClass(this.name, this.javacTargetRelease);
        this.topLevelEnclosingClass = Utils.getTopLevelEnclosingClass(this.name);
    }

    public ClassInfo(byte[] classFileBytes, PCDManager pcdm, String classFileFullPath) {
        this.pcdm = pcdm;
        this.verCode = 2;
        pcdm.getClassFileReader().readClassFile(classFileBytes, this, classFileFullPath, false);
        this.packageName = Utils.getPackageName(this.name);
        this.directlyEnclosingClass = Utils.getDirectlyEnclosingClass(this.name, this.javacTargetRelease);
        this.topLevelEnclosingClass = Utils.getTopLevelEnclosingClass(this.name);
    }

    public ClassInfo(String name, PCDManager pcdm) {
        this.pcdm = pcdm;
        this.verCode = 2;
        this.name = name;
        this.packageName = Utils.getPackageName(name);
        this.directlyEnclosingClass = Utils.getDirectlyEnclosingClass(name, 0);
        this.topLevelEnclosingClass = Utils.getTopLevelEnclosingClass(name);
    }

    public ClassInfo() {
    }

    public void initializeImmediateTransientFields() {
        this.verCode = 0;
        this.packageName = Utils.getPackageName(this.name);
        this.directlyEnclosingClass = Utils.getDirectlyEnclosingClass(this.name, this.javacTargetRelease);
        this.topLevelEnclosingClass = Utils.getTopLevelEnclosingClass(this.name);
    }

    public void restorePCDM(PCDManager pcdm) {
        this.pcdm = pcdm;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlags);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.accessFlags);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.accessFlags);
    }

    public List<String> getAllSuperclassNames() {
        ArrayList<String> res = new ArrayList<String>();
        String superName = this.superName;
        while (superName != null && !"java/lang/Object".equals(superName)) {
            res.add(superName);
            ClassInfo classInfo = this.pcdm.getClassInfoForName(this.verCode, superName);
            if (classInfo == null) {
                ClassPath.getSuperclasses(superName, res, this.pcdm);
                break;
            }
            superName = classInfo.superName;
        }
        return res;
    }

    public Set<String> getAllImplementedIntfNames() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        this.addImplementedInterfaceNames(false, res);
        return res;
    }

    private void addImplementedInterfaceNames(boolean directOnly, Set<String> intfSet) {
        if (this.interfaces != null) {
            int i = 0;
            while (i < this.interfaces.length) {
                String superIntfName = this.interfaces[i];
                intfSet.add(superIntfName);
                if (!directOnly) {
                    ClassInfo superIntfInfo = this.pcdm.getClassInfoForName(this.verCode, superIntfName);
                    if (superIntfInfo == null) {
                        ClassPath.addAllImplementedInterfaceNames(superIntfName, intfSet, this.pcdm);
                    } else {
                        superIntfInfo.addImplementedInterfaceNames(false, intfSet);
                    }
                }
                ++i;
            }
        }
        if (directOnly || this.superName == null || "java/lang/Object".equals(this.superName)) {
            return;
        }
        ClassInfo superInfo = this.pcdm.getClassInfoForName(this.verCode, this.superName);
        if (superInfo == null) {
            ClassPath.addAllImplementedInterfaceNames(this.superName, intfSet, this.pcdm);
        } else {
            superInfo.addImplementedInterfaceNames(false, intfSet);
        }
    }

    public ClassInfo[] getDirectSubclasses() {
        if (this.directSubclasses != null) {
            return this.directSubclasses;
        }
        ArrayList<ClassInfo> listRes = new ArrayList<ClassInfo>();
        for (PCDEntry entry : this.pcdm.entries()) {
            ClassInfo classInfo = this.pcdm.getClassInfoForPCDEntry(this.verCode, entry);
            if (classInfo == null || !classInfo.superName.equals(this.name)) continue;
            listRes.add(classInfo);
        }
        this.directSubclasses = listRes.toArray(new ClassInfo[listRes.size()]);
        return this.directSubclasses;
    }

    public static boolean constFieldInitValuesEqual(ClassInfo oldClassInfo, int oldFieldNo, ClassInfo newClassInfo, int newFieldNo) {
        Object newInitValue;
        Object oldInitValue = oldClassInfo.primitiveConstantInitValues == null ? null : oldClassInfo.primitiveConstantInitValues[oldFieldNo];
        Object object = newInitValue = newClassInfo.primitiveConstantInitValues == null ? null : newClassInfo.primitiveConstantInitValues[newFieldNo];
        if (oldInitValue == newInitValue) {
            return true;
        }
        if (oldInitValue == null || newInitValue == null) {
            return false;
        }
        if (oldInitValue instanceof Integer) {
            return ((Integer)oldInitValue).intValue() == ((Integer)newInitValue).intValue();
        }
        if (oldInitValue instanceof String) {
            return ((String)oldInitValue).equals((String)newInitValue);
        }
        if (oldInitValue instanceof Long) {
            return ((Long)oldInitValue).longValue() == ((Long)newInitValue).longValue();
        }
        if (oldInitValue instanceof Float) {
            return ((Float)oldInitValue).floatValue() == ((Float)newInitValue).floatValue();
        }
        if (oldInitValue instanceof Double) {
            return ((Double)oldInitValue).doubleValue() == ((Double)newInitValue).doubleValue();
        }
        return true;
    }

    public boolean implementsInterfaceDirectly(String intfName) {
        if (this.interfaces == null) {
            return false;
        }
        int i = 0;
        while (i < this.interfaces.length) {
            if (intfName.equals(this.interfaces[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean implementsIntfOrSubintfDirectly(String intfName) {
        if (this.interfaces == null) {
            return false;
        }
        int i = 0;
        while (i < this.interfaces.length) {
            if (intfName.equals(this.interfaces[i])) {
                return true;
            }
            ClassInfo superIntfInfo = this.pcdm.getClassInfoForName(this.verCode, this.interfaces[i]);
            if (superIntfInfo != null && superIntfInfo.implementsIntfOrSubintfDirectly(intfName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean implementsInterfaceDirectlyOrIndirectly(String intfName) {
        if (this.interfaces == null) {
            return false;
        }
        if (this.implementsIntfOrSubintfDirectly(intfName)) {
            return true;
        }
        if (this.superName != null) {
            ClassInfo superInfo = this.pcdm.getClassInfoForName(this.verCode, this.superName);
            if (superInfo == null) {
                return false;
            }
            return superInfo.implementsInterfaceDirectlyOrIndirectly(intfName);
        }
        return false;
    }

    public boolean declaresField(ClassInfo classInfo, int fieldNo) {
        if (this.fieldNames == null) {
            return false;
        }
        String fieldName = classInfo.fieldNames[fieldNo];
        String fieldSignature = classInfo.fieldSignatures[fieldNo];
        int i = 0;
        while (i < this.fieldNames.length) {
            if (fieldName.equals(this.fieldNames[i]) && fieldSignature.equals(this.fieldSignatures[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean declaresField(String name, String signature, boolean isStatic) {
        if (this.fieldNames == null) {
            return false;
        }
        signature = ("@" + signature + "#").intern();
        int i = 0;
        while (i < this.fieldNames.length) {
            if (name.equals(this.fieldNames[i]) && signature.equals(this.fieldSignatures[i]) && Modifier.isStatic(this.fieldAccessFlags[i]) == isStatic) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean declaresMethod(ClassInfo classInfo, int methodNo) {
        if (this.methodNames == null) {
            return false;
        }
        String methodName = classInfo.methodNames[methodNo];
        String methodSignature = classInfo.methodSignatures[methodNo];
        int i = 0;
        while (i < this.methodNames.length) {
            if (methodName.equals(this.methodNames[i]) && methodSignature.equals(this.methodSignatures[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getDeclaredMethodPos(ClassInfo classInfo, int methodNo) {
        if (this.methodNames == null) {
            return -1;
        }
        String methodName = classInfo.methodNames[methodNo];
        String methodSignature = classInfo.methodSignatures[methodNo];
        int i = 0;
        while (i < this.methodNames.length) {
            if (methodName.equals(this.methodNames[i]) && methodSignature.equals(this.methodSignatures[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int declaresSameNameMethod(String methodName) {
        if (this.methodNames == null) {
            return -1;
        }
        int j = 0;
        while (j < this.methodNames.length) {
            if (methodName.equals(this.methodNames[j])) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public boolean referencesClass(String className, boolean isRefTypeInterface, int thorDegree) {
        block26: {
            int i;
            block25: {
                if (thorDegree != 0) break block25;
                if (this.cpoolRefsToClasses == null) {
                    return false;
                }
                int i2 = 0;
                while (i2 < this.cpoolRefsToClasses.length) {
                    if (!this.isRefClassArray[i2] && className.equals(this.cpoolRefsToClasses[i2])) {
                        return true;
                    }
                    ++i2;
                }
                break block26;
            }
            if (this.isSubclassOf(className, thorDegree == 1)) {
                return true;
            }
            if (isRefTypeInterface && (thorDegree == 1 ? this.implementsInterfaceDirectly(className) : this.implementsInterfaceDirectlyOrIndirectly(className))) {
                return true;
            }
            if (this.cpoolRefsToClasses != null) {
                i = 0;
                while (i < this.cpoolRefsToClasses.length) {
                    if (className.equals(this.cpoolRefsToClasses[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            if (thorDegree == 2) {
                if (this.cpoolRefsToFieldSignatures != null) {
                    i = 0;
                    while (i < this.cpoolRefsToFieldSignatures.length) {
                        if (ClassInfo.signatureIncludesClassName(this.cpoolRefsToFieldSignatures[i], className)) {
                            return true;
                        }
                        ++i;
                    }
                }
                if (this.cpoolRefsToMethodNames != null) {
                    i = 0;
                    while (i < this.cpoolRefsToMethodSignatures.length) {
                        if (ClassInfo.signatureIncludesClassName(this.cpoolRefsToMethodSignatures[i], className)) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            if (this.fieldSignatures != null) {
                i = 0;
                while (i < this.fieldSignatures.length) {
                    if (ClassInfo.signatureIncludesClassName(this.fieldSignatures[i], className)) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.methodSignatures != null) {
                i = 0;
                while (i < this.methodSignatures.length) {
                    if (ClassInfo.signatureIncludesClassName(this.methodSignatures[i], className)) {
                        return true;
                    }
                    ++i;
                }
            }
            if (this.checkedExceptions == null) break block26;
            i = 0;
            while (i < this.checkedExceptions.length) {
                if (this.checkedExceptions[i] != null) {
                    String[] excArray = this.checkedExceptions[i];
                    int j = 0;
                    while (j < excArray.length) {
                        if (className.equals(excArray[j])) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean signatureIncludesClassName(String signature, String className) {
        int stIndex = signature.indexOf(className);
        if (stIndex == -1) {
            return false;
        }
        return stIndex != 0 && signature.charAt(stIndex - 1) == '@' && signature.charAt(stIndex + className.length()) == '#' || stIndex == 0 && signature.length() == className.length();
    }

    public boolean isSubclassOf(String className, boolean directOnly) {
        if (className.equals(this.superName)) {
            return true;
        }
        if (directOnly) {
            return false;
        }
        String superName = this.superName;
        while (superName != null) {
            if (className.equals(superName)) {
                return true;
            }
            ClassInfo classInfo = this.pcdm.getClassInfoForName(this.verCode, superName);
            if (classInfo == null) break;
            superName = classInfo.superName;
        }
        return false;
    }

    public boolean referencesField(ClassInfo fieldDefClassInfo, int fieldNo) {
        if (this.cpoolRefsToFieldNames == null) {
            return false;
        }
        String fieldDefClassName = fieldDefClassInfo.name;
        String fieldName = fieldDefClassInfo.fieldNames[fieldNo];
        String fieldSig = fieldDefClassInfo.fieldSignatures[fieldNo];
        int i = 0;
        while (i < this.cpoolRefsToFieldNames.length) {
            if (fieldName.equals(this.cpoolRefsToFieldNames[i]) && fieldSig.equals(this.cpoolRefsToFieldSignatures[i])) {
                if (fieldDefClassName.equals(this.cpoolRefsToFieldClasses[i])) {
                    return true;
                }
                ClassInfo classInThisCpool = this.pcdm.getClassInfoForName(this.verCode, this.cpoolRefsToFieldClasses[i]);
                if (classInThisCpool != null && classInThisCpool.isSubclassOf(fieldDefClassInfo.name, false)) {
                    String superName;
                    boolean redeclared = false;
                    ClassInfo curClass = classInThisCpool;
                    do {
                        if (!curClass.declaresField(fieldDefClassInfo, fieldNo)) continue;
                        redeclared = true;
                        break;
                    } while ((curClass = this.pcdm.getClassInfoForName(this.verCode, superName = curClass.superName)) != null && curClass != fieldDefClassInfo);
                    if (!redeclared) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public boolean referencesMethod(ClassInfo methodDefClassInfo, int methodNo) {
        if (this.cpoolRefsToMethodNames == null) {
            return false;
        }
        String methodDefClassName = methodDefClassInfo.name;
        String methodName = methodDefClassInfo.methodNames[methodNo];
        String methodSig = methodDefClassInfo.methodSignatures[methodNo];
        int i = 0;
        while (i < this.cpoolRefsToMethodNames.length) {
            if (methodName.equals(this.cpoolRefsToMethodNames[i]) && methodSig.equals(this.cpoolRefsToMethodSignatures[i])) {
                if (methodDefClassName.equals(this.cpoolRefsToMethodClasses[i])) {
                    return true;
                }
                ClassInfo classInThisCpool = this.pcdm.getClassInfoForName(this.verCode, this.cpoolRefsToMethodClasses[i]);
                if (classInThisCpool != null) {
                    if (classInThisCpool.isSubclassOf(methodDefClassInfo.name, false)) {
                        String superName;
                        boolean redeclared = false;
                        ClassInfo curClass = classInThisCpool;
                        do {
                            if (!curClass.declaresMethod(methodDefClassInfo, methodNo)) continue;
                            redeclared = true;
                            break;
                        } while ((curClass = this.pcdm.getClassInfoForName(this.verCode, superName = curClass.superName)) != null && curClass != methodDefClassInfo);
                        if (!redeclared) {
                            return true;
                        }
                    } else if (methodDefClassInfo.isInterface() && classInThisCpool.implementsIntfOrSubintfDirectly(methodDefClassName)) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public int hasMethodThrowingException(ClassInfo excClassInfo, int startMethodIdx) {
        if (this.checkedExceptions == null) {
            return -1;
        }
        if (startMethodIdx >= this.checkedExceptions.length) {
            return -1;
        }
        String excName = excClassInfo.name;
        int i = startMethodIdx;
        while (i < this.checkedExceptions.length) {
            if (this.checkedExceptions[i] != null) {
                String[] exc = this.checkedExceptions[i];
                int j = 0;
                while (j < exc.length) {
                    if (exc[j].equals(excName)) {
                        return i;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    public void findExistingSameNameMethods(String methodName, boolean includeSuperclasses, boolean includeInterfaces, MethodHandler h) {
        String className = this.name;
        while (className != null) {
            ClassInfo classInfo = this.pcdm.getClassInfoForName(this.verCode, className);
            if (classInfo == null) break;
            String[] mNames = classInfo.methodNames;
            int mNamesLen = mNames != null ? mNames.length : 0;
            int i = 0;
            while (i < mNamesLen) {
                if (methodName.equals(mNames[i])) {
                    h.handleMethod(classInfo, i);
                }
                ++i;
            }
            if (includeInterfaces && classInfo.interfaces != null) {
                String[] intfNames = classInfo.interfaces;
                int i2 = 0;
                while (i2 < intfNames.length) {
                    ClassInfo superIntfInfo = this.pcdm.getClassInfoForName(this.verCode, intfNames[i2]);
                    if (superIntfInfo != null) {
                        superIntfInfo.findExistingSameNameMethods(methodName, true, includeInterfaces, h);
                    }
                    ++i2;
                }
            }
            if (includeSuperclasses) {
                className = classInfo.superName;
                continue;
            }
            return;
        }
    }

    public static boolean isPrimitiveFieldSig(String fieldSig) {
        return fieldSig.indexOf(64) == -1;
    }

    public boolean isNonProjectClassTypeFieldSig(String fieldSig) {
        int stPos = fieldSig.indexOf(64);
        if (stPos == -1) {
            return false;
        }
        int endPos = fieldSig.indexOf(35);
        String className = fieldSig.substring(stPos + 1, endPos);
        return !this.pcdm.isProjectClass(this.verCode, className);
    }

    public String toString() {
        return String.valueOf(this.name) + (this.verCode == 0 ? " OLD" : " NEW");
    }

    public static abstract class MethodHandler {
        abstract void handleMethod(ClassInfo var1, int var2);
    }
}

