/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.PCDManager;
import com.sun.tools.jmake.PublicExceptions;
import com.sun.tools.jmake.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    private PathEntry[] paths;
    private static ClassPath projectClassPath;
    private static ClassPath standardClassPath;
    private static ClassPath bootClassPath;
    private static ClassPath extClassPath;
    private static ClassPath virtualPath;
    private static String compilerUserClassPath;
    private static String standardClassPathStr;
    private static String projectClassPathStr;
    private static String bootClassPathStr;
    private static String extDirsStr;
    private static String virtualPathStr;
    private static Map<String, ClassInfo> classCache;

    static {
        ClassPath.resetOnFinish();
    }

    public static void resetOnFinish() {
        virtualPath = null;
        extClassPath = null;
        bootClassPath = null;
        standardClassPath = null;
        projectClassPath = null;
        compilerUserClassPath = null;
        virtualPathStr = null;
        extDirsStr = null;
        bootClassPathStr = null;
        projectClassPathStr = null;
        standardClassPathStr = null;
        classCache = new LinkedHashMap<String, ClassInfo>();
    }

    public static void setClassPath(String value) throws PublicExceptions.InvalidCmdOptionException {
        standardClassPathStr = value;
        standardClassPath = new ClassPath(value, false);
    }

    public static void setProjectClassPath(String value) throws PublicExceptions.InvalidCmdOptionException {
        projectClassPathStr = value;
        projectClassPath = new ClassPath(value, true);
    }

    public static void setBootClassPath(String value) throws PublicExceptions.InvalidCmdOptionException {
        bootClassPathStr = value;
        bootClassPath = new ClassPath(value, false);
    }

    public static void setExtDirs(String value) throws PublicExceptions.InvalidCmdOptionException {
        extDirsStr = value;
        ArrayList<String> extClassPathElements = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(value, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            File extDir = new File(tok.nextToken());
            String[] extJars = extDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".zip") || name.endsWith(".jar");
                }
            });
            if (extJars == null) continue;
            int i = 0;
            while (i < extJars.length) {
                extClassPathElements.add(extDir + File.separator + extJars[i]);
                ++i;
            }
        }
        extClassPath = new ClassPath(extClassPathElements, false);
    }

    public static void setVirtualPath(String value) throws PublicExceptions.InvalidCmdOptionException {
        if (value == null) {
            throw new PublicExceptions.InvalidCmdOptionException("null argument");
        }
        StringTokenizer st = new StringTokenizer(value, File.pathSeparator);
        while (st.hasMoreElements()) {
            String dir = st.nextToken();
            if (new File(dir).isDirectory()) continue;
            throw new PublicExceptions.InvalidCmdOptionException("Virtual path must contain only directories. Entry " + dir + " is not a directory.");
        }
        virtualPathStr = value;
        virtualPath = new ClassPath(value, false);
    }

    public static void initializeAllClassPaths() {
        compilerUserClassPath = standardClassPathStr == null && projectClassPathStr == null ? "." : (standardClassPathStr == null ? projectClassPathStr : (projectClassPathStr == null ? standardClassPathStr : String.valueOf(standardClassPathStr) + File.pathSeparator + projectClassPathStr));
        if (virtualPathStr != null) {
            compilerUserClassPath = String.valueOf(compilerUserClassPath) + File.pathSeparator + virtualPathStr;
        }
        if (standardClassPathStr == null) {
            try {
                String tmp = ".";
                if (virtualPathStr != null) {
                    tmp = String.valueOf(tmp) + File.pathSeparator + virtualPathStr;
                }
                standardClassPath = new ClassPath(tmp, false);
            }
            catch (PublicExceptions.InvalidCmdOptionException invalidCmdOptionException) {
                // empty catch block
            }
        }
        if (projectClassPathStr == null) {
            projectClassPath = new ClassPath();
        }
        if (bootClassPathStr == null) {
            try {
                bootClassPath = new ClassPath(System.getProperty("sun.boot.class.path"), false);
            }
            catch (PublicExceptions.InvalidCmdOptionException invalidCmdOptionException) {
                // empty catch block
            }
        }
        if (extDirsStr == null) {
            try {
                ClassPath.setExtDirs(System.getProperty("java.ext.dirs"));
            }
            catch (PublicExceptions.InvalidCmdOptionException invalidCmdOptionException) {
                // empty catch block
            }
            extDirsStr = null;
        }
    }

    public static String getCompilerUserClassPath() {
        return compilerUserClassPath;
    }

    public static String getCompilerBootClassPath() {
        return bootClassPathStr;
    }

    public static String getCompilerExtDirs() {
        return extDirsStr;
    }

    public static String getVirtualPath() {
        return virtualPathStr;
    }

    public static void getSuperclasses(String className, Collection<String> res, PCDManager pcdm) {
        int iterNo = 0;
        while (!"java/lang/Object".equals(className)) {
            ClassInfo ci = ClassPath.getClassInfoForName(className, pcdm);
            if (ci == null) {
                return;
            }
            if (iterNo++ > 0) {
                res.add(ci.name);
            }
            className = ci.superName;
        }
    }

    public static void addAllImplementedInterfaceNames(String className, Set<String> intfSet, PCDManager pcdm) {
        String superName;
        if ("java/lang/Object".equals(className)) {
            return;
        }
        ClassInfo ci = ClassPath.getClassInfoForName(className, pcdm);
        if (ci == null) {
            return;
        }
        String[] interfaces = ci.interfaces;
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                intfSet.add(interfaces[i]);
                ClassPath.addAllImplementedInterfaceNames(interfaces[i], intfSet, pcdm);
                ++i;
            }
        }
        if ((superName = ci.superName) != null) {
            ClassPath.addAllImplementedInterfaceNames(superName, intfSet, pcdm);
        }
    }

    public static String[] getProjectJars() {
        if (projectClassPath == null || projectClassPath.isEmpty()) {
            return null;
        }
        PathEntry[] paths = ClassPath.projectClassPath.paths;
        String[] ret = new String[paths.length];
        int i = 0;
        while (i < paths.length) {
            ret[i] = paths[i].toString();
            ++i;
        }
        return ret;
    }

    public static ClassInfo getClassInfoForName(String className, PCDManager pcdm) {
        ClassInfo info = classCache.get(className);
        if (info != null) {
            return info;
        }
        byte[] buf = bootClassPath.getBytesForClass(className);
        if (buf == null) {
            buf = extClassPath.getBytesForClass(className);
        }
        if (buf == null) {
            buf = standardClassPath.getBytesForClass(className);
        }
        if (buf == null) {
            buf = projectClassPath.getBytesForClass(className);
        }
        if (buf == null) {
            return null;
        }
        info = new ClassInfo(buf, pcdm, className);
        classCache.put(className, info);
        return info;
    }

    public static ClassLoader getClassLoaderForPath(String classPath) throws Exception {
        boolean isWindows = System.getProperty("os.name").startsWith("Win");
        ClassPath cp = new ClassPath(classPath, false);
        PathEntry[] paths = cp.paths;
        URL[] urls = new URL[paths.length];
        int i = 0;
        while (i < paths.length) {
            String dirOrJar = paths[i].toString();
            if (!dirOrJar.startsWith("file://") && !dirOrJar.startsWith("http://")) {
                if (isWindows && dirOrJar.charAt(1) == ':') {
                    dirOrJar = "/" + dirOrJar;
                }
                dirOrJar = "file://" + dirOrJar;
            }
            if (!(dirOrJar.endsWith(".jar") || dirOrJar.endsWith(".zip") || dirOrJar.endsWith(File.separator))) {
                dirOrJar = String.valueOf(dirOrJar) + File.separator;
            }
            urls[i] = new URL(dirOrJar);
            ++i;
        }
        return new URLClassLoader(urls);
    }

    private ClassPath() {
        this.paths = new PathEntry[0];
    }

    private ClassPath(String classPath, boolean isJarOnly) throws PublicExceptions.InvalidCmdOptionException {
        if (classPath == null) {
            throw new PublicExceptions.InvalidCmdOptionException("null argument");
        }
        ArrayList<String> vec = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            vec.add(path);
        }
        this.init(vec, isJarOnly);
    }

    private ClassPath(List<String> pathEntries, boolean isJarOnly) throws PublicExceptions.InvalidCmdOptionException {
        this.init(pathEntries, isJarOnly);
    }

    private void init(List<String> pathEntries, boolean isJarOnly) throws PublicExceptions.InvalidCmdOptionException {
        if (pathEntries == null) {
            throw new PublicExceptions.InvalidCmdOptionException("null argument");
        }
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>(pathEntries.size());
        int i = 0;
        while (i < pathEntries.size()) {
            block11: {
                String path = pathEntries.get(i);
                if (!path.equals("")) {
                    File file = new File(path);
                    try {
                        if (file.exists() && file.canRead()) {
                            if (file.isDirectory()) {
                                if (isJarOnly) {
                                    throw new PublicExceptions.InvalidCmdOptionException("directories are not allowed on this class path: " + path);
                                }
                                vec.add(new Dir(file));
                            } else {
                                vec.add(new Zip(new ZipFile(file)));
                            }
                        } else if (isJarOnly) {
                            throw new IOException("file does not exist");
                        }
                    }
                    catch (IOException e) {
                        if (!isJarOnly) break block11;
                        throw new PublicExceptions.InvalidCmdOptionException("error initializing class path component " + path + ": " + e.getMessage());
                    }
                }
            }
            ++i;
        }
        this.paths = new PathEntry[vec.size()];
        vec.toArray(this.paths);
    }

    private boolean isEmpty() {
        return this.paths.length == 0;
    }

    private byte[] getBytesForClass(String className) {
        String fileName = String.valueOf(className) + ".class";
        int i = 0;
        while (i < this.paths.length) {
            byte[] buf = this.paths[i].getBytesForClassFile(fileName);
            if (buf != null) {
                return buf;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        if (this.paths == null) {
            return "NULL";
        }
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < this.paths.length) {
            res.append(this.paths[i].toString());
            ++i;
        }
        return res.toString();
    }

    private static class Dir
    extends PathEntry {
        private String dir;

        Dir(File f) throws IOException {
            this.dir = f.getCanonicalPath();
        }

        @Override
        byte[] getBytesForClassFile(String fileName) {
            File file = new File(String.valueOf(this.dir) + File.separatorChar + fileName);
            if (file.exists()) {
                return Utils.readFileIntoBuffer(file);
            }
            return null;
        }

        @Override
        public String toString() {
            return this.dir;
        }
    }

    private static abstract class PathEntry {
        private PathEntry() {
        }

        abstract byte[] getBytesForClassFile(String var1);

        public abstract String toString();
    }

    private static class Zip
    extends PathEntry {
        private ZipFile zip;

        Zip(ZipFile z) {
            this.zip = z;
        }

        @Override
        byte[] getBytesForClassFile(String fileName) {
            ZipEntry entry = this.zip.getEntry(fileName);
            if (entry != null) {
                return Utils.readZipEntryIntoBuffer(this.zip, entry);
            }
            return null;
        }

        @Override
        public String toString() {
            return this.zip.getName();
        }
    }
}

