/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.ClassPath;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.PCDManager;
import com.sun.tools.jmake.RefClassFinder;
import com.sun.tools.jmake.Utils;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;

public class CompatibilityChecker {
    private PCDManager pcdm;
    private RefClassFinder rf;
    ClassInfo oldClassInfo = null;
    ClassInfo newClassInfo = null;
    private boolean versionsCompatible;
    private boolean publicConstantChanged;

    public CompatibilityChecker(PCDManager pcdm, boolean failOnDependentJar, boolean noWarnOnDependentJar) {
        this.pcdm = pcdm;
        this.publicConstantChanged = false;
        this.rf = new RefClassFinder(pcdm, failOnDependentJar, noWarnOnDependentJar);
    }

    public boolean compareClassVersions(PCDEntry entry) {
        this.oldClassInfo = this.pcdm.getClassInfoForPCDEntry(0, entry);
        this.newClassInfo = this.pcdm.getClassInfoForPCDEntry(1, entry);
        this.rf.initialize(this.oldClassInfo.name, entry.javaFileFullPath.endsWith(".jar"));
        this.versionsCompatible = true;
        this.checkAccessFlags();
        this.checkSuperclasses();
        this.checkImplementedInterfaces();
        this.checkFields();
        this.checkMethodsAndConstructors();
        return this.versionsCompatible;
    }

    public void checkDeletedClass(PCDEntry entry) {
        this.oldClassInfo = entry.oldClassInfo;
        this.rf.initialize(this.oldClassInfo.name, entry.javaFileFullPath.endsWith(".jar"));
        this.rf.findReferencingClassesForDeletedClass(this.oldClassInfo);
        String packageToLookIn = this.oldClassInfo.isPublic() ? null : this.oldClassInfo.packageName;
        this.rf.findClassesDeclaringField(("class$" + this.oldClassInfo.name).intern(), "java/lang/Class", true, packageToLookIn);
        this.checkForFinalFields();
    }

    public String[] getAffectedClasses() {
        return this.rf.getAffectedClassNames();
    }

    private void checkAccessFlags() {
        char oldClassFlags = this.oldClassInfo.accessFlags;
        char newClassFlags = this.newClassInfo.accessFlags;
        if (oldClassFlags == newClassFlags) {
            return;
        }
        if (!Modifier.isFinal(oldClassFlags) && Modifier.isFinal(newClassFlags)) {
            this.versionsCompatible = false;
            this.rf.findDirectSubclasses(this.oldClassInfo);
        }
        if (!Modifier.isAbstract(oldClassFlags) && Modifier.isAbstract(newClassFlags)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClasses0(this.oldClassInfo);
        }
        if (Modifier.isPublic(newClassFlags)) {
            return;
        }
        if (Modifier.isProtected(newClassFlags)) {
            if (Modifier.isPublic(oldClassFlags)) {
                this.versionsCompatible = false;
                this.rf.findDiffPackageAndNotSubReferencingClasses1(this.oldClassInfo);
            }
        } else if (Modifier.isPrivate(newClassFlags)) {
            if (Modifier.isPrivate(oldClassFlags)) {
                return;
            }
            this.versionsCompatible = false;
            if (Modifier.isPublic(oldClassFlags)) {
                this.rf.findReferencingClasses1(this.oldClassInfo);
            } else if (Modifier.isProtected(oldClassFlags)) {
                this.rf.findThisPackageOrSubReferencingClasses1(this.oldClassInfo);
            } else {
                this.rf.findThisPackageReferencingClasses1(this.oldClassInfo);
            }
        } else if (Modifier.isPublic(oldClassFlags)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageReferencingClasses1(this.oldClassInfo);
        } else if (Modifier.isProtected(oldClassFlags)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageAndSubReferencingClasses1(this.oldClassInfo);
        }
    }

    private void checkSuperclasses() {
        List<String> oldSuperNames = this.oldClassInfo.getAllSuperclassNames();
        List<String> newSuperNames = this.newClassInfo.getAllSuperclassNames();
        int oldNamesSizeMinusOne = oldSuperNames.size() - 1;
        int i = 0;
        while (i <= oldNamesSizeMinusOne) {
            String oldSuperName = oldSuperNames.get(i);
            if (!newSuperNames.contains(oldSuperName)) {
                this.versionsCompatible = false;
                ClassInfo missingSuperClass = this.pcdm.getClassInfoForName(0, oldSuperName);
                if (missingSuperClass == null && (missingSuperClass = ClassPath.getClassInfoForName(oldSuperName, this.pcdm)) == null) {
                    missingSuperClass = new ClassInfo(oldSuperName, this.pcdm);
                }
                this.rf.findReferencingClasses2(missingSuperClass, this.oldClassInfo);
            }
            ++i;
        }
        if (this.oldClassInfo.isInterface() || oldSuperNames.size() == 0) {
            return;
        }
        if (!oldSuperNames.contains("java/lang/RuntimeException") && !oldSuperNames.contains("java/lang/Error")) {
            return;
        }
        if (!newSuperNames.contains("java/lang/RuntimeException") && !newSuperNames.contains("java/lang/Error")) {
            if (!newSuperNames.contains("java/lang/Throwable")) {
                return;
            }
            this.versionsCompatible = false;
            this.rf.findReferencingClasses0(this.oldClassInfo);
            this.rf.findRefsToMethodsThrowingException(this.oldClassInfo);
        }
    }

    private void checkImplementedInterfaces() {
        Set<String> oldIntfNames = this.oldClassInfo.getAllImplementedIntfNames();
        Set<String> newIntfNames = this.newClassInfo.getAllImplementedIntfNames();
        for (String oldIntfName : oldIntfNames) {
            if (newIntfNames.contains(oldIntfName)) continue;
            this.versionsCompatible = false;
            ClassInfo missingSuperInterface = this.pcdm.getClassInfoForName(0, oldIntfName);
            if (missingSuperInterface == null && (missingSuperInterface = ClassPath.getClassInfoForName(oldIntfName, this.pcdm)) == null) {
                missingSuperInterface = new ClassInfo(oldIntfName, this.pcdm);
            }
            this.rf.findReferencingClasses2(missingSuperInterface, this.oldClassInfo);
        }
        if (this.newClassInfo.isAbstract()) {
            for (String newIntfName : newIntfNames) {
                if (oldIntfNames.contains(newIntfName)) continue;
                this.versionsCompatible = false;
                this.rf.findConcreteSubclasses(this.oldClassInfo);
                break;
            }
        }
    }

    private void checkFields() {
        int j;
        boolean found;
        int nFLen;
        String[] oFNames = this.oldClassInfo.fieldNames;
        String[] oFSignatures = this.oldClassInfo.fieldSignatures;
        char[] oFFlags = this.oldClassInfo.fieldAccessFlags;
        String[] nFNames = this.newClassInfo.fieldNames;
        String[] nFSignatures = this.newClassInfo.fieldSignatures;
        char[] nFFlags = this.newClassInfo.fieldAccessFlags;
        int oFLen = oFNames != null ? oFNames.length : 0;
        int nonMatchingNewFields = nFLen = nFNames != null ? nFNames.length : 0;
        int i = 0;
        while (i < oFLen) {
            char oFMod = oFFlags[i];
            if (!Modifier.isPrivate(oFMod)) {
                String oFName = oFNames[i];
                String oFSig = oFSignatures[i];
                found = false;
                int endIdx = nFLen - 1;
                int k = i < nFLen ? i : endIdx;
                j = 0;
                while (j < nFLen) {
                    if (oFName.equals(nFNames[k]) && oFSig.equals(nFSignatures[k])) {
                        found = true;
                        break;
                    }
                    k = k < endIdx ? ++k : 0;
                    ++j;
                }
                if (found) {
                    --nonMatchingNewFields;
                    char nFMod = nFFlags[k];
                    this.checkFieldModifiers(oFMod, nFMod, i, k);
                    if (this.publicConstantChanged) {
                        return;
                    }
                } else if (Modifier.isStatic(oFMod) && Modifier.isFinal(oFMod) && this.oldClassInfo.primitiveConstantInitValues != null && this.oldClassInfo.primitiveConstantInitValues[i] != null) {
                    this.versionsCompatible = false;
                    this.rf.findAllProjectClasses(this.oldClassInfo, i);
                    if (Modifier.isPublic(oFMod)) {
                        this.publicConstantChanged = true;
                        return;
                    }
                } else {
                    this.versionsCompatible = false;
                    this.rf.findReferencingClassesForField(this.oldClassInfo, i);
                }
            }
            ++i;
        }
        if (nonMatchingNewFields > 0) {
            i = 0;
            while (i < nFLen) {
                String nFName = nFNames[i];
                found = false;
                j = 0;
                while (j < oFLen) {
                    if (nFName.equals(oFNames[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    String superName = this.oldClassInfo.superName;
                    while (superName != null) {
                        ClassInfo superInfo = this.pcdm.getClassInfoForName(0, superName);
                        if (superInfo == null) break;
                        String[] superOFNames = superInfo.fieldNames;
                        int superOFNamesLen = superOFNames != null ? superOFNames.length : 0;
                        j = 0;
                        while (j < superOFNamesLen) {
                            if (nFName == superOFNames[j]) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForField(superInfo, j);
                            }
                            ++j;
                        }
                        superName = superInfo.superName;
                    }
                }
                ++i;
            }
        }
    }

    private void checkFieldModifiers(int oFMod, int nFMod, int oldFieldIdx, int newFieldIdx) {
        if (oFMod == nFMod && Modifier.isFinal(oFMod) && !ClassInfo.constFieldInitValuesEqual(this.oldClassInfo, oldFieldIdx, this.newClassInfo, newFieldIdx)) {
            this.versionsCompatible = false;
            this.rf.findAllProjectClasses(this.oldClassInfo, oldFieldIdx);
            if (Modifier.isPublic(oFMod)) {
                this.publicConstantChanged = true;
            }
            return;
        }
        if (Modifier.isStatic(oFMod) && Modifier.isFinal(oFMod) && (!Modifier.isFinal(nFMod) || !ClassInfo.constFieldInitValuesEqual(this.oldClassInfo, oldFieldIdx, this.newClassInfo, newFieldIdx))) {
            this.versionsCompatible = false;
            this.rf.findAllProjectClasses(this.oldClassInfo, oldFieldIdx);
            if (Modifier.isPublic(oFMod)) {
                this.publicConstantChanged = true;
            }
        } else if (Modifier.isPrivate(nFMod) || !Modifier.isFinal(oFMod) && Modifier.isFinal(nFMod) || Modifier.isStatic(oFMod) != Modifier.isStatic(nFMod) || Modifier.isVolatile(oFMod) != Modifier.isVolatile(nFMod)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClassesForField(this.oldClassInfo, oldFieldIdx);
        } else if (Modifier.isPublic(oFMod) && Modifier.isProtected(nFMod)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageReferencingClassesForField(this.oldClassInfo, oldFieldIdx);
        } else if (!(!Modifier.isPublic(oFMod) && !Modifier.isProtected(oFMod) || Modifier.isPublic(nFMod) || Modifier.isProtected(nFMod) || Modifier.isPrivate(nFMod))) {
            this.versionsCompatible = false;
            if (Modifier.isPublic(oFMod)) {
                this.rf.findDiffPackageReferencingClassesForField(this.oldClassInfo, oldFieldIdx);
            } else {
                this.rf.findDiffPackageAndSubReferencingClassesForField(this.oldClassInfo, oldFieldIdx);
            }
        }
    }

    private void checkForFinalFields() {
        char[] oFFlags = this.oldClassInfo.fieldAccessFlags;
        int oFLen = this.oldClassInfo.fieldNames != null ? this.oldClassInfo.fieldNames.length : 0;
        int i = 0;
        while (i < oFLen) {
            char oFMod = oFFlags[i];
            if (!Modifier.isPrivate(oFMod) && Modifier.isStatic(oFMod) && Modifier.isFinal(oFMod)) {
                this.rf.findAllProjectClasses(this.oldClassInfo, i);
                if (Modifier.isPublic(oFMod)) {
                    this.publicConstantChanged = true;
                    return;
                }
            }
            ++i;
        }
    }

    private void checkMethodsAndConstructors() {
        block31: {
            String newMSig;
            char nMMod;
            int j;
            int nMLen;
            String[] oMNames = this.oldClassInfo.methodNames;
            String[] oMSignatures = this.oldClassInfo.methodSignatures;
            char[] oMFlags = this.oldClassInfo.methodAccessFlags;
            String[] nMNames = this.newClassInfo.methodNames;
            String[] nMSignatures = this.newClassInfo.methodSignatures;
            char[] nMFlags = this.newClassInfo.methodAccessFlags;
            int oMLen = oMNames != null ? oMNames.length : 0;
            int nonMatchingNewMethods = nMLen = nMNames != null ? nMNames.length : 0;
            int i = 0;
            while (i < oMLen) {
                char oMMod = oMFlags[i];
                if (!Modifier.isPrivate(oMMod)) {
                    String oMName = oMNames[i];
                    String oMSig = oMSignatures[i];
                    boolean found = false;
                    int endIdx = nMLen - 1;
                    int k = i < nMLen ? i : endIdx;
                    j = 0;
                    while (j < nMLen) {
                        if (oMName == nMNames[k] && oMSig == nMSignatures[k]) {
                            found = true;
                            break;
                        }
                        k = k < endIdx ? ++k : 0;
                        ++j;
                    }
                    if (found) {
                        --nonMatchingNewMethods;
                        nMMod = nMFlags[k];
                        if (oMMod != nMMod) {
                            this.checkMethodModifiers(oMMod, nMMod, i);
                        }
                        if (this.newClassInfo.checkedExceptions != null && this.newClassInfo.checkedExceptions[k] != null) {
                            if (this.oldClassInfo.checkedExceptions == null) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForMethod(this.oldClassInfo, i);
                            } else if (this.oldClassInfo.checkedExceptions[i] == null) {
                                this.versionsCompatible = false;
                                this.rf.findReferencingClassesForMethod(this.oldClassInfo, i);
                            } else {
                                String[] oldExceptions = this.oldClassInfo.checkedExceptions[i];
                                String[] newExceptions = this.newClassInfo.checkedExceptions[k];
                                int ei = 0;
                                while (ei < newExceptions.length) {
                                    String newEx = newExceptions[ei];
                                    found = false;
                                    int ej = 0;
                                    while (ej < oldExceptions.length) {
                                        if (newEx.equals(oldExceptions[ej])) {
                                            found = true;
                                            break;
                                        }
                                        ++ej;
                                    }
                                    if (!found) {
                                        this.versionsCompatible = false;
                                        this.rf.findReferencingClassesForMethod(this.oldClassInfo, i);
                                        break;
                                    }
                                    ++ei;
                                }
                            }
                        }
                    } else {
                        this.versionsCompatible = false;
                        this.rf.findReferencingClassesForMethod(this.oldClassInfo, i);
                        if (this.oldClassInfo.isAbstract() && !Modifier.isAbstract(oMMod)) {
                            this.rf.findConcreteSubclassesNotOverridingAbstractMethod(this.oldClassInfo, this.oldClassInfo, i);
                        }
                    }
                }
                ++i;
            }
            if (nonMatchingNewMethods <= 0) break block31;
            if (!this.oldClassInfo.isInterface()) {
                i = 0;
                while (i < nMLen) {
                    nMMod = nMFlags[i];
                    if (!Modifier.isPrivate(nMMod)) {
                        String newMName = nMNames[i];
                        newMSig = nMSignatures[i];
                        final boolean isStatic = Modifier.isStatic(nMMod);
                        boolean found = false;
                        j = 0;
                        while (j < oMLen) {
                            if (newMName.equals(oMNames[j]) && newMSig.equals(oMSignatures[j])) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            this.oldClassInfo.findExistingSameNameMethods(newMName, !newMName.equals("<init>"), false, new ClassInfo.MethodHandler(){

                                @Override
                                void handleMethod(ClassInfo classInfo, int methodIdx) {
                                    String otherMSig = classInfo.methodSignatures[methodIdx];
                                    if (newMSig.equals(otherMSig) && isStatic && classInfo != CompatibilityChecker.this.oldClassInfo || newMSig != otherMSig && Utils.sameParamNumber(newMSig, otherMSig)) {
                                        CompatibilityChecker.this.versionsCompatible = false;
                                        CompatibilityChecker.this.rf.findReferencingClassesForMethod(classInfo, methodIdx);
                                    }
                                }
                            });
                            if (Modifier.isAbstract(nMMod)) {
                                this.versionsCompatible = false;
                                this.rf.findConcreteSubclassesNotOverridingAbstractMethod(this.oldClassInfo, this.newClassInfo, i);
                            }
                            if (this.subclassesDeclareSameNameMethod(this.oldClassInfo, newMName)) {
                                this.versionsCompatible = false;
                            }
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < nMLen) {
                    String newMName = nMNames[i];
                    newMSig = nMSignatures[i];
                    boolean found = false;
                    j = 0;
                    while (j < oMLen) {
                        if (newMName == oMNames[j] && newMSig == oMSignatures[j]) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        this.versionsCompatible = false;
                        this.oldClassInfo.findExistingSameNameMethods(newMName, true, true, new ClassInfo.MethodHandler(){

                            @Override
                            void handleMethod(ClassInfo classInfo, int methodIdx) {
                                String otherMSig = classInfo.methodSignatures[methodIdx];
                                if (newMSig != otherMSig && Utils.sameParamNumber(newMSig, otherMSig)) {
                                    CompatibilityChecker.this.rf.findReferencingClassesForMethod(classInfo, methodIdx);
                                }
                            }
                        });
                        this.rf.findDirectlyAndOtherwiseImplementingConcreteClasses(this.oldClassInfo);
                        this.rf.findAbstractSubtypesWithSameNameMethod(this.oldClassInfo, newMName, newMSig);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void checkMethodModifiers(int oMMod, int nMMod, int oldMethodIdx) {
        if (Modifier.isPrivate(nMMod)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClassesForMethod(this.oldClassInfo, oldMethodIdx);
        } else if (Modifier.isPublic(oMMod) && Modifier.isProtected(nMMod)) {
            this.versionsCompatible = false;
            this.rf.findDiffPackageReferencingClassesForMethod(this.oldClassInfo, oldMethodIdx);
        } else if (!(!Modifier.isPublic(oMMod) && !Modifier.isProtected(oMMod) || Modifier.isPublic(nMMod) || Modifier.isProtected(nMMod) || Modifier.isPrivate(nMMod))) {
            this.versionsCompatible = false;
            if (Modifier.isPublic(oMMod)) {
                this.rf.findDiffPackageReferencingClassesForMethod(this.oldClassInfo, oldMethodIdx);
            } else {
                this.rf.findDiffPackageAndSubReferencingClassesForMethod(this.oldClassInfo, oldMethodIdx);
            }
        } else if (Modifier.isPrivate(oMMod) && !Modifier.isPrivate(nMMod) || Modifier.isProtected(oMMod) && Modifier.isPublic(nMMod) || !Modifier.isPublic(oMMod) && !Modifier.isProtected(oMMod) && !Modifier.isPrivate(oMMod) && (Modifier.isPublic(nMMod) || Modifier.isProtected(nMMod))) {
            this.versionsCompatible = false;
            this.rf.findSubclassesReimplementingMethod(this.oldClassInfo, oldMethodIdx);
        }
        if (!Modifier.isAbstract(oMMod) && Modifier.isAbstract(nMMod) || Modifier.isStatic(oMMod) != Modifier.isStatic(nMMod)) {
            this.versionsCompatible = false;
            this.rf.findReferencingClassesForMethod(this.oldClassInfo, oldMethodIdx);
            if (!Modifier.isAbstract(oMMod) && Modifier.isAbstract(nMMod)) {
                this.rf.findConcreteSubclassesNotOverridingAbstractMethod(this.oldClassInfo, this.newClassInfo, oldMethodIdx);
            }
        }
        if (!Modifier.isFinal(oMMod) && Modifier.isFinal(nMMod)) {
            this.versionsCompatible = false;
            this.rf.findSubclassesReimplementingMethod(this.oldClassInfo, oldMethodIdx);
        }
    }

    private boolean subclassesDeclareSameNameMethod(ClassInfo oldClassInfo, String methodName) {
        boolean res = false;
        ClassInfo[] directSubclasses = oldClassInfo.getDirectSubclasses();
        int i = 0;
        while (i < directSubclasses.length) {
            ClassInfo subclass = directSubclasses[i];
            int methNo = subclass.declaresSameNameMethod(methodName);
            if (methNo >= 0) {
                this.rf.addToAffectedClassNames(subclass.name);
                this.rf.findReferencingClassesForMethod(subclass, methNo);
                res = true;
            }
            if (this.subclassesDeclareSameNameMethod(subclass, methodName)) {
                res = true;
            }
            ++i;
        }
        return res;
    }
}

