/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.ClassPath;
import com.sun.tools.jmake.PCDContainer;
import com.sun.tools.jmake.PCDManager;
import com.sun.tools.jmake.PrivateException;
import com.sun.tools.jmake.PublicExceptions;
import com.sun.tools.jmake.Utils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    static final String DEFAULT_STORE_NAME = "jmake.pdb";
    static final String VERSION = "1.3.8-5";
    private String pdbFileName = null;
    private List<String> allProjectJavaFileNamesList = new ArrayList<String>(100);
    private String[] allProjectJavaFileNames;
    private String[] addedJavaFileNames;
    private String[] removedJavaFileNames;
    private String[] updatedJavaFileNames;
    private String destDir = "";
    private List<String> javacAddArgs = new ArrayList<String>();
    private String jcPath;
    private String jcMainClass;
    private String jcMethod;
    private String jcExecApp;
    boolean controlledExecution = false;
    Object externalApp = null;
    Method externalCompileSourceFilesMethod = null;
    private boolean failOnDependentJar = false;
    private boolean noWarnOnDependentJar = false;
    private boolean pdbTextFormat = false;
    private PCDManager pcdm = null;
    private String dependencyFile;
    private static final String[] optNames = new String[]{"-h", "-help", "-d", "-pdb", "-C", "-jcpath", "-jcmainclass", "-jcmethod", "-jcexec", "-Xtiming", "-version", "-warnlimit", "-failondependentjar", "-nowarnondependentjar", "-classpath", "-projclasspath", "-bootclasspath", "-extdirs", "-vpath", "-pdb-text-format", "-depfile"};
    private static final int[] optArgs = new int[]{0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1};
    private static final int OPT_H = 0;
    private static final int OPT_HELP = 1;
    private static final int OPT_D = 2;
    private static final int OPT_STORE = 3;
    private static final int OPT_JAVAC_OPT = 4;
    private static final int OPT_JCPATH = 5;
    private static final int OPT_JCMAINCLASS = 6;
    private static final int OPT_JCMETHOD = 7;
    private static final int OPT_JCEXEC = 8;
    private static final int OPT_TIMING = 9;
    private static final int OPT_VERSION = 10;
    private static final int OPT_WARNLIMIT = 11;
    private static final int OPT_FAILONDEPJAR = 12;
    private static final int OPT_NOWARNONDEPJAR = 13;
    private static final int OPT_CLASSPATH = 14;
    private static final int OPT_PROJECTCLASSPATH = 15;
    private static final int OPT_BOOTCLASSPATH = 16;
    private static final int OPT_EXTDIRS = 17;
    private static final int OPT_VPATH = 18;
    private static final int OPT_PDB_TEXT_FORMAT = 19;
    private static final int OPT_DEPENDENCY_FILE = 20;
    public static final int DEPJAR_NOWARNORERROR = 0;
    public static final int DEPJAR_WARNING = 1;
    public static final int DEPJAR_ERROR = 2;
    private static final String ERR_IS_INVALID_OPTION = " is an invalid option or argument.";
    private static final String ERR_NO_TWO_COMPILER_OPTIONS = "You may not specify both compiler class and compiler executable application";
    private static final String ERR_SHOULD_BE_EXPLICIT = " compiler option should be specified directly as a jmake option";

    private static int inOptions(String option) {
        if (option.startsWith(optNames[4])) {
            return 4;
        }
        for (int i = 0; i < optNames.length; ++i) {
            if (!option.equals(optNames[i])) continue;
            return i;
        }
        return -1;
    }

    private void processCommandLine(String[] args) {
        if (args.length == 0 || args.length == 1 && args[0].equals(optNames[1])) {
            Main.printUsage();
            throw new PrivateException(new PublicExceptions.NoActionRequestedException());
        }
        ArrayList<String> argsV = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argsV.add(args[i]);
        }
        int argsSt = 0;
        block35: while (argsSt < argsV.size()) {
            String arg;
            if ((arg = (String)argsV.get(argsSt++)).charAt(0) == '-') {
                int argN = Main.inOptions(arg);
                if (argN != -1) {
                    if (argsSt + optArgs[argN] > argsV.size()) {
                        Main.optRequiresArg("\"" + optNames[argN] + "\"");
                    }
                } else {
                    Main.bailOut(arg + ERR_IS_INVALID_OPTION);
                }
                switch (argN) {
                    case 0: 
                    case 1: {
                        Main.printUsage();
                        throw new PrivateException(new PublicExceptions.NoActionRequestedException());
                    }
                    case 2: {
                        this.destDir = (String)argsV.get(argsSt);
                        this.javacAddArgs.add("-d");
                        this.javacAddArgs.add((String)argsV.get(argsSt));
                        ++argsSt;
                        continue block35;
                    }
                    case 14: {
                        try {
                            Main.setClassPath((String)argsV.get(argsSt++));
                        }
                        catch (PublicExceptions.InvalidCmdOptionException ex) {
                            Main.bailOut(ex.getMessage());
                        }
                        continue block35;
                    }
                    case 15: {
                        try {
                            Main.setProjectClassPath((String)argsV.get(argsSt++));
                        }
                        catch (PublicExceptions.InvalidCmdOptionException ex) {
                            Main.bailOut(ex.getMessage());
                        }
                        continue block35;
                    }
                    case 3: {
                        this.pdbFileName = (String)argsV.get(argsSt++);
                        continue block35;
                    }
                    case 4: {
                        String javacArg = ((String)argsV.get(argsSt - 1)).substring(2);
                        if (javacArg.equals("-d") || javacArg.equals("-classpath") || javacArg.equals("-bootclasspath") || javacArg.equals("-extdirs")) {
                            Main.bailOut(javacArg + ERR_SHOULD_BE_EXPLICIT);
                        }
                        this.javacAddArgs.add(javacArg);
                        continue block35;
                    }
                    case 5: {
                        if (this.jcExecApp != null) {
                            Main.bailOut(ERR_NO_TWO_COMPILER_OPTIONS);
                        }
                        this.jcPath = (String)argsV.get(argsSt++);
                        continue block35;
                    }
                    case 6: {
                        if (this.jcExecApp != null) {
                            Main.bailOut(ERR_NO_TWO_COMPILER_OPTIONS);
                        }
                        this.jcMainClass = (String)argsV.get(argsSt++);
                        continue block35;
                    }
                    case 7: {
                        if (this.jcExecApp != null) {
                            Main.bailOut(ERR_NO_TWO_COMPILER_OPTIONS);
                        }
                        this.jcMethod = (String)argsV.get(argsSt++);
                        continue block35;
                    }
                    case 8: {
                        if (this.jcPath != null || this.jcMainClass != null || this.jcMethod != null) {
                            Main.bailOut(ERR_NO_TWO_COMPILER_OPTIONS);
                        }
                        this.jcExecApp = (String)argsV.get(argsSt++);
                        continue block35;
                    }
                    case 9: {
                        Utils.setTimingOn();
                        continue block35;
                    }
                    case 10: {
                        throw new PrivateException(new PublicExceptions.NoActionRequestedException());
                    }
                    case 11: {
                        try {
                            Utils.warningLimit = Integer.parseInt((String)argsV.get(argsSt++));
                        }
                        catch (NumberFormatException e) {
                            Utils.ignore(e);
                            Main.bailOut((String)argsV.get(argsSt) + ERR_IS_INVALID_OPTION);
                        }
                        continue block35;
                    }
                    case 12: {
                        if (this.noWarnOnDependentJar) {
                            Main.bailOut("it is not allowed to use -nowarnondependentjar and -failondependentjar together");
                        }
                        this.failOnDependentJar = true;
                        continue block35;
                    }
                    case 13: {
                        if (this.failOnDependentJar) {
                            Main.bailOut("it is not allowed to use -failondependentjar and -nowarnondependentjar together");
                        }
                        this.noWarnOnDependentJar = true;
                        continue block35;
                    }
                    case 16: {
                        try {
                            Main.setBootClassPath((String)argsV.get(argsSt++));
                        }
                        catch (PublicExceptions.InvalidCmdOptionException ex) {
                            Main.bailOut(ex.getMessage());
                        }
                        continue block35;
                    }
                    case 17: {
                        try {
                            Main.setExtDirs((String)argsV.get(argsSt++));
                        }
                        catch (PublicExceptions.InvalidCmdOptionException ex) {
                            Main.bailOut(ex.getMessage());
                        }
                        continue block35;
                    }
                    case 18: {
                        try {
                            Main.setVirtualPath((String)argsV.get(argsSt++));
                        }
                        catch (PublicExceptions.InvalidCmdOptionException ex) {
                            Main.bailOut(ex.getMessage());
                        }
                        continue block35;
                    }
                    case 19: {
                        this.pdbTextFormat = true;
                        continue block35;
                    }
                    case 20: {
                        this.dependencyFile = (String)argsV.get(argsSt++);
                        continue block35;
                    }
                }
                Main.bailOut(arg + ERR_IS_INVALID_OPTION);
                continue;
            }
            if (arg.length() > 1 && arg.charAt(0) == '@') {
                arg = arg.substring(1);
                this.loadCmdFile(arg, argsV);
                continue;
            }
            if (!arg.endsWith(".java")) {
                Main.bailOut(arg + ERR_IS_INVALID_OPTION);
            }
            this.allProjectJavaFileNamesList.add(arg);
        }
    }

    private void loadCmdFile(String name, List<String> argsV) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(name));
            StreamTokenizer st = new StreamTokenizer(r);
            st.resetSyntax();
            st.wordChars(32, 255);
            st.whitespaceChars(0, 32);
            st.commentChar(35);
            st.quoteChar(34);
            st.quoteChar(39);
            while (st.nextToken() != -1) {
                argsV.add(st.sval);
            }
            ((Reader)r).close();
        }
        catch (IOException e) {
            throw new PrivateException(new PublicExceptions.CommandFileReadException(name + ":\n" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainProgrammatic(String[] args) throws PublicExceptions.NoActionRequestedException, PublicExceptions.InvalidCmdOptionException, PublicExceptions.PDBCorruptedException, PublicExceptions.CommandFileReadException, PublicExceptions.CompilerInteractionException, PublicExceptions.ClassFileParseException, PublicExceptions.ClassNameMismatchException, PublicExceptions.InvalidSourceFileExtensionException, PublicExceptions.JarDependsOnSourceException, PublicExceptions.DoubleEntryException, FileNotFoundException, IOException, PublicExceptions.InternalException {
        try {
            String[] projectJars;
            Utils.printInfoMessage("Jmake version 1.3.8-5");
            if (!this.controlledExecution) {
                this.processCommandLine(args);
                projectJars = ClassPath.getProjectJars();
                if (projectJars != null) {
                    for (int i = 0; i < projectJars.length; ++i) {
                        this.allProjectJavaFileNamesList.add(projectJars[i]);
                    }
                }
                this.allProjectJavaFileNames = this.allProjectJavaFileNamesList.toArray(new String[this.allProjectJavaFileNamesList.size()]);
            } else {
                projectJars = ClassPath.getProjectJars();
                if (projectJars != null) {
                    String[] newNames = new String[this.allProjectJavaFileNames.length + projectJars.length];
                    System.arraycopy(this.allProjectJavaFileNames, 0, newNames, 0, this.allProjectJavaFileNames.length);
                    System.arraycopy(projectJars, 0, newNames, this.allProjectJavaFileNames.length, projectJars.length);
                    this.allProjectJavaFileNames = newNames;
                }
            }
            Utils.startTiming(1);
            PCDContainer pcdc = PCDContainer.load(this.pdbFileName, this.pdbTextFormat);
            Utils.stopAndPrintTiming("DB read", 1);
            this.pcdm = new PCDManager(pcdc, this.allProjectJavaFileNames, this.addedJavaFileNames, this.removedJavaFileNames, this.updatedJavaFileNames, this.destDir, this.javacAddArgs, this.failOnDependentJar, this.noWarnOnDependentJar, this.dependencyFile);
            this.pcdm.initializeCompiler(this.jcExecApp, this.jcPath, this.jcMainClass, this.jcMethod, this.externalApp, this.externalCompileSourceFilesMethod);
            this.pcdm.run();
        }
        catch (PrivateException e) {
            Throwable origException = e.getOriginalException();
            if (origException instanceof PublicExceptions.NoActionRequestedException) {
                throw (PublicExceptions.NoActionRequestedException)origException;
            }
            if (origException instanceof PublicExceptions.InvalidCmdOptionException) {
                throw (PublicExceptions.InvalidCmdOptionException)origException;
            }
            if (origException instanceof PublicExceptions.CommandFileReadException) {
                throw (PublicExceptions.CommandFileReadException)origException;
            }
            if (origException instanceof PublicExceptions.PDBCorruptedException) {
                throw (PublicExceptions.PDBCorruptedException)origException;
            }
            if (origException instanceof PublicExceptions.CompilerInteractionException) {
                throw (PublicExceptions.CompilerInteractionException)origException;
            }
            if (origException instanceof PublicExceptions.ClassFileParseException) {
                throw (PublicExceptions.ClassFileParseException)origException;
            }
            if (origException instanceof PublicExceptions.ClassNameMismatchException) {
                throw (PublicExceptions.ClassNameMismatchException)origException;
            }
            if (origException instanceof PublicExceptions.InvalidSourceFileExtensionException) {
                throw (PublicExceptions.InvalidSourceFileExtensionException)origException;
            }
            if (origException instanceof PublicExceptions.JarDependsOnSourceException) {
                throw (PublicExceptions.JarDependsOnSourceException)origException;
            }
            if (origException instanceof PublicExceptions.DoubleEntryException) {
                throw (PublicExceptions.DoubleEntryException)origException;
            }
            if (origException instanceof FileNotFoundException) {
                throw (FileNotFoundException)origException;
            }
            if (origException instanceof IOException) {
                throw (IOException)origException;
            }
            if (origException instanceof PublicExceptions.InternalException) {
                throw (PublicExceptions.InternalException)origException;
            }
        }
        finally {
            ClassPath.resetOnFinish();
        }
    }

    public int mainExternal(String[] args) {
        try {
            this.mainProgrammatic(args);
        }
        catch (PublicExceptions.NoActionRequestedException e0) {
        }
        catch (PublicExceptions.InvalidCmdOptionException e1) {
            Utils.printErrorMessage(e1.getMessage());
            return -1;
        }
        catch (PublicExceptions.CommandFileReadException e2) {
            Utils.printErrorMessage("error parsing command file:");
            Utils.printErrorMessage(e2.getMessage());
            return -2;
        }
        catch (PublicExceptions.PDBCorruptedException e3) {
            Utils.printErrorMessage("project database corrupted: " + e3.getMessage());
            return -3;
        }
        catch (PublicExceptions.CompilerInteractionException e4) {
            if (e4.getOriginalException() != null) {
                Utils.printErrorMessage("error interacting with the compiler: ");
                Utils.printErrorMessage(e4.getMessage());
                Utils.printErrorMessage("original exception:");
                Utils.printErrorMessage(e4.getOriginalException().getMessage());
                return -4;
            }
            return -5;
        }
        catch (PublicExceptions.ClassFileParseException e6) {
            Utils.printErrorMessage(e6.getMessage());
            return -6;
        }
        catch (FileNotFoundException e7) {
            Utils.printErrorMessage(e7.getMessage());
            return -7;
        }
        catch (IOException e8) {
            Utils.printErrorMessage(e8.getMessage());
            return -8;
        }
        catch (PublicExceptions.InternalException e9) {
            Utils.printErrorMessage("internal jmake exception detected:");
            Utils.printErrorMessage(e9.getMessage());
            Utils.printErrorMessage("Please report this problem to Mikhail.Dmitriev@sun.com");
            Utils.printErrorMessage("the stack trace is as follows:");
            e9.printStackTrace();
            return -9;
        }
        catch (PublicExceptions.ClassNameMismatchException e10) {
            Utils.printErrorMessage(e10.getMessage());
            return -10;
        }
        catch (PublicExceptions.InvalidSourceFileExtensionException e11) {
            Utils.printErrorMessage(e11.getMessage());
            return -11;
        }
        catch (PublicExceptions.JarDependsOnSourceException e12) {
            Utils.printErrorMessage(e12.getMessage());
            return -12;
        }
        catch (PublicExceptions.DoubleEntryException e13) {
            Utils.printErrorMessage(e13.getMessage());
            return -13;
        }
        catch (InternalError e20) {
            Utils.printErrorMessage("internal Java error: " + e20);
            Utils.printErrorMessage("Consult the following stack trace for more info:");
            e20.printStackTrace();
            return -20;
        }
        catch (RuntimeException e30) {
            Utils.printErrorMessage("internal Java exception: " + e30);
            Utils.printErrorMessage("Consult the following stack trace for more info:");
            e30.printStackTrace();
            return -30;
        }
        return 0;
    }

    public void mainProgrammaticControlled(String[] javaFileNames, String destDirName, String pdbFileName, Object externalApp, Method externalCompileSourceFilesMethod) throws PublicExceptions.NoActionRequestedException, PublicExceptions.InvalidCmdOptionException, PublicExceptions.PDBCorruptedException, PublicExceptions.CommandFileReadException, PublicExceptions.CompilerInteractionException, PublicExceptions.ClassFileParseException, PublicExceptions.ClassNameMismatchException, PublicExceptions.InvalidSourceFileExtensionException, PublicExceptions.JarDependsOnSourceException, PublicExceptions.DoubleEntryException, PublicExceptions.InternalException, FileNotFoundException, IOException {
        this.controlledExecution = true;
        this.pdbFileName = pdbFileName;
        this.destDir = destDirName;
        this.allProjectJavaFileNames = javaFileNames;
        this.externalApp = externalApp;
        this.externalCompileSourceFilesMethod = externalCompileSourceFilesMethod;
        this.mainProgrammatic(null);
    }

    public int mainExternalControlled(String[] javaFileNames, String destDirName, String pdbFileName, Object externalApp, Method externalCompileSourceFilesMethod) {
        this.controlledExecution = true;
        this.pdbFileName = pdbFileName;
        this.destDir = destDirName;
        this.allProjectJavaFileNames = javaFileNames;
        this.externalApp = externalApp;
        this.externalCompileSourceFilesMethod = externalCompileSourceFilesMethod;
        return this.mainExternal(null);
    }

    public void mainProgrammaticControlled(String[] addedJavaFileNames, String[] removedJavaFileNames, String[] updatedJavaFileNames, String destDirName, String pdbFileName, Object externalApp, Method externalCompileSourceFilesMethod) throws PublicExceptions.NoActionRequestedException, PublicExceptions.InvalidCmdOptionException, PublicExceptions.PDBCorruptedException, PublicExceptions.CommandFileReadException, PublicExceptions.CompilerInteractionException, PublicExceptions.ClassFileParseException, PublicExceptions.ClassNameMismatchException, PublicExceptions.InvalidSourceFileExtensionException, PublicExceptions.JarDependsOnSourceException, PublicExceptions.DoubleEntryException, PublicExceptions.InternalException, FileNotFoundException, IOException {
        this.controlledExecution = true;
        this.pdbFileName = pdbFileName;
        this.destDir = destDirName;
        this.addedJavaFileNames = addedJavaFileNames;
        this.removedJavaFileNames = removedJavaFileNames;
        this.updatedJavaFileNames = updatedJavaFileNames;
        this.externalApp = externalApp;
        this.externalCompileSourceFilesMethod = externalCompileSourceFilesMethod;
        this.mainProgrammatic(null);
    }

    public int mainExternalControlled(String[] addedJavaFileNames, String[] removedJavaFileNames, String[] updatedJavaFileNames, String destDirName, String pdbFileName, Object externalApp, Method externalCompileSourceFilesMethod) {
        this.controlledExecution = true;
        this.pdbFileName = pdbFileName;
        this.destDir = destDirName;
        this.addedJavaFileNames = addedJavaFileNames;
        this.removedJavaFileNames = removedJavaFileNames;
        this.updatedJavaFileNames = updatedJavaFileNames;
        this.externalApp = externalApp;
        this.externalCompileSourceFilesMethod = externalCompileSourceFilesMethod;
        return this.mainExternal(null);
    }

    public static void main(String[] args) {
        Utils.startTiming(0);
        Main m = new Main();
        int exitCode = m.mainExternal(args);
        Utils.stopAndPrintTiming("Total", 0);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static void customizeOutput(boolean printInfoMessages, boolean printWarningMessages, boolean printErrorMessages) {
        Utils.customizeOutput(printInfoMessages, printWarningMessages, printErrorMessages);
    }

    public static void setClassPath(String classPath) throws PublicExceptions.InvalidCmdOptionException {
        ClassPath.setClassPath(classPath);
    }

    public static void setProjectClassPath(String projectClassPath) throws PublicExceptions.InvalidCmdOptionException {
        ClassPath.setProjectClassPath(projectClassPath);
    }

    public static void setBootClassPath(String classPath) throws PublicExceptions.InvalidCmdOptionException {
        ClassPath.setBootClassPath(classPath);
    }

    public static void setExtDirs(String dirs) throws PublicExceptions.InvalidCmdOptionException {
        ClassPath.setExtDirs(dirs);
    }

    public static void setVirtualPath(String dirs) throws PublicExceptions.InvalidCmdOptionException {
        ClassPath.setVirtualPath(dirs);
    }

    public void setResponseOnDependentJar(int code) {
        switch (code) {
            case 0: {
                this.noWarnOnDependentJar = true;
                this.failOnDependentJar = false;
                break;
            }
            case 1: {
                this.noWarnOnDependentJar = false;
                this.failOnDependentJar = false;
                break;
            }
            case 2: {
                this.noWarnOnDependentJar = false;
                this.failOnDependentJar = true;
            }
        }
    }

    public String[] getUpdatedClasses() {
        return this.pcdm.getAllUpdatedClassesAsStringArray();
    }

    public static void setOutputStreams(PrintStream out, PrintStream warn, PrintStream err) {
        Utils.setOutputStreams(out, warn, err);
    }

    public static String getVersion() {
        return VERSION;
    }

    private static void bailOut(String s) {
        throw new PrivateException(new PublicExceptions.InvalidCmdOptionException("jmake: " + s + "\nRun \"jmake -h\" for help."));
    }

    private static void optRequiresArg(String s) {
        Main.bailOut("the " + s + " option requires an argument.");
    }

    private static void printUsage() {
        Utils.printInfoMessage("Usage: jmake <options> <.java files> <@files>");
        Utils.printInfoMessage("where possible options include:");
        Utils.printInfoMessage("  -h, -help             print this help message");
        Utils.printInfoMessage("  -version              print the product version number");
        Utils.printInfoMessage("  -pdb <file name>      specify non-default project database file");
        Utils.printInfoMessage("  -pdb-text-format      if specified, pdb file is stored in text format");
        Utils.printInfoMessage("  -d <directory>        specify where to place generated class files");
        Utils.printInfoMessage("  -classpath <path>     specify where to find user class files");
        Utils.printInfoMessage("  -projclasspath <path> specify where to find sourceless project classes");
        Utils.printInfoMessage("                        (currently only JARs are allowed on this path)");
        Utils.printInfoMessage("  -C<option>            specify an option to be passed to the Java compiler");
        Utils.printInfoMessage("                        (this option's arguments should also be preceded by -C)");
        Utils.printInfoMessage("  -jcpath <path>        specify the class path for a non-default Java compiler");
        Utils.printInfoMessage("                        (default is <JAVAHOME>/lib/tools.jar)");
        Utils.printInfoMessage("  -jcmainclass <class>  specify the main class for a non-default Java compiler");
        Utils.printInfoMessage("                        (default is com.sun.tools.javac.Main)");
        Utils.printInfoMessage("  -jcmethod <method>    specify the method to call in the Java compiler class");
        Utils.printInfoMessage("                        (default is \"compile(String args[])\")");
        Utils.printInfoMessage("  -jcexec <file name>   specify a binary non-default Java compiler application");
        Utils.printInfoMessage("  -failondependentjar   fail if a class on projectclasspath depends on a class");
        Utils.printInfoMessage("                        with .java source (by default, a warning is issued)");
        Utils.printInfoMessage("  -nowarnondependentjar no warning or error if a class on projectclasspath");
        Utils.printInfoMessage("                        depends on a class with a .java source (use with care)");
        Utils.printInfoMessage("  -warnlimit <number>   specify the maximum number of warnings (20 by default)");
        Utils.printInfoMessage("  -bootclasspath <path> override location of bootstrap class files");
        Utils.printInfoMessage("  -extdirs <dirs>       override location of installed extensions");
        Utils.printInfoMessage("  -vpath <dirs>         a list of directories to search for Java and class files similar to GNUMake's VPATH");
        Utils.printInfoMessage("  -depfile <path>       a file generated by the compiler containing additional java->class mappings");
        Utils.printInfoMessage("");
        Utils.printInfoMessage("Examples:");
        Utils.printInfoMessage("  jmake -d classes -classpath .;mylib.jar X.java Y.java Z.java");
        Utils.printInfoMessage("  jmake -pdb myproject.pdb -jcexec c:\\java\\jikes\\jikes.exe @myproject.src");
    }
}

