/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.BinaryProjectDatabaseReader;
import com.sun.tools.jmake.BinaryProjectDatabaseWriter;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.TextProjectDatabaseReader;
import com.sun.tools.jmake.TextProjectDatabaseWriter;
import com.sun.tools.jmake.Utils;
import java.io.File;
import java.util.Map;

public class PCDContainer {
    Map<String, PCDEntry> pcd;
    String storeName;
    boolean textFormat;

    private PCDContainer(Map<String, PCDEntry> pcd, String storeName, boolean textFormat) {
        this.storeName = storeName;
        this.pcd = pcd;
        this.textFormat = textFormat;
    }

    public static PCDContainer load(String storeName, boolean textFormat) {
        File storeFile;
        if (storeName == null) {
            storeName = "jmake.pdb";
        }
        if ((storeFile = Utils.checkFileForName(storeName)) != null) {
            Utils.printInfoMessageNoEOL("Opening project database...  ");
            Map<String, PCDEntry> pcd = textFormat ? new TextProjectDatabaseReader().readProjectDatabaseFromFile(storeFile) : new BinaryProjectDatabaseReader().readProjectDatabaseFromFile(storeFile);
            PCDContainer pcdc = new PCDContainer(pcd, storeName, textFormat);
            Utils.printInfoMessage("Done.");
            return pcdc;
        }
        return new PCDContainer(null, storeName, textFormat);
    }

    public void save() {
        Utils.printInfoMessageNoEOL("Writing project database...  ");
        File outfile = new File(this.storeName);
        if (this.textFormat) {
            new TextProjectDatabaseWriter().writeProjectDatabaseToFile(outfile, this.pcd);
        } else {
            new BinaryProjectDatabaseWriter().writeProjectDatabaseToFile(outfile, this.pcd);
        }
        Utils.printInfoMessage("Done.");
    }
}

