/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.ClassFileReader;
import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.ClassPath;
import com.sun.tools.jmake.CompatibilityChecker;
import com.sun.tools.jmake.PCDContainer;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.PrivateException;
import com.sun.tools.jmake.PublicExceptions;
import com.sun.tools.jmake.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.Adler32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PCDManager {
    private PCDContainer pcdc;
    private Map<String, PCDEntry> pcd;
    private String[] projectJavaAndJarFilesArray;
    private String[] addedJavaAndJarFilesArray;
    private String[] removedJavaAndJarFilesArray;
    private String[] updatedJavaAndJarFilesArray;
    private List<String> newJavaFiles;
    private Set<String> updatedJavaFiles;
    private Set<String> recompiledJavaFiles;
    private Set<String> updatedClasses;
    private Set<String> allUpdatedClasses;
    private Set<String> updatedAndCheckedClasses;
    private Set<String> deletedClasses;
    private Set<String> updatedJarFiles;
    private Set<String> stableJarFiles;
    private Set<String> newJarFiles;
    private Set<String> deletedJarFiles;
    private Map<String, List<String>> extraDependencies;
    private String destDir;
    private boolean destDirSpecified;
    private List<String> javacAddArgs;
    private Class<?> compilerClass;
    private Method compileMethod;
    private String jcExecApp;
    private Object externalApp;
    private Method externalCompileSourceFilesMethod;
    private Adler32 checkSum;
    private CompatibilityChecker cv;
    private ClassFileReader cfr;
    private boolean newProject = false;
    private String dependencyFile = null;
    private static boolean backSlashFileSeparator = File.separatorChar != '/';

    public PCDManager(PCDContainer pcdc, String[] projectJavaAndJarFilesArray, String[] addedJavaAndJarFilesArray, String[] removedJavaAndJarFilesArray, String[] updatedJavaAndJarFilesArray, String in_destDir, List<String> javacAddArgs, boolean failOnDependentJar, boolean noWarnOnDependentJar, String dependencyFile) {
        this.pcdc = pcdc;
        if (pcdc.pcd == null) {
            this.pcd = new LinkedHashMap<String, PCDEntry>();
            pcdc.pcd = this.pcd;
            this.newProject = true;
        } else {
            this.pcd = pcdc.pcd;
        }
        this.projectJavaAndJarFilesArray = projectJavaAndJarFilesArray;
        this.addedJavaAndJarFilesArray = addedJavaAndJarFilesArray;
        this.removedJavaAndJarFilesArray = removedJavaAndJarFilesArray;
        this.updatedJavaAndJarFilesArray = updatedJavaAndJarFilesArray;
        this.dependencyFile = dependencyFile;
        this.newJavaFiles = new ArrayList<String>();
        this.updatedJavaFiles = new LinkedHashSet<String>();
        this.recompiledJavaFiles = new LinkedHashSet<String>();
        this.updatedAndCheckedClasses = new LinkedHashSet<String>();
        this.deletedClasses = new LinkedHashSet<String>();
        this.allUpdatedClasses = new LinkedHashSet<String>();
        this.updatedJarFiles = new LinkedHashSet<String>();
        this.stableJarFiles = new LinkedHashSet<String>();
        this.newJarFiles = new LinkedHashSet<String>();
        this.deletedJarFiles = new LinkedHashSet<String>();
        this.initializeDestDir(in_destDir);
        this.javacAddArgs = javacAddArgs;
        this.checkSum = new Adler32();
        this.cv = new CompatibilityChecker(this, failOnDependentJar, noWarnOnDependentJar);
        this.cfr = new ClassFileReader();
    }

    public Collection<PCDEntry> entries() {
        return this.pcd.values();
    }

    public ClassFileReader getClassFileReader() {
        return this.cfr;
    }

    public ClassInfo getClassInfoForName(int verCode, String className) {
        PCDEntry pcde = this.pcd.get(className);
        if (pcde != null) {
            return this.getClassInfoForPCDEntry(verCode, pcde);
        }
        return null;
    }

    public boolean isProjectClass(int verCode, String className) {
        if (verCode == 0) {
            return this.pcd.containsKey(className);
        }
        PCDEntry pcde = this.pcd.get(className);
        return pcde != null && pcde.checkResult != 3;
    }

    public ClassInfo getClassInfoForPCDEntry(int verCode, PCDEntry pcde) {
        if (verCode == 0) {
            return pcde.oldClassInfo;
        }
        ClassInfo res = pcde.newClassInfo;
        if (res == null) {
            byte[] classFileBytes;
            String classFileFullPath = null;
            if (pcde.javaFileFullPath.endsWith(".java")) {
                File classFile = Utils.checkFileForName(pcde.classFileFullPath);
                if (classFile == null) {
                    return null;
                }
                classFileBytes = Utils.readFileIntoBuffer(classFile);
                classFileFullPath = pcde.classFileFullPath;
            } else {
                try {
                    JarFile jarFile = new JarFile(pcde.javaFileFullPath);
                    JarEntry jarEntry = jarFile.getJarEntry(pcde.className + ".class");
                    if (jarEntry == null) {
                        return null;
                    }
                    classFileBytes = Utils.readZipEntryIntoBuffer(jarFile, jarEntry);
                }
                catch (IOException ex) {
                    throw new PrivateException(ex);
                }
            }
            pcde.newClassInfo = res = new ClassInfo(classFileBytes, verCode, this, classFileFullPath);
        }
        return res;
    }

    public String classAlreadyRecompiledOrUncompileable(String className) {
        PCDEntry pcde = this.pcd.get(className);
        if (pcde == null) {
            for (String keyName : this.pcd.keySet()) {
                PCDEntry entry = this.pcd.get(keyName);
                if (!entry.className.equals(className)) continue;
                System.out.println("ERROR: inconsistent entry: key = " + keyName + ", name in entry = " + entry.className);
            }
            throw this.internalException(className + " not in project when it should be");
        }
        if (pcde.checkResult == 3) {
            return "";
        }
        if (pcde.javaFileFullPath.endsWith(".jar")) {
            return pcde.javaFileFullPath;
        }
        return this.recompiledJavaFiles.contains(pcde.javaFileFullPath) ? "" : null;
    }

    public void initializeCompiler(String jcExecApp, String jcPath, String jcMainClass, String jcMethod, Object externalApp, Method externalCompileSourceFilesMethod) {
        ClassLoader compilerLoader;
        ClassPath.initializeAllClassPaths();
        if (externalApp != null) {
            this.externalApp = externalApp;
            this.externalCompileSourceFilesMethod = externalCompileSourceFilesMethod;
            return;
        }
        if (jcExecApp != null) {
            this.jcExecApp = jcExecApp;
            return;
        }
        if (jcPath == null) {
            String javaHome = System.getProperty("java.home");
            if (javaHome.endsWith(File.separator + "jre") || javaHome.endsWith(File.separator + "bin")) {
                javaHome = javaHome.substring(0, javaHome.length() - 4);
            }
            jcPath = javaHome + "/lib/tools.jar";
        }
        try {
            compilerLoader = ClassPath.getClassLoaderForPath(jcPath);
        }
        catch (Exception ex) {
            throw this.compilerInteractionException("error opening compiler path", ex, 0);
        }
        if (jcMainClass == null) {
            jcMainClass = "com.sun.tools.javac.Main";
        }
        if (jcMethod == null) {
            jcMethod = "compile";
        }
        try {
            this.compilerClass = compilerLoader.loadClass(jcMainClass);
        }
        catch (ClassNotFoundException e) {
            throw this.compilerInteractionException("error loading compiler main class com.sun.tools.javac.Main", e, 0);
        }
        Class[] args = new Class[]{String[].class};
        try {
            this.compileMethod = this.compilerClass.getMethod(jcMethod, args);
        }
        catch (Exception e) {
            throw this.compilerInteractionException("error getting method com.sun.tools.javac.Main.compile(String args[])", e, 0);
        }
    }

    public void run() {
        Utils.startTiming(2);
        this.synchronizeProjectFilesAndPCD();
        Utils.stopAndPrintTiming("Synchro", 2);
        Utils.printTiming("of which synchro check file", 3);
        Utils.startTiming(4);
        this.findUpdatedJavaAndJarFiles();
        Utils.stopAndPrintTiming("findUpdatedJavaAndJarFiles", 4);
        Utils.printTiming("of which classFileObsoleteOrDeleted", 5);
        this.projectJavaAndJarFilesArray = null;
        this.updatedClasses = new LinkedHashSet<String>();
        this.dealWithClassesInUpdatedJarFiles();
        int iterNo = 0;
        int res = 0;
        while (iterNo == 0 || this.updatedJavaFiles.size() != 0 || this.newJavaFiles.size() != 0) {
            if (this.updatedJavaFiles.size() > 0 || this.newJavaFiles.size() > 0) {
                Utils.startTiming(6);
                int intermediateRes = this.recompileUpdatedJavaFiles();
                Utils.stopAndPrintTiming("Compile", 6);
                if (intermediateRes != 0) {
                    res = intermediateRes;
                }
            }
            Utils.startTiming(12);
            if (iterNo++ == 0 && res == 0) {
                this.findClassFilesForNewJavaAndJarFiles();
                this.findClassFilesForUpdatedJavaFiles();
                this.dealWithNestedClassesForUpdatedJavaFiles();
            }
            Utils.stopAndPrintTiming("Entering new classes in PDB", 12);
            this.updatedJavaFiles.clear();
            this.newJavaFiles.clear();
            Utils.startTiming(7);
            this.findUpdatedClasses();
            Utils.stopAndPrintTiming("Find updated classes", 7);
            Utils.startTiming(8);
            this.checkDeletedClasses();
            this.checkUpdatedClasses();
            Utils.stopAndPrintTiming("Check updated classes", 8);
            this.updatedClasses = new LinkedHashSet<String>();
            if (ClassPath.getVirtualPath() == null || res == 0) continue;
        }
        Utils.startTiming(9);
        this.updateClassFilesInfoInPCD(res);
        this.pcdc.save();
        Utils.stopAndPrintTiming("PDB write", 9);
        if (res != 0) {
            throw this.compilerInteractionException("compilation error(s)", null, res);
        }
    }

    private void findClassFilesForUpdatedJavaFiles() {
        if (this.dependencyFile == null) {
            return;
        }
        HashSet<String> allClasses = new HashSet<String>();
        Map<String, List<String>> dependencies = this.parseDependencyFile();
        for (String string : this.updatedJavaFiles) {
            List<String> myDeps = dependencies.get(string);
            if (myDeps == null) continue;
            PCDEntry parent = this.getNamedPCDE(string, dependencies);
            for (String dependency : myDeps) {
                allClasses.add(dependency);
                if (this.pcd.containsKey(dependency)) continue;
                this.findClassFileOnFilesystem(string, parent, dependency, false);
            }
        }
        for (Map.Entry entry : this.pcd.entrySet()) {
            String cls = (String)entry.getKey();
            if (allClasses.contains(cls)) continue;
            PCDEntry pcde = (PCDEntry)entry.getValue();
            if (!this.updatedJavaFiles.contains(pcde.javaFileFullPath)) continue;
            this.deletedClasses.add(cls);
            this.pcd.remove(cls);
        }
    }

    public String[] getAllUpdatedClassesAsStringArray() {
        String[] res = new String[this.allUpdatedClasses.size()];
        int i = 0;
        for (String updatedClass : this.allUpdatedClasses) {
            res[i++] = updatedClass.replace('/', '.');
        }
        return res;
    }

    private void synchronizeProjectFilesAndPCD() {
        if (this.projectJavaAndJarFilesArray != null) {
            LinkedHashSet<String> pcdJavaFilesSet = new LinkedHashSet<String>(this.pcd.size() * 3 / 2);
            for (PCDEntry entry : this.entries()) {
                pcdJavaFilesSet.add(entry.javaFileFullPath);
            }
            LinkedHashSet<String> canonicalPJF = new LinkedHashSet<String>(this.projectJavaAndJarFilesArray.length * 3 / 2);
            for (int i = 0; i < this.projectJavaAndJarFilesArray.length; ++i) {
                String projFileName = this.projectJavaAndJarFilesArray[i];
                Utils.startTiming(10);
                File projFile = Utils.checkFileForName(projFileName);
                Utils.stopAndAddTiming(10, 3);
                if (projFile == null) {
                    throw new PrivateException(new FileNotFoundException("specified source file " + projFileName + " not found."));
                }
                String absoluteProjFileName = projFile.getAbsolutePath();
                if (backSlashFileSeparator) {
                    absoluteProjFileName = Utils.convertDriveLetterToLowerCase(absoluteProjFileName);
                }
                canonicalPJF.add(absoluteProjFileName);
                if (pcdJavaFilesSet.contains(absoluteProjFileName)) continue;
                if (absoluteProjFileName.endsWith(".java")) {
                    this.newJavaFiles.add(absoluteProjFileName);
                    continue;
                }
                if (absoluteProjFileName.endsWith(".jar")) {
                    this.newJarFiles.add(absoluteProjFileName);
                    continue;
                }
                throw new PrivateException(new PublicExceptions.InvalidSourceFileExtensionException("specified source file " + projFileName + " has an invalid extension (not .java or .jar)."));
            }
            for (Map.Entry<String, PCDEntry> entry : this.pcd.entrySet()) {
                String key = entry.getKey();
                PCDEntry e = entry.getValue();
                e.oldClassInfo.restorePCDM(this);
                if (canonicalPJF.contains(e.javaFileFullPath)) {
                    if (!e.isPackagePrivateClass()) continue;
                    this.initializeClassFileFullPath(e);
                    new File(e.classFileFullPath).delete();
                    continue;
                }
                if (ClassPath.getVirtualPath() == null) {
                    this.deletedClasses.add(key);
                } else if (e.oldClassFileFingerprint == (long)this.projectJavaAndJarFilesArray.length && this.newJavaFiles.size() == 0 || Utils.checkFileForName(e.javaFileFullPath) != null) {
                    e.checkResult = 5;
                    e.oldClassFileFingerprint = this.projectJavaAndJarFilesArray.length;
                } else {
                    String classFound = null;
                    String sourceFound = null;
                    String path = ClassPath.getVirtualPath();
                    StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
                    while ((classFound == null || sourceFound == null) && st.hasMoreTokens()) {
                        String fullPath = st.nextToken() + File.separator + e.className;
                        if (sourceFound != null && new File(fullPath + ".java").exists()) {
                            sourceFound = fullPath + ".java";
                        }
                        if (classFound == null || !new File(fullPath + ".class").exists()) continue;
                        classFound = fullPath + ".class";
                    }
                    if (classFound == null) {
                        this.deletedClasses.add(key);
                        if (e.javaFileFullPath.endsWith(".jar")) {
                            this.deletedJarFiles.add(e.javaFileFullPath);
                        } else {
                            this.initializeClassFileFullPath(e);
                            new File(e.classFileFullPath).delete();
                        }
                    } else if (sourceFound != null) {
                        this.newJavaFiles.add(sourceFound);
                        e.checkResult = 5;
                        e.oldClassFileFingerprint = this.projectJavaAndJarFilesArray.length;
                    } else {
                        classFound = classFound.replace('/', File.separatorChar);
                        throw new PrivateException(new FileNotFoundException("deleted class " + classFound + " still exists."));
                    }
                }
                if (e.javaFileFullPath.endsWith(".jar")) {
                    this.deletedJarFiles.add(e.javaFileFullPath);
                    continue;
                }
                this.initializeClassFileFullPath(e);
                new File(e.classFileFullPath).delete();
            }
        } else {
            if (this.addedJavaAndJarFilesArray != null) {
                for (String fileName : this.addedJavaAndJarFilesArray) {
                    if ((fileName = fileName.intern()).endsWith(".java")) {
                        this.newJavaFiles.add(fileName);
                        continue;
                    }
                    if (fileName.endsWith(".jar")) {
                        this.newJarFiles.add(fileName);
                        continue;
                    }
                    throw new PrivateException(new PublicExceptions.InvalidSourceFileExtensionException("specified source file " + fileName + " has an invalid extension (not .java or .jar)."));
                }
            }
            LinkedHashSet<String> removedJavaAndJarFilesSet = null;
            if (this.removedJavaAndJarFilesArray != null) {
                removedJavaAndJarFilesSet = new LinkedHashSet<String>();
                for (String fileName : this.removedJavaAndJarFilesArray) {
                    fileName = fileName.intern();
                    removedJavaAndJarFilesSet.add(fileName);
                    if (!fileName.endsWith(".jar")) continue;
                    this.deletedJarFiles.add(fileName);
                }
            }
            for (Map.Entry<String, PCDEntry> entry : this.pcd.entrySet()) {
                String key = entry.getKey();
                PCDEntry e = entry.getValue();
                e.oldClassInfo.restorePCDM(this);
                if (removedJavaAndJarFilesSet == null || !removedJavaAndJarFilesSet.contains(e.javaFileFullPath)) continue;
                this.deletedClasses.add(key);
                if (e.javaFileFullPath.endsWith(".jar")) continue;
                this.initializeClassFileFullPath(e);
                new File(e.classFileFullPath).delete();
            }
        }
    }

    private void updateClassFilesInfoInPCD(int compilationResult) {
        PCDEntry entry;
        if (compilationResult != 0) {
            for (String className : this.updatedAndCheckedClasses) {
                entry = this.pcd.get(className);
                if (entry.checkResult != 3 || "".equals(entry.oldClassInfo.directlyEnclosingClass)) continue;
                PCDEntry enclEntry = this.pcd.get(entry.oldClassInfo.directlyEnclosingClass);
                enclEntry.checkResult = 2;
            }
        }
        for (String className : this.updatedAndCheckedClasses) {
            entry = this.pcd.get(className);
            if (entry.checkResult == 0 || ClassPath.getVirtualPath() != null && entry.checkResult == 5) continue;
            if (entry.checkResult == 3) {
                if (compilationResult != 0) continue;
                this.pcd.remove(className);
                continue;
            }
            if (entry.checkResult != 1 && entry.checkResult != 4 && (entry.checkResult != 2 || compilationResult != 0)) continue;
            if (entry.newClassInfo == null) {
                Utils.printWarningMessage("Warning: internal information inconsistency detected during pdb updating");
                Utils.printWarningMessage("Please report this problem to Mikhail.Dmitriev@sun.com");
                Utils.printWarningMessage("Class name: " + className);
                if (entry.checkResult != 4) continue;
                this.pcd.remove(className);
            }
            entry.oldClassFileLastModified = entry.newClassFileLastModified;
            entry.oldClassFileFingerprint = entry.newClassFileFingerprint;
            entry.oldClassInfo = entry.newClassInfo;
        }
    }

    private void findUpdatedJavaAndJarFiles() {
        boolean projectSpecifiedAsAllSources = this.projectJavaAndJarFilesArray != null;
        for (PCDEntry entry : this.entries()) {
            if (this.deletedClasses.contains(entry.className)) continue;
            if (entry.javaFileFullPath.endsWith(".java")) {
                this.initializeClassFileFullPath(entry);
                if (projectSpecifiedAsAllSources) {
                    if (ClassPath.getVirtualPath() != null) {
                        String[] paths = ClassPath.getVirtualPath().split(File.pathSeparator);
                        String tmpClassName = entry.className;
                        tmpClassName = tmpClassName.replaceAll("\\Q$\\E.*$", "");
                        for (int i = 0; i < paths.length; ++i) {
                            String tmpFilename = paths[i] + File.separator + tmpClassName + ".java";
                            File tmpFile = new File(tmpFilename);
                            if (!tmpFile.exists()) continue;
                            entry.javaFileFullPath = tmpFile.getAbsolutePath();
                            break;
                        }
                    }
                    Utils.startTiming(11);
                    if (this.classFileObsoleteOrDeleted(entry)) {
                        this.updatedJavaFiles.add(entry.javaFileFullPath);
                    }
                    Utils.stopAndAddTiming(11, 5);
                }
                entry.checked = true;
                continue;
            }
            if (this.projectJavaAndJarFilesArray == null) continue;
            entry.checked = !this.checkJarFileForUpdate(entry);
        }
        if (!projectSpecifiedAsAllSources && this.updatedJavaAndJarFilesArray != null) {
            for (int i = 0; i < this.updatedJavaAndJarFilesArray.length; ++i) {
                if (this.updatedJavaAndJarFilesArray[i].endsWith(".java")) {
                    this.updatedJavaFiles.add(this.updatedJavaAndJarFilesArray[i]);
                    continue;
                }
                this.updatedJarFiles.add(this.updatedJavaAndJarFilesArray[i]);
            }
        }
    }

    private boolean classFileObsoleteOrDeleted(PCDEntry entry) {
        File classFile;
        if (ClassPath.getVirtualPath() != null) {
            File file1 = new File(entry.javaFileFullPath);
            if (file1 == null) {
                throw new PrivateException(new FileNotFoundException("specified source file " + entry.javaFileFullPath + " not found."));
            }
            if (file1.lastModified() <= entry.oldClassFileLastModified) {
                return false;
            }
        }
        if ((classFile = Utils.checkFileForName(entry.classFileFullPath)) == null || !classFile.exists()) {
            return true;
        }
        File javaFile = new File(entry.javaFileFullPath);
        return classFile.lastModified() < javaFile.lastModified();
    }

    private boolean checkJarFileForUpdate(PCDEntry entry) {
        String jarFileName = entry.javaFileFullPath;
        if (this.stableJarFiles.contains(jarFileName)) {
            return false;
        }
        if (this.updatedJarFiles.contains(jarFileName) || this.newJarFiles.contains(jarFileName) || this.deletedJarFiles.contains(jarFileName)) {
            return true;
        }
        File jarFile = new File(jarFileName);
        if (entry.oldClassFileLastModified != jarFile.lastModified()) {
            this.updatedJarFiles.add(jarFileName);
            return true;
        }
        this.stableJarFiles.add(jarFileName);
        return false;
    }

    public int recompileUpdatedJavaFiles() {
        if (this.externalApp != null) {
            return this.recompileUpdatedJavaFilesUsingExternalMethod();
        }
        return this.recompileUpdatedJavaFilesOurselves();
    }

    private int recompileUpdatedJavaFilesOurselves() {
        String compilerExtDirs;
        int filesNo = this.updatedJavaFiles.size() + this.newJavaFiles.size();
        int addArgsNo = this.javacAddArgs.size();
        int argsNo = addArgsNo + filesNo + 2;
        String compilerBootClassPath = ClassPath.getCompilerBootClassPath();
        if (compilerBootClassPath != null) {
            argsNo += 2;
        }
        if ((compilerExtDirs = ClassPath.getCompilerExtDirs()) != null) {
            argsNo += 2;
        }
        if (this.jcExecApp != null) {
            ++argsNo;
        }
        String[] args = new String[argsNo];
        int pos = 0;
        if (this.jcExecApp != null) {
            args[pos++] = this.jcExecApp;
        }
        for (int i = 0; i < addArgsNo; ++i) {
            args[pos++] = this.javacAddArgs.get(i);
        }
        args[pos++] = "-classpath";
        args[pos++] = ClassPath.getCompilerUserClassPath();
        if (compilerBootClassPath != null) {
            args[pos++] = "-bootclasspath";
            args[pos++] = compilerBootClassPath;
        }
        if (compilerExtDirs != null) {
            args[pos++] = "-extdirs";
            args[pos++] = compilerExtDirs;
        }
        if (!this.newProject) {
            Utils.printInfoMessage("Recompiling source files:");
        }
        for (String javaFileFullPath : this.updatedJavaFiles) {
            if (!this.newProject) {
                Utils.printInfoMessage(javaFileFullPath);
            }
            int n = pos++;
            String string = javaFileFullPath;
            args[n] = string;
            this.recompiledJavaFiles.add(string);
        }
        for (int j = 0; j < this.newJavaFiles.size(); ++j) {
            String javaFileFullPath;
            javaFileFullPath = this.newJavaFiles.get(j);
            if (!this.newProject) {
                Utils.printInfoMessage(javaFileFullPath);
            }
            int n = pos++;
            String string = javaFileFullPath;
            args[n] = string;
            this.recompiledJavaFiles.add(string);
        }
        if (this.jcExecApp == null) {
            Object[] reflectArgs = new Object[]{args};
            try {
                Object dummy = this.compilerClass.newInstance();
                Integer res = (Integer)this.compileMethod.invoke(dummy, reflectArgs);
                return res;
            }
            catch (Exception e) {
                throw this.compilerInteractionException("exception thrown when trying to invoke the compiler method", e, 0);
            }
        }
        int exitCode = 0;
        try {
            Process p = Runtime.getRuntime().exec(args);
            InputStream pErr = p.getErrorStream();
            InputStream pOut = p.getInputStream();
            boolean terminated = false;
            while (!terminated) {
                try {
                    exitCode = p.exitValue();
                    terminated = true;
                }
                catch (IllegalThreadStateException itse) {
                    Utils.ignore(itse);
                    Utils.delay(100);
                }
                try {
                    Utils.readAndPrintBytesFromStream(pErr, System.err);
                    Utils.readAndPrintBytesFromStream(pOut, System.out);
                }
                catch (IOException ioe1) {
                    throw this.compilerInteractionException("I/O error when reading the compiler application output", ioe1, exitCode);
                }
            }
            return exitCode;
        }
        catch (IOException ioe2) {
            throw this.compilerInteractionException("I/O error when trying to invoke the compiler application", ioe2, exitCode);
        }
    }

    private int recompileUpdatedJavaFilesUsingExternalMethod() {
        int filesNo = this.updatedJavaFiles.size() + this.newJavaFiles.size();
        String[] fileNames = new String[filesNo];
        int i = 0;
        Iterator<String> i$ = this.updatedJavaFiles.iterator();
        while (i$.hasNext()) {
            String updatedFile;
            fileNames[i] = updatedFile = i$.next();
            this.recompiledJavaFiles.add(fileNames[i]);
        }
        for (int j = 0; j < this.newJavaFiles.size(); ++j) {
            int n = i++;
            String string = this.newJavaFiles.get(j);
            fileNames[n] = string;
            this.recompiledJavaFiles.add(string);
        }
        try {
            Integer res = (Integer)this.externalCompileSourceFilesMethod.invoke(this.externalApp, new Object[]{fileNames});
            return res;
        }
        catch (IllegalAccessException e1) {
            throw this.compilerInteractionException("compiler method is not accessible", e1, 0);
        }
        catch (IllegalArgumentException e2) {
            throw this.compilerInteractionException("illegal arguments passed to compiler method", e2, 0);
        }
        catch (InvocationTargetException e3) {
            throw this.compilerInteractionException("exception when executing the compiler method", e3, 0);
        }
    }

    private void findClassFilesForNewJavaAndJarFiles() {
        for (String javaFileFullPath : this.newJavaFiles) {
            Map<String, List<String>> dependencies;
            List<String> myDeps;
            PCDEntry pcde = this.findClassFileOnFilesystem(javaFileFullPath, null, null, false);
            if (pcde == null) {
                if (this.missingClassIsOk(javaFileFullPath)) continue;
                throw new PrivateException(new PublicExceptions.ClassNameMismatchException("Could not find class file for " + javaFileFullPath));
            }
            HashSet<String> entries = new HashSet<String>();
            if (pcde.checkResult == 4) {
                entries.addAll(this.findAndUpdateAllNestedClassesForClass(pcde, false));
            } else {
                entries.addAll(this.findAndUpdateAllNestedClassesForClass(pcde, true));
            }
            entries.add(pcde.className);
            if (this.dependencyFile == null || (myDeps = (dependencies = this.parseDependencyFile()).get(javaFileFullPath)) == null) continue;
            for (String dependency : myDeps) {
                if (entries.contains(dependency)) continue;
                this.findClassFileOnFilesystem(javaFileFullPath, pcde, dependency, false);
            }
        }
        for (String newJarFile : this.newJarFiles) {
            this.processAllClassesFromJarFile(newJarFile);
        }
    }

    private Map<String, List<String>> parseDependencyFile() {
        if (!this.destDirSpecified) {
            throw new RuntimeException("Dependency files require destDir");
        }
        if (this.extraDependencies != null) {
            return this.extraDependencies;
        }
        BufferedReader in = null;
        try {
            this.extraDependencies = new HashMap<String, List<String>>();
            in = new BufferedReader(new FileReader("dependencyFile"));
            int lineNumber = 0;
            while (true) {
                ++lineNumber;
                String line = in.readLine();
                if (line == null) {
                    break;
                }
                String[] parts = line.split("->");
                if (parts.length != 2) {
                    throw new RuntimeException("Failed to parse line " + lineNumber + " of " + this.dependencyFile + ". Expected {foo.java} -> {classname}.");
                }
                String src = parts[0].trim();
                src = new File(this.destDir, src).getCanonicalPath();
                String cls = parts[1].trim();
                List<String> classes = this.extraDependencies.get(src);
                if (classes == null) {
                    classes = new ArrayList<String>();
                    this.extraDependencies.put(src, classes);
                }
                cls = cls.substring(0, cls.length() - 6);
                classes.add(cls);
            }
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.extraDependencies;
    }

    private boolean missingClassIsOk(String javaFileFullPath) {
        return javaFileFullPath != null && "package-info.java".equals(new File(javaFileFullPath).getName());
    }

    private PCDEntry findClassFileOnFilesystem(String javaFileFullPath, PCDEntry enclosingClassPCDE, String nestedClassFullName, boolean isNested) {
        String fullClassName;
        String classFileFullPath = null;
        File classFile = null;
        if (enclosingClassPCDE == null) {
            fullClassName = javaFileFullPath.substring(0, javaFileFullPath.length() - 5);
            if (this.destDirSpecified) {
                while (classFile == null) {
                    classFileFullPath = this.destDir + fullClassName + ".class";
                    classFile = Utils.checkFileForName(classFileFullPath);
                    if (classFile != null) continue;
                    int cutIndex = fullClassName.indexOf(File.separatorChar);
                    if (cutIndex == -1) {
                        Utils.printWarningMessage("Warning: unable to find .class file corresponding to source " + javaFileFullPath + ": expected " + classFileFullPath);
                        return null;
                    }
                    fullClassName = fullClassName.substring(cutIndex + 1);
                }
            } else {
                classFileFullPath = fullClassName + ".class";
                classFile = Utils.checkFileForName(classFileFullPath);
                if (classFile == null) {
                    Utils.printWarningMessage("Warning: unable to find .class file corresponding to source " + javaFileFullPath);
                    return null;
                }
            }
        } else {
            classFileFullPath = Utils.getClassFileFullPathForNestedClass(enclosingClassPCDE.classFileFullPath, nestedClassFullName);
            classFile = Utils.checkFileForName(classFileFullPath);
            if (classFile == null) {
                Utils.printWarningMessage("Warning: unable to find .class file corresponding to nested class " + nestedClassFullName);
                return null;
            }
            fullClassName = nestedClassFullName;
        }
        if (backSlashFileSeparator) {
            fullClassName = fullClassName.replace(File.separatorChar, '/');
        }
        byte[] classFileBytes = Utils.readFileIntoBuffer(classFile);
        ClassInfo classInfo = new ClassInfo(classFileBytes, 1, this, classFileFullPath);
        if (isNested && !classInfo.directlyEnclosingClass.equals(enclosingClassPCDE.newClassInfo.name)) {
            String a = classInfo.directlyEnclosingClass;
            String ad1 = enclosingClassPCDE.newClassInfo.name;
            if (classInfo.javacTargetRelease != 0x1040000 || !ad1.startsWith(a + "$") || !Character.isDigit(ad1.charAt(a.length() + 1))) {
                throw new PrivateException(new PublicExceptions.ClassFileParseException("Enclosing class names for class " + classInfo.name + " don't match:\n" + classInfo.directlyEnclosingClass + " and " + enclosingClassPCDE.newClassInfo.name));
            }
        }
        if (this.destDirSpecified) {
            if (!fullClassName.equals(classInfo.name)) {
                throw new PrivateException(new PublicExceptions.ClassNameMismatchException("Error: deduced class name is different from the real one for source " + javaFileFullPath + "\n" + fullClassName + " and " + classInfo.name));
            }
        } else {
            fullClassName = classInfo.name;
        }
        if (enclosingClassPCDE != null) {
            javaFileFullPath = enclosingClassPCDE.javaFileFullPath;
        }
        long classFileLastMod = classFile.lastModified();
        long classFileFP = this.computeFP(classFileBytes);
        if (this.pcd.containsKey(fullClassName)) {
            PCDEntry pcde = this.pcd.get(fullClassName);
            if (pcde.checkResult == 5) {
                pcde.checkResult = 0;
            } else if (pcde.checked) {
                throw new PrivateException(new PublicExceptions.DoubleEntryException("Two entries for class " + classInfo.name + " detected: " + pcde.javaFileFullPath + " and " + javaFileFullPath));
            }
            pcde.javaFileFullPath = javaFileFullPath;
            pcde.classFileFullPath = classFileFullPath;
            pcde.newClassInfo = classInfo;
            if (this.deletedClasses.contains(fullClassName)) {
                this.deletedClasses.remove(fullClassName);
            }
            return pcde;
        }
        PCDEntry pcde = new PCDEntry(fullClassName, javaFileFullPath, classFileFullPath, classFileLastMod, classFileFP, classInfo);
        pcde.checkResult = 4;
        this.updatedAndCheckedClasses.add(fullClassName);
        this.pcd.put(fullClassName, pcde);
        return pcde;
    }

    private Set<String> findAndUpdateAllNestedClassesForClass(PCDEntry pcde, boolean move) {
        ClassInfo classInfo = pcde.newClassInfo;
        if (classInfo.nestedClasses == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        String[] nestedClasses = classInfo.nestedClasses;
        String javaFileFullPath = pcde.javaFileFullPath;
        String enclosingClassFileFullPath = pcde.classFileFullPath;
        boolean isJavaSourceFile = javaFileFullPath.endsWith(".java");
        for (int i = 0; i < nestedClasses.length; ++i) {
            PCDEntry nestedPCDE = this.pcd.get(nestedClasses[i]);
            if (nestedPCDE == null) {
                if (isJavaSourceFile) {
                    nestedPCDE = this.findClassFileOnFilesystem(null, pcde, nestedClasses[i], true);
                }
                if (nestedPCDE == null) {
                    throw new PrivateException(new PublicExceptions.ClassNameMismatchException("Could not find class file for " + pcde.toString()));
                }
            }
            if (move) {
                if (this.deletedClasses.contains(nestedClasses[i])) {
                    this.deletedClasses.remove(nestedClasses[i]);
                }
                nestedPCDE.javaFileFullPath = javaFileFullPath;
                nestedPCDE.classFileFullPath = javaFileFullPath.endsWith(".java") ? Utils.getClassFileFullPathForNestedClass(enclosingClassFileFullPath, nestedClasses[i]) : javaFileFullPath;
            }
            if (nestedPCDE.newClassInfo == null) {
                this.getClassInfoForPCDEntry(1, nestedPCDE);
            }
            nestedPCDE.newClassInfo.accessFlags = pcde.newClassInfo.nestedClassAccessFlags[i];
            nestedPCDE.newClassInfo.isNonMemberNestedClass = pcde.newClassInfo.nestedClassNonMember[i];
            entries.add(nestedPCDE.className);
            entries.addAll(this.findAndUpdateAllNestedClassesForClass(nestedPCDE, move));
        }
        return entries;
    }

    private void dealWithNestedClassesForUpdatedJavaFiles() {
        if (this.updatedJavaFiles.size() == 0) {
            return;
        }
        ArrayList<PCDEntry> updatedEntries = new ArrayList<PCDEntry>();
        for (PCDEntry pcde : this.entries()) {
            if (pcde.checkResult == 4 || !this.updatedJavaFiles.contains(pcde.javaFileFullPath)) continue;
            ClassInfo oldClassInfo = pcde.oldClassInfo;
            ClassInfo newClassInfo = this.getClassInfoForPCDEntry(1, pcde);
            if (newClassInfo == null) {
                this.deletedClasses.add(pcde.className);
                continue;
            }
            if (oldClassInfo.nestedClasses == null && newClassInfo.nestedClasses == null) continue;
            updatedEntries.add(pcde);
        }
        if (this.dependencyFile != null) {
            Map<String, List<String>> dependencies = this.parseDependencyFile();
            for (String file : this.updatedJavaFiles) {
                List<String> myDeps = dependencies.get(file);
                if (myDeps == null) continue;
                PCDEntry pcde = this.getNamedPCDE(file, dependencies);
                for (String dependency : myDeps) {
                    PCDEntry dep = this.pcd.get(dependency);
                    if (dep != null) continue;
                    dep = this.findClassFileOnFilesystem(file, pcde, dependency, false);
                    this.getClassInfoForPCDEntry(1, dep);
                    if (dep.newClassInfo.nestedClasses == null) continue;
                    updatedEntries.add(dep);
                }
            }
        }
        this.dealWithNestedClassesForUpdatedPCDEntries(updatedEntries, false);
    }

    private PCDEntry getNamedPCDE(String file, Map<String, List<String>> dependencies) {
        List<String> depsForFile = dependencies.get(file);
        PCDEntry pcde = null;
        for (String dependency : depsForFile) {
            if (dependency.indexOf(36) == -1 && (pcde = this.pcd.get(dependency)) != null) break;
        }
        if (pcde == null) {
            throw new PrivateException(new PublicExceptions.InternalException(file + " was supposed to be an updated file, but there are no PCDEntries for any of its deps"));
        }
        return pcde;
    }

    private void dealWithNestedClassesForUpdatedPCDEntries(List<PCDEntry> entries, boolean move) {
        for (int i = 0; i < entries.size(); ++i) {
            PCDEntry pcde = entries.get(i);
            ClassInfo oldClassInfo = pcde.oldClassInfo;
            ClassInfo newClassInfo = pcde.newClassInfo;
            if (newClassInfo.nestedClasses != null) {
                Set<String> nested = this.findAndUpdateAllNestedClassesForClass(pcde, move);
                if (oldClassInfo.nestedClasses == null) continue;
                for (int j = 0; j < oldClassInfo.nestedClasses.length; ++j) {
                    boolean found = false;
                    String oldNestedClass = oldClassInfo.nestedClasses[j];
                    for (int k = 0; k < newClassInfo.nestedClasses.length; ++k) {
                        if (!oldNestedClass.equals(newClassInfo.nestedClasses[k])) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.deletedClasses.add(oldNestedClass);
                }
                continue;
            }
            for (int j = 0; j < oldClassInfo.nestedClasses.length; ++j) {
                this.deletedClasses.add(oldClassInfo.nestedClasses[j]);
            }
        }
    }

    private void findUpdatedClasses() {
        for (PCDEntry entry : this.entries()) {
            String className = entry.className;
            if (this.updatedAndCheckedClasses.contains(className) || this.deletedClasses.contains(className) || !entry.javaFileFullPath.endsWith(".java") || entry.checkResult == 5 || this.updatedAndCheckedClasses.contains(className) || this.deletedClasses.contains(className) || !entry.javaFileFullPath.endsWith(".java") || !this.classFileUpdated(entry)) continue;
            this.updatedClasses.add(className);
            this.allUpdatedClasses.add(className);
        }
    }

    private boolean classFileUpdated(PCDEntry entry) {
        File classFile = Utils.checkFileForName(entry.classFileFullPath);
        if (classFile == null) {
            return false;
        }
        long classFileLastMod = classFile.lastModified();
        if (classFileLastMod > entry.oldClassFileLastModified) {
            entry.newClassFileLastModified = classFileLastMod;
            long classFileFP = this.computeFP(classFile);
            if (classFileFP != entry.oldClassFileFingerprint) {
                entry.newClassFileFingerprint = classFileFP;
                return true;
            }
        }
        return false;
    }

    private void checkUpdatedClasses() {
        for (String className : this.updatedClasses) {
            int i;
            PCDEntry pcde = this.pcd.get(className);
            this.getClassInfoForPCDEntry(1, pcde);
            if (!"".equals(pcde.oldClassInfo.directlyEnclosingClass)) {
                ClassInfo enclosingClassInfo = this.getClassInfoForName(1, pcde.oldClassInfo.directlyEnclosingClass);
                if (enclosingClassInfo.nestedClasses != null) {
                    for (i = 0; i < enclosingClassInfo.nestedClasses.length; ++i) {
                        if (!className.equals(enclosingClassInfo.nestedClasses[i])) continue;
                        pcde.newClassInfo.accessFlags = enclosingClassInfo.nestedClassAccessFlags[i];
                        pcde.newClassInfo.isNonMemberNestedClass = enclosingClassInfo.nestedClassNonMember[i];
                        break;
                    }
                }
            }
            if (!pcde.oldClassInfo.isNonMemberNestedClass || !pcde.newClassInfo.isNonMemberNestedClass) {
                Utils.printInfoMessage("Checking " + pcde.className);
                pcde.checkResult = this.cv.compareClassVersions(pcde) ? 1 : 2;
                String[] affectedClasses = this.cv.getAffectedClasses();
                if (affectedClasses != null) {
                    for (i = 0; i < affectedClasses.length; ++i) {
                        PCDEntry affEntry = this.pcd.get(affectedClasses[i]);
                        this.updatedJavaFiles.add(affEntry.javaFileFullPath);
                    }
                }
            } else {
                pcde.checkResult = 1;
            }
            this.updatedAndCheckedClasses.add(className);
        }
    }

    private void checkDeletedClasses() {
        for (String className : this.deletedClasses) {
            PCDEntry pcde = this.pcd.get(className);
            if (pcde == null) {
                Utils.printWarningMessage("Warning: internal information inconsistency when checking deleted classes");
                Utils.printWarningMessage("Please report this problem to Mikhail.Dmitriev@sun.com");
                Utils.printWarningMessage("Class name: " + className);
                continue;
            }
            ClassInfo oldCI = pcde.oldClassInfo;
            if (!oldCI.isNonMemberNestedClass) {
                Utils.printInfoMessage("Checking deleted class " + oldCI.name);
                this.cv.checkDeletedClass(pcde);
                String[] affectedClasses = this.cv.getAffectedClasses();
                if (affectedClasses != null) {
                    for (int i = 0; i < affectedClasses.length; ++i) {
                        PCDEntry affEntry = this.pcd.get(affectedClasses[i]);
                        if (this.deletedClasses.contains(affEntry.className)) continue;
                        this.updatedJavaFiles.add(affEntry.javaFileFullPath);
                    }
                }
            }
            pcde.checkResult = 3;
            this.updatedAndCheckedClasses.add(className);
        }
        this.deletedClasses.clear();
    }

    private void processAllClassesFromJarFile(String jarFileName) {
        JarFile jarFile;
        long jarFileLastMod = 0L;
        try {
            File file = new File(jarFileName);
            jarFileLastMod = file.lastModified();
            jarFile = new JarFile(jarFileName);
        }
        catch (IOException ex) {
            throw new PrivateException(ex);
        }
        ArrayList<PCDEntry> newEntries = new ArrayList<PCDEntry>();
        ArrayList<PCDEntry> updatedEntries = new ArrayList<PCDEntry>();
        ArrayList<PCDEntry> movedEntries = new ArrayList<PCDEntry>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String fullClassName = jarEntry.getName();
            if (!fullClassName.endsWith(".class")) continue;
            fullClassName = fullClassName.substring(0, fullClassName.length() - 6).intern();
            byte[] classFileBytes = Utils.readZipEntryIntoBuffer(jarFile, jarEntry);
            long classFileFP = this.computeFP(classFileBytes);
            PCDEntry pcde = this.pcd.get(fullClassName);
            if (pcde != null) {
                if (pcde.checked) {
                    throw new PrivateException(new PublicExceptions.DoubleEntryException("Two entries for class " + fullClassName + " detected: " + pcde.javaFileFullPath + " and " + jarFileName));
                }
                pcde.checked = true;
                pcde.newClassFileLastModified = jarFileLastMod;
                if (pcde.oldClassFileFingerprint == classFileFP && pcde.javaFileFullPath.equals(jarFileName)) {
                    pcde.oldClassFileLastModified = jarFileLastMod;
                    continue;
                }
                if (pcde.oldClassFileFingerprint != classFileFP) {
                    this.updatedClasses.add(fullClassName);
                    this.allUpdatedClasses.add(fullClassName);
                    pcde.newClassFileLastModified = jarFileLastMod;
                    pcde.newClassFileFingerprint = classFileFP;
                    pcde.newClassInfo = new ClassInfo(classFileBytes, 1, this, fullClassName);
                    if (pcde.oldClassInfo.nestedClasses != null || pcde.newClassInfo.nestedClasses != null) {
                        updatedEntries.add(pcde);
                    }
                } else {
                    pcde.oldClassFileLastModified = jarFileLastMod;
                }
                if (!pcde.javaFileFullPath.equals(jarFileName)) {
                    if (this.deletedClasses.contains(fullClassName)) {
                        this.deletedClasses.remove(fullClassName);
                    }
                    if (pcde.oldClassInfo.nestedClasses != null) {
                        movedEntries.add(pcde);
                        pcde.newClassInfo = new ClassInfo(classFileBytes, 1, this, fullClassName);
                    }
                }
                pcde.javaFileFullPath = jarFileName;
                continue;
            }
            ClassInfo classInfo = new ClassInfo(classFileBytes, 1, this, fullClassName);
            pcde = new PCDEntry(fullClassName, jarFileName, jarFileName, jarFileLastMod, classFileFP, classInfo);
            pcde.checkResult = 4;
            this.updatedAndCheckedClasses.add(fullClassName);
            this.pcd.put(fullClassName, pcde);
            if (pcde.newClassInfo.nestedClasses == null) continue;
            newEntries.add(pcde);
        }
        this.dealWithNestedClassesForUpdatedPCDEntries(updatedEntries, false);
        this.dealWithNestedClassesForUpdatedPCDEntries(movedEntries, true);
        for (int i = 0; i < newEntries.size(); ++i) {
            this.findAndUpdateAllNestedClassesForClass((PCDEntry)newEntries.get(i), false);
        }
    }

    private void dealWithClassesInUpdatedJarFiles() {
        if (this.updatedJarFiles.size() == 0) {
            return;
        }
        for (String updatedJarFile : this.updatedJarFiles) {
            this.processAllClassesFromJarFile(updatedJarFile);
        }
        for (PCDEntry pcde : this.entries()) {
            if (!this.updatedJarFiles.contains(pcde.javaFileFullPath) || pcde.checked) continue;
            this.deletedClasses.add(pcde.className);
        }
    }

    private void initializeDestDir(String inDestDir) {
        if (inDestDir != null && !inDestDir.equals("")) {
            File dir = Utils.checkOrCreateDirForName(inDestDir);
            if (dir == null) {
                throw new PrivateException(new IOException("specified directory " + inDestDir + " cannot be created."));
            }
            inDestDir = PCDManager.getCanonicalPath(dir);
            if (!inDestDir.endsWith(File.separator)) {
                inDestDir = inDestDir + File.separatorChar;
            }
            this.destDir = inDestDir;
            this.destDirSpecified = true;
        } else {
            this.destDirSpecified = false;
        }
    }

    private void initializeClassFileFullPath(PCDEntry entry) {
        String classFileFullPath;
        if (this.destDirSpecified) {
            classFileFullPath = this.destDir + entry.className + ".class";
        } else {
            String classFileName;
            String javaFileDir = entry.javaFileFullPath;
            int cutIndex = javaFileDir.lastIndexOf(File.separatorChar);
            if (cutIndex != -1) {
                javaFileDir = javaFileDir.substring(0, cutIndex + 1);
            }
            if ((cutIndex = (classFileName = entry.className).lastIndexOf(47)) != -1) {
                classFileName = classFileName.substring(cutIndex + 1);
            }
            classFileFullPath = javaFileDir + classFileName + ".class";
        }
        if (backSlashFileSeparator) {
            classFileFullPath = classFileFullPath.replace('/', File.separatorChar);
        }
        entry.classFileFullPath = classFileFullPath;
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath().intern();
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    private long computeFP(File file) {
        byte[] buf = Utils.readFileIntoBuffer(file);
        return this.computeFP(buf);
    }

    private long computeFP(byte[] buf) {
        this.checkSum.reset();
        this.checkSum.update(buf);
        return this.checkSum.getValue();
    }

    private PrivateException compilerInteractionException(String message, Exception origException, int errCode) {
        return new PrivateException(new PublicExceptions.CompilerInteractionException(message, origException, errCode));
    }

    private PrivateException internalException(String message) {
        return new PrivateException(new PublicExceptions.InternalException(message));
    }
}

