/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.PCDContainer;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.TestPCDUtils;
import com.sun.tools.jmake.TextProjectDatabaseWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class PCDSerializationTest {
    private void doTestRoundTrip(boolean textFormat) {
        String pcdPath = TestPCDUtils.generatePCD(textFormat);
        String roundTripPcdPath = "build/test/generate_test_pcd/scratchpad/test_roundtrip.pcd";
        PCDContainer pcd = TestPCDUtils.loadPDB(pcdPath, textFormat);
        TestPCDUtils.savePDB(pcd, roundTripPcdPath);
        PCDContainer roundtripPcd = TestPCDUtils.loadPDB(roundTripPcdPath, textFormat);
        Assert.assertTrue((boolean)TestPCDUtils.comparePCDContainers(pcd, roundtripPcd));
    }

    @Test
    public void testRoundTripTextFormat() {
        this.doTestRoundTrip(true);
    }

    @Test
    public void testRoundTripBinaryFormat() {
        this.doTestRoundTrip(false);
    }

    @Test
    public void testDependencyMunging() {
        String[][] testDeps = new String[][]{{"java/lang/Object", "[[[@java/lang/Object#", "[C", "C", "byte"}, {"[C", "[java/lang/Class"}};
        String[] expectedMungedDeps = new String[]{"java/lang/Object", "java/lang/Class"};
        LinkedHashMap<String, PCDEntry> pcds = new LinkedHashMap<String, PCDEntry>();
        this.addDeps(pcds, "foo/bar/Baz", testDeps[0]);
        this.addDeps(pcds, "foo/bar/Baz$", testDeps[1]);
        StringWriter writer = new StringWriter();
        new TextProjectDatabaseWriter().writeProjectDatabase(writer, pcds);
        String output = writer.toString();
        String[] lines = output.split("\n");
        String depsLine = lines[lines.length - 1];
        String[] deps = depsLine.split("\t");
        String src = deps[0];
        Assert.assertEquals((Object)"/root/foo/bar/Baz.java", (Object)src);
        LinkedHashSet expectedMungedDepsSet = new LinkedHashSet();
        Collections.addAll(expectedMungedDepsSet, expectedMungedDeps);
        LinkedHashSet<String> actualMungedDepsSet = new LinkedHashSet<String>();
        int i = 1;
        while (i < deps.length) {
            actualMungedDepsSet.add(deps[i]);
            ++i;
        }
        Assert.assertEquals(expectedMungedDepsSet, actualMungedDepsSet);
    }

    private void addDeps(Map<String, PCDEntry> pcds, String cls, String[] deps) {
        ClassInfo ci = new ClassInfo();
        ci.cpoolRefsToClasses = deps;
        pcds.put(cls, new PCDEntry(cls, "/root/foo/bar/Baz.java", 0L, 0L, ci));
    }
}

