/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.PCDManager;
import com.sun.tools.jmake.PrivateException;
import com.sun.tools.jmake.PublicExceptions;
import com.sun.tools.jmake.Utils;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Set;

public class RefClassFinder {
    private boolean failOnDependentJar;
    private boolean noWarnOnDependentJar;
    private String checkedClassName;
    private PCDManager pcdm;
    private Set<String> affectedClassNames;
    private boolean checkedClassIsFromJar;

    public RefClassFinder(PCDManager pcdm, boolean failOnDependentJar, boolean noWarnOnDependentJar) {
        this.pcdm = pcdm;
        this.failOnDependentJar = failOnDependentJar;
        this.noWarnOnDependentJar = noWarnOnDependentJar;
    }

    public void initialize(String checkedClassName, boolean checkedClassIsFromJar) {
        this.checkedClassName = checkedClassName;
        this.checkedClassIsFromJar = checkedClassIsFromJar;
        this.affectedClassNames = new LinkedHashSet<String>();
    }

    public String[] getAffectedClassNames() {
        int size = this.affectedClassNames.size();
        if (size == 0) {
            return null;
        }
        String[] ret = new String[size];
        int i = 0;
        for (String className : this.affectedClassNames) {
            ret[i++] = className;
        }
        return ret;
    }

    public void findAllProjectClasses(ClassInfo fieldClassInfo, int fieldNo) {
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo clientInfo;
            if (pcde.checkResult == 3 || pcde.javaFileFullPath.endsWith(".jar") || (clientInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde)) == null || !this.memberAccessibleFrom(fieldClassInfo, fieldNo, clientInfo, true)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    public void findReferencingClasses0(ClassInfo classInfo) {
        this.findReferencingClasses(classInfo, 0, false, null);
    }

    public void findReferencingClassesForDeletedClass(ClassInfo classInfo) {
        String packageName = classInfo.packageName;
        boolean isPublic = classInfo.isPublic();
        boolean isInterface = classInfo.isInterface();
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (clientInfo == null || !isPublic && packageName.equals(clientInfo.packageName) || !clientInfo.referencesClass(classInfo.name, isInterface, 1)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    public void findDiffPackageAndNotSubReferencingClasses1(ClassInfo classInfo) {
        String packageName = classInfo.packageName;
        String directlyEnclosingClass = classInfo.directlyEnclosingClass;
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (clientInfo == null || packageName.equals(clientInfo.packageName) || clientInfo.isSubclassOf(directlyEnclosingClass, false) || !clientInfo.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    public void findReferencingClasses1(ClassInfo classInfo) {
        String topLevelEnclosingClass = classInfo.topLevelEnclosingClass;
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (clientInfo == null || topLevelEnclosingClass.equals(clientInfo.topLevelEnclosingClass) || !clientInfo.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    public void findThisPackageOrSubReferencingClasses1(ClassInfo classInfo) {
        String directlyEnclosingClass = classInfo.directlyEnclosingClass;
        String topLevelEnclosingClass = classInfo.topLevelEnclosingClass;
        String packageName = classInfo.packageName;
        for (PCDEntry entry : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, entry);
            if (clientInfo == null || !clientInfo.packageName.equals(packageName) && !clientInfo.isSubclassOf(directlyEnclosingClass, false) || clientInfo.topLevelEnclosingClass.equals(topLevelEnclosingClass) || !clientInfo.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    public void findThisPackageReferencingClasses1(ClassInfo classInfo) {
        String topLevelEnclosingClass = classInfo.topLevelEnclosingClass;
        String packageName = classInfo.packageName;
        for (PCDEntry entry : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, entry);
            if (clientInfo == null || !clientInfo.packageName.equals(packageName) || topLevelEnclosingClass.equals(clientInfo.topLevelEnclosingClass) || !clientInfo.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    public void findDiffPackageReferencingClasses1(ClassInfo classInfo) {
        String packageName = classInfo.packageName;
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (clientInfo == null || clientInfo.packageName.equals(packageName) || !clientInfo.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    public void findDiffPackageAndSubReferencingClasses1(ClassInfo classInfo) {
        String packageName = classInfo.packageName;
        String directlyEnclosingClass = classInfo.directlyEnclosingClass;
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (clientInfo == null || clientInfo.packageName.equals(packageName) || !clientInfo.isSubclassOf(directlyEnclosingClass, false) || !clientInfo.referencesClass(classInfo.name, classInfo.isInterface(), 1)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    public void findReferencingClasses2(ClassInfo classInfo1, ClassInfo classInfo2) {
        LinkedHashSet<String> refClazz1 = new LinkedHashSet<String>();
        this.findReferencingClasses(classInfo1, 2, false, refClazz1);
        LinkedHashSet<String> refClazz2 = new LinkedHashSet<String>();
        this.findReferencingClasses(classInfo2, 2, false, refClazz2);
        for (String className1 : refClazz1) {
            if (!refClazz2.contains(className1)) continue;
            this.addToAffectedClassNames(className1);
        }
    }

    public void findDirectSubclasses(ClassInfo classInfo) {
        ClassInfo[] classInfoArray = classInfo.getDirectSubclasses();
        int n = classInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo subclassInfo = classInfoArray[n2];
            this.addToAffectedClassNames(subclassInfo.name);
            ++n2;
        }
    }

    public void findDirectlyAndOtherwiseImplementingConcreteClasses(ClassInfo intfInfo) {
        for (PCDEntry entry : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, entry);
            if (clientInfo == null || clientInfo.isInterface()) continue;
            if (clientInfo.isAbstract()) {
                if (!clientInfo.implementsInterfaceDirectlyOrIndirectly(intfInfo.name)) continue;
                this.findAllNearestConcreteSubclasses(clientInfo);
                continue;
            }
            if (!clientInfo.implementsIntfOrSubintfDirectly(intfInfo.name)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    private void findAllNearestConcreteSubclasses(ClassInfo classInfo) {
        ClassInfo[] classInfoArray = classInfo.getDirectSubclasses();
        int n = classInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo subclassInfo = classInfoArray[n2];
            if (subclassInfo.isAbstract()) {
                this.findAllNearestConcreteSubclasses(subclassInfo);
            } else {
                this.addToAffectedClassNames(subclassInfo.name);
            }
            ++n2;
        }
    }

    public void findAbstractSubtypesWithSameNameMethod(ClassInfo intfInfo, String mName, final String mSig) {
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo ci = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (ci == null || !ci.isInterface() && !ci.isAbstract() || !ci.implementsInterfaceDirectlyOrIndirectly(intfInfo.name)) continue;
            this.addToAffectedClassNames(ci.name);
            ci.findExistingSameNameMethods(mName, true, true, new ClassInfo.MethodHandler(){

                @Override
                void handleMethod(ClassInfo classInfo, int otherMethodIdx) {
                    String otherMSig = classInfo.methodSignatures[otherMethodIdx];
                    if (!mSig.equals(otherMSig) && Utils.sameParamNumber(mSig, otherMSig)) {
                        RefClassFinder.this.findReferencingClassesForMethod(classInfo, otherMethodIdx);
                    }
                }
            });
        }
    }

    public void findReferencingClassesForField(ClassInfo classInfo, int fieldNo) {
        this.findReferencingClassesForMember(classInfo, fieldNo, true, false, false);
    }

    public void findDiffPackageReferencingClassesForField(ClassInfo classInfo, int fieldNo) {
        this.findReferencingClassesForMember(classInfo, fieldNo, true, true, false);
    }

    public void findDiffPackageAndSubReferencingClassesForField(ClassInfo classInfo, int fieldNo) {
        this.findReferencingClassesForMember(classInfo, fieldNo, true, true, true);
    }

    public void findReferencingClassesForMethod(ClassInfo classInfo, int methodNo) {
        this.findReferencingClassesForMember(classInfo, methodNo, false, false, false);
    }

    public void findDiffPackageReferencingClassesForMethod(ClassInfo classInfo, int methodNo) {
        this.findReferencingClassesForMember(classInfo, methodNo, false, true, false);
    }

    public void findDiffPackageAndSubReferencingClassesForMethod(ClassInfo classInfo, int methodNo) {
        this.findReferencingClassesForMember(classInfo, methodNo, false, true, true);
    }

    public void findSubclassesReimplementingMethod(ClassInfo classInfo, int methodNo) {
        this.findSubclassesReimplementingMethod(classInfo, classInfo, methodNo);
    }

    private void findSubclassesReimplementingMethod(ClassInfo targetClass, ClassInfo methodDeclaringClass, int methodNo) {
        ClassInfo[] classInfoArray = targetClass.getDirectSubclasses();
        int n = classInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo subclass = classInfoArray[n2];
            if (subclass.declaresMethod(methodDeclaringClass, methodNo)) {
                this.addToAffectedClassNames(subclass.name);
            } else {
                this.findSubclassesReimplementingMethod(subclass, methodDeclaringClass, methodNo);
            }
            ++n2;
        }
    }

    public void findConcreteSubclasses(ClassInfo targetClass) {
        ClassInfo[] classInfoArray = targetClass.getDirectSubclasses();
        int n = classInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo subclass = classInfoArray[n2];
            if (subclass.isAbstract()) {
                this.findConcreteSubclasses(subclass);
            } else {
                this.addToAffectedClassNames(subclass.name);
            }
            ++n2;
        }
    }

    public void findConcreteSubclassesNotOverridingAbstractMethod(ClassInfo targetClass, ClassInfo methodDeclaringClass, int methodNo) {
        ClassInfo[] classInfoArray = targetClass.getDirectSubclasses();
        int n = classInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo subclass = classInfoArray[n2];
            int pos = subclass.getDeclaredMethodPos(methodDeclaringClass, methodNo);
            if (pos == -1) {
                if (!subclass.isAbstract()) {
                    this.addToAffectedClassNames(subclass.name);
                } else {
                    this.findConcreteSubclassesNotOverridingAbstractMethod(subclass, methodDeclaringClass, methodNo);
                }
            } else if (Modifier.isAbstract(subclass.methodAccessFlags[pos])) {
                this.findConcreteSubclassesNotOverridingAbstractMethod(subclass, methodDeclaringClass, methodNo);
            }
            ++n2;
        }
    }

    public void findRefsToMethodsThrowingException(ClassInfo excClassInfo) {
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo classInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (classInfo == null) continue;
            int methodIdx = -1;
            do {
                if ((methodIdx = classInfo.hasMethodThrowingException(excClassInfo, methodIdx + 1)) == -1) continue;
                this.findReferencingClassesForMethod(classInfo, methodIdx);
            } while (methodIdx != -1);
        }
    }

    public void findClassesDeclaringField(String name, String signature, boolean isStatic, String packageToLookIn) {
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo classInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (classInfo == null || packageToLookIn != null && !classInfo.packageName.equals(packageToLookIn) || !classInfo.declaresField(name, signature, isStatic)) continue;
            this.addToAffectedClassNames(classInfo.name);
        }
    }

    public void addToAffectedClassNames(String className) {
        String res = this.pcdm.classAlreadyRecompiledOrUncompileable(className);
        if (res == null) {
            this.affectedClassNames.add(className);
        } else if (!"".equals(res)) {
            if (this.checkedClassIsFromJar || this.noWarnOnDependentJar) {
                return;
            }
            String message = "Class " + className + " is affected by a change to " + this.checkedClassName + ", but can't be recompiled, " + "since it is located in archive " + res;
            if (this.failOnDependentJar) {
                throw new PrivateException(new PublicExceptions.JarDependsOnSourceException(message));
            }
            Utils.printWarningMessage("Warning: " + message);
        }
    }

    private void findReferencingClasses(ClassInfo classInfo, int thorDegree, boolean fromDiffPackages, Set<String> ret) {
        String packageName = classInfo.packageName;
        for (PCDEntry pcde : this.pcdm.entries()) {
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (clientInfo == null || fromDiffPackages && packageName.equals(clientInfo.packageName) || thorDegree != 2 && !this.classAccessibleFrom(classInfo, clientInfo) || !clientInfo.referencesClass(classInfo.name, classInfo.isInterface(), thorDegree)) continue;
            if (ret == null) {
                this.addToAffectedClassNames(clientInfo.name);
                continue;
            }
            ret.add(clientInfo.name);
        }
    }

    private void findReferencingClassesForMember(ClassInfo declaringClassInfo, int memberNo, boolean isField, boolean fromDiffPackages, boolean onlySubclasses) {
        String declaringClassName = declaringClassInfo.name;
        String declaringClassPackage = declaringClassInfo.packageName;
        for (PCDEntry pcde : this.pcdm.entries()) {
            String className;
            ClassInfo clientInfo = this.pcdm.getClassInfoForPCDEntry(0, pcde);
            if (clientInfo == null || (className = clientInfo.name).equals(declaringClassName) || !this.memberAccessibleFrom(declaringClassInfo, memberNo, clientInfo, isField) || fromDiffPackages && declaringClassPackage.equals(clientInfo.packageName) || onlySubclasses && !clientInfo.isSubclassOf(declaringClassName, false)) continue;
            if (isField) {
                if (!clientInfo.referencesField(declaringClassInfo, memberNo)) continue;
                this.addToAffectedClassNames(clientInfo.name);
                continue;
            }
            if (!clientInfo.referencesMethod(declaringClassInfo, memberNo)) continue;
            this.addToAffectedClassNames(clientInfo.name);
        }
    }

    private boolean classAccessibleFrom(ClassInfo classInfo, ClassInfo clientClassInfo) {
        char classFlags = classInfo.accessFlags;
        String classPackage = classInfo.packageName;
        String clientClassPackage = clientClassInfo.packageName;
        if (Modifier.isPublic(classFlags)) {
            return true;
        }
        return Modifier.isProtected(classFlags) ? classPackage.equals(clientClassPackage) || clientClassInfo.isSubclassOf(classInfo.directlyEnclosingClass, false) : (Modifier.isPrivate(classFlags) ? classInfo.topLevelEnclosingClass.equals(clientClassInfo.topLevelEnclosingClass) : classPackage.equals(clientClassPackage));
    }

    private boolean memberAccessibleFrom(ClassInfo memberClassInfo, int memberNo, ClassInfo clientClassInfo, boolean isField) {
        char memberClassFlags = memberClassInfo.accessFlags;
        char memberFlags = isField ? memberClassInfo.fieldAccessFlags[memberNo] : memberClassInfo.methodAccessFlags[memberNo];
        String memberClassPackage = memberClassInfo.packageName;
        String clientClassPackage = clientClassInfo.packageName;
        if (Modifier.isPublic(memberClassFlags)) {
            if (Modifier.isPublic(memberFlags)) {
                return true;
            }
            if (Modifier.isProtected(memberFlags) && (memberClassPackage.equals(clientClassPackage) || clientClassInfo.isSubclassOf(memberClassInfo.name, false))) {
                return true;
            }
            if (Modifier.isPrivate(memberFlags) ? memberClassInfo.topLevelEnclosingClass.equals(clientClassInfo.topLevelEnclosingClass) : memberClassPackage.equals(clientClassPackage)) {
                return true;
            }
        } else if (Modifier.isProtected(memberClassFlags)) {
            if (!memberClassPackage.equals(clientClassPackage) && !clientClassInfo.isSubclassOf(memberClassInfo.directlyEnclosingClass, false)) {
                return true;
            }
            if (Modifier.isPublic(memberFlags) || Modifier.isProtected(memberFlags)) {
                return true;
            }
            if (Modifier.isPrivate(memberFlags) ? memberClassInfo.topLevelEnclosingClass.equals(clientClassInfo.topLevelEnclosingClass) : memberClassPackage.equals(clientClassPackage)) {
                return true;
            }
        } else if (Modifier.isPrivate(memberClassFlags)) {
            if (memberClassInfo.topLevelEnclosingClass.equals(clientClassInfo.topLevelEnclosingClass)) {
                return true;
            }
        } else {
            if (!memberClassPackage.equals(clientClassPackage)) {
                return false;
            }
            if (Modifier.isPublic(memberFlags) || Modifier.isProtected(memberFlags)) {
                return true;
            }
            if (Modifier.isPrivate(memberFlags)) {
                if (memberClassInfo.topLevelEnclosingClass.equals(clientClassInfo.topLevelEnclosingClass)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

