/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.Main;
import com.sun.tools.jmake.PCDContainer;
import com.sun.tools.jmake.PCDEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDepFile {
    @Before
    public void setUp() throws Exception {
        Files.deleteIfExists(Paths.get("build/test/classes/Foo.class", new String[0]));
        Files.deleteIfExists(Paths.get("build/test/classes/Bar.class", new String[0]));
        Files.deleteIfExists(Paths.get("build/test/testdepfile.pdb", new String[0]));
    }

    @Test
    public void testDepFileNew() {
        System.out.println("jmake with depfile, new file");
        this.withExtraClass();
    }

    @Test
    public void testDepFileExisting() {
        this.withoutExtraClass();
        this.withExtraClass();
        this.withoutExtraClass();
    }

    private void withExtraClass() {
        this.writeDepfile(new File("build/test/depfile"), "../../../test/testcase2/Foo.java", "testcase2/Foo.class", "../../../test/testcase2/Foo.java", "testcase2/Bar.class");
        this.copyFile("test/testcase2/orig-files/with-extra", "test/testcase2/Foo.java");
        String[] args = new String[]{"-pdb", "build/test/testdepfile.pdb", "-pdb-text-format", "-depfile", "build/test/depfile", "-d", "build/test/classes", "test/testcase2/Foo.java"};
        Main.main(args);
        PCDContainer container = PCDContainer.load("build/test/testdepfile.pdb", true);
        PCDEntry pcde = container.pcd.get("testcase2/Foo");
        Assert.assertNotNull((Object)pcde);
        PCDEntry pcde2 = container.pcd.get("testcase2/Bar");
        Assert.assertNotNull((Object)pcde2);
    }

    private void withoutExtraClass() {
        this.writeDepfile(new File("build/test/depfile"), "../../../test/testcase2/Foo.java", "testcase2/Foo.class");
        this.copyFile("test/testcase2/orig-files/without-extra", "test/testcase2/Foo.java");
        String[] args = new String[]{"-pdb", "build/test/testdepfile.pdb", "-pdb-text-format", "-depfile", "build/test/depfile", "-d", "build/test/classes", "test/testcase2/Foo.java"};
        Main.main(args);
        PCDContainer container = PCDContainer.load("build/test/testdepfile.pdb", true);
        PCDEntry pcde = container.pcd.get("testcase2/Foo");
        Assert.assertNotNull((Object)pcde);
        PCDEntry pcde2 = container.pcd.get("testcase2/Bar");
        Assert.assertNull((Object)pcde2);
    }

    private void copyFile(String src, String dest) {
        try {
            Files.copy(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDepfile(File file, String ... deps) {
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(file));
            int i = 0;
            while (i < deps.length) {
                String java = deps[i];
                String cls = deps[i + 1];
                writer.println(String.valueOf(java) + " -> " + cls);
                i += 2;
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

