/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.CompileResult;
import com.sun.tools.jmake.Main;
import com.sun.tools.jmake.PCDContainer;
import com.sun.tools.jmake.PCDEntry;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;

public class TestPCDUtils {
    private TestPCDUtils() {
    }

    public static String generatePCD(boolean textFormat) {
        return TestPCDUtils.compileJMake(textFormat);
    }

    public static PCDContainer loadPDB(String pdbFile, boolean textFormat) {
        return PCDContainer.load(pdbFile, textFormat);
    }

    public static void savePDB(PCDContainer pcd, String pdbFile) {
        new File(pdbFile).getParentFile().mkdirs();
        pcd.storeName = pdbFile;
        pcd.save();
    }

    public static boolean comparePCDContainers(PCDContainer l, PCDContainer r) {
        TreeMap<String, PCDEntry> sortedL = new TreeMap<String, PCDEntry>(l.pcd);
        TreeMap<String, PCDEntry> sortedR = new TreeMap<String, PCDEntry>(r.pcd);
        if (!sortedL.keySet().equals(sortedR.keySet())) {
            return false;
        }
        Iterator iterL = sortedL.values().iterator();
        Iterator iterR = sortedR.values().iterator();
        while (iterL.hasNext()) {
            if (TestPCDUtils.comparePCDEntry((PCDEntry)iterL.next(), (PCDEntry)iterR.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean comparePCDEntry(PCDEntry l, PCDEntry r) {
        return TestPCDUtils.safeEquals(l.className, r.className) && TestPCDUtils.safeEquals(l.javaFileFullPath, r.javaFileFullPath) && l.oldClassFileLastModified == r.oldClassFileLastModified && l.oldClassFileFingerprint == r.oldClassFileFingerprint && TestPCDUtils.compareClassInfo(l.oldClassInfo, r.oldClassInfo);
    }

    public static boolean compareClassInfo(ClassInfo l, ClassInfo r) {
        return TestPCDUtils.safeEquals(l.name, r.name) && l.javacTargetRelease == r.javacTargetRelease && Arrays.equals(l.cpoolRefsToClasses, r.cpoolRefsToClasses) && Arrays.equals(l.isRefClassArray, r.isRefClassArray) && Arrays.equals(l.cpoolRefsToFieldClasses, r.cpoolRefsToFieldClasses) && Arrays.equals(l.cpoolRefsToFieldNames, r.cpoolRefsToFieldNames) && Arrays.equals(l.cpoolRefsToFieldSignatures, r.cpoolRefsToFieldSignatures) && Arrays.equals(l.cpoolRefsToMethodClasses, r.cpoolRefsToMethodClasses) && Arrays.equals(l.cpoolRefsToMethodNames, r.cpoolRefsToMethodNames) && Arrays.equals(l.cpoolRefsToMethodSignatures, r.cpoolRefsToMethodSignatures) && l.accessFlags == r.accessFlags && l.isNonMemberNestedClass == r.isNonMemberNestedClass && TestPCDUtils.safeEquals(l.superName, r.superName) && Arrays.equals(l.interfaces, r.interfaces) && Arrays.equals(l.fieldNames, r.fieldNames) && Arrays.equals(l.fieldSignatures, r.fieldSignatures) && Arrays.equals(l.fieldAccessFlags, r.fieldAccessFlags) && Arrays.equals(l.primitiveConstantInitValues, r.primitiveConstantInitValues) && Arrays.equals(l.methodNames, r.methodNames) && Arrays.equals(l.methodSignatures, r.methodSignatures) && Arrays.equals(l.methodAccessFlags, r.methodAccessFlags) && Arrays.deepEquals((Object[])l.checkedExceptions, (Object[])r.checkedExceptions) && Arrays.equals(l.nestedClasses, r.nestedClasses);
    }

    public static CompileResult compile(String testRoot, File[] sources, boolean textFormat) {
        File testRootDir = new File(testRoot);
        File pdbFile = new File(testRootDir, "test.pdb");
        File outputDir = new File(testRootDir, "classes");
        pdbFile.delete();
        TestPCDUtils.nuke(outputDir);
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-d");
        argsList.add(outputDir.getPath());
        argsList.add("-pdb");
        argsList.add(pdbFile.getPath());
        if (textFormat) {
            argsList.add("-pdb-text-format");
        }
        File[] fileArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            File src = fileArray[n2];
            argsList.add(src.toString());
            ++n2;
        }
        String[] args = argsList.toArray(new String[argsList.size()]);
        Main m = new Main();
        int exitCode = m.mainExternal(args);
        return new CompileResult(exitCode, pdbFile.getPath());
    }

    private static void nuke(File f) {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                TestPCDUtils.nuke(child);
                ++n2;
            }
        }
        f.delete();
    }

    private static boolean safeEquals(Object l, Object r) {
        if (l == null) {
            return r == null;
        }
        return l.equals(r);
    }

    private static String compileJMake(boolean textFormat) {
        String testRoot = "build/test/generate_test_pcd";
        File[] sources = TestPCDUtils.getAllJMakeSources();
        return TestPCDUtils.compile(testRoot, sources, textFormat).getPdbPath();
    }

    private static File[] getAllJMakeSources() {
        File sourcesDir = new File("src/com/sun/tools/jmake");
        return sourcesDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
    }
}

