/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.Base64;
import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.PrivateException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextProjectDatabaseReader {
    public Map<String, PCDEntry> readProjectDatabaseFromFile(File infile) {
        Map<String, PCDEntry> map;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "UTF-8"));
        try {
            map = this.readProjectDatabase(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new PrivateException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new PrivateException(e);
            }
            catch (IOException e) {
                throw new PrivateException(e);
            }
        }
        in.close();
        return map;
    }

    public Map<String, PCDEntry> readProjectDatabase(BufferedReader in) {
        LinkedHashMap<String, PCDEntry> pcd;
        try {
            String line = in.readLine();
            if (!"pcd entries:".equals(line)) {
                throw this.error("Expected: 'pcd entries:', got: " + line);
            }
            line = in.readLine();
            Matcher m = Pattern.compile("^(\\d+) items$").matcher(line);
            if (!m.matches()) {
                throw this.error("Expected: '<n> items', got: " + line);
            }
            int numEntries = Integer.parseInt(m.group(1));
            pcd = new LinkedHashMap<String, PCDEntry>(numEntries);
            int i = 0;
            while (i < numEntries) {
                line = in.readLine();
                if (line == null) {
                    throw this.error("Unexpected EOF");
                }
                String[] parts = line.split("\t");
                if (parts.length != 5) {
                    throw this.error("Invalid line: " + line);
                }
                String className = parts[0];
                String javaFullFilePath = parts[1];
                long oldClassFileLastModified = Long.parseLong(parts[2]);
                long oldClassFileFingerprint = Long.parseLong(parts[3]);
                ClassInfo ci = this.classInfoFromBase64(parts[4]);
                PCDEntry entry = new PCDEntry(className, javaFullFilePath, oldClassFileLastModified, oldClassFileFingerprint, ci);
                pcd.put(entry.className, entry);
                ++i;
            }
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
        return pcd;
    }

    private PrivateException error(String msg) {
        return new PrivateException(new IllegalArgumentException(msg));
    }

    private ClassInfo classInfoFromBase64(String s) {
        try {
            byte[] bytes = Base64.decode(s.toCharArray());
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            ClassInfo ret = (ClassInfo)ois.readObject();
            ret.initializeImmediateTransientFields();
            return ret;
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new PrivateException(e);
        }
    }
}

