/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jmake;

import com.sun.tools.jmake.Base64;
import com.sun.tools.jmake.ClassInfo;
import com.sun.tools.jmake.PCDEntry;
import com.sun.tools.jmake.PrivateException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TextProjectDatabaseWriter {
    private static Set<String> primitives = new LinkedHashSet<String>(Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short", "Z", "B", "C", "D", "F", "I", "J", "S"));
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public void writeProjectDatabaseToFile(File outfile, Map<String, PCDEntry> pcd) {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "UTF-8"));){
            this.writeProjectDatabase(out, pcd);
        }
        catch (FileNotFoundException e) {
            throw new PrivateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new PrivateException(e);
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    public void writeProjectDatabase(Writer out, Map<String, PCDEntry> pcd) {
        try {
            out.write("pcd entries:\n");
            out.write(Integer.toString(pcd.size()));
            out.write(" items\n");
            LinkedHashMap<String, LinkedHashSet<String>> depsBySource = new LinkedHashMap<String, LinkedHashSet<String>>();
            for (PCDEntry pCDEntry : pcd.values()) {
                this.writePCDEntry(out, pCDEntry);
                LinkedHashSet<String> deps = (LinkedHashSet<String>)depsBySource.get(pCDEntry.javaFileFullPath);
                if (deps == null) {
                    deps = new LinkedHashSet<String>();
                    depsBySource.put(pCDEntry.javaFileFullPath, deps);
                }
                this.addDepsFromClassInfo(deps, pCDEntry.oldClassInfo);
            }
            out.write("dependencies:\n");
            out.write(Integer.toString(depsBySource.size()));
            out.write(" items\n");
            for (Map.Entry entry : depsBySource.entrySet()) {
                out.write((String)entry.getKey());
                for (String s : (Set)entry.getValue()) {
                    out.write(9);
                    out.write(s);
                }
                out.write(10);
            }
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    private void addDepsFromClassInfo(Set<String> deps, ClassInfo ci) {
        String[] stringArray = ci.cpoolRefsToClasses;
        int n = ci.cpoolRefsToClasses.length;
        int n2 = 0;
        while (n2 < n) {
            int k;
            String s = stringArray[n2];
            int i = 0;
            int j = s.length();
            while (s.charAt(i) == '[') {
                ++i;
            }
            if (s.charAt(i) == '@') {
                ++i;
            }
            if (s.endsWith("#")) {
                --j;
            }
            if ((k = s.indexOf(36)) != -1) {
                j = k;
            }
            if (i > 0 || j < s.length()) {
                s = s.substring(i, j);
            }
            if (!primitives.contains(s)) {
                deps.add(s);
            }
            ++n2;
        }
    }

    private void writePCDEntry(Writer out, PCDEntry entry) {
        try {
            out.write(entry.className);
            out.write(9);
            out.write(entry.javaFileFullPath);
            out.write(9);
            out.write(Long.toString(entry.oldClassFileLastModified));
            out.write(9);
            out.write(Long.toString(entry.oldClassFileFingerprint));
            out.write(9);
            out.write(this.classInfoToBase64(entry.oldClassInfo));
            out.write(10);
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
    }

    private char[] classInfoToBase64(ClassInfo ci) {
        this.baos.reset();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(this.baos);
            oos.writeObject(ci);
            oos.close();
        }
        catch (IOException e) {
            throw new PrivateException(e);
        }
        return Base64.encode(this.baos.toByteArray());
    }
}

